/*
 * Decompiled with CFR 0.152.
 */
package org.eximeebpms.bpm.engine.rest.impl;

import com.fasterxml.jackson.databind.ObjectMapper;
import jakarta.ws.rs.core.MultivaluedMap;
import jakarta.ws.rs.core.UriInfo;
import java.util.ArrayList;
import java.util.List;
import org.eximeebpms.bpm.engine.ProcessEngine;
import org.eximeebpms.bpm.engine.rest.VariableInstanceRestService;
import org.eximeebpms.bpm.engine.rest.dto.CountResultDto;
import org.eximeebpms.bpm.engine.rest.dto.runtime.VariableInstanceDto;
import org.eximeebpms.bpm.engine.rest.dto.runtime.VariableInstanceQueryDto;
import org.eximeebpms.bpm.engine.rest.impl.AbstractRestProcessEngineAware;
import org.eximeebpms.bpm.engine.rest.sub.runtime.VariableInstanceResource;
import org.eximeebpms.bpm.engine.rest.sub.runtime.impl.VariableInstanceResourceImpl;
import org.eximeebpms.bpm.engine.rest.util.QueryUtil;
import org.eximeebpms.bpm.engine.runtime.VariableInstance;
import org.eximeebpms.bpm.engine.runtime.VariableInstanceQuery;

public class VariableInstanceRestServiceImpl
extends AbstractRestProcessEngineAware
implements VariableInstanceRestService {
    public VariableInstanceRestServiceImpl(String engineName, ObjectMapper objectMapper) {
        super(engineName, objectMapper);
    }

    @Override
    public VariableInstanceResource getVariableInstance(String id) {
        return new VariableInstanceResourceImpl(id, this.getProcessEngine());
    }

    @Override
    public List<VariableInstanceDto> getVariableInstances(UriInfo uriInfo, Integer firstResult, Integer maxResults, boolean deserializeObjectValues) {
        VariableInstanceQueryDto queryDto = new VariableInstanceQueryDto(this.getObjectMapper(), (MultivaluedMap<String, String>)uriInfo.getQueryParameters());
        return this.queryVariableInstances(queryDto, firstResult, maxResults, deserializeObjectValues);
    }

    @Override
    public List<VariableInstanceDto> queryVariableInstances(VariableInstanceQueryDto queryDto, Integer firstResult, Integer maxResults, boolean deserializeObjectValues) {
        ProcessEngine engine = this.getProcessEngine();
        queryDto.setObjectMapper(this.getObjectMapper());
        VariableInstanceQuery query = (VariableInstanceQuery)queryDto.toQuery(engine);
        query.disableBinaryFetching();
        if (!deserializeObjectValues) {
            query.disableCustomObjectDeserialization();
        }
        List<VariableInstance> matchingInstances = QueryUtil.list(query, firstResult, maxResults);
        ArrayList<VariableInstanceDto> instanceResults = new ArrayList<VariableInstanceDto>();
        for (VariableInstance instance : matchingInstances) {
            VariableInstanceDto resultInstance = VariableInstanceDto.fromVariableInstance(instance);
            instanceResults.add(resultInstance);
        }
        return instanceResults;
    }

    @Override
    public CountResultDto getVariableInstancesCount(UriInfo uriInfo) {
        VariableInstanceQueryDto queryDto = new VariableInstanceQueryDto(this.getObjectMapper(), (MultivaluedMap<String, String>)uriInfo.getQueryParameters());
        return this.queryVariableInstancesCount(queryDto);
    }

    @Override
    public CountResultDto queryVariableInstancesCount(VariableInstanceQueryDto queryDto) {
        ProcessEngine engine = this.getProcessEngine();
        queryDto.setObjectMapper(this.getObjectMapper());
        VariableInstanceQuery query = (VariableInstanceQuery)queryDto.toQuery(engine);
        long count = query.count();
        CountResultDto result = new CountResultDto();
        result.setCount(count);
        return result;
    }
}

