/*
 * Copyright Camunda Services GmbH and/or licensed to Camunda Services GmbH
 * under one or more contributor license agreements. See the NOTICE file
 * distributed with this work for additional information regarding copyright
 * ownership. Camunda licenses this file to you under the Apache License,
 * Version 2.0; you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package org.eximeebpms.bpm.engine.rest.dto.externaltask;

/**
 * Base DTO class for Worker-related External Task operations.
 * Contains the <code>workerId</code> property.
 *
 * Used in:
 * <ul>
 *   <li>{@link LockExternalTaskDto}</li>
 *   <li>{@link ExtendLockOnExternalTaskDto}</li>
 *   <li>{@link ExternalTaskFailureDto}</li>
 *   <li>{@link CompleteExternalTaskDto}</li>
 * </ul>
 *
 * Note: the {@link ExternalTaskBpmnError} class doesn't extend this class. Any adjustments made here
 * should be mirrored in that class as well.
 */
public class HandleExternalTaskDto {

  protected String workerId;

  public String getWorkerId() {
    return workerId;
  }

  public void setWorkerId(String workerId) {
    this.workerId = workerId;
  }

}