/*
 * Decompiled with CFR 0.152.
 */
package org.eximeebpms.bpm.engine.rest;

import io.restassured.RestAssured;
import io.restassured.http.ContentType;
import io.restassured.response.Response;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.InputStream;
import java.lang.invoke.StringConcatFactory;
import java.net.URISyntaxException;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import javax.ws.rs.core.Response;
import org.eximeebpms.bpm.engine.AuthorizationException;
import org.eximeebpms.bpm.engine.BadUserRequestException;
import org.eximeebpms.bpm.engine.CaseService;
import org.eximeebpms.bpm.engine.ProcessEngineException;
import org.eximeebpms.bpm.engine.RepositoryService;
import org.eximeebpms.bpm.engine.impl.util.IoUtil;
import org.eximeebpms.bpm.engine.impl.util.ReflectUtil;
import org.eximeebpms.bpm.engine.repository.CaseDefinition;
import org.eximeebpms.bpm.engine.repository.CaseDefinitionQuery;
import org.eximeebpms.bpm.engine.rest.AbstractRestServiceTest;
import org.eximeebpms.bpm.engine.rest.dto.HistoryTimeToLiveDto;
import org.eximeebpms.bpm.engine.rest.exception.RestException;
import org.eximeebpms.bpm.engine.rest.helper.EqualsVariableMap;
import org.eximeebpms.bpm.engine.rest.helper.MockProvider;
import org.eximeebpms.bpm.engine.rest.helper.variable.EqualsPrimitiveValue;
import org.eximeebpms.bpm.engine.rest.helper.variable.EqualsUntypedValue;
import org.eximeebpms.bpm.engine.rest.sub.repository.impl.ProcessDefinitionResourceImpl;
import org.eximeebpms.bpm.engine.rest.util.VariablesBuilder;
import org.eximeebpms.bpm.engine.rest.util.container.TestContainerRule;
import org.eximeebpms.bpm.engine.runtime.CaseInstance;
import org.eximeebpms.bpm.engine.runtime.CaseInstanceBuilder;
import org.eximeebpms.bpm.engine.variable.type.ValueType;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.junit.Assert;
import org.junit.Before;
import org.junit.ClassRule;
import org.junit.Test;
import org.mockito.Mockito;
import org.mockito.hamcrest.MockitoHamcrest;

public class CaseDefinitionRestServiceInteractionTest
extends AbstractRestServiceTest {
    protected static final String CASE_DEFINITION_URL = "/rest-test/case-definition";
    protected static final String SINGLE_CASE_DEFINITION_URL = "/rest-test/case-definition/{id}";
    protected static final String SINGLE_CASE_DEFINITION_BY_KEY_URL = "/rest-test/case-definition/key/{key}";
    protected static final String SINGLE_CASE_DEFINITION_BY_KEY_AND_TENANT_ID_URL = "/rest-test/case-definition/key/{key}/tenant-id/{tenant-id}";
    protected static final String XML_DEFINITION_URL = "/rest-test/case-definition/{id}/xml";
    protected static final String XML_DEFINITION_BY_KEY_URL = "/rest-test/case-definition/key/{key}/xml";
    protected static final String CREATE_INSTANCE_URL = "/rest-test/case-definition/{id}/create";
    protected static final String CREATE_INSTANCE_BY_KEY_URL = "/rest-test/case-definition/key/{key}/create";
    protected static final String CREATE_INSTANCE_BY_KEY_AND_TENANT_ID_URL = "/rest-test/case-definition/key/{key}/tenant-id/{tenant-id}/create";
    protected static final String DIAGRAM_DEFINITION_URL = "/rest-test/case-definition/{id}/diagram";
    protected static final String UPDATE_HISTORY_TIME_TO_LIVE_URL = "/rest-test/case-definition/{id}/history-time-to-live";
    @ClassRule
    public static TestContainerRule rule = new TestContainerRule();
    private RepositoryService repositoryServiceMock;
    private CaseService caseServiceMock;
    private CaseDefinitionQuery caseDefinitionQueryMock;
    private CaseInstanceBuilder caseInstanceBuilder;

    @Before
    public void setUpRuntime() {
        CaseDefinition mockCaseDefinition = MockProvider.createMockCaseDefinition();
        this.setUpRuntimeData(mockCaseDefinition);
        this.caseServiceMock = (CaseService)Mockito.mock(CaseService.class);
        Mockito.when((Object)processEngine.getCaseService()).thenReturn((Object)this.caseServiceMock);
        this.caseInstanceBuilder = (CaseInstanceBuilder)Mockito.mock(CaseInstanceBuilder.class);
        CaseInstance mockCaseInstance = MockProvider.createMockCaseInstance();
        Mockito.when((Object)this.caseServiceMock.withCaseDefinition("aCaseDefnitionId")).thenReturn((Object)this.caseInstanceBuilder);
        Mockito.when((Object)this.caseInstanceBuilder.businessKey((String)Mockito.any())).thenReturn((Object)this.caseInstanceBuilder);
        Mockito.when((Object)this.caseInstanceBuilder.setVariables((Map)Mockito.any())).thenReturn((Object)this.caseInstanceBuilder);
        Mockito.when((Object)this.caseInstanceBuilder.create()).thenReturn((Object)mockCaseInstance);
    }

    private void setUpRuntimeData(CaseDefinition mockCaseDefinition) {
        this.repositoryServiceMock = (RepositoryService)Mockito.mock(RepositoryService.class);
        Mockito.when((Object)processEngine.getRepositoryService()).thenReturn((Object)this.repositoryServiceMock);
        Mockito.when((Object)this.repositoryServiceMock.getCaseDefinition((String)Mockito.eq((Object)"aCaseDefnitionId"))).thenReturn((Object)mockCaseDefinition);
        Mockito.when((Object)this.repositoryServiceMock.getCaseModel((String)Mockito.eq((Object)"aCaseDefnitionId"))).thenReturn((Object)this.createMockCaseDefinitionCmmnXml());
        this.caseDefinitionQueryMock = (CaseDefinitionQuery)Mockito.mock(CaseDefinitionQuery.class);
        Mockito.when((Object)this.caseDefinitionQueryMock.caseDefinitionKey("aCaseDefinitionKey")).thenReturn((Object)this.caseDefinitionQueryMock);
        Mockito.when((Object)this.caseDefinitionQueryMock.tenantIdIn((String[])Mockito.any())).thenReturn((Object)this.caseDefinitionQueryMock);
        Mockito.when((Object)this.caseDefinitionQueryMock.withoutTenantId()).thenReturn((Object)this.caseDefinitionQueryMock);
        Mockito.when((Object)this.caseDefinitionQueryMock.latestVersion()).thenReturn((Object)this.caseDefinitionQueryMock);
        Mockito.when((Object)((CaseDefinition)this.caseDefinitionQueryMock.singleResult())).thenReturn((Object)mockCaseDefinition);
        Mockito.when((Object)this.caseDefinitionQueryMock.list()).thenReturn(Collections.singletonList(mockCaseDefinition));
        Mockito.when((Object)this.repositoryServiceMock.createCaseDefinitionQuery()).thenReturn((Object)this.caseDefinitionQueryMock);
    }

    private InputStream createMockCaseDefinitionCmmnXml() {
        InputStream cmmnXmlInputStream = ReflectUtil.getResourceAsStream((String)"cases/case-model.cmmn");
        Assert.assertNotNull((Object)cmmnXmlInputStream);
        return cmmnXmlInputStream;
    }

    @Test
    public void testCaseDefinitionCmmnXmlRetrieval() {
        Response response = (Response)RestAssured.given().pathParam("id", (Object)"aCaseDefnitionId").then().expect().statusCode(Response.Status.OK.getStatusCode()).when().get(XML_DEFINITION_URL, new Object[0]);
        String responseContent = response.asString();
        Assert.assertTrue((boolean)responseContent.contains("aCaseDefnitionId"));
        Assert.assertTrue((boolean)responseContent.contains("<?xml"));
    }

    @Test
    public void testDefinitionRetrieval() {
        RestAssured.given().pathParam("id", (Object)"aCaseDefnitionId").then().expect().statusCode(Response.Status.OK.getStatusCode()).body("id", Matchers.equalTo((Object)"aCaseDefnitionId"), new Object[0]).body("key", Matchers.equalTo((Object)"aCaseDefinitionKey"), new Object[0]).body("category", Matchers.equalTo((Object)"aCaseDefinitionCategory"), new Object[0]).body("name", Matchers.equalTo((Object)"aCaseDefinitionName"), new Object[0]).body("deploymentId", Matchers.equalTo((Object)"aDeploymentId"), new Object[0]).body("version", Matchers.equalTo((Object)1), new Object[0]).body("resource", Matchers.equalTo((Object)"aCaseDefinitionResourceName"), new Object[0]).body("tenantId", Matchers.equalTo(null), new Object[0]).when().get(SINGLE_CASE_DEFINITION_URL, new Object[0]);
        ((RepositoryService)Mockito.verify((Object)this.repositoryServiceMock)).getCaseDefinition("aCaseDefnitionId");
    }

    @Test
    public void testCaseDefinitionCmmnXmlRetrieval_ByKey() {
        Response response = (Response)RestAssured.given().pathParam("key", (Object)"aCaseDefinitionKey").then().expect().statusCode(Response.Status.OK.getStatusCode()).when().get(XML_DEFINITION_BY_KEY_URL, new Object[0]);
        String responseContent = response.asString();
        Assert.assertTrue((boolean)responseContent.contains("aCaseDefnitionId"));
        Assert.assertTrue((boolean)responseContent.contains("<?xml"));
    }

    @Test
    public void testDefinitionRetrieval_ByKey() {
        RestAssured.given().pathParam("key", (Object)"aCaseDefinitionKey").then().expect().statusCode(Response.Status.OK.getStatusCode()).body("id", Matchers.equalTo((Object)"aCaseDefnitionId"), new Object[0]).body("key", Matchers.equalTo((Object)"aCaseDefinitionKey"), new Object[0]).body("category", Matchers.equalTo((Object)"aCaseDefinitionCategory"), new Object[0]).body("name", Matchers.equalTo((Object)"aCaseDefinitionName"), new Object[0]).body("deploymentId", Matchers.equalTo((Object)"aDeploymentId"), new Object[0]).body("version", Matchers.equalTo((Object)1), new Object[0]).body("resource", Matchers.equalTo((Object)"aCaseDefinitionResourceName"), new Object[0]).body("tenantId", Matchers.equalTo(null), new Object[0]).when().get(SINGLE_CASE_DEFINITION_BY_KEY_URL, new Object[0]);
        ((CaseDefinitionQuery)Mockito.verify((Object)this.caseDefinitionQueryMock)).withoutTenantId();
        ((RepositoryService)Mockito.verify((Object)this.repositoryServiceMock)).getCaseDefinition("aCaseDefnitionId");
    }

    @Test
    public void testNonExistingCaseDefinitionRetrieval_ByKey() {
        String nonExistingKey = "aNonExistingDefinitionKey";
        Mockito.when((Object)this.repositoryServiceMock.createCaseDefinitionQuery().caseDefinitionKey(nonExistingKey)).thenReturn((Object)this.caseDefinitionQueryMock);
        Mockito.when((Object)this.caseDefinitionQueryMock.latestVersion()).thenReturn((Object)this.caseDefinitionQueryMock);
        Mockito.when((Object)((CaseDefinition)this.caseDefinitionQueryMock.singleResult())).thenReturn(null);
        Mockito.when((Object)this.caseDefinitionQueryMock.list()).thenReturn(Collections.emptyList());
        RestAssured.given().pathParam("key", (Object)nonExistingKey).then().expect().statusCode(Response.Status.NOT_FOUND.getStatusCode()).contentType(ContentType.JSON).body("type", Matchers.is((Object)RestException.class.getSimpleName()), new Object[0]).body("message", Matchers.containsString((String)("No matching case definition with key: " + nonExistingKey)), new Object[0]).when().get(SINGLE_CASE_DEFINITION_BY_KEY_URL, new Object[0]);
    }

    @Test
    public void testDefinitionRetrieval_ByKeyAndTenantId() {
        CaseDefinition mockDefinition = MockProvider.mockCaseDefinition().tenantId("aTenantId").build();
        this.setUpRuntimeData(mockDefinition);
        RestAssured.given().pathParam("key", (Object)"aCaseDefinitionKey").pathParam("tenant-id", (Object)"aTenantId").then().expect().statusCode(Response.Status.OK.getStatusCode()).body("id", Matchers.equalTo((Object)"aCaseDefnitionId"), new Object[0]).body("key", Matchers.equalTo((Object)"aCaseDefinitionKey"), new Object[0]).body("category", Matchers.equalTo((Object)"aCaseDefinitionCategory"), new Object[0]).body("name", Matchers.equalTo((Object)"aCaseDefinitionName"), new Object[0]).body("deploymentId", Matchers.equalTo((Object)"aDeploymentId"), new Object[0]).body("version", Matchers.equalTo((Object)1), new Object[0]).body("resource", Matchers.equalTo((Object)"aCaseDefinitionResourceName"), new Object[0]).body("tenantId", Matchers.equalTo((Object)"aTenantId"), new Object[0]).when().get(SINGLE_CASE_DEFINITION_BY_KEY_AND_TENANT_ID_URL, new Object[0]);
        ((CaseDefinitionQuery)Mockito.verify((Object)this.caseDefinitionQueryMock)).tenantIdIn(new String[]{"aTenantId"});
        ((RepositoryService)Mockito.verify((Object)this.repositoryServiceMock)).getCaseDefinition("aCaseDefnitionId");
    }

    @Test
    public void testNonExistingCaseDefinitionRetrieval_ByKeyAndTenantId() {
        String nonExistingKey = "aNonExistingDefinitionKey";
        String nonExistingTenantId = "aNonExistingTenantId";
        Mockito.when((Object)this.repositoryServiceMock.createCaseDefinitionQuery().caseDefinitionKey(nonExistingKey)).thenReturn((Object)this.caseDefinitionQueryMock);
        Mockito.when((Object)((CaseDefinition)this.caseDefinitionQueryMock.singleResult())).thenReturn(null);
        RestAssured.given().pathParam("key", (Object)nonExistingKey).pathParam("tenant-id", (Object)nonExistingTenantId).then().expect().statusCode(Response.Status.NOT_FOUND.getStatusCode()).contentType(ContentType.JSON).body("type", Matchers.is((Object)RestException.class.getSimpleName()), new Object[0]).body("message", Matchers.containsString((String)("No matching case definition with key: " + nonExistingKey + " and tenant-id: " + nonExistingTenantId)), new Object[0]).when().get(SINGLE_CASE_DEFINITION_BY_KEY_AND_TENANT_ID_URL, new Object[0]);
    }

    @Test
    public void testCreateCaseInstanceByCaseDefinitionKeyAndTenantId() {
        CaseDefinition mockDefinition = MockProvider.mockCaseDefinition().tenantId("aTenantId").build();
        this.setUpRuntimeData(mockDefinition);
        RestAssured.given().pathParam("key", (Object)"aCaseDefinitionKey").pathParam("tenant-id", (Object)"aTenantId").contentType(POST_JSON_CONTENT_TYPE).body("{}").then().expect().statusCode(Response.Status.OK.getStatusCode()).body("id", Matchers.equalTo((Object)"aCaseInstId"), new Object[0]).when().post(CREATE_INSTANCE_BY_KEY_AND_TENANT_ID_URL, new Object[0]);
        ((CaseDefinitionQuery)Mockito.verify((Object)this.caseDefinitionQueryMock)).tenantIdIn(new String[]{"aTenantId"});
        ((CaseService)Mockito.verify((Object)this.caseServiceMock)).withCaseDefinition("aCaseDefnitionId");
        ((CaseInstanceBuilder)Mockito.verify((Object)this.caseInstanceBuilder)).create();
    }

    @Test
    public void testCreateCaseInstanceByCaseDefinitionId() {
        RestAssured.given().pathParam("id", (Object)"aCaseDefnitionId").contentType(POST_JSON_CONTENT_TYPE).body("{}").then().expect().statusCode(Response.Status.OK.getStatusCode()).body("id", Matchers.equalTo((Object)"aCaseInstId"), new Object[0]).when().post(CREATE_INSTANCE_URL, new Object[0]);
        ((CaseService)Mockito.verify((Object)this.caseServiceMock)).withCaseDefinition("aCaseDefnitionId");
        ((CaseInstanceBuilder)Mockito.verify((Object)this.caseInstanceBuilder)).businessKey(null);
        ((CaseInstanceBuilder)Mockito.verify((Object)this.caseInstanceBuilder)).setVariables(null);
        ((CaseInstanceBuilder)Mockito.verify((Object)this.caseInstanceBuilder)).create();
    }

    @Test
    public void testCreateCaseInstanceByCaseDefinitionKey() {
        RestAssured.given().pathParam("key", (Object)"aCaseDefinitionKey").contentType(POST_JSON_CONTENT_TYPE).body("{}").then().expect().statusCode(Response.Status.OK.getStatusCode()).body("id", Matchers.equalTo((Object)"aCaseInstId"), new Object[0]).when().post(CREATE_INSTANCE_BY_KEY_URL, new Object[0]);
        ((CaseService)Mockito.verify((Object)this.caseServiceMock)).withCaseDefinition("aCaseDefnitionId");
        ((CaseInstanceBuilder)Mockito.verify((Object)this.caseInstanceBuilder)).businessKey(null);
        ((CaseInstanceBuilder)Mockito.verify((Object)this.caseInstanceBuilder)).setVariables(null);
        ((CaseInstanceBuilder)Mockito.verify((Object)this.caseInstanceBuilder)).create();
    }

    @Test
    public void testCreateCaseInstanceByCaseDefinitionIdWithBusinessKey() {
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("businessKey", "aBusinessKey");
        RestAssured.given().pathParam("id", (Object)"aCaseDefnitionId").contentType(POST_JSON_CONTENT_TYPE).body(params).then().expect().statusCode(Response.Status.OK.getStatusCode()).body("id", Matchers.equalTo((Object)"aCaseInstId"), new Object[0]).when().post(CREATE_INSTANCE_URL, new Object[0]);
        ((CaseService)Mockito.verify((Object)this.caseServiceMock)).withCaseDefinition("aCaseDefnitionId");
        ((CaseInstanceBuilder)Mockito.verify((Object)this.caseInstanceBuilder)).businessKey("aBusinessKey");
        ((CaseInstanceBuilder)Mockito.verify((Object)this.caseInstanceBuilder)).setVariables(null);
        ((CaseInstanceBuilder)Mockito.verify((Object)this.caseInstanceBuilder)).create();
    }

    @Test
    public void testCreateCaseInstanceByCaseDefinitionKeyWithBusinessKey() {
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("businessKey", "aBusinessKey");
        RestAssured.given().pathParam("key", (Object)"aCaseDefinitionKey").contentType(POST_JSON_CONTENT_TYPE).body(params).then().expect().statusCode(Response.Status.OK.getStatusCode()).body("id", Matchers.equalTo((Object)"aCaseInstId"), new Object[0]).when().post(CREATE_INSTANCE_BY_KEY_URL, new Object[0]);
        ((CaseService)Mockito.verify((Object)this.caseServiceMock)).withCaseDefinition("aCaseDefnitionId");
        ((CaseInstanceBuilder)Mockito.verify((Object)this.caseInstanceBuilder)).businessKey("aBusinessKey");
        ((CaseInstanceBuilder)Mockito.verify((Object)this.caseInstanceBuilder)).setVariables(null);
        ((CaseInstanceBuilder)Mockito.verify((Object)this.caseInstanceBuilder)).create();
    }

    @Test
    public void testCreateCaseInstanceByCaseDefinitionIdWithVariables() {
        HashMap<String, Map<String, Object>> variables = new HashMap<String, Map<String, Object>>();
        variables.put("aVariableName", VariablesBuilder.getVariableValueMap((Object)"abc", ValueType.STRING.getName()));
        variables.put("anotherVariableName", VariablesBuilder.getVariableValueMap((Object)900, ValueType.INTEGER.getName()));
        HashMap<String, HashMap<String, Map<String, Object>>> params = new HashMap<String, HashMap<String, Map<String, Object>>>();
        params.put("variables", variables);
        RestAssured.given().pathParam("id", (Object)"aCaseDefnitionId").contentType(POST_JSON_CONTENT_TYPE).body(params).then().expect().statusCode(Response.Status.OK.getStatusCode()).body("id", Matchers.equalTo((Object)"aCaseInstId"), new Object[0]).when().post(CREATE_INSTANCE_URL, new Object[0]);
        ((CaseService)Mockito.verify((Object)this.caseServiceMock)).withCaseDefinition("aCaseDefnitionId");
        ((CaseInstanceBuilder)Mockito.verify((Object)this.caseInstanceBuilder)).businessKey(null);
        ((CaseInstanceBuilder)Mockito.verify((Object)this.caseInstanceBuilder)).setVariables((Map)MockitoHamcrest.argThat((Matcher)EqualsVariableMap.matches().matcher("aVariableName", (Matcher<?>)EqualsPrimitiveValue.stringValue("abc")).matcher("anotherVariableName", (Matcher<?>)EqualsPrimitiveValue.integerValue(900))));
        ((CaseInstanceBuilder)Mockito.verify((Object)this.caseInstanceBuilder)).create();
    }

    @Test
    public void testCreateCaseInstanceByCaseDefinitionKeyWithVariables() {
        HashMap<String, Map<String, Object>> variables = new HashMap<String, Map<String, Object>>();
        variables.put("aVariableName", VariablesBuilder.getVariableValueMap((Object)"abc", null));
        variables.put("anotherVariableName", VariablesBuilder.getVariableValueMap((Object)900, null));
        HashMap<String, HashMap<String, Map<String, Object>>> params = new HashMap<String, HashMap<String, Map<String, Object>>>();
        params.put("variables", variables);
        RestAssured.given().pathParam("key", (Object)"aCaseDefinitionKey").contentType(POST_JSON_CONTENT_TYPE).body(params).then().expect().statusCode(Response.Status.OK.getStatusCode()).body("id", Matchers.equalTo((Object)"aCaseInstId"), new Object[0]).when().post(CREATE_INSTANCE_BY_KEY_URL, new Object[0]);
        HashMap<String, Object> expectedVariables = new HashMap<String, Object>();
        expectedVariables.put("aVariableName", "abc");
        expectedVariables.put("anotherVariableName", 999);
        ((CaseService)Mockito.verify((Object)this.caseServiceMock)).withCaseDefinition("aCaseDefnitionId");
        ((CaseInstanceBuilder)Mockito.verify((Object)this.caseInstanceBuilder)).businessKey(null);
        ((CaseInstanceBuilder)Mockito.verify((Object)this.caseInstanceBuilder)).setVariables((Map)MockitoHamcrest.argThat((Matcher)EqualsVariableMap.matches().matcher("aVariableName", (Matcher<?>)EqualsUntypedValue.matcher().value("abc")).matcher("anotherVariableName", (Matcher<?>)EqualsUntypedValue.matcher().value(900))));
        ((CaseInstanceBuilder)Mockito.verify((Object)this.caseInstanceBuilder)).create();
    }

    @Test
    public void testCreateCaseInstanceByCaseDefinitionIdWithBusinessKeyAndVariables() {
        HashMap<String, Map<String, Object>> variables = new HashMap<String, Map<String, Object>>();
        variables.put("aVariableName", VariablesBuilder.getVariableValueMap((Object)"abc", null));
        variables.put("anotherVariableName", VariablesBuilder.getVariableValueMap((Object)900, null));
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("variables", variables);
        params.put("businessKey", "aBusinessKey");
        RestAssured.given().pathParam("id", (Object)"aCaseDefnitionId").contentType(POST_JSON_CONTENT_TYPE).body(params).then().expect().statusCode(Response.Status.OK.getStatusCode()).body("id", Matchers.equalTo((Object)"aCaseInstId"), new Object[0]).when().post(CREATE_INSTANCE_URL, new Object[0]);
        HashMap<String, Object> expectedVariables = new HashMap<String, Object>();
        expectedVariables.put("aVariableName", "abc");
        expectedVariables.put("anotherVariableName", 999);
        ((CaseService)Mockito.verify((Object)this.caseServiceMock)).withCaseDefinition("aCaseDefnitionId");
        ((CaseInstanceBuilder)Mockito.verify((Object)this.caseInstanceBuilder)).businessKey("aBusinessKey");
        ((CaseInstanceBuilder)Mockito.verify((Object)this.caseInstanceBuilder)).setVariables((Map)MockitoHamcrest.argThat((Matcher)EqualsVariableMap.matches().matcher("aVariableName", (Matcher<?>)EqualsUntypedValue.matcher().value("abc")).matcher("anotherVariableName", (Matcher<?>)EqualsUntypedValue.matcher().value(900))));
        ((CaseInstanceBuilder)Mockito.verify((Object)this.caseInstanceBuilder)).create();
    }

    @Test
    public void testCreateCaseInstanceByCaseDefinitionKeyWithBusinessKeyAndVariables() {
        HashMap<String, Map<String, Object>> variables = new HashMap<String, Map<String, Object>>();
        variables.put("aVariableName", VariablesBuilder.getVariableValueMap((Object)"abc", null));
        variables.put("anotherVariableName", VariablesBuilder.getVariableValueMap((Object)900, null));
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("variables", variables);
        params.put("businessKey", "aBusinessKey");
        RestAssured.given().pathParam("key", (Object)"aCaseDefinitionKey").contentType(POST_JSON_CONTENT_TYPE).body(params).then().expect().statusCode(Response.Status.OK.getStatusCode()).body("id", Matchers.equalTo((Object)"aCaseInstId"), new Object[0]).when().post(CREATE_INSTANCE_BY_KEY_URL, new Object[0]);
        HashMap<String, Object> expectedVariables = new HashMap<String, Object>();
        expectedVariables.put("aVariableName", "abc");
        expectedVariables.put("anotherVariableName", 999);
        ((CaseService)Mockito.verify((Object)this.caseServiceMock)).withCaseDefinition("aCaseDefnitionId");
        ((CaseInstanceBuilder)Mockito.verify((Object)this.caseInstanceBuilder)).businessKey("aBusinessKey");
        ((CaseInstanceBuilder)Mockito.verify((Object)this.caseInstanceBuilder)).setVariables((Map)MockitoHamcrest.argThat((Matcher)EqualsVariableMap.matches().matcher("aVariableName", (Matcher<?>)EqualsUntypedValue.matcher().value("abc")).matcher("anotherVariableName", (Matcher<?>)EqualsUntypedValue.matcher().value(900))));
        ((CaseInstanceBuilder)Mockito.verify((Object)this.caseInstanceBuilder)).create();
    }

    @Test
    public void testCreateCaseInstanceByInvalidCaseDefinitionId() {
        Mockito.when((Object)this.caseInstanceBuilder.create()).thenThrow(new Throwable[]{new ProcessEngineException("expected exception")});
        RestAssured.given().pathParam("id", (Object)"aCaseDefnitionId").contentType(POST_JSON_CONTENT_TYPE).body("{}").then().expect().statusCode(Response.Status.INTERNAL_SERVER_ERROR.getStatusCode()).contentType(ContentType.JSON).body("type", Matchers.equalTo((Object)RestException.class.getSimpleName()), new Object[0]).body("message", Matchers.containsString((String)"Cannot instantiate case definition aCaseDefnitionId: expected exception"), new Object[0]).when().post(CREATE_INSTANCE_URL, new Object[0]);
    }

    @Test
    public void testCreateCaseInstanceByInvalidCaseDefinitionKey() {
        Mockito.when((Object)this.caseInstanceBuilder.create()).thenThrow(new Throwable[]{new ProcessEngineException("expected exception")});
        RestAssured.given().pathParam("key", (Object)"aCaseDefinitionKey").contentType(POST_JSON_CONTENT_TYPE).body("{}").then().expect().statusCode(Response.Status.INTERNAL_SERVER_ERROR.getStatusCode()).contentType(ContentType.JSON).body("type", Matchers.equalTo((Object)RestException.class.getSimpleName()), new Object[0]).body("message", Matchers.containsString((String)"Cannot instantiate case definition aCaseDefnitionId: expected exception"), new Object[0]).when().post(CREATE_INSTANCE_BY_KEY_URL, new Object[0]);
    }

    @Test
    public void testCaseDiagramRetrieval() throws FileNotFoundException, URISyntaxException {
        File file = this.getFile("/processes/todo-process.png");
        Mockito.when((Object)this.repositoryServiceMock.getCaseDiagram("aCaseDefnitionId")).thenReturn((Object)new FileInputStream(file));
        byte[] actual = ((Response)RestAssured.given().pathParam("id", (Object)"aCaseDefnitionId").expect().statusCode(Response.Status.OK.getStatusCode()).contentType("image/png").header("Content-Disposition", "attachment; filename=\"aResourceName.png\"; filename*=UTF-8''aResourceName.png").when().get(DIAGRAM_DEFINITION_URL, new Object[0])).getBody().asByteArray();
        ((RepositoryService)Mockito.verify((Object)this.repositoryServiceMock)).getCaseDefinition("aCaseDefnitionId");
        ((RepositoryService)Mockito.verify((Object)this.repositoryServiceMock)).getCaseDiagram("aCaseDefnitionId");
        byte[] expected = IoUtil.readInputStream((InputStream)new FileInputStream(file), (String)"case diagram");
        Assert.assertArrayEquals((byte[])expected, (byte[])actual);
    }

    @Test
    public void testCaseDiagramNullFilename() throws FileNotFoundException, URISyntaxException {
        File file = this.getFile("/processes/todo-process.png");
        Mockito.when((Object)this.repositoryServiceMock.getCaseDefinition("aCaseDefnitionId").getDiagramResourceName()).thenReturn(null);
        Mockito.when((Object)this.repositoryServiceMock.getCaseDiagram("aCaseDefnitionId")).thenReturn((Object)new FileInputStream(file));
        byte[] actual = ((Response)RestAssured.given().pathParam("id", (Object)"aCaseDefnitionId").expect().statusCode(Response.Status.OK.getStatusCode()).contentType("application/octet-stream").header("Content-Disposition", (String)((Object)StringConcatFactory.makeConcatWithConstants("makeConcatWithConstants", new Object[]{"attachment; filename=\"null\"; filename*=UTF-8''null"}))).when().get(DIAGRAM_DEFINITION_URL, new Object[0])).getBody().asByteArray();
        ((RepositoryService)Mockito.verify((Object)this.repositoryServiceMock)).getCaseDiagram("aCaseDefnitionId");
        byte[] expected = IoUtil.readInputStream((InputStream)new FileInputStream(file), (String)"case diagram");
        Assert.assertArrayEquals((byte[])expected, (byte[])actual);
    }

    @Test
    public void testCaseDiagramNotExist() {
        Mockito.when((Object)this.repositoryServiceMock.getCaseDiagram("aCaseDefnitionId")).thenReturn(null);
        RestAssured.given().pathParam("id", (Object)"aCaseDefnitionId").expect().statusCode(Response.Status.NO_CONTENT.getStatusCode()).when().get(DIAGRAM_DEFINITION_URL, new Object[0]);
        ((RepositoryService)Mockito.verify((Object)this.repositoryServiceMock)).getCaseDefinition("aCaseDefnitionId");
        ((RepositoryService)Mockito.verify((Object)this.repositoryServiceMock)).getCaseDiagram("aCaseDefnitionId");
    }

    @Test
    public void testProcessDiagramMediaType() {
        Assert.assertEquals((Object)"image/png", (Object)ProcessDefinitionResourceImpl.getMediaTypeForFileSuffix((String)"process.png"));
        Assert.assertEquals((Object)"image/png", (Object)ProcessDefinitionResourceImpl.getMediaTypeForFileSuffix((String)"process.PNG"));
        Assert.assertEquals((Object)"image/svg+xml", (Object)ProcessDefinitionResourceImpl.getMediaTypeForFileSuffix((String)"process.svg"));
        Assert.assertEquals((Object)"image/jpeg", (Object)ProcessDefinitionResourceImpl.getMediaTypeForFileSuffix((String)"process.jpeg"));
        Assert.assertEquals((Object)"image/jpeg", (Object)ProcessDefinitionResourceImpl.getMediaTypeForFileSuffix((String)"process.jpg"));
        Assert.assertEquals((Object)"image/gif", (Object)ProcessDefinitionResourceImpl.getMediaTypeForFileSuffix((String)"process.gif"));
        Assert.assertEquals((Object)"image/bmp", (Object)ProcessDefinitionResourceImpl.getMediaTypeForFileSuffix((String)"process.bmp"));
        Assert.assertEquals((Object)"application/octet-stream", (Object)ProcessDefinitionResourceImpl.getMediaTypeForFileSuffix((String)"process.UNKNOWN"));
    }

    @Test
    public void testUpdateHistoryTimeToLive() {
        RestAssured.given().pathParam("id", (Object)"aCaseDefnitionId").body((Object)new HistoryTimeToLiveDto(Integer.valueOf(5))).contentType(ContentType.JSON).then().expect().statusCode(Response.Status.NO_CONTENT.getStatusCode()).when().put(UPDATE_HISTORY_TIME_TO_LIVE_URL, new Object[0]);
        ((RepositoryService)Mockito.verify((Object)this.repositoryServiceMock)).updateCaseDefinitionHistoryTimeToLive("aCaseDefnitionId", Integer.valueOf(5));
    }

    @Test
    public void testUpdateHistoryTimeToLiveNullValue() {
        RestAssured.given().pathParam("id", (Object)"aCaseDefnitionId").body((Object)new HistoryTimeToLiveDto()).contentType(ContentType.JSON).then().expect().statusCode(Response.Status.NO_CONTENT.getStatusCode()).when().put(UPDATE_HISTORY_TIME_TO_LIVE_URL, new Object[0]);
        ((RepositoryService)Mockito.verify((Object)this.repositoryServiceMock)).updateCaseDefinitionHistoryTimeToLive("aCaseDefnitionId", null);
    }

    @Test
    public void testUpdateHistoryTimeToLiveNegativeValue() {
        String expectedMessage = "expectedMessage";
        ((RepositoryService)Mockito.doThrow((Throwable[])new Throwable[]{new BadUserRequestException(expectedMessage)}).when((Object)this.repositoryServiceMock)).updateCaseDefinitionHistoryTimeToLive((String)Mockito.eq((Object)"aCaseDefnitionId"), Integer.valueOf(Mockito.eq((int)-1)));
        RestAssured.given().pathParam("id", (Object)"aCaseDefnitionId").body((Object)new HistoryTimeToLiveDto(Integer.valueOf(-1))).contentType(ContentType.JSON).then().expect().statusCode(Response.Status.BAD_REQUEST.getStatusCode()).body("type", Matchers.is((Object)BadUserRequestException.class.getSimpleName()), new Object[0]).body("message", Matchers.containsString((String)expectedMessage), new Object[0]).when().put(UPDATE_HISTORY_TIME_TO_LIVE_URL, new Object[0]);
        ((RepositoryService)Mockito.verify((Object)this.repositoryServiceMock)).updateCaseDefinitionHistoryTimeToLive("aCaseDefnitionId", Integer.valueOf(-1));
    }

    @Test
    public void testUpdateHistoryTimeToLiveAuthorizationException() {
        String expectedMessage = "expectedMessage";
        ((RepositoryService)Mockito.doThrow((Throwable[])new Throwable[]{new AuthorizationException(expectedMessage)}).when((Object)this.repositoryServiceMock)).updateCaseDefinitionHistoryTimeToLive((String)Mockito.eq((Object)"aCaseDefnitionId"), Integer.valueOf(Mockito.eq((int)5)));
        RestAssured.given().pathParam("id", (Object)"aCaseDefnitionId").body((Object)new HistoryTimeToLiveDto(Integer.valueOf(5))).contentType(ContentType.JSON).then().expect().statusCode(Response.Status.FORBIDDEN.getStatusCode()).body("type", Matchers.is((Object)AuthorizationException.class.getSimpleName()), new Object[0]).body("message", Matchers.containsString((String)expectedMessage), new Object[0]).when().put(UPDATE_HISTORY_TIME_TO_LIVE_URL, new Object[0]);
        ((RepositoryService)Mockito.verify((Object)this.repositoryServiceMock)).updateCaseDefinitionHistoryTimeToLive("aCaseDefnitionId", Integer.valueOf(5));
    }
}

