/*
 * Decompiled with CFR 0.152.
 */
package org.eximeebpms.bpm.engine.rest;

import io.restassured.RestAssured;
import io.restassured.path.json.JsonPath;
import io.restassured.response.Response;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.ws.rs.core.Response;
import org.assertj.core.api.Assertions;
import org.eximeebpms.bpm.engine.rest.AbstractRestServiceTest;
import org.eximeebpms.bpm.engine.rest.helper.MockProvider;
import org.eximeebpms.bpm.engine.rest.util.container.TestContainerRule;
import org.eximeebpms.bpm.engine.runtime.EventSubscription;
import org.eximeebpms.bpm.engine.runtime.EventSubscriptionQuery;
import org.hamcrest.Matchers;
import org.junit.Assert;
import org.junit.Before;
import org.junit.ClassRule;
import org.junit.Test;
import org.mockito.InOrder;
import org.mockito.Mockito;

public class EventSubscriptionRestServiceQueryTest
extends AbstractRestServiceTest {
    @ClassRule
    public static TestContainerRule rule = new TestContainerRule();
    protected static final String EVENT_SUBSCRIPTION_URL = "/rest-test/event-subscription";
    protected static final String EVENT_SUBSCRIPTION_COUNT_QUERY_URL = "/rest-test/event-subscription/count";
    private EventSubscriptionQuery mockedEventSubscriptionQuery;

    @Before
    public void setUpRuntimeData() {
        this.mockedEventSubscriptionQuery = this.setUpMockEventSubscriptionQuery(this.createMockEventSubscriptionList());
    }

    private EventSubscriptionQuery setUpMockEventSubscriptionQuery(List<EventSubscription> mockedInstances) {
        EventSubscriptionQuery sampleEventSubscriptionsQuery = (EventSubscriptionQuery)Mockito.mock(EventSubscriptionQuery.class);
        Mockito.when((Object)sampleEventSubscriptionsQuery.list()).thenReturn(mockedInstances);
        Mockito.when((Object)sampleEventSubscriptionsQuery.count()).thenReturn((Object)mockedInstances.size());
        Mockito.when((Object)processEngine.getRuntimeService().createEventSubscriptionQuery()).thenReturn((Object)sampleEventSubscriptionsQuery);
        return sampleEventSubscriptionsQuery;
    }

    private List<EventSubscription> createMockEventSubscriptionList() {
        ArrayList<EventSubscription> mocks = new ArrayList<EventSubscription>();
        mocks.add(MockProvider.createMockEventSubscription());
        return mocks;
    }

    @Test
    public void testEmptyQuery() {
        RestAssured.given().then().expect().statusCode(Response.Status.OK.getStatusCode()).when().get(EVENT_SUBSCRIPTION_URL, new Object[0]);
    }

    @Test
    public void testEventSubscriptionRetrieval() {
        Response response = (Response)RestAssured.given().then().expect().statusCode(Response.Status.OK.getStatusCode()).when().get(EVENT_SUBSCRIPTION_URL, new Object[0]);
        InOrder inOrder = Mockito.inOrder((Object[])new Object[]{this.mockedEventSubscriptionQuery});
        ((EventSubscriptionQuery)inOrder.verify((Object)this.mockedEventSubscriptionQuery)).list();
        String content = response.asString();
        List instances = JsonPath.from((String)content).getList("");
        Assert.assertEquals((String)"There should be one event subscription returned.", (long)1L, (long)instances.size());
        Assert.assertNotNull((String)"There should be one event subscription returned", instances.get(0));
        String returnedEventSubscriptionId = JsonPath.from((String)content).getString("[0].id");
        String returnedEventType = JsonPath.from((String)content).getString("[0].eventType");
        String returnedEventName = JsonPath.from((String)content).getString("[0].eventName");
        String returnedExecutionId = JsonPath.from((String)content).getString("[0].executionId");
        String returnedProcessInstanceId = JsonPath.from((String)content).getString("[0].processInstanceId");
        String returnedActivityId = JsonPath.from((String)content).getString("[0].activityId");
        String returnedCreatedDate = JsonPath.from((String)content).getString("[0].createdDate");
        String returnedTenantId = JsonPath.from((String)content).getString("[0].tenantId");
        Assert.assertEquals((Object)"anEventSubscriptionId", (Object)returnedEventSubscriptionId);
        Assert.assertEquals((Object)"message", (Object)returnedEventType);
        Assert.assertEquals((Object)"anEvent", (Object)returnedEventName);
        Assert.assertEquals((Object)"anExecutionId", (Object)returnedExecutionId);
        Assert.assertEquals((Object)"aProcInstId", (Object)returnedProcessInstanceId);
        Assert.assertEquals((Object)"anActivity", (Object)returnedActivityId);
        Assert.assertEquals((Object)MockProvider.EXAMPLE_EVENT_SUBSCRIPTION_CREATION_DATE, (Object)returnedCreatedDate);
        Assert.assertEquals((Object)"aTenantId", (Object)returnedTenantId);
    }

    @Test
    public void testInvalidSortingOptions() {
        this.executeAndVerifySorting("anInvalidSortByOption", "asc", Response.Status.BAD_REQUEST);
        this.executeAndVerifySorting("definitionId", "anInvalidSortOrderOption", Response.Status.BAD_REQUEST);
    }

    @Test
    public void testSortByParameterOnly() {
        RestAssured.given().queryParam("sortBy", new Object[]{"created"}).then().expect().statusCode(Response.Status.BAD_REQUEST.getStatusCode()).when().get(EVENT_SUBSCRIPTION_URL, new Object[0]);
    }

    @Test
    public void testSortOrderParameterOnly() {
        RestAssured.given().queryParam("sortOrder", new Object[]{"asc"}).then().expect().statusCode(Response.Status.BAD_REQUEST.getStatusCode()).when().get(EVENT_SUBSCRIPTION_URL, new Object[0]);
    }

    @Test
    public void testNoParametersQuery() {
        RestAssured.expect().statusCode(Response.Status.OK.getStatusCode()).when().get(EVENT_SUBSCRIPTION_URL, new Object[0]);
        ((EventSubscriptionQuery)Mockito.verify((Object)this.mockedEventSubscriptionQuery)).list();
        Mockito.verifyNoMoreInteractions((Object[])new Object[]{this.mockedEventSubscriptionQuery});
    }

    @Test
    public void testQueryParameters() {
        Map<String, String> queryParameters = this.getCompleteQueryParameters();
        RestAssured.given().queryParams(queryParameters).expect().statusCode(Response.Status.OK.getStatusCode()).when().get(EVENT_SUBSCRIPTION_URL, new Object[0]);
        ((EventSubscriptionQuery)Mockito.verify((Object)this.mockedEventSubscriptionQuery)).eventSubscriptionId(queryParameters.get("eventSubscriptionId"));
        ((EventSubscriptionQuery)Mockito.verify((Object)this.mockedEventSubscriptionQuery)).eventType(queryParameters.get("eventType"));
        ((EventSubscriptionQuery)Mockito.verify((Object)this.mockedEventSubscriptionQuery)).eventName(queryParameters.get("eventName"));
        ((EventSubscriptionQuery)Mockito.verify((Object)this.mockedEventSubscriptionQuery)).executionId(queryParameters.get("executionId"));
        ((EventSubscriptionQuery)Mockito.verify((Object)this.mockedEventSubscriptionQuery)).processInstanceId(queryParameters.get("processInstanceId"));
        ((EventSubscriptionQuery)Mockito.verify((Object)this.mockedEventSubscriptionQuery)).activityId(queryParameters.get("activityId"));
        ((EventSubscriptionQuery)Mockito.verify((Object)this.mockedEventSubscriptionQuery)).list();
    }

    @Test
    public void testTenantIdListParameter() {
        this.mockedEventSubscriptionQuery = this.setUpMockEventSubscriptionQuery(this.createMockEventSubscriptionTwoTenants());
        Response response = (Response)RestAssured.given().queryParam("tenantIdIn", new Object[]{"aTenantId,anotherTenantId"}).then().expect().statusCode(Response.Status.OK.getStatusCode()).when().get(EVENT_SUBSCRIPTION_URL, new Object[0]);
        ((EventSubscriptionQuery)Mockito.verify((Object)this.mockedEventSubscriptionQuery)).tenantIdIn(new String[]{"aTenantId", "anotherTenantId"});
        ((EventSubscriptionQuery)Mockito.verify((Object)this.mockedEventSubscriptionQuery)).list();
        String content = response.asString();
        List instances = JsonPath.from((String)content).getList("");
        Assertions.assertThat((List)instances).hasSize(2);
        String returnedTenantId1 = JsonPath.from((String)content).getString("[0].tenantId");
        String returnedTenantId2 = JsonPath.from((String)content).getString("[1].tenantId");
        Assertions.assertThat((String)returnedTenantId1).isEqualTo((Object)"aTenantId");
        Assertions.assertThat((String)returnedTenantId2).isEqualTo((Object)"anotherTenantId");
    }

    @Test
    public void testWithoutTenantIdParameter() {
        this.mockedEventSubscriptionQuery = this.setUpMockEventSubscriptionQuery(Arrays.asList(MockProvider.createMockEventSubscription(null)));
        Response response = (Response)RestAssured.given().queryParam("withoutTenantId", new Object[]{true}).then().expect().statusCode(Response.Status.OK.getStatusCode()).when().get(EVENT_SUBSCRIPTION_URL, new Object[0]);
        ((EventSubscriptionQuery)Mockito.verify((Object)this.mockedEventSubscriptionQuery)).withoutTenantId();
        ((EventSubscriptionQuery)Mockito.verify((Object)this.mockedEventSubscriptionQuery)).list();
        String content = response.asString();
        List definitions = JsonPath.from((String)content).getList("");
        Assertions.assertThat((List)definitions).hasSize(1);
        String returnedTenantId1 = JsonPath.from((String)content).getString("[0].tenantId");
        Assertions.assertThat((String)returnedTenantId1).isEqualTo(null);
    }

    @Test
    public void testSortingParameters() {
        InOrder inOrder = Mockito.inOrder((Object[])new Object[]{this.mockedEventSubscriptionQuery});
        this.executeAndVerifySorting("created", "asc", Response.Status.OK);
        ((EventSubscriptionQuery)inOrder.verify((Object)this.mockedEventSubscriptionQuery)).orderByCreated();
        ((EventSubscriptionQuery)inOrder.verify((Object)this.mockedEventSubscriptionQuery)).asc();
        inOrder = Mockito.inOrder((Object[])new Object[]{this.mockedEventSubscriptionQuery});
        this.executeAndVerifySorting("created", "desc", Response.Status.OK);
        ((EventSubscriptionQuery)inOrder.verify((Object)this.mockedEventSubscriptionQuery)).orderByCreated();
        ((EventSubscriptionQuery)inOrder.verify((Object)this.mockedEventSubscriptionQuery)).desc();
        inOrder = Mockito.inOrder((Object[])new Object[]{this.mockedEventSubscriptionQuery});
        this.executeAndVerifySorting("tenantId", "asc", Response.Status.OK);
        ((EventSubscriptionQuery)inOrder.verify((Object)this.mockedEventSubscriptionQuery)).orderByTenantId();
        ((EventSubscriptionQuery)inOrder.verify((Object)this.mockedEventSubscriptionQuery)).asc();
        inOrder = Mockito.inOrder((Object[])new Object[]{this.mockedEventSubscriptionQuery});
        this.executeAndVerifySorting("tenantId", "desc", Response.Status.OK);
        ((EventSubscriptionQuery)inOrder.verify((Object)this.mockedEventSubscriptionQuery)).orderByTenantId();
        ((EventSubscriptionQuery)inOrder.verify((Object)this.mockedEventSubscriptionQuery)).desc();
    }

    @Test
    public void testSuccessfulPagination() {
        int firstResult = 0;
        int maxResults = 10;
        RestAssured.given().queryParam("firstResult", new Object[]{firstResult}).queryParam("maxResults", new Object[]{maxResults}).then().expect().statusCode(Response.Status.OK.getStatusCode()).when().get(EVENT_SUBSCRIPTION_URL, new Object[0]);
        ((EventSubscriptionQuery)Mockito.verify((Object)this.mockedEventSubscriptionQuery)).listPage(firstResult, maxResults);
    }

    @Test
    public void testMissingFirstResultParameter() {
        int maxResults = 10;
        RestAssured.given().queryParam("maxResults", new Object[]{maxResults}).then().expect().statusCode(Response.Status.OK.getStatusCode()).when().get(EVENT_SUBSCRIPTION_URL, new Object[0]);
        ((EventSubscriptionQuery)Mockito.verify((Object)this.mockedEventSubscriptionQuery)).listPage(0, maxResults);
    }

    @Test
    public void testMissingMaxResultsParameter() {
        int firstResult = 10;
        RestAssured.given().queryParam("firstResult", new Object[]{firstResult}).then().expect().statusCode(Response.Status.OK.getStatusCode()).when().get(EVENT_SUBSCRIPTION_URL, new Object[0]);
        ((EventSubscriptionQuery)Mockito.verify((Object)this.mockedEventSubscriptionQuery)).listPage(firstResult, Integer.MAX_VALUE);
    }

    @Test
    public void testQueryCount() {
        RestAssured.expect().statusCode(Response.Status.OK.getStatusCode()).body("count", Matchers.equalTo((Object)1), new Object[0]).when().get(EVENT_SUBSCRIPTION_COUNT_QUERY_URL, new Object[0]);
        ((EventSubscriptionQuery)Mockito.verify((Object)this.mockedEventSubscriptionQuery)).count();
    }

    protected void executeAndVerifySorting(String sortBy, String sortOrder, Response.Status expectedStatus) {
        RestAssured.given().queryParam("sortBy", new Object[]{sortBy}).queryParam("sortOrder", new Object[]{sortOrder}).then().expect().statusCode(expectedStatus.getStatusCode()).when().get(EVENT_SUBSCRIPTION_URL, new Object[0]);
    }

    private Map<String, String> getCompleteQueryParameters() {
        HashMap<String, String> parameters = new HashMap<String, String>();
        parameters.put("eventSubscriptionId", "anEventSubscriptionId");
        parameters.put("eventType", "aEventType");
        parameters.put("eventName", "aEventName");
        parameters.put("executionId", "aExecutionId");
        parameters.put("processInstanceId", "aProcessInstanceId");
        parameters.put("activityId", "aActivityId");
        return parameters;
    }

    private List<EventSubscription> createMockEventSubscriptionTwoTenants() {
        return Arrays.asList(MockProvider.createMockEventSubscription("aTenantId"), MockProvider.createMockEventSubscription("anotherTenantId"));
    }
}

