/*
 * Decompiled with CFR 0.152.
 */
package org.eximeebpms.bpm.engine.rest;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.type.TypeFactory;
import io.restassured.RestAssured;
import io.restassured.http.ContentType;
import io.restassured.response.Response;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.ws.rs.core.Response;
import org.eximeebpms.bpm.engine.AuthorizationException;
import org.eximeebpms.bpm.engine.ProcessEngineException;
import org.eximeebpms.bpm.engine.TaskService;
import org.eximeebpms.bpm.engine.impl.TaskServiceImpl;
import org.eximeebpms.bpm.engine.impl.digest._apacheCommonsCodec.Base64;
import org.eximeebpms.bpm.engine.impl.util.IoUtil;
import org.eximeebpms.bpm.engine.rest.AbstractRestServiceTest;
import org.eximeebpms.bpm.engine.rest.exception.InvalidRequestException;
import org.eximeebpms.bpm.engine.rest.exception.RestException;
import org.eximeebpms.bpm.engine.rest.helper.EqualsList;
import org.eximeebpms.bpm.engine.rest.helper.EqualsMap;
import org.eximeebpms.bpm.engine.rest.helper.ErrorMessageHelper;
import org.eximeebpms.bpm.engine.rest.helper.MockObjectValue;
import org.eximeebpms.bpm.engine.rest.helper.VariableTypeHelper;
import org.eximeebpms.bpm.engine.rest.helper.variable.EqualsNullValue;
import org.eximeebpms.bpm.engine.rest.helper.variable.EqualsObjectValue;
import org.eximeebpms.bpm.engine.rest.helper.variable.EqualsPrimitiveValue;
import org.eximeebpms.bpm.engine.rest.helper.variable.EqualsUntypedValue;
import org.eximeebpms.bpm.engine.rest.util.DateTimeUtils;
import org.eximeebpms.bpm.engine.rest.util.VariablesBuilder;
import org.eximeebpms.bpm.engine.rest.util.container.TestContainerRule;
import org.eximeebpms.bpm.engine.variable.Variables;
import org.eximeebpms.bpm.engine.variable.type.ValueType;
import org.eximeebpms.bpm.engine.variable.value.BooleanValue;
import org.eximeebpms.bpm.engine.variable.value.FileValue;
import org.eximeebpms.bpm.engine.variable.value.ObjectValue;
import org.eximeebpms.bpm.engine.variable.value.TypedValue;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.Matchers;
import org.junit.Assert;
import org.junit.Before;
import org.junit.ClassRule;
import org.junit.Test;
import org.mockito.ArgumentCaptor;
import org.mockito.Mockito;
import org.mockito.hamcrest.MockitoHamcrest;
import org.mockito.verification.VerificationMode;

public class TaskVariableLocalRestResourceInteractionTest
extends AbstractRestServiceTest {
    @ClassRule
    public static TestContainerRule rule = new TestContainerRule();
    protected static final String TASK_SERVICE_URL = "/rest-test/task";
    protected static final String SINGLE_TASK_URL = "/rest-test/task/{id}";
    protected static final String SINGLE_TASK_VARIABLES_URL = "/rest-test/task/{id}/localVariables";
    protected static final String SINGLE_TASK_SINGLE_VARIABLE_URL = "/rest-test/task/{id}/localVariables/{varId}";
    protected static final String SINGLE_TASK_PUT_SINGLE_VARIABLE_URL = "/rest-test/task/{id}/localVariables/{varId}";
    protected static final String SINGLE_TASK_SINGLE_BINARY_VARIABLE_URL = "/rest-test/task/{id}/localVariables/{varId}/data";
    protected static final String SINGLE_TASK_DELETE_SINGLE_VARIABLE_URL = "/rest-test/task/{id}/localVariables/{varId}";
    protected static final String SINGLE_TASK_MODIFY_VARIABLES_URL = "/rest-test/task/{id}/localVariables";
    protected TaskService taskServiceMock;

    @Before
    public void setUpRuntimeData() {
        this.taskServiceMock = (TaskService)Mockito.mock(TaskService.class);
        Mockito.when((Object)processEngine.getTaskService()).thenReturn((Object)this.taskServiceMock);
    }

    private TaskServiceImpl mockTaskServiceImpl() {
        TaskServiceImpl taskServiceMock = (TaskServiceImpl)Mockito.mock(TaskServiceImpl.class);
        Mockito.when((Object)processEngine.getTaskService()).thenReturn((Object)taskServiceMock);
        return taskServiceMock;
    }

    @Test
    public void testGetLocalVariables() {
        Mockito.when((Object)this.taskServiceMock.getVariablesLocalTyped("anId", true)).thenReturn((Object)EXAMPLE_VARIABLES);
        Response response = (Response)RestAssured.given().pathParam("id", (Object)"anId").header("accept", (Object)"application/json", new Object[0]).then().expect().statusCode(Response.Status.OK.getStatusCode()).body("aVariableKey", Matchers.notNullValue(), new Object[0]).body("aVariableKey.value", CoreMatchers.equalTo((Object)EXAMPLE_VARIABLE_VALUE.getValue()), new Object[0]).body("aVariableKey.type", CoreMatchers.equalTo((Object)VariableTypeHelper.toExpectedValueTypeName(EXAMPLE_VARIABLE_VALUE.getType())), new Object[0]).when().get("/rest-test/task/{id}/localVariables", new Object[0]);
        Assert.assertEquals((String)"Should return exactly one variable", (long)1L, (long)response.jsonPath().getMap("").size());
    }

    @Test
    public void testGetLocalObjectVariables() {
        String variableKey = "aVariableId";
        List<String> payload = Arrays.asList("a", "b");
        MockObjectValue variableValue = MockObjectValue.fromObjectValue((ObjectValue)Variables.objectValue(payload).serializationDataFormat("application/json").create()).objectTypeName(ArrayList.class.getName()).serializedValue("a serialized value");
        Mockito.when((Object)this.taskServiceMock.getVariablesLocalTyped((String)Mockito.eq((Object)"anId"), Mockito.anyBoolean())).thenReturn((Object)Variables.createVariables().putValueTyped(variableKey, (TypedValue)variableValue));
        RestAssured.given().pathParam("id", (Object)"anId").then().expect().statusCode(Response.Status.OK.getStatusCode()).body(variableKey + ".value", CoreMatchers.equalTo(payload), new Object[0]).body(variableKey + ".type", CoreMatchers.equalTo((Object)"Object"), new Object[0]).body(variableKey + ".valueInfo.serializationDataFormat", CoreMatchers.equalTo((Object)"application/json"), new Object[0]).body(variableKey + ".valueInfo.objectTypeName", CoreMatchers.equalTo((Object)ArrayList.class.getName()), new Object[0]).when().get("/rest-test/task/{id}/localVariables", new Object[0]);
        ((TaskService)Mockito.verify((Object)this.taskServiceMock)).getVariablesLocalTyped("anId", true);
    }

    @Test
    public void testGetLocalObjectVariablesSerialized() {
        String variableKey = "aVariableId";
        ObjectValue variableValue = (ObjectValue)Variables.serializedObjectValue((String)"a serialized value").serializationDataFormat("application/json").objectTypeName(ArrayList.class.getName()).create();
        Mockito.when((Object)this.taskServiceMock.getVariablesLocalTyped((String)Mockito.eq((Object)"anId"), Mockito.anyBoolean())).thenReturn((Object)Variables.createVariables().putValueTyped(variableKey, (TypedValue)variableValue));
        RestAssured.given().pathParam("id", (Object)"anId").queryParam("deserializeValues", new Object[]{false}).then().expect().statusCode(Response.Status.OK.getStatusCode()).body(variableKey + ".value", CoreMatchers.equalTo((Object)"a serialized value"), new Object[0]).body(variableKey + ".type", CoreMatchers.equalTo((Object)"Object"), new Object[0]).body(variableKey + ".valueInfo.serializationDataFormat", CoreMatchers.equalTo((Object)"application/json"), new Object[0]).body(variableKey + ".valueInfo.objectTypeName", CoreMatchers.equalTo((Object)ArrayList.class.getName()), new Object[0]).when().get("/rest-test/task/{id}/localVariables", new Object[0]);
        ((TaskService)Mockito.verify((Object)this.taskServiceMock)).getVariablesLocalTyped("anId", false);
    }

    @Test
    public void testGetLocalVariablesForNonExistingTaskId() {
        Mockito.when((Object)this.taskServiceMock.getVariablesLocalTyped("nonExistingId", true)).thenThrow(new Throwable[]{new ProcessEngineException("task nonExistingId doesn't exist")});
        RestAssured.given().pathParam("id", (Object)"nonExistingId").header("accept", (Object)"application/json", new Object[0]).then().expect().statusCode(Response.Status.INTERNAL_SERVER_ERROR.getStatusCode()).contentType(ContentType.JSON).body("type", CoreMatchers.equalTo((Object)ProcessEngineException.class.getSimpleName()), new Object[0]).body("message", CoreMatchers.equalTo((Object)"task nonExistingId doesn't exist"), new Object[0]).when().get("/rest-test/task/{id}/localVariables", new Object[0]);
    }

    @Test
    public void testGetLocalVariablesThrowsAuthorizationException() {
        String message = "expected exception";
        Mockito.when((Object)this.taskServiceMock.getVariablesLocalTyped(Mockito.anyString(), Mockito.anyBoolean())).thenThrow(new Throwable[]{new AuthorizationException(message)});
        RestAssured.given().pathParam("id", (Object)"anId").then().expect().statusCode(Response.Status.FORBIDDEN.getStatusCode()).contentType(ContentType.JSON).body("type", CoreMatchers.equalTo((Object)AuthorizationException.class.getSimpleName()), new Object[0]).body("message", CoreMatchers.equalTo((Object)message), new Object[0]).when().get("/rest-test/task/{id}/localVariables", new Object[0]);
    }

    @Test
    public void testLocalVariableModification() {
        TaskServiceImpl taskServiceMock = this.mockTaskServiceImpl();
        HashMap<String, Object> messageBodyJson = new HashMap<String, Object>();
        String variableKey = "aKey";
        int variableValue = 123;
        Map<String, Object> modifications = VariablesBuilder.create().variable(variableKey, variableValue).getVariables();
        messageBodyJson.put("modifications", modifications);
        ArrayList<String> deletions = new ArrayList<String>();
        deletions.add("deleteKey");
        messageBodyJson.put("deletions", deletions);
        RestAssured.given().pathParam("id", (Object)"anId").contentType(ContentType.JSON).body(messageBodyJson).header("accept", (Object)"application/json", new Object[0]).then().expect().statusCode(Response.Status.NO_CONTENT.getStatusCode()).when().post("/rest-test/task/{id}/localVariables", new Object[0]);
        HashMap<String, Object> expectedModifications = new HashMap<String, Object>();
        expectedModifications.put(variableKey, variableValue);
        ((TaskServiceImpl)Mockito.verify((Object)taskServiceMock)).updateVariablesLocal((String)Mockito.eq((Object)"anId"), (Map)MockitoHamcrest.argThat((Matcher)new EqualsMap(expectedModifications)), (Collection)MockitoHamcrest.argThat((Matcher)new EqualsList(deletions)));
    }

    @Test
    public void testLocalVariableModificationForNonExistingTaskId() {
        TaskServiceImpl taskServiceMock = this.mockTaskServiceImpl();
        ((TaskServiceImpl)Mockito.doThrow((Throwable[])new Throwable[]{new ProcessEngineException("Cannot find task with id nonExistingId")}).when((Object)taskServiceMock)).updateVariablesLocal((String)Mockito.any(), (Map)Mockito.any(), (Collection)Mockito.any());
        HashMap<String, Map<String, Object>> messageBodyJson = new HashMap<String, Map<String, Object>>();
        String variableKey = "aKey";
        int variableValue = 123;
        Map<String, Object> modifications = VariablesBuilder.create().variable(variableKey, variableValue).getVariables();
        messageBodyJson.put("modifications", modifications);
        RestAssured.given().pathParam("id", (Object)"nonExistingId").contentType(ContentType.JSON).body(messageBodyJson).header("accept", (Object)"application/json", new Object[0]).then().expect().statusCode(Response.Status.INTERNAL_SERVER_ERROR.getStatusCode()).contentType(ContentType.JSON).body("type", CoreMatchers.equalTo((Object)RestException.class.getSimpleName()), new Object[0]).body("message", CoreMatchers.equalTo((Object)"Cannot modify variables for task nonExistingId: Cannot find task with id nonExistingId"), new Object[0]).when().post("/rest-test/task/{id}/localVariables", new Object[0]);
    }

    @Test
    public void testEmptyLocalVariableModification() {
        this.mockTaskServiceImpl();
        RestAssured.given().pathParam("id", (Object)"anId").contentType(ContentType.JSON).body("{}").header("accept", (Object)"application/json", new Object[0]).then().expect().statusCode(Response.Status.NO_CONTENT.getStatusCode()).when().post("/rest-test/task/{id}/localVariables", new Object[0]);
    }

    @Test
    public void testVariableModificationThrowsAuthorizationException() {
        String variableKey = "aKey";
        int variableValue = 123;
        HashMap<String, Map<String, Object>> messageBodyJson = new HashMap<String, Map<String, Object>>();
        Map<String, Object> modifications = VariablesBuilder.create().variable(variableKey, variableValue).getVariables();
        messageBodyJson.put("modifications", modifications);
        TaskServiceImpl taskServiceMock = this.mockTaskServiceImpl();
        String message = "excpected exception";
        ((TaskServiceImpl)Mockito.doThrow((Throwable[])new Throwable[]{new AuthorizationException(message)}).when((Object)taskServiceMock)).updateVariablesLocal((String)Mockito.any(), (Map)Mockito.any(), (Collection)Mockito.any());
        RestAssured.given().pathParam("id", (Object)"anId").contentType(ContentType.JSON).body(messageBodyJson).then().expect().statusCode(Response.Status.FORBIDDEN.getStatusCode()).body("type", Matchers.is((Object)AuthorizationException.class.getSimpleName()), new Object[0]).body("message", Matchers.is((Object)message), new Object[0]).when().post("/rest-test/task/{id}/localVariables", new Object[0]);
    }

    @Test
    public void testGetSingleLocalVariable() {
        String variableKey = "aVariableKey";
        int variableValue = 123;
        Mockito.when((Object)this.taskServiceMock.getVariableLocalTyped((String)Mockito.eq((Object)"anId"), (String)Mockito.eq((Object)variableKey), Mockito.anyBoolean())).thenReturn((Object)Variables.integerValue((Integer)variableValue));
        RestAssured.given().pathParam("id", (Object)"anId").pathParam("varId", (Object)variableKey).header("accept", (Object)"application/json", new Object[0]).then().expect().statusCode(Response.Status.OK.getStatusCode()).body("value", Matchers.is((Object)123), new Object[0]).body("type", Matchers.is((Object)"Integer"), new Object[0]).when().get("/rest-test/task/{id}/localVariables/{varId}", new Object[0]);
    }

    @Test
    public void testGetSingleLocalVariableData() {
        Mockito.when((Object)this.taskServiceMock.getVariableLocalTyped(Mockito.anyString(), (String)Mockito.eq((Object)"aBytesVariableKey"), Mockito.eq((boolean)false))).thenReturn((Object)EXAMPLE_VARIABLE_VALUE_BYTES);
        RestAssured.given().pathParam("id", (Object)"anId").pathParam("varId", (Object)"aBytesVariableKey").then().expect().statusCode(Response.Status.OK.getStatusCode()).contentType("application/octet-stream").when().get(SINGLE_TASK_SINGLE_BINARY_VARIABLE_URL, new Object[0]);
        ((TaskService)Mockito.verify((Object)this.taskServiceMock)).getVariableLocalTyped("anId", "aBytesVariableKey", false);
    }

    @Test
    public void testGetSingleLocalVariableDataNonExisting() {
        Mockito.when((Object)this.taskServiceMock.getVariableLocalTyped(Mockito.anyString(), (String)Mockito.eq((Object)"nonExisting"), Mockito.eq((boolean)false))).thenReturn(null);
        RestAssured.given().pathParam("id", (Object)"anId").pathParam("varId", (Object)"nonExisting").then().expect().statusCode(Response.Status.NOT_FOUND.getStatusCode()).body("type", Matchers.is((Object)InvalidRequestException.class.getSimpleName()), new Object[0]).body("message", Matchers.is((Object)"task variable with name nonExisting does not exist"), new Object[0]).when().get(SINGLE_TASK_SINGLE_BINARY_VARIABLE_URL, new Object[0]);
        ((TaskService)Mockito.verify((Object)this.taskServiceMock)).getVariableLocalTyped("anId", "nonExisting", false);
    }

    @Test
    public void testGetSingleLocalVariabledataNotBinary() {
        Mockito.when((Object)this.taskServiceMock.getVariableLocalTyped(Mockito.anyString(), (String)Mockito.eq((Object)"aVariableKey"), Mockito.eq((boolean)false))).thenReturn((Object)EXAMPLE_VARIABLE_VALUE);
        RestAssured.given().pathParam("id", (Object)"anId").pathParam("varId", (Object)"aVariableKey").then().expect().statusCode(Response.Status.BAD_REQUEST.getStatusCode()).when().get(SINGLE_TASK_SINGLE_BINARY_VARIABLE_URL, new Object[0]);
        ((TaskService)Mockito.verify((Object)this.taskServiceMock)).getVariableLocalTyped("anId", "aVariableKey", false);
    }

    @Test
    public void testGetSingleLocalObjectVariable() {
        String variableKey = "aVariableId";
        List<String> payload = Arrays.asList("a", "b");
        MockObjectValue variableValue = MockObjectValue.fromObjectValue((ObjectValue)Variables.objectValue(payload).serializationDataFormat("application/json").create()).objectTypeName(ArrayList.class.getName()).serializedValue("a serialized value");
        Mockito.when((Object)this.taskServiceMock.getVariableLocalTyped((String)Mockito.eq((Object)"anId"), (String)Mockito.eq((Object)variableKey), Mockito.anyBoolean())).thenReturn((Object)variableValue);
        RestAssured.given().pathParam("id", (Object)"anId").pathParam("varId", (Object)variableKey).then().expect().statusCode(Response.Status.OK.getStatusCode()).body("value", CoreMatchers.equalTo(payload), new Object[0]).body("type", CoreMatchers.equalTo((Object)"Object"), new Object[0]).body("valueInfo.serializationDataFormat", CoreMatchers.equalTo((Object)"application/json"), new Object[0]).body("valueInfo.objectTypeName", CoreMatchers.equalTo((Object)ArrayList.class.getName()), new Object[0]).when().get("/rest-test/task/{id}/localVariables/{varId}", new Object[0]);
        ((TaskService)Mockito.verify((Object)this.taskServiceMock)).getVariableLocalTyped("anId", variableKey, true);
    }

    @Test
    public void testGetSingleLocalObjectVariableSerialized() {
        String variableKey = "aVariableId";
        ObjectValue variableValue = (ObjectValue)Variables.serializedObjectValue((String)"a serialized value").serializationDataFormat("application/json").objectTypeName(ArrayList.class.getName()).create();
        Mockito.when((Object)this.taskServiceMock.getVariableLocalTyped((String)Mockito.eq((Object)"anId"), (String)Mockito.eq((Object)variableKey), Mockito.anyBoolean())).thenReturn((Object)variableValue);
        RestAssured.given().pathParam("id", (Object)"anId").pathParam("varId", (Object)variableKey).queryParam("deserializeValue", new Object[]{false}).then().expect().statusCode(Response.Status.OK.getStatusCode()).body("value", CoreMatchers.equalTo((Object)"a serialized value"), new Object[0]).body("type", CoreMatchers.equalTo((Object)"Object"), new Object[0]).body("valueInfo.serializationDataFormat", CoreMatchers.equalTo((Object)"application/json"), new Object[0]).body("valueInfo.objectTypeName", CoreMatchers.equalTo((Object)ArrayList.class.getName()), new Object[0]).when().get("/rest-test/task/{id}/localVariables/{varId}", new Object[0]);
        ((TaskService)Mockito.verify((Object)this.taskServiceMock)).getVariableLocalTyped("anId", variableKey, false);
    }

    @Test
    public void testNonExistingLocalVariable() {
        String variableKey = "aVariableKey";
        Mockito.when((Object)this.taskServiceMock.getVariableLocal((String)Mockito.eq((Object)"anId"), (String)Mockito.eq((Object)variableKey))).thenReturn(null);
        RestAssured.given().pathParam("id", (Object)"anId").pathParam("varId", (Object)variableKey).header("accept", (Object)"application/json", new Object[0]).then().expect().statusCode(Response.Status.NOT_FOUND.getStatusCode()).body("type", Matchers.is((Object)InvalidRequestException.class.getSimpleName()), new Object[0]).body("message", Matchers.is((Object)("task variable with name " + variableKey + " does not exist")), new Object[0]).when().get("/rest-test/task/{id}/localVariables/{varId}", new Object[0]);
    }

    @Test
    public void testGetLocalVariableForNonExistingTaskId() {
        String variableKey = "aVariableKey";
        Mockito.when((Object)this.taskServiceMock.getVariableLocalTyped((String)Mockito.eq((Object)"nonExistingId"), (String)Mockito.eq((Object)variableKey), Mockito.anyBoolean())).thenThrow(new Throwable[]{new ProcessEngineException("task nonExistingId doesn't exist")});
        RestAssured.given().pathParam("id", (Object)"nonExistingId").pathParam("varId", (Object)variableKey).header("accept", (Object)"application/json", new Object[0]).then().expect().statusCode(Response.Status.INTERNAL_SERVER_ERROR.getStatusCode()).body("type", Matchers.is((Object)RestException.class.getSimpleName()), new Object[0]).body("message", Matchers.is((Object)("Cannot get task variable " + variableKey + ": task nonExistingId doesn't exist")), new Object[0]).when().get("/rest-test/task/{id}/localVariables/{varId}", new Object[0]);
    }

    @Test
    public void testGetSingleLocalVariableThrowsAuthorizationException() {
        String variableKey = "aVariableKey";
        String message = "excpected exception";
        Mockito.when((Object)this.taskServiceMock.getVariableLocalTyped(Mockito.anyString(), Mockito.anyString(), Mockito.anyBoolean())).thenThrow(new Throwable[]{new AuthorizationException(message)});
        RestAssured.given().pathParam("id", (Object)"anId").pathParam("varId", (Object)variableKey).then().expect().statusCode(Response.Status.FORBIDDEN.getStatusCode()).body("type", Matchers.is((Object)AuthorizationException.class.getSimpleName()), new Object[0]).body("message", Matchers.is((Object)message), new Object[0]).when().get("/rest-test/task/{id}/localVariables/{varId}", new Object[0]);
    }

    @Test
    public void testGetFileVariable() {
        String variableKey = "aVariableKey";
        byte[] byteContent = "some bytes".getBytes();
        String filename = "test.txt";
        String mimeType = "text/plain";
        FileValue variableValue = (FileValue)Variables.fileValue((String)filename).file(byteContent).mimeType(mimeType).create();
        Mockito.when((Object)this.taskServiceMock.getVariableLocalTyped((String)Mockito.eq((Object)"anId"), (String)Mockito.eq((Object)variableKey), Mockito.anyBoolean())).thenReturn((Object)variableValue);
        RestAssured.given().pathParam("id", (Object)"anId").pathParam("varId", (Object)variableKey).then().expect().statusCode(Response.Status.OK.getStatusCode()).contentType(ContentType.JSON.toString()).and().body("valueInfo.mimeType", CoreMatchers.equalTo((Object)mimeType), new Object[0]).body("valueInfo.filename", CoreMatchers.equalTo((Object)filename), new Object[0]).body("value", CoreMatchers.nullValue(), new Object[0]).when().get("/rest-test/task/{id}/localVariables/{varId}", new Object[0]);
    }

    @Test
    public void testGetNullFileVariable() {
        String variableKey = "aVariableKey";
        String filename = "test.txt";
        String mimeType = "text/plain";
        FileValue variableValue = (FileValue)Variables.fileValue((String)filename).mimeType(mimeType).create();
        Mockito.when((Object)this.taskServiceMock.getVariableLocalTyped((String)Mockito.eq((Object)"anId"), (String)Mockito.eq((Object)variableKey), Mockito.anyBoolean())).thenReturn((Object)variableValue);
        RestAssured.given().pathParam("id", (Object)"anId").pathParam("varId", (Object)variableKey).then().expect().statusCode(Response.Status.OK.getStatusCode()).contentType(ContentType.TEXT.toString()).and().body(Matchers.is((Matcher)CoreMatchers.equalTo((Object)"")), new Matcher[0]).when().get(SINGLE_TASK_SINGLE_BINARY_VARIABLE_URL, new Object[0]);
    }

    @Test
    public void testGetFileVariableDownloadWithType() {
        String variableKey = "aVariableKey";
        byte[] byteContent = "some bytes".getBytes();
        String filename = "test.txt";
        FileValue variableValue = (FileValue)Variables.fileValue((String)filename).file(byteContent).mimeType(ContentType.TEXT.toString()).create();
        Mockito.when((Object)this.taskServiceMock.getVariableLocalTyped((String)Mockito.eq((Object)"anId"), (String)Mockito.eq((Object)variableKey), Mockito.anyBoolean())).thenReturn((Object)variableValue);
        RestAssured.given().pathParam("id", (Object)"anId").pathParam("varId", (Object)variableKey).then().expect().statusCode(Response.Status.OK.getStatusCode()).contentType(ContentType.TEXT.toString()).and().body(Matchers.is((Matcher)CoreMatchers.equalTo((Object)new String(byteContent))), new Matcher[0]).when().get(SINGLE_TASK_SINGLE_BINARY_VARIABLE_URL, new Object[0]);
    }

    @Test
    public void testGetFileVariableDownloadWithTypeAndEncoding() {
        String variableKey = "aVariableKey";
        byte[] byteContent = "some bytes".getBytes();
        String filename = "test.txt";
        String encoding = "UTF-8";
        FileValue variableValue = (FileValue)Variables.fileValue((String)filename).file(byteContent).mimeType(ContentType.TEXT.toString()).encoding(encoding).create();
        Mockito.when((Object)this.taskServiceMock.getVariableLocalTyped((String)Mockito.eq((Object)"anId"), (String)Mockito.eq((Object)variableKey), Mockito.anyBoolean())).thenReturn((Object)variableValue);
        Response response = (Response)RestAssured.given().pathParam("id", (Object)"anId").pathParam("varId", (Object)variableKey).then().expect().statusCode(Response.Status.OK.getStatusCode()).body(Matchers.is((Matcher)CoreMatchers.equalTo((Object)new String(byteContent))), new Matcher[0]).when().get(SINGLE_TASK_SINGLE_BINARY_VARIABLE_URL, new Object[0]);
        String contentType = response.contentType().replaceAll(" ", "");
        MatcherAssert.assertThat((Object)contentType, (Matcher)Matchers.is((Object)(ContentType.TEXT + ";charset=" + encoding)));
    }

    @Test
    public void testGetFileVariableDownloadWithoutType() {
        String variableKey = "aVariableKey";
        byte[] byteContent = "some bytes".getBytes();
        String filename = "test.txt";
        FileValue variableValue = (FileValue)Variables.fileValue((String)filename).file(byteContent).create();
        Mockito.when((Object)this.taskServiceMock.getVariableLocalTyped((String)Mockito.eq((Object)"anId"), (String)Mockito.eq((Object)variableKey), Mockito.anyBoolean())).thenReturn((Object)variableValue);
        RestAssured.given().pathParam("id", (Object)"anId").pathParam("varId", (Object)variableKey).then().expect().statusCode(Response.Status.OK.getStatusCode()).contentType("application/octet-stream").and().body(Matchers.is((Matcher)CoreMatchers.equalTo((Object)new String(byteContent))), new Matcher[0]).header("Content-Disposition", Matchers.containsString((String)filename)).when().get(SINGLE_TASK_SINGLE_BINARY_VARIABLE_URL, new Object[0]);
    }

    @Test
    public void testCannotDownloadVariableOtherThanFile() {
        String variableKey = "aVariableKey";
        BooleanValue variableValue = Variables.booleanValue((Boolean)true);
        Mockito.when((Object)this.taskServiceMock.getVariableLocalTyped((String)Mockito.eq((Object)"anId"), (String)Mockito.eq((Object)variableKey), Mockito.anyBoolean())).thenReturn((Object)variableValue);
        RestAssured.given().pathParam("id", (Object)"anId").pathParam("varId", (Object)variableKey).then().expect().statusCode(Response.Status.BAD_REQUEST.getStatusCode()).when().get(SINGLE_TASK_SINGLE_BINARY_VARIABLE_URL, new Object[0]);
    }

    @Test
    public void testPutSingleLocalVariable() {
        String variableKey = "aVariableKey";
        String variableValue = "aVariableValue";
        Map<String, Object> variableJson = VariablesBuilder.getVariableValueMap(variableValue);
        RestAssured.given().pathParam("id", (Object)"anId").pathParam("varId", (Object)variableKey).contentType(ContentType.JSON).body(variableJson).header("accept", (Object)"application/json", new Object[0]).then().expect().statusCode(Response.Status.NO_CONTENT.getStatusCode()).when().put("/rest-test/task/{id}/localVariables/{varId}", new Object[0]);
        ((TaskService)Mockito.verify((Object)this.taskServiceMock)).setVariableLocal((String)Mockito.eq((Object)"anId"), (String)Mockito.eq((Object)variableKey), MockitoHamcrest.argThat((Matcher)EqualsUntypedValue.matcher().value(variableValue)));
    }

    @Test
    public void testPutSingleVariableWithTypeInteger() {
        String variableKey = "aVariableKey";
        Integer variableValue = 123;
        String type = "Integer";
        Map<String, Object> variableJson = VariablesBuilder.getVariableValueMap((Object)variableValue, type);
        RestAssured.given().pathParam("id", (Object)"anId").pathParam("varId", (Object)variableKey).contentType(ContentType.JSON).body(variableJson).header("accept", (Object)"application/json", new Object[0]).then().expect().statusCode(Response.Status.NO_CONTENT.getStatusCode()).when().put("/rest-test/task/{id}/localVariables/{varId}", new Object[0]);
        ((TaskService)Mockito.verify((Object)this.taskServiceMock)).setVariableLocal((String)Mockito.eq((Object)"anId"), (String)Mockito.eq((Object)variableKey), MockitoHamcrest.argThat((Matcher)EqualsPrimitiveValue.integerValue(variableValue)));
    }

    @Test
    public void testPutSingleVariableWithUnparseableInteger() {
        String variableKey = "aVariableKey";
        String variableValue = "1abc";
        String type = "Integer";
        Map<String, Object> variableJson = VariablesBuilder.getVariableValueMap((Object)variableValue, type);
        RestAssured.given().pathParam("id", (Object)"anId").pathParam("varId", (Object)variableKey).contentType(ContentType.JSON).body(variableJson).header("accept", (Object)"application/json", new Object[0]).then().expect().statusCode(Response.Status.BAD_REQUEST.getStatusCode()).body("type", CoreMatchers.equalTo((Object)InvalidRequestException.class.getSimpleName()), new Object[0]).body("message", CoreMatchers.equalTo((Object)("Cannot put task variable " + variableKey + ": " + ErrorMessageHelper.getExpectedFailingConversionMessage(variableValue, type, Integer.class))), new Object[0]).when().put("/rest-test/task/{id}/localVariables/{varId}", new Object[0]);
    }

    @Test
    public void testPutSingleVariableWithTypeShort() {
        String variableKey = "aVariableKey";
        Short variableValue = 123;
        String type = "Short";
        Map<String, Object> variableJson = VariablesBuilder.getVariableValueMap((Object)variableValue, type);
        RestAssured.given().pathParam("id", (Object)"anId").pathParam("varId", (Object)variableKey).contentType(ContentType.JSON).body(variableJson).header("accept", (Object)"application/json", new Object[0]).then().expect().statusCode(Response.Status.NO_CONTENT.getStatusCode()).when().put("/rest-test/task/{id}/localVariables/{varId}", new Object[0]);
        ((TaskService)Mockito.verify((Object)this.taskServiceMock)).setVariableLocal((String)Mockito.eq((Object)"anId"), (String)Mockito.eq((Object)variableKey), MockitoHamcrest.argThat((Matcher)EqualsPrimitiveValue.shortValue(variableValue)));
    }

    @Test
    public void testPutSingleVariableWithUnparseableShort() {
        String variableKey = "aVariableKey";
        String variableValue = "1abc";
        String type = "Short";
        Map<String, Object> variableJson = VariablesBuilder.getVariableValueMap((Object)variableValue, type);
        RestAssured.given().pathParam("id", (Object)"anId").pathParam("varId", (Object)variableKey).contentType(ContentType.JSON).body(variableJson).header("accept", (Object)"application/json", new Object[0]).then().expect().statusCode(Response.Status.BAD_REQUEST.getStatusCode()).body("type", CoreMatchers.equalTo((Object)InvalidRequestException.class.getSimpleName()), new Object[0]).body("message", CoreMatchers.equalTo((Object)("Cannot put task variable " + variableKey + ": " + ErrorMessageHelper.getExpectedFailingConversionMessage(variableValue, type, Short.class))), new Object[0]).when().put("/rest-test/task/{id}/localVariables/{varId}", new Object[0]);
    }

    @Test
    public void testPutSingleVariableWithTypeLong() {
        String variableKey = "aVariableKey";
        Long variableValue = 123L;
        String type = "Long";
        Map<String, Object> variableJson = VariablesBuilder.getVariableValueMap((Object)variableValue, type);
        RestAssured.given().pathParam("id", (Object)"anId").pathParam("varId", (Object)variableKey).contentType(ContentType.JSON).body(variableJson).header("accept", (Object)"application/json", new Object[0]).then().expect().statusCode(Response.Status.NO_CONTENT.getStatusCode()).when().put("/rest-test/task/{id}/localVariables/{varId}", new Object[0]);
        ((TaskService)Mockito.verify((Object)this.taskServiceMock)).setVariableLocal((String)Mockito.eq((Object)"anId"), (String)Mockito.eq((Object)variableKey), MockitoHamcrest.argThat((Matcher)EqualsPrimitiveValue.longValue(variableValue)));
    }

    @Test
    public void testPutSingleVariableWithUnparseableLong() {
        String variableKey = "aVariableKey";
        String variableValue = "1abc";
        String type = "Long";
        Map<String, Object> variableJson = VariablesBuilder.getVariableValueMap((Object)variableValue, type);
        RestAssured.given().pathParam("id", (Object)"anExecutionId").pathParam("varId", (Object)variableKey).contentType(ContentType.JSON).body(variableJson).header("accept", (Object)"application/json", new Object[0]).then().expect().statusCode(Response.Status.BAD_REQUEST.getStatusCode()).body("type", CoreMatchers.equalTo((Object)InvalidRequestException.class.getSimpleName()), new Object[0]).body("message", CoreMatchers.equalTo((Object)("Cannot put task variable " + variableKey + ": " + ErrorMessageHelper.getExpectedFailingConversionMessage(variableValue, type, Long.class))), new Object[0]).when().put("/rest-test/task/{id}/localVariables/{varId}", new Object[0]);
    }

    @Test
    public void testPutSingleVariableWithTypeDouble() {
        String variableKey = "aVariableKey";
        Double variableValue = 123.456;
        String type = "Double";
        Map<String, Object> variableJson = VariablesBuilder.getVariableValueMap((Object)variableValue, type);
        RestAssured.given().pathParam("id", (Object)"anId").pathParam("varId", (Object)variableKey).contentType(ContentType.JSON).body(variableJson).header("accept", (Object)"application/json", new Object[0]).then().expect().statusCode(Response.Status.NO_CONTENT.getStatusCode()).when().put("/rest-test/task/{id}/localVariables/{varId}", new Object[0]);
        ((TaskService)Mockito.verify((Object)this.taskServiceMock)).setVariableLocal((String)Mockito.eq((Object)"anId"), (String)Mockito.eq((Object)variableKey), MockitoHamcrest.argThat((Matcher)EqualsPrimitiveValue.doubleValue(variableValue)));
    }

    @Test
    public void testPutSingleVariableWithUnparseableDouble() {
        String variableKey = "aVariableKey";
        String variableValue = "1abc";
        String type = "Double";
        Map<String, Object> variableJson = VariablesBuilder.getVariableValueMap((Object)variableValue, type);
        RestAssured.given().pathParam("id", (Object)"anId").pathParam("varId", (Object)variableKey).contentType(ContentType.JSON).body(variableJson).header("accept", (Object)"application/json", new Object[0]).then().expect().statusCode(Response.Status.BAD_REQUEST.getStatusCode()).body("type", CoreMatchers.equalTo((Object)InvalidRequestException.class.getSimpleName()), new Object[0]).body("message", CoreMatchers.equalTo((Object)("Cannot put task variable " + variableKey + ": " + ErrorMessageHelper.getExpectedFailingConversionMessage(variableValue, type, Double.class))), new Object[0]).when().put("/rest-test/task/{id}/localVariables/{varId}", new Object[0]);
    }

    @Test
    public void testPutSingleVariableWithTypeBoolean() {
        String variableKey = "aVariableKey";
        Boolean variableValue = true;
        String type = "Boolean";
        Map<String, Object> variableJson = VariablesBuilder.getVariableValueMap((Object)variableValue, type);
        RestAssured.given().pathParam("id", (Object)"anId").pathParam("varId", (Object)variableKey).contentType(ContentType.JSON).body(variableJson).header("accept", (Object)"application/json", new Object[0]).then().expect().statusCode(Response.Status.NO_CONTENT.getStatusCode()).when().put("/rest-test/task/{id}/localVariables/{varId}", new Object[0]);
        ((TaskService)Mockito.verify((Object)this.taskServiceMock)).setVariableLocal((String)Mockito.eq((Object)"anId"), (String)Mockito.eq((Object)variableKey), MockitoHamcrest.argThat((Matcher)EqualsPrimitiveValue.booleanValue(variableValue)));
    }

    @Test
    public void testPutSingleVariableWithTypeDate() throws Exception {
        Date now = new Date();
        String variableKey = "aVariableKey";
        String variableValue = DateTimeUtils.DATE_FORMAT_WITH_TIMEZONE.format(now);
        String type = "Date";
        Date expectedValue = DateTimeUtils.DATE_FORMAT_WITH_TIMEZONE.parse(variableValue);
        Map<String, Object> variableJson = VariablesBuilder.getVariableValueMap((Object)variableValue, type);
        RestAssured.given().pathParam("id", (Object)"anId").pathParam("varId", (Object)variableKey).contentType(ContentType.JSON).body(variableJson).header("accept", (Object)"application/json", new Object[0]).then().expect().statusCode(Response.Status.NO_CONTENT.getStatusCode()).when().put("/rest-test/task/{id}/localVariables/{varId}", new Object[0]);
        ((TaskService)Mockito.verify((Object)this.taskServiceMock)).setVariableLocal((String)Mockito.eq((Object)"anId"), (String)Mockito.eq((Object)variableKey), MockitoHamcrest.argThat((Matcher)EqualsPrimitiveValue.dateValue(expectedValue)));
    }

    @Test
    public void testPutSingleVariableWithUnparseableDate() {
        String variableKey = "aVariableKey";
        String variableValue = "1abc";
        String type = "Date";
        Map<String, Object> variableJson = VariablesBuilder.getVariableValueMap((Object)variableValue, type);
        RestAssured.given().pathParam("id", (Object)"anId").pathParam("varId", (Object)variableKey).contentType(ContentType.JSON).body(variableJson).header("accept", (Object)"application/json", new Object[0]).then().expect().statusCode(Response.Status.BAD_REQUEST.getStatusCode()).body("type", CoreMatchers.equalTo((Object)InvalidRequestException.class.getSimpleName()), new Object[0]).body("message", CoreMatchers.equalTo((Object)("Cannot put task variable " + variableKey + ": " + ErrorMessageHelper.getExpectedFailingConversionMessage(variableValue, type, Date.class))), new Object[0]).when().put("/rest-test/task/{id}/localVariables/{varId}", new Object[0]);
    }

    @Test
    public void testPutSingleVariableWithNotSupportedType() {
        String variableKey = "aVariableKey";
        String variableValue = "1abc";
        String type = "X";
        Map<String, Object> variableJson = VariablesBuilder.getVariableValueMap((Object)variableValue, type);
        RestAssured.given().pathParam("id", (Object)"anId").pathParam("varId", (Object)variableKey).contentType(ContentType.JSON).body(variableJson).header("accept", (Object)"application/json", new Object[0]).then().expect().statusCode(Response.Status.BAD_REQUEST.getStatusCode()).body("type", CoreMatchers.equalTo((Object)InvalidRequestException.class.getSimpleName()), new Object[0]).body("message", CoreMatchers.equalTo((Object)("Cannot put task variable " + variableKey + ": Unsupported value type 'X'")), new Object[0]).when().put("/rest-test/task/{id}/localVariables/{varId}", new Object[0]);
    }

    @Test
    public void testPutSingleLocalVariableWithNoValue() {
        String variableKey = "aVariableKey";
        RestAssured.given().pathParam("id", (Object)"anId").pathParam("varId", (Object)variableKey).contentType(ContentType.JSON).body("{}").header("accept", (Object)"application/json", new Object[0]).then().expect().statusCode(Response.Status.NO_CONTENT.getStatusCode()).when().put("/rest-test/task/{id}/localVariables/{varId}", new Object[0]);
        ((TaskService)Mockito.verify((Object)this.taskServiceMock)).setVariableLocal((String)Mockito.eq((Object)"anId"), (String)Mockito.eq((Object)variableKey), MockitoHamcrest.argThat((Matcher)EqualsNullValue.matcher()));
    }

    @Test
    public void testPutLocalVariableForNonExistingTaskId() {
        String variableKey = "aVariableKey";
        String variableValue = "aVariableValue";
        Map<String, Object> variableJson = VariablesBuilder.getVariableValueMap(variableValue);
        ((TaskService)Mockito.doThrow((Throwable[])new Throwable[]{new ProcessEngineException("Cannot find task with id nonExistingId")}).when((Object)this.taskServiceMock)).setVariableLocal((String)Mockito.eq((Object)"nonExistingId"), (String)Mockito.eq((Object)variableKey), Mockito.any());
        RestAssured.given().pathParam("id", (Object)"nonExistingId").pathParam("varId", (Object)variableKey).contentType(ContentType.JSON).body(variableJson).header("accept", (Object)"application/json", new Object[0]).then().expect().statusCode(Response.Status.INTERNAL_SERVER_ERROR.getStatusCode()).body("type", Matchers.is((Object)RestException.class.getSimpleName()), new Object[0]).body("message", Matchers.is((Object)("Cannot put task variable " + variableKey + ": Cannot find task with id nonExistingId")), new Object[0]).when().put("/rest-test/task/{id}/localVariables/{varId}", new Object[0]);
    }

    @Test
    public void testPutSingleVariableThrowsAuthorizationException() {
        String variableKey = "aVariableKey";
        String variableValue = "1abc";
        String type = "String";
        Map<String, Object> variableJson = VariablesBuilder.getVariableValueMap((Object)variableValue, type);
        String message = "expected exception";
        ((TaskService)Mockito.doThrow((Throwable[])new Throwable[]{new AuthorizationException(message)}).when((Object)this.taskServiceMock)).setVariableLocal(Mockito.anyString(), Mockito.anyString(), Mockito.any());
        RestAssured.given().pathParam("id", (Object)"anId").pathParam("varId", (Object)variableKey).contentType(ContentType.JSON).body(variableJson).then().expect().statusCode(Response.Status.FORBIDDEN.getStatusCode()).body("type", CoreMatchers.equalTo((Object)AuthorizationException.class.getSimpleName()), new Object[0]).body("message", CoreMatchers.equalTo((Object)message), new Object[0]).when().put("/rest-test/task/{id}/localVariables/{varId}", new Object[0]);
    }

    @Test
    public void testPostSingleLocalBinaryVariable() throws Exception {
        byte[] bytes = "someContent".getBytes();
        String variableKey = "aVariableKey";
        RestAssured.given().pathParam("id", (Object)"anId").pathParam("varId", (Object)variableKey).multiPart("data", null, bytes).header("accept", (Object)"application/json", new Object[0]).expect().statusCode(Response.Status.NO_CONTENT.getStatusCode()).when().post(SINGLE_TASK_SINGLE_BINARY_VARIABLE_URL, new Object[0]);
        ((TaskService)Mockito.verify((Object)this.taskServiceMock)).setVariableLocal((String)Mockito.eq((Object)"anId"), (String)Mockito.eq((Object)variableKey), MockitoHamcrest.argThat((Matcher)EqualsPrimitiveValue.bytesValue(bytes)));
    }

    @Test
    public void testPostSingleLocalBinaryVariableWithValueType() throws Exception {
        byte[] bytes = "someContent".getBytes();
        String variableKey = "aVariableKey";
        RestAssured.given().pathParam("id", (Object)"anId").pathParam("varId", (Object)variableKey).multiPart("data", null, bytes).multiPart("valueType", "Bytes", "text/plain").header("accept", (Object)"application/json", new Object[0]).expect().statusCode(Response.Status.NO_CONTENT.getStatusCode()).when().post(SINGLE_TASK_SINGLE_BINARY_VARIABLE_URL, new Object[0]);
        ((TaskService)Mockito.verify((Object)this.taskServiceMock)).setVariableLocal((String)Mockito.eq((Object)"anId"), (String)Mockito.eq((Object)variableKey), MockitoHamcrest.argThat((Matcher)EqualsPrimitiveValue.bytesValue(bytes)));
    }

    @Test
    public void testPostSingleLocalBinaryVariableWithNoValue() throws Exception {
        byte[] bytes = new byte[]{};
        String variableKey = "aVariableKey";
        RestAssured.given().pathParam("id", (Object)"anId").pathParam("varId", (Object)variableKey).multiPart("data", null, bytes).header("accept", (Object)"application/json", new Object[0]).expect().statusCode(Response.Status.NO_CONTENT.getStatusCode()).when().post(SINGLE_TASK_SINGLE_BINARY_VARIABLE_URL, new Object[0]);
        ((TaskService)Mockito.verify((Object)this.taskServiceMock)).setVariableLocal((String)Mockito.eq((Object)"anId"), (String)Mockito.eq((Object)variableKey), MockitoHamcrest.argThat((Matcher)EqualsPrimitiveValue.bytesValue(bytes)));
    }

    @Test
    public void testPutSingleBinaryVariableThrowsAuthorizationException() {
        byte[] bytes = "someContent".getBytes();
        String variableKey = "aVariableKey";
        String message = "expected exception";
        ((TaskService)Mockito.doThrow((Throwable[])new Throwable[]{new AuthorizationException(message)}).when((Object)this.taskServiceMock)).setVariableLocal(Mockito.anyString(), Mockito.anyString(), Mockito.any());
        RestAssured.given().pathParam("id", (Object)"anId").pathParam("varId", (Object)variableKey).multiPart("data", "unspecified", bytes).expect().statusCode(Response.Status.FORBIDDEN.getStatusCode()).contentType(ContentType.JSON).body("type", CoreMatchers.equalTo((Object)AuthorizationException.class.getSimpleName()), new Object[0]).body("message", CoreMatchers.equalTo((Object)message), new Object[0]).when().post(SINGLE_TASK_SINGLE_BINARY_VARIABLE_URL, new Object[0]);
    }

    @Test
    public void testPostSingleLocalSerializableVariable() throws Exception {
        ArrayList<String> serializable = new ArrayList<String>();
        serializable.add("foo");
        ObjectMapper mapper = new ObjectMapper();
        String jsonBytes = mapper.writeValueAsString(serializable);
        String typeName = TypeFactory.defaultInstance().constructType(serializable.getClass()).toCanonical();
        String variableKey = "aVariableKey";
        RestAssured.given().pathParam("id", (Object)"anId").pathParam("varId", (Object)variableKey).multiPart("data", jsonBytes, "application/json").multiPart("type", typeName, "text/plain").header("accept", (Object)"application/json", new Object[0]).expect().statusCode(Response.Status.NO_CONTENT.getStatusCode()).when().post(SINGLE_TASK_SINGLE_BINARY_VARIABLE_URL, new Object[0]);
        ((TaskService)Mockito.verify((Object)this.taskServiceMock)).setVariableLocal((String)Mockito.eq((Object)"anId"), (String)Mockito.eq((Object)variableKey), MockitoHamcrest.argThat((Matcher)EqualsObjectValue.objectValueMatcher().isDeserialized().value(serializable)));
    }

    @Test
    public void testPostSingleLocalSerializableVariableUnsupportedMediaType() throws Exception {
        ArrayList<String> serializable = new ArrayList<String>();
        serializable.add("foo");
        ObjectMapper mapper = new ObjectMapper();
        String jsonBytes = mapper.writeValueAsString(serializable);
        String typeName = TypeFactory.defaultInstance().constructType(serializable.getClass()).toCanonical();
        String variableKey = "aVariableKey";
        RestAssured.given().pathParam("id", (Object)"anId").pathParam("varId", (Object)variableKey).multiPart("data", jsonBytes, "unsupported").multiPart("type", typeName, "text/plain").header("accept", (Object)"application/json", new Object[0]).expect().statusCode(Response.Status.BAD_REQUEST.getStatusCode()).body(Matchers.containsString((String)"Unrecognized content type for serialized java type: unsupported"), new Matcher[0]).when().post(SINGLE_TASK_SINGLE_BINARY_VARIABLE_URL, new Object[0]);
        ((TaskService)Mockito.verify((Object)this.taskServiceMock, (VerificationMode)Mockito.never())).setVariableLocal((String)Mockito.eq((Object)"anId"), (String)Mockito.eq((Object)variableKey), Mockito.eq(serializable));
    }

    @Test
    public void testPostSingleLocalFileVariableWithEncodingAndMimeType() throws Exception {
        byte[] value = "some text".getBytes();
        String variableKey = "aVariableKey";
        String encoding = "utf-8";
        String filename = "test.txt";
        String mimetype = "text/plain";
        RestAssured.given().pathParam("id", (Object)"anId").pathParam("varId", (Object)variableKey).multiPart("data", filename, value, mimetype + "; encoding=" + encoding).multiPart("valueType", "File", "text/plain").header("accept", (Object)"application/json", new Object[0]).expect().statusCode(Response.Status.NO_CONTENT.getStatusCode()).when().post(SINGLE_TASK_SINGLE_BINARY_VARIABLE_URL, new Object[0]);
        ArgumentCaptor captor = ArgumentCaptor.forClass(FileValue.class);
        ((TaskService)Mockito.verify((Object)this.taskServiceMock)).setVariableLocal((String)Mockito.eq((Object)"anId"), (String)Mockito.eq((Object)variableKey), captor.capture());
        FileValue captured = (FileValue)captor.getValue();
        MatcherAssert.assertThat((Object)captured.getEncoding(), (Matcher)Matchers.is((Object)encoding));
        MatcherAssert.assertThat((Object)captured.getFilename(), (Matcher)Matchers.is((Object)filename));
        MatcherAssert.assertThat((Object)captured.getMimeType(), (Matcher)Matchers.is((Object)mimetype));
        MatcherAssert.assertThat((Object)IoUtil.readInputStream((InputStream)captured.getValue(), null), (Matcher)Matchers.is((Object)value));
    }

    @Test
    public void testPostSingleLocalFileVariableWithMimeType() throws Exception {
        byte[] value = "some text".getBytes();
        String base64 = Base64.encodeBase64String((byte[])value);
        String variableKey = "aVariableKey";
        String filename = "test.txt";
        String mimetype = "text/plain";
        RestAssured.given().pathParam("id", (Object)"anId").pathParam("varId", (Object)variableKey).multiPart("data", filename, value, mimetype).multiPart("valueType", "File", "text/plain").header("accept", (Object)"application/json", new Object[0]).expect().statusCode(Response.Status.NO_CONTENT.getStatusCode()).when().post(SINGLE_TASK_SINGLE_BINARY_VARIABLE_URL, new Object[0]);
        ArgumentCaptor captor = ArgumentCaptor.forClass(FileValue.class);
        ((TaskService)Mockito.verify((Object)this.taskServiceMock)).setVariableLocal((String)Mockito.eq((Object)"anId"), (String)Mockito.eq((Object)variableKey), captor.capture());
        FileValue captured = (FileValue)captor.getValue();
        MatcherAssert.assertThat((Object)captured.getEncoding(), (Matcher)Matchers.is((Matcher)CoreMatchers.nullValue()));
        MatcherAssert.assertThat((Object)captured.getFilename(), (Matcher)Matchers.is((Object)filename));
        MatcherAssert.assertThat((Object)captured.getMimeType(), (Matcher)Matchers.is((Object)mimetype));
        MatcherAssert.assertThat((Object)IoUtil.readInputStream((InputStream)captured.getValue(), null), (Matcher)Matchers.is((Object)value));
    }

    @Test
    public void testPostSingleLocalFileVariableWithEncoding() throws Exception {
        byte[] value = "some text".getBytes();
        String variableKey = "aVariableKey";
        String encoding = "utf-8";
        String filename = "test.txt";
        RestAssured.given().pathParam("id", (Object)"anId").pathParam("varId", (Object)variableKey).multiPart("data", filename, value, "encoding=" + encoding).multiPart("valueType", "File", "text/plain").header("accept", (Object)"application/json", new Object[0]).expect().statusCode(Response.Status.BAD_REQUEST.getStatusCode()).when().post(SINGLE_TASK_SINGLE_BINARY_VARIABLE_URL, new Object[0]);
    }

    @Test
    public void testPostSingleLocalFileVariableOnlyFilename() throws Exception {
        String variableKey = "aVariableKey";
        String filename = "test.txt";
        RestAssured.given().pathParam("id", (Object)"anId").pathParam("varId", (Object)variableKey).multiPart("data", filename, new byte[0]).multiPart("valueType", "File", "text/plain").header("accept", (Object)"application/json", new Object[0]).expect().statusCode(Response.Status.NO_CONTENT.getStatusCode()).when().post(SINGLE_TASK_SINGLE_BINARY_VARIABLE_URL, new Object[0]);
        ArgumentCaptor captor = ArgumentCaptor.forClass(FileValue.class);
        ((TaskService)Mockito.verify((Object)this.taskServiceMock)).setVariableLocal((String)Mockito.eq((Object)"anId"), (String)Mockito.eq((Object)variableKey), captor.capture());
        FileValue captured = (FileValue)captor.getValue();
        MatcherAssert.assertThat((Object)captured.getEncoding(), (Matcher)Matchers.is((Matcher)CoreMatchers.nullValue()));
        MatcherAssert.assertThat((Object)captured.getFilename(), (Matcher)Matchers.is((Object)filename));
        MatcherAssert.assertThat((Object)captured.getMimeType(), (Matcher)Matchers.is((Object)"application/octet-stream"));
        MatcherAssert.assertThat((Object)captured.getValue().available(), (Matcher)Matchers.is((Object)0));
    }

    @Test
    public void testPutSingleLocalVariableFromSerialized() throws Exception {
        String serializedValue = "{\"prop\" : \"value\"}";
        Map<String, Object> requestJson = VariablesBuilder.getObjectValueMap(serializedValue, ValueType.OBJECT.getName(), "aDataFormat", "aRootType");
        String variableKey = "aVariableKey";
        RestAssured.given().pathParam("id", (Object)"anId").pathParam("varId", (Object)variableKey).contentType(ContentType.JSON).body(requestJson).expect().statusCode(Response.Status.NO_CONTENT.getStatusCode()).when().put("/rest-test/task/{id}/localVariables/{varId}", new Object[0]);
        ((TaskService)Mockito.verify((Object)this.taskServiceMock)).setVariableLocal((String)Mockito.eq((Object)"anId"), (String)Mockito.eq((Object)variableKey), MockitoHamcrest.argThat((Matcher)EqualsObjectValue.objectValueMatcher().serializedValue(serializedValue).serializationFormat("aDataFormat").objectTypeName("aRootType")));
    }

    @Test
    public void testPutSingleLocalVariableFromInvalidSerialized() throws Exception {
        String serializedValue = "{\"prop\" : \"value\"}";
        Map<String, Object> requestJson = VariablesBuilder.getObjectValueMap(serializedValue, "aNonExistingType", null, null);
        String variableKey = "aVariableKey";
        RestAssured.given().pathParam("id", (Object)"anId").pathParam("varId", (Object)variableKey).contentType(ContentType.JSON).body(requestJson).expect().statusCode(Response.Status.BAD_REQUEST.getStatusCode()).body("type", CoreMatchers.equalTo((Object)InvalidRequestException.class.getSimpleName()), new Object[0]).body("message", CoreMatchers.equalTo((Object)"Cannot put task variable aVariableKey: Unsupported value type 'aNonExistingType'"), new Object[0]).when().put("/rest-test/task/{id}/localVariables/{varId}", new Object[0]);
    }

    @Test
    public void testPutSingleLocalVariableFromSerializedWithNoValue() {
        String variableKey = "aVariableKey";
        Map<String, Object> requestJson = VariablesBuilder.getObjectValueMap(null, ValueType.OBJECT.getName(), null, null);
        RestAssured.given().pathParam("id", (Object)"anId").pathParam("varId", (Object)variableKey).contentType(ContentType.JSON).body(requestJson).then().expect().statusCode(Response.Status.NO_CONTENT.getStatusCode()).when().put("/rest-test/task/{id}/localVariables/{varId}", new Object[0]);
        ((TaskService)Mockito.verify((Object)this.taskServiceMock)).setVariableLocal((String)Mockito.eq((Object)"anId"), (String)Mockito.eq((Object)variableKey), MockitoHamcrest.argThat((Matcher)EqualsObjectValue.objectValueMatcher()));
    }

    @Test
    public void testDeleteSingleLocalVariable() {
        String variableKey = "aVariableKey";
        RestAssured.given().pathParam("id", (Object)"anId").pathParam("varId", (Object)variableKey).header("accept", (Object)"application/json", new Object[0]).then().expect().statusCode(Response.Status.NO_CONTENT.getStatusCode()).when().delete("/rest-test/task/{id}/localVariables/{varId}", new Object[0]);
        ((TaskService)Mockito.verify((Object)this.taskServiceMock)).removeVariableLocal((String)Mockito.eq((Object)"anId"), (String)Mockito.eq((Object)variableKey));
    }

    @Test
    public void testDeleteLocalVariableForNonExistingTaskId() {
        String variableKey = "aVariableKey";
        ((TaskService)Mockito.doThrow((Throwable[])new Throwable[]{new ProcessEngineException("Cannot find task with id nonExistingId")}).when((Object)this.taskServiceMock)).removeVariableLocal((String)Mockito.eq((Object)"nonExistingId"), (String)Mockito.eq((Object)variableKey));
        RestAssured.given().pathParam("id", (Object)"nonExistingId").pathParam("varId", (Object)variableKey).header("accept", (Object)"application/json", new Object[0]).then().expect().statusCode(Response.Status.INTERNAL_SERVER_ERROR.getStatusCode()).contentType(ContentType.JSON).body("type", Matchers.is((Object)RestException.class.getSimpleName()), new Object[0]).body("message", Matchers.is((Object)("Cannot delete task variable " + variableKey + ": Cannot find task with id nonExistingId")), new Object[0]).when().delete("/rest-test/task/{id}/localVariables/{varId}", new Object[0]);
    }

    @Test
    public void testDeleteVariableThrowsAuthorizationException() {
        String variableKey = "aVariableKey";
        String message = "expected exception";
        ((TaskService)Mockito.doThrow((Throwable[])new Throwable[]{new AuthorizationException(message)}).when((Object)this.taskServiceMock)).removeVariableLocal(Mockito.anyString(), Mockito.anyString());
        RestAssured.given().pathParam("id", (Object)"anId").pathParam("varId", (Object)variableKey).then().expect().statusCode(Response.Status.FORBIDDEN.getStatusCode()).contentType(ContentType.JSON).body("type", Matchers.is((Object)AuthorizationException.class.getSimpleName()), new Object[0]).body("message", Matchers.is((Object)message), new Object[0]).when().delete("/rest-test/task/{id}/localVariables/{varId}", new Object[0]);
    }
}

