/*
 * Decompiled with CFR 0.152.
 */
package org.eximeebpms.bpm.engine.rest;

import io.restassured.RestAssured;
import io.restassured.http.ContentType;
import io.restassured.path.json.JsonPath;
import io.restassured.response.Response;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.ws.rs.core.Response;
import org.eximeebpms.bpm.engine.rest.AbstractRestServiceTest;
import org.eximeebpms.bpm.engine.rest.exception.InvalidRequestException;
import org.eximeebpms.bpm.engine.rest.helper.MockProvider;
import org.eximeebpms.bpm.engine.rest.helper.MockVariableInstanceBuilder;
import org.eximeebpms.bpm.engine.rest.helper.VariableTypeHelper;
import org.eximeebpms.bpm.engine.rest.helper.variable.EqualsPrimitiveValue;
import org.eximeebpms.bpm.engine.rest.util.OrderingBuilder;
import org.eximeebpms.bpm.engine.rest.util.container.TestContainerRule;
import org.eximeebpms.bpm.engine.runtime.VariableInstance;
import org.eximeebpms.bpm.engine.runtime.VariableInstanceQuery;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.junit.Assert;
import org.junit.Before;
import org.junit.ClassRule;
import org.junit.Test;
import org.mockito.InOrder;
import org.mockito.Mockito;
import org.mockito.hamcrest.MockitoHamcrest;
import org.mockito.verification.VerificationMode;

public class VariableInstanceRestServiceQueryTest
extends AbstractRestServiceTest {
    @ClassRule
    public static TestContainerRule rule = new TestContainerRule();
    protected static final String VARIABLE_INSTANCE_QUERY_URL = "/rest-test/variable-instance";
    protected static final String VARIABLE_INSTANCE_COUNT_QUERY_URL = "/rest-test/variable-instance/count";
    protected VariableInstanceQuery mockedQuery;
    protected VariableInstance mockInstance;
    protected MockVariableInstanceBuilder mockInstanceBuilder;

    @Before
    public void setUpRuntimeData() {
        this.mockInstanceBuilder = MockProvider.mockVariableInstance();
        this.mockInstance = this.mockInstanceBuilder.build();
        this.mockedQuery = this.setUpMockVariableInstanceQuery(this.createMockVariableInstanceList(this.mockInstance));
    }

    private VariableInstanceQuery setUpMockVariableInstanceQuery(List<VariableInstance> mockedInstances) {
        VariableInstanceQuery sampleInstanceQuery = (VariableInstanceQuery)Mockito.mock(VariableInstanceQuery.class);
        Mockito.when((Object)sampleInstanceQuery.list()).thenReturn(mockedInstances);
        Mockito.when((Object)sampleInstanceQuery.count()).thenReturn((Object)mockedInstances.size());
        Mockito.when((Object)processEngine.getRuntimeService().createVariableInstanceQuery()).thenReturn((Object)sampleInstanceQuery);
        return sampleInstanceQuery;
    }

    protected List<VariableInstance> createMockVariableInstanceList(VariableInstance mockInstance) {
        ArrayList<VariableInstance> mocks = new ArrayList<VariableInstance>();
        mocks.add(mockInstance);
        return mocks;
    }

    @Test
    public void testNoParametersQuery() {
        RestAssured.expect().statusCode(Response.Status.OK.getStatusCode()).when().get(VARIABLE_INSTANCE_QUERY_URL, new Object[0]);
        ((VariableInstanceQuery)Mockito.verify((Object)this.mockedQuery)).list();
        ((VariableInstanceQuery)Mockito.verify((Object)this.mockedQuery)).disableBinaryFetching();
        ((VariableInstanceQuery)Mockito.verify((Object)this.mockedQuery, (VerificationMode)Mockito.never())).disableCustomObjectDeserialization();
        Mockito.verifyNoMoreInteractions((Object[])new Object[]{this.mockedQuery});
    }

    @Test
    public void testNoParametersQueryDisableObjectDeserialization() {
        RestAssured.given().queryParam("deserializeValues", new Object[]{false}).expect().statusCode(Response.Status.OK.getStatusCode()).when().get(VARIABLE_INSTANCE_QUERY_URL, new Object[0]);
        ((VariableInstanceQuery)Mockito.verify((Object)this.mockedQuery)).list();
        ((VariableInstanceQuery)Mockito.verify((Object)this.mockedQuery)).disableBinaryFetching();
        ((VariableInstanceQuery)Mockito.verify((Object)this.mockedQuery)).disableCustomObjectDeserialization();
        Mockito.verifyNoMoreInteractions((Object[])new Object[]{this.mockedQuery});
    }

    @Test
    public void testNoParametersQueryAsPost() {
        RestAssured.given().contentType(POST_JSON_CONTENT_TYPE).body("{}").expect().statusCode(Response.Status.OK.getStatusCode()).when().post(VARIABLE_INSTANCE_QUERY_URL, new Object[0]);
        ((VariableInstanceQuery)Mockito.verify((Object)this.mockedQuery)).list();
        ((VariableInstanceQuery)Mockito.verify((Object)this.mockedQuery)).disableBinaryFetching();
        ((VariableInstanceQuery)Mockito.verify((Object)this.mockedQuery, (VerificationMode)Mockito.never())).disableCustomObjectDeserialization();
        Mockito.verifyNoMoreInteractions((Object[])new Object[]{this.mockedQuery});
    }

    @Test
    public void testNoParametersQueryAsPostDisableObjectDeserialization() {
        RestAssured.given().queryParam("deserializeValues", new Object[]{false}).contentType(POST_JSON_CONTENT_TYPE).body("{}").expect().statusCode(Response.Status.OK.getStatusCode()).when().post(VARIABLE_INSTANCE_QUERY_URL, new Object[0]);
        ((VariableInstanceQuery)Mockito.verify((Object)this.mockedQuery)).list();
        ((VariableInstanceQuery)Mockito.verify((Object)this.mockedQuery)).disableBinaryFetching();
        ((VariableInstanceQuery)Mockito.verify((Object)this.mockedQuery)).disableCustomObjectDeserialization();
        Mockito.verifyNoMoreInteractions((Object[])new Object[]{this.mockedQuery});
    }

    @Test
    public void testInvalidVariableRequests() {
        String invalidComparator = "anInvalidComparator";
        String variableName = "varName";
        String variableValue = "varValue";
        Object queryValue = variableName + "_" + invalidComparator + "_" + variableValue;
        RestAssured.given().queryParam("variableValues", new Object[]{queryValue}).then().expect().statusCode(Response.Status.BAD_REQUEST.getStatusCode()).contentType(ContentType.JSON).body("type", Matchers.equalTo((Object)InvalidRequestException.class.getSimpleName()), new Object[0]).body("message", Matchers.containsString((String)("Invalid variable comparator specified: " + invalidComparator)), new Object[0]).when().get(VARIABLE_INSTANCE_QUERY_URL, new Object[0]);
        queryValue = "invalidFormattedVariableQuery";
        RestAssured.given().queryParam("variableValues", new Object[]{queryValue}).then().expect().statusCode(Response.Status.BAD_REQUEST.getStatusCode()).contentType(ContentType.JSON).body("type", Matchers.equalTo((Object)InvalidRequestException.class.getSimpleName()), new Object[0]).body("message", Matchers.containsString((String)"variable query parameter has to have format KEY_OPERATOR_VALUE"), new Object[0]).when().get(VARIABLE_INSTANCE_QUERY_URL, new Object[0]);
    }

    @Test
    public void testInvalidSortingOptions() {
        this.executeAndVerifySorting("anInvalidSortByOption", "asc", Response.Status.BAD_REQUEST);
        this.executeAndVerifySorting("variableName", "anInvalidSortOrderOption", Response.Status.BAD_REQUEST);
    }

    protected void executeAndVerifySorting(String sortBy, String sortOrder, Response.Status expectedStatus) {
        RestAssured.given().queryParam("sortBy", new Object[]{sortBy}).queryParam("sortOrder", new Object[]{sortOrder}).then().expect().statusCode(expectedStatus.getStatusCode()).when().get(VARIABLE_INSTANCE_QUERY_URL, new Object[0]);
    }

    @Test
    public void testSortByParameterOnly() {
        RestAssured.given().queryParam("sortBy", new Object[]{"variableName"}).then().expect().statusCode(Response.Status.BAD_REQUEST.getStatusCode()).when().get(VARIABLE_INSTANCE_QUERY_URL, new Object[0]);
    }

    @Test
    public void testSortOrderParameterOnly() {
        RestAssured.given().queryParam("sortOrder", new Object[]{"asc"}).then().expect().statusCode(Response.Status.BAD_REQUEST.getStatusCode()).when().get(VARIABLE_INSTANCE_QUERY_URL, new Object[0]);
    }

    @Test
    public void testSortingParameters() {
        InOrder inOrder = Mockito.inOrder((Object[])new Object[]{this.mockedQuery});
        this.executeAndVerifySorting("variableName", "asc", Response.Status.OK);
        ((VariableInstanceQuery)inOrder.verify((Object)this.mockedQuery)).orderByVariableName();
        ((VariableInstanceQuery)inOrder.verify((Object)this.mockedQuery)).asc();
        inOrder = Mockito.inOrder((Object[])new Object[]{this.mockedQuery});
        this.executeAndVerifySorting("variableType", "desc", Response.Status.OK);
        ((VariableInstanceQuery)inOrder.verify((Object)this.mockedQuery)).orderByVariableType();
        ((VariableInstanceQuery)inOrder.verify((Object)this.mockedQuery)).desc();
        inOrder = Mockito.inOrder((Object[])new Object[]{this.mockedQuery});
        this.executeAndVerifySorting("activityInstanceId", "asc", Response.Status.OK);
        ((VariableInstanceQuery)inOrder.verify((Object)this.mockedQuery)).orderByActivityInstanceId();
        ((VariableInstanceQuery)inOrder.verify((Object)this.mockedQuery)).asc();
        inOrder = Mockito.inOrder((Object[])new Object[]{this.mockedQuery});
        this.executeAndVerifySorting("activityInstanceId", "desc", Response.Status.OK);
        ((VariableInstanceQuery)inOrder.verify((Object)this.mockedQuery)).orderByActivityInstanceId();
        ((VariableInstanceQuery)inOrder.verify((Object)this.mockedQuery)).desc();
        inOrder = Mockito.inOrder((Object[])new Object[]{this.mockedQuery});
        this.executeAndVerifySorting("tenantId", "asc", Response.Status.OK);
        ((VariableInstanceQuery)inOrder.verify((Object)this.mockedQuery)).orderByTenantId();
        ((VariableInstanceQuery)inOrder.verify((Object)this.mockedQuery)).asc();
        inOrder = Mockito.inOrder((Object[])new Object[]{this.mockedQuery});
        this.executeAndVerifySorting("tenantId", "desc", Response.Status.OK);
        ((VariableInstanceQuery)inOrder.verify((Object)this.mockedQuery)).orderByTenantId();
        ((VariableInstanceQuery)inOrder.verify((Object)this.mockedQuery)).desc();
    }

    @Test
    public void testSecondarySortingAsPost() {
        InOrder inOrder = Mockito.inOrder((Object[])new Object[]{this.mockedQuery});
        HashMap<String, List<Map<String, Object>>> json = new HashMap<String, List<Map<String, Object>>>();
        json.put("sorting", OrderingBuilder.create().orderBy("variableName").desc().orderBy("activityInstanceId").asc().getJson());
        RestAssured.given().contentType(POST_JSON_CONTENT_TYPE).body(json).header("accept", (Object)"application/json", new Object[0]).then().expect().statusCode(Response.Status.OK.getStatusCode()).when().post(VARIABLE_INSTANCE_QUERY_URL, new Object[0]);
        ((VariableInstanceQuery)inOrder.verify((Object)this.mockedQuery)).orderByVariableName();
        ((VariableInstanceQuery)inOrder.verify((Object)this.mockedQuery)).desc();
        ((VariableInstanceQuery)inOrder.verify((Object)this.mockedQuery)).orderByActivityInstanceId();
        ((VariableInstanceQuery)inOrder.verify((Object)this.mockedQuery)).asc();
    }

    @Test
    public void testSuccessfulPagination() {
        int firstResult = 0;
        int maxResults = 10;
        RestAssured.given().queryParam("firstResult", new Object[]{firstResult}).queryParam("maxResults", new Object[]{maxResults}).then().expect().statusCode(Response.Status.OK.getStatusCode()).when().get(VARIABLE_INSTANCE_QUERY_URL, new Object[0]);
        ((VariableInstanceQuery)Mockito.verify((Object)this.mockedQuery)).listPage(firstResult, maxResults);
        ((VariableInstanceQuery)Mockito.verify((Object)this.mockedQuery)).disableBinaryFetching();
        ((VariableInstanceQuery)Mockito.verify((Object)this.mockedQuery, (VerificationMode)Mockito.never())).disableCustomObjectDeserialization();
    }

    @Test
    public void testMissingFirstResultParameter() {
        int maxResults = 10;
        RestAssured.given().queryParam("maxResults", new Object[]{maxResults}).then().expect().statusCode(Response.Status.OK.getStatusCode()).when().get(VARIABLE_INSTANCE_QUERY_URL, new Object[0]);
        ((VariableInstanceQuery)Mockito.verify((Object)this.mockedQuery)).listPage(0, maxResults);
        ((VariableInstanceQuery)Mockito.verify((Object)this.mockedQuery)).disableBinaryFetching();
        ((VariableInstanceQuery)Mockito.verify((Object)this.mockedQuery, (VerificationMode)Mockito.never())).disableCustomObjectDeserialization();
    }

    @Test
    public void testMissingMaxResultsParameter() {
        int firstResult = 10;
        RestAssured.given().queryParam("firstResult", new Object[]{firstResult}).then().expect().statusCode(Response.Status.OK.getStatusCode()).when().get(VARIABLE_INSTANCE_QUERY_URL, new Object[0]);
        ((VariableInstanceQuery)Mockito.verify((Object)this.mockedQuery)).listPage(firstResult, Integer.MAX_VALUE);
        ((VariableInstanceQuery)Mockito.verify((Object)this.mockedQuery)).disableBinaryFetching();
        ((VariableInstanceQuery)Mockito.verify((Object)this.mockedQuery, (VerificationMode)Mockito.never())).disableCustomObjectDeserialization();
    }

    @Test
    public void testVariableInstanceRetrieval() {
        String queryVariableName = "aVariableInstanceName";
        Response response = (Response)RestAssured.given().queryParam("variableName", new Object[]{queryVariableName}).then().expect().statusCode(Response.Status.OK.getStatusCode()).and().body("size()", Matchers.is((Object)1), new Object[0]).body("[0].id", Matchers.equalTo((Object)this.mockInstanceBuilder.getId()), new Object[0]).body("[0].name", Matchers.equalTo((Object)this.mockInstanceBuilder.getName()), new Object[0]).body("[0].type", Matchers.equalTo((Object)VariableTypeHelper.toExpectedValueTypeName(this.mockInstanceBuilder.getTypedValue().getType())), new Object[0]).body("[0].value", Matchers.equalTo((Object)this.mockInstanceBuilder.getValue()), new Object[0]).body("[0].processDefinitionId", Matchers.equalTo((Object)this.mockInstanceBuilder.getProcessDefinitionId()), new Object[0]).body("[0].processInstanceId", Matchers.equalTo((Object)this.mockInstanceBuilder.getProcessInstanceId()), new Object[0]).body("[0].executionId", Matchers.equalTo((Object)this.mockInstanceBuilder.getExecutionId()), new Object[0]).body("[0].caseInstanceId", Matchers.equalTo((Object)this.mockInstanceBuilder.getCaseInstanceId()), new Object[0]).body("[0].caseExecutionId", Matchers.equalTo((Object)this.mockInstanceBuilder.getCaseExecutionId()), new Object[0]).body("[0].taskId", Matchers.equalTo((Object)this.mockInstanceBuilder.getTaskId()), new Object[0]).body("[0].batchId", Matchers.equalTo((Object)this.mockInstanceBuilder.getBatchId()), new Object[0]).body("[0].activityInstanceId", Matchers.equalTo((Object)this.mockInstanceBuilder.getActivityInstanceId()), new Object[0]).body("[0].tenantId", Matchers.equalTo((Object)this.mockInstanceBuilder.getTenantId()), new Object[0]).body("[0].errorMessage", Matchers.equalTo((Object)this.mockInstanceBuilder.getErrorMessage()), new Object[0]).body("[0].serializedValue", Matchers.nullValue(), new Object[0]).when().get(VARIABLE_INSTANCE_QUERY_URL, new Object[0]);
        InOrder inOrder = Mockito.inOrder((Object[])new Object[]{this.mockedQuery});
        ((VariableInstanceQuery)inOrder.verify((Object)this.mockedQuery)).variableName(queryVariableName);
        ((VariableInstanceQuery)inOrder.verify((Object)this.mockedQuery)).list();
        String content = response.asString();
        List variables = JsonPath.from((String)content).getList("");
        Assert.assertEquals((String)"There should be one variable instance returned.", (long)1L, (long)variables.size());
        Assert.assertNotNull((String)"There should be one variable instance returned", variables.get(0));
        ((VariableInstanceQuery)Mockito.verify((Object)this.mockedQuery)).disableBinaryFetching();
        ((VariableInstanceQuery)Mockito.verify((Object)this.mockedQuery, (VerificationMode)Mockito.never())).disableCustomObjectDeserialization();
    }

    @Test
    public void testVariableInstanceRetrievalAsPost() {
        String queryVariableName = "aVariableInstanceName";
        HashMap<String, String> queryParameter = new HashMap<String, String>();
        queryParameter.put("variableName", queryVariableName);
        Response response = (Response)RestAssured.given().contentType(POST_JSON_CONTENT_TYPE).body(queryParameter).then().expect().statusCode(Response.Status.OK.getStatusCode()).and().body("size()", Matchers.is((Object)1), new Object[0]).body("[0].id", Matchers.equalTo((Object)this.mockInstanceBuilder.getId()), new Object[0]).body("[0].name", Matchers.equalTo((Object)this.mockInstanceBuilder.getName()), new Object[0]).body("[0].type", Matchers.equalTo((Object)VariableTypeHelper.toExpectedValueTypeName(this.mockInstanceBuilder.getTypedValue().getType())), new Object[0]).body("[0].value", Matchers.equalTo((Object)this.mockInstanceBuilder.getTypedValue().getValue()), new Object[0]).body("[0].processInstanceId", Matchers.equalTo((Object)this.mockInstanceBuilder.getProcessInstanceId()), new Object[0]).body("[0].executionId", Matchers.equalTo((Object)this.mockInstanceBuilder.getExecutionId()), new Object[0]).body("[0].caseInstanceId", Matchers.equalTo((Object)this.mockInstanceBuilder.getCaseInstanceId()), new Object[0]).body("[0].caseExecutionId", Matchers.equalTo((Object)this.mockInstanceBuilder.getCaseExecutionId()), new Object[0]).body("[0].taskId", Matchers.equalTo((Object)this.mockInstanceBuilder.getTaskId()), new Object[0]).body("[0].batchId", Matchers.equalTo((Object)this.mockInstanceBuilder.getBatchId()), new Object[0]).body("[0].activityInstanceId", Matchers.equalTo((Object)this.mockInstanceBuilder.getActivityInstanceId()), new Object[0]).body("[0].tenantId", Matchers.equalTo((Object)this.mockInstanceBuilder.getTenantId()), new Object[0]).body("[0].errorMessage", Matchers.equalTo((Object)this.mockInstanceBuilder.getErrorMessage()), new Object[0]).body("[0].serializedValue", Matchers.nullValue(), new Object[0]).when().post(VARIABLE_INSTANCE_QUERY_URL, new Object[0]);
        InOrder inOrder = Mockito.inOrder((Object[])new Object[]{this.mockedQuery});
        ((VariableInstanceQuery)inOrder.verify((Object)this.mockedQuery)).variableName(queryVariableName);
        ((VariableInstanceQuery)inOrder.verify((Object)this.mockedQuery)).list();
        String content = response.asString();
        List variables = JsonPath.from((String)content).getList("");
        Assert.assertEquals((String)"There should be one process definition returned.", (long)1L, (long)variables.size());
        Assert.assertNotNull((String)"There should be one process definition returned", variables.get(0));
        ((VariableInstanceQuery)Mockito.verify((Object)this.mockedQuery)).disableBinaryFetching();
        ((VariableInstanceQuery)Mockito.verify((Object)this.mockedQuery, (VerificationMode)Mockito.never())).disableCustomObjectDeserialization();
    }

    @Test
    public void testAdditionalParametersExcludingVariableValues() {
        HashMap<String, String> queryParameters = new HashMap<String, String>();
        queryParameters.put("variableName", "aVariableName");
        queryParameters.put("variableNameLike", "aVariableNameLike");
        queryParameters.put("executionIdIn", "anExecutionId");
        queryParameters.put("processInstanceIdIn", "aProcessInstanceId");
        queryParameters.put("caseExecutionIdIn", "aCaseExecutionId");
        queryParameters.put("caseInstanceIdIn", "aCaseInstanceId");
        queryParameters.put("taskIdIn", "aTaskId");
        queryParameters.put("batchIdIn", "aBatchId");
        queryParameters.put("variableScopeIdIn", "aVariableScopeId");
        queryParameters.put("activityInstanceIdIn", "anActivityInstanceId");
        queryParameters.put("tenantIdIn", "anTenantId");
        RestAssured.given().queryParams(queryParameters).expect().statusCode(Response.Status.OK.getStatusCode()).when().get(VARIABLE_INSTANCE_QUERY_URL, new Object[0]);
        ((VariableInstanceQuery)Mockito.verify((Object)this.mockedQuery)).variableName((String)queryParameters.get("variableName"));
        ((VariableInstanceQuery)Mockito.verify((Object)this.mockedQuery)).variableNameLike((String)queryParameters.get("variableNameLike"));
        ((VariableInstanceQuery)Mockito.verify((Object)this.mockedQuery)).processInstanceIdIn(new String[]{(String)queryParameters.get("processInstanceIdIn")});
        ((VariableInstanceQuery)Mockito.verify((Object)this.mockedQuery)).executionIdIn(new String[]{(String)queryParameters.get("executionIdIn")});
        ((VariableInstanceQuery)Mockito.verify((Object)this.mockedQuery)).caseInstanceIdIn(new String[]{(String)queryParameters.get("caseInstanceIdIn")});
        ((VariableInstanceQuery)Mockito.verify((Object)this.mockedQuery)).caseExecutionIdIn(new String[]{(String)queryParameters.get("caseExecutionIdIn")});
        ((VariableInstanceQuery)Mockito.verify((Object)this.mockedQuery)).taskIdIn(new String[]{(String)queryParameters.get("taskIdIn")});
        ((VariableInstanceQuery)Mockito.verify((Object)this.mockedQuery)).batchIdIn(new String[]{(String)queryParameters.get("batchIdIn")});
        ((VariableInstanceQuery)Mockito.verify((Object)this.mockedQuery)).variableScopeIdIn(new String[]{(String)queryParameters.get("variableScopeIdIn")});
        ((VariableInstanceQuery)Mockito.verify((Object)this.mockedQuery)).activityInstanceIdIn(new String[]{(String)queryParameters.get("activityInstanceIdIn")});
        ((VariableInstanceQuery)Mockito.verify((Object)this.mockedQuery)).tenantIdIn(new String[]{(String)queryParameters.get("tenantIdIn")});
        ((VariableInstanceQuery)Mockito.verify((Object)this.mockedQuery)).list();
        ((VariableInstanceQuery)Mockito.verify((Object)this.mockedQuery)).disableBinaryFetching();
        ((VariableInstanceQuery)Mockito.verify((Object)this.mockedQuery, (VerificationMode)Mockito.never())).disableCustomObjectDeserialization();
    }

    @Test
    public void testAdditionalParametersExcludingVariableValuesAsPost() {
        String aVariableName = "aVariableName";
        String aVariableNameLike = "aVariableNameLike";
        String aProcessInstanceId = "aProcessInstanceId";
        String anExecutionId = "anExecutionId";
        String aTaskId = "aTaskId";
        String aBatchId = "aBatchId";
        String aVariableScopeId = "aVariableScopeId";
        String anActivityInstanceId = "anActivityInstanceId";
        String aCaseInstanceId = "aCaseInstanceId";
        String aCaseExecutionId = "aCaseExecutionId";
        String aTenantId = "aTenantId";
        HashMap<String, Object> queryParameters = new HashMap<String, Object>();
        queryParameters.put("variableName", aVariableName);
        queryParameters.put("variableNameLike", aVariableNameLike);
        ArrayList<String> executionIdIn = new ArrayList<String>();
        executionIdIn.add(anExecutionId);
        queryParameters.put("executionIdIn", executionIdIn);
        ArrayList<String> processInstanceIdIn = new ArrayList<String>();
        processInstanceIdIn.add(aProcessInstanceId);
        queryParameters.put("processInstanceIdIn", processInstanceIdIn);
        ArrayList<String> caseExecutionIdIn = new ArrayList<String>();
        caseExecutionIdIn.add(aCaseExecutionId);
        queryParameters.put("caseExecutionIdIn", caseExecutionIdIn);
        ArrayList<String> caseInstanceIdIn = new ArrayList<String>();
        caseInstanceIdIn.add(aCaseInstanceId);
        queryParameters.put("caseInstanceIdIn", caseInstanceIdIn);
        ArrayList<String> taskIdIn = new ArrayList<String>();
        taskIdIn.add(aTaskId);
        queryParameters.put("taskIdIn", taskIdIn);
        ArrayList<String> batchIdIn = new ArrayList<String>();
        batchIdIn.add(aBatchId);
        queryParameters.put("batchIdIn", batchIdIn);
        ArrayList<String> variableScopeIdIn = new ArrayList<String>();
        variableScopeIdIn.add(aVariableScopeId);
        queryParameters.put("variableScopeIdIn", variableScopeIdIn);
        ArrayList<String> activityInstanceIdIn = new ArrayList<String>();
        activityInstanceIdIn.add(anActivityInstanceId);
        queryParameters.put("activityInstanceIdIn", activityInstanceIdIn);
        ArrayList<String> tenantIdIn = new ArrayList<String>();
        tenantIdIn.add(aTenantId);
        queryParameters.put("tenantIdIn", tenantIdIn);
        RestAssured.given().contentType(POST_JSON_CONTENT_TYPE).body(queryParameters).then().expect().statusCode(Response.Status.OK.getStatusCode()).when().post(VARIABLE_INSTANCE_QUERY_URL, new Object[0]);
        ((VariableInstanceQuery)Mockito.verify((Object)this.mockedQuery)).variableName(aVariableName);
        ((VariableInstanceQuery)Mockito.verify((Object)this.mockedQuery)).variableNameLike(aVariableNameLike);
        ((VariableInstanceQuery)Mockito.verify((Object)this.mockedQuery)).processInstanceIdIn(new String[]{aProcessInstanceId});
        ((VariableInstanceQuery)Mockito.verify((Object)this.mockedQuery)).executionIdIn(new String[]{anExecutionId});
        ((VariableInstanceQuery)Mockito.verify((Object)this.mockedQuery)).taskIdIn(new String[]{aTaskId});
        ((VariableInstanceQuery)Mockito.verify((Object)this.mockedQuery)).batchIdIn(new String[]{aBatchId});
        ((VariableInstanceQuery)Mockito.verify((Object)this.mockedQuery)).variableScopeIdIn(new String[]{aVariableScopeId});
        ((VariableInstanceQuery)Mockito.verify((Object)this.mockedQuery)).activityInstanceIdIn(new String[]{anActivityInstanceId});
        ((VariableInstanceQuery)Mockito.verify((Object)this.mockedQuery)).tenantIdIn(new String[]{aTenantId});
        ((VariableInstanceQuery)Mockito.verify((Object)this.mockedQuery)).list();
        ((VariableInstanceQuery)Mockito.verify((Object)this.mockedQuery)).disableBinaryFetching();
        ((VariableInstanceQuery)Mockito.verify((Object)this.mockedQuery, (VerificationMode)Mockito.never())).disableCustomObjectDeserialization();
    }

    @Test
    public void testVariableValueEquals() {
        String variableName = "varName";
        String variableValue = "varValue";
        String queryValue = variableName + "_eq_" + variableValue;
        RestAssured.given().queryParam("variableValues", new Object[]{queryValue}).then().expect().statusCode(Response.Status.OK.getStatusCode()).when().get(VARIABLE_INSTANCE_QUERY_URL, new Object[0]);
        ((VariableInstanceQuery)Mockito.verify((Object)this.mockedQuery)).variableValueEquals(variableName, (Object)variableValue);
        ((VariableInstanceQuery)Mockito.verify((Object)this.mockedQuery)).disableBinaryFetching();
        ((VariableInstanceQuery)Mockito.verify((Object)this.mockedQuery, (VerificationMode)Mockito.never())).disableCustomObjectDeserialization();
    }

    @Test
    public void testVariableValueGreaterThan() {
        String variableName = "varName";
        String variableValue = "varValue";
        String queryValue = variableName + "_gt_" + variableValue;
        RestAssured.given().queryParam("variableValues", new Object[]{queryValue}).then().expect().statusCode(Response.Status.OK.getStatusCode()).when().get(VARIABLE_INSTANCE_QUERY_URL, new Object[0]);
        ((VariableInstanceQuery)Mockito.verify((Object)this.mockedQuery)).variableValueGreaterThan(variableName, (Object)variableValue);
        ((VariableInstanceQuery)Mockito.verify((Object)this.mockedQuery)).disableBinaryFetching();
        ((VariableInstanceQuery)Mockito.verify((Object)this.mockedQuery, (VerificationMode)Mockito.never())).disableCustomObjectDeserialization();
    }

    @Test
    public void testVariableValueGreaterThanEquals() {
        String variableName = "varName";
        String variableValue = "varValue";
        String queryValue = variableName + "_gteq_" + variableValue;
        RestAssured.given().queryParam("variableValues", new Object[]{queryValue}).then().expect().statusCode(Response.Status.OK.getStatusCode()).when().get(VARIABLE_INSTANCE_QUERY_URL, new Object[0]);
        ((VariableInstanceQuery)Mockito.verify((Object)this.mockedQuery)).variableValueGreaterThanOrEqual(variableName, (Object)variableValue);
        ((VariableInstanceQuery)Mockito.verify((Object)this.mockedQuery)).disableBinaryFetching();
        ((VariableInstanceQuery)Mockito.verify((Object)this.mockedQuery, (VerificationMode)Mockito.never())).disableCustomObjectDeserialization();
    }

    @Test
    public void testVariableValueLessThan() {
        String variableName = "varName";
        String variableValue = "varValue";
        String queryValue = variableName + "_lt_" + variableValue;
        RestAssured.given().queryParam("variableValues", new Object[]{queryValue}).then().expect().statusCode(Response.Status.OK.getStatusCode()).when().get(VARIABLE_INSTANCE_QUERY_URL, new Object[0]);
        ((VariableInstanceQuery)Mockito.verify((Object)this.mockedQuery)).variableValueLessThan(variableName, (Object)variableValue);
        ((VariableInstanceQuery)Mockito.verify((Object)this.mockedQuery)).disableBinaryFetching();
        ((VariableInstanceQuery)Mockito.verify((Object)this.mockedQuery, (VerificationMode)Mockito.never())).disableCustomObjectDeserialization();
    }

    @Test
    public void testVariableValueLessThanEquals() {
        String variableName = "varName";
        String variableValue = "varValue";
        String queryValue = variableName + "_lteq_" + variableValue;
        RestAssured.given().queryParam("variableValues", new Object[]{queryValue}).then().expect().statusCode(Response.Status.OK.getStatusCode()).when().get(VARIABLE_INSTANCE_QUERY_URL, new Object[0]);
        ((VariableInstanceQuery)Mockito.verify((Object)this.mockedQuery)).variableValueLessThanOrEqual(variableName, (Object)variableValue);
        ((VariableInstanceQuery)Mockito.verify((Object)this.mockedQuery)).disableBinaryFetching();
        ((VariableInstanceQuery)Mockito.verify((Object)this.mockedQuery, (VerificationMode)Mockito.never())).disableCustomObjectDeserialization();
    }

    @Test
    public void testVariableValueLike() {
        String variableName = "varName";
        String variableValue = "varValue";
        String queryValue = variableName + "_like_" + variableValue;
        RestAssured.given().queryParam("variableValues", new Object[]{queryValue}).then().expect().statusCode(Response.Status.OK.getStatusCode()).when().get(VARIABLE_INSTANCE_QUERY_URL, new Object[0]);
        ((VariableInstanceQuery)Mockito.verify((Object)this.mockedQuery)).variableValueLike(variableName, variableValue);
        ((VariableInstanceQuery)Mockito.verify((Object)this.mockedQuery)).disableBinaryFetching();
        ((VariableInstanceQuery)Mockito.verify((Object)this.mockedQuery, (VerificationMode)Mockito.never())).disableCustomObjectDeserialization();
    }

    @Test
    public void testVariableValueNotEquals() {
        String variableName = "varName";
        String variableValue = "varValue";
        String queryValue = variableName + "_neq_" + variableValue;
        RestAssured.given().queryParam("variableValues", new Object[]{queryValue}).then().expect().statusCode(Response.Status.OK.getStatusCode()).when().get(VARIABLE_INSTANCE_QUERY_URL, new Object[0]);
        ((VariableInstanceQuery)Mockito.verify((Object)this.mockedQuery)).variableValueNotEquals(variableName, (Object)variableValue);
        ((VariableInstanceQuery)Mockito.verify((Object)this.mockedQuery)).disableBinaryFetching();
        ((VariableInstanceQuery)Mockito.verify((Object)this.mockedQuery, (VerificationMode)Mockito.never())).disableCustomObjectDeserialization();
    }

    @Test
    public void testVariableValuesEqualsIgnoreCase() {
        String variableName = "varName";
        String variableValue = "varValue";
        String queryValue = variableName + "_eq_" + variableValue;
        RestAssured.given().queryParam("variableValues", new Object[]{queryValue}).queryParam("variableValuesIgnoreCase", new Object[]{true}).then().expect().statusCode(Response.Status.OK.getStatusCode()).when().get(VARIABLE_INSTANCE_QUERY_URL, new Object[0]);
        ((VariableInstanceQuery)Mockito.verify((Object)this.mockedQuery)).variableValueEquals(variableName, (Object)variableValue);
        ((VariableInstanceQuery)Mockito.verify((Object)this.mockedQuery)).matchVariableValuesIgnoreCase();
        ((VariableInstanceQuery)Mockito.verify((Object)this.mockedQuery)).disableBinaryFetching();
        ((VariableInstanceQuery)Mockito.verify((Object)this.mockedQuery, (VerificationMode)Mockito.never())).disableCustomObjectDeserialization();
    }

    @Test
    public void testVariableValuesNotEqualsIgnoreCase() {
        String variableName = "varName";
        String variableValue = "varValue";
        String queryValue = variableName + "_neq_" + variableValue;
        RestAssured.given().queryParam("variableValues", new Object[]{queryValue}).queryParam("variableValuesIgnoreCase", new Object[]{true}).then().expect().statusCode(Response.Status.OK.getStatusCode()).when().get(VARIABLE_INSTANCE_QUERY_URL, new Object[0]);
        ((VariableInstanceQuery)Mockito.verify((Object)this.mockedQuery)).variableValueNotEquals(variableName, (Object)variableValue);
        ((VariableInstanceQuery)Mockito.verify((Object)this.mockedQuery)).matchVariableValuesIgnoreCase();
        ((VariableInstanceQuery)Mockito.verify((Object)this.mockedQuery)).disableBinaryFetching();
        ((VariableInstanceQuery)Mockito.verify((Object)this.mockedQuery, (VerificationMode)Mockito.never())).disableCustomObjectDeserialization();
    }

    @Test
    public void testVariableValuesLikeIgnoreCase() {
        String variableName = "varName";
        String variableValue = "varValue";
        String queryValue = variableName + "_like_" + variableValue;
        RestAssured.given().queryParam("variableValues", new Object[]{queryValue}).queryParam("variableValuesIgnoreCase", new Object[]{true}).then().expect().statusCode(Response.Status.OK.getStatusCode()).when().get(VARIABLE_INSTANCE_QUERY_URL, new Object[0]);
        ((VariableInstanceQuery)Mockito.verify((Object)this.mockedQuery)).variableValueLike(variableName, variableValue);
        ((VariableInstanceQuery)Mockito.verify((Object)this.mockedQuery)).matchVariableValuesIgnoreCase();
        ((VariableInstanceQuery)Mockito.verify((Object)this.mockedQuery)).disableBinaryFetching();
        ((VariableInstanceQuery)Mockito.verify((Object)this.mockedQuery, (VerificationMode)Mockito.never())).disableCustomObjectDeserialization();
    }

    @Test
    public void testVariableNamesEqualsIgnoreCase() {
        String variableName = "varName";
        String variableValue = "varValue";
        String queryValue = variableName + "_eq_" + variableValue;
        RestAssured.given().queryParam("variableValues", new Object[]{queryValue}).queryParam("variableNamesIgnoreCase", new Object[]{true}).then().expect().statusCode(Response.Status.OK.getStatusCode()).when().get(VARIABLE_INSTANCE_QUERY_URL, new Object[0]);
        ((VariableInstanceQuery)Mockito.verify((Object)this.mockedQuery)).variableValueEquals(variableName, (Object)variableValue);
        ((VariableInstanceQuery)Mockito.verify((Object)this.mockedQuery)).matchVariableNamesIgnoreCase();
        ((VariableInstanceQuery)Mockito.verify((Object)this.mockedQuery)).disableBinaryFetching();
        ((VariableInstanceQuery)Mockito.verify((Object)this.mockedQuery, (VerificationMode)Mockito.never())).disableCustomObjectDeserialization();
    }

    @Test
    public void testVariableNamesNotEqualsIgnoreCase() {
        String variableName = "varName";
        String variableValue = "varValue";
        String queryValue = variableName + "_neq_" + variableValue;
        RestAssured.given().queryParam("variableValues", new Object[]{queryValue}).queryParam("variableNamesIgnoreCase", new Object[]{true}).then().expect().statusCode(Response.Status.OK.getStatusCode()).when().get(VARIABLE_INSTANCE_QUERY_URL, new Object[0]);
        ((VariableInstanceQuery)Mockito.verify((Object)this.mockedQuery)).variableValueNotEquals(variableName, (Object)variableValue);
        ((VariableInstanceQuery)Mockito.verify((Object)this.mockedQuery)).matchVariableNamesIgnoreCase();
        ((VariableInstanceQuery)Mockito.verify((Object)this.mockedQuery)).disableBinaryFetching();
        ((VariableInstanceQuery)Mockito.verify((Object)this.mockedQuery, (VerificationMode)Mockito.never())).disableCustomObjectDeserialization();
    }

    @Test
    public void testVariableValueEqualsAsPost() {
        HashMap<String, String> variableJson = new HashMap<String, String>();
        variableJson.put("name", "varName");
        variableJson.put("value", "varValue");
        variableJson.put("operator", "eq");
        ArrayList<HashMap<String, String>> variables = new ArrayList<HashMap<String, String>>();
        variables.add(variableJson);
        HashMap<String, ArrayList<HashMap<String, String>>> json = new HashMap<String, ArrayList<HashMap<String, String>>>();
        json.put("variableValues", variables);
        RestAssured.given().contentType(POST_JSON_CONTENT_TYPE).body(json).then().expect().statusCode(Response.Status.OK.getStatusCode()).when().post(VARIABLE_INSTANCE_QUERY_URL, new Object[0]);
        ((VariableInstanceQuery)Mockito.verify((Object)this.mockedQuery)).variableValueEquals("varName", (Object)"varValue");
        ((VariableInstanceQuery)Mockito.verify((Object)this.mockedQuery)).disableBinaryFetching();
        ((VariableInstanceQuery)Mockito.verify((Object)this.mockedQuery, (VerificationMode)Mockito.never())).disableCustomObjectDeserialization();
    }

    @Test
    public void testVariableValueGreaterThanAsPost() {
        HashMap<String, String> variableJson = new HashMap<String, String>();
        variableJson.put("name", "varName");
        variableJson.put("value", "varValue");
        variableJson.put("operator", "gt");
        ArrayList<HashMap<String, String>> variables = new ArrayList<HashMap<String, String>>();
        variables.add(variableJson);
        HashMap<String, ArrayList<HashMap<String, String>>> json = new HashMap<String, ArrayList<HashMap<String, String>>>();
        json.put("variableValues", variables);
        RestAssured.given().contentType(POST_JSON_CONTENT_TYPE).body(json).then().expect().statusCode(Response.Status.OK.getStatusCode()).when().post(VARIABLE_INSTANCE_QUERY_URL, new Object[0]);
        ((VariableInstanceQuery)Mockito.verify((Object)this.mockedQuery)).variableValueGreaterThan("varName", (Object)"varValue");
        ((VariableInstanceQuery)Mockito.verify((Object)this.mockedQuery)).disableBinaryFetching();
        ((VariableInstanceQuery)Mockito.verify((Object)this.mockedQuery, (VerificationMode)Mockito.never())).disableCustomObjectDeserialization();
    }

    @Test
    public void testVariableValueGreaterThanEqualsAsPost() {
        HashMap<String, String> variableJson = new HashMap<String, String>();
        variableJson.put("name", "varName");
        variableJson.put("value", "varValue");
        variableJson.put("operator", "gteq");
        ArrayList<HashMap<String, String>> variables = new ArrayList<HashMap<String, String>>();
        variables.add(variableJson);
        HashMap<String, ArrayList<HashMap<String, String>>> json = new HashMap<String, ArrayList<HashMap<String, String>>>();
        json.put("variableValues", variables);
        RestAssured.given().contentType(POST_JSON_CONTENT_TYPE).body(json).then().expect().statusCode(Response.Status.OK.getStatusCode()).when().post(VARIABLE_INSTANCE_QUERY_URL, new Object[0]);
        ((VariableInstanceQuery)Mockito.verify((Object)this.mockedQuery)).variableValueGreaterThanOrEqual("varName", (Object)"varValue");
        ((VariableInstanceQuery)Mockito.verify((Object)this.mockedQuery)).disableBinaryFetching();
        ((VariableInstanceQuery)Mockito.verify((Object)this.mockedQuery, (VerificationMode)Mockito.never())).disableCustomObjectDeserialization();
    }

    @Test
    public void testVariableValueLessThanAsPost() {
        HashMap<String, String> variableJson = new HashMap<String, String>();
        variableJson.put("name", "varName");
        variableJson.put("value", "varValue");
        variableJson.put("operator", "lt");
        ArrayList<HashMap<String, String>> variables = new ArrayList<HashMap<String, String>>();
        variables.add(variableJson);
        HashMap<String, ArrayList<HashMap<String, String>>> json = new HashMap<String, ArrayList<HashMap<String, String>>>();
        json.put("variableValues", variables);
        RestAssured.given().contentType(POST_JSON_CONTENT_TYPE).body(json).then().expect().statusCode(Response.Status.OK.getStatusCode()).when().post(VARIABLE_INSTANCE_QUERY_URL, new Object[0]);
        ((VariableInstanceQuery)Mockito.verify((Object)this.mockedQuery)).variableValueLessThan("varName", (Object)"varValue");
        ((VariableInstanceQuery)Mockito.verify((Object)this.mockedQuery)).disableBinaryFetching();
        ((VariableInstanceQuery)Mockito.verify((Object)this.mockedQuery, (VerificationMode)Mockito.never())).disableCustomObjectDeserialization();
    }

    @Test
    public void testVariableValueLessThanEqualsAsPost() {
        HashMap<String, String> variableJson = new HashMap<String, String>();
        variableJson.put("name", "varName");
        variableJson.put("value", "varValue");
        variableJson.put("operator", "lteq");
        ArrayList<HashMap<String, String>> variables = new ArrayList<HashMap<String, String>>();
        variables.add(variableJson);
        HashMap<String, ArrayList<HashMap<String, String>>> json = new HashMap<String, ArrayList<HashMap<String, String>>>();
        json.put("variableValues", variables);
        RestAssured.given().contentType(POST_JSON_CONTENT_TYPE).body(json).then().expect().statusCode(Response.Status.OK.getStatusCode()).when().post(VARIABLE_INSTANCE_QUERY_URL, new Object[0]);
        ((VariableInstanceQuery)Mockito.verify((Object)this.mockedQuery)).variableValueLessThanOrEqual("varName", (Object)"varValue");
        ((VariableInstanceQuery)Mockito.verify((Object)this.mockedQuery)).disableBinaryFetching();
        ((VariableInstanceQuery)Mockito.verify((Object)this.mockedQuery, (VerificationMode)Mockito.never())).disableCustomObjectDeserialization();
    }

    @Test
    public void testVariableValueLikeAsPost() {
        HashMap<String, String> variableJson = new HashMap<String, String>();
        variableJson.put("name", "varName");
        variableJson.put("value", "varValue");
        variableJson.put("operator", "like");
        ArrayList<HashMap<String, String>> variables = new ArrayList<HashMap<String, String>>();
        variables.add(variableJson);
        HashMap<String, ArrayList<HashMap<String, String>>> json = new HashMap<String, ArrayList<HashMap<String, String>>>();
        json.put("variableValues", variables);
        RestAssured.given().contentType(POST_JSON_CONTENT_TYPE).body(json).then().expect().statusCode(Response.Status.OK.getStatusCode()).when().post(VARIABLE_INSTANCE_QUERY_URL, new Object[0]);
        ((VariableInstanceQuery)Mockito.verify((Object)this.mockedQuery)).variableValueLike("varName", "varValue");
        ((VariableInstanceQuery)Mockito.verify((Object)this.mockedQuery)).disableBinaryFetching();
        ((VariableInstanceQuery)Mockito.verify((Object)this.mockedQuery, (VerificationMode)Mockito.never())).disableCustomObjectDeserialization();
    }

    @Test
    public void testVariableValueNotEqualsAsPost() {
        HashMap<String, String> variableJson = new HashMap<String, String>();
        variableJson.put("name", "varName");
        variableJson.put("value", "varValue");
        variableJson.put("operator", "neq");
        ArrayList<HashMap<String, String>> variables = new ArrayList<HashMap<String, String>>();
        variables.add(variableJson);
        HashMap<String, ArrayList<HashMap<String, String>>> json = new HashMap<String, ArrayList<HashMap<String, String>>>();
        json.put("variableValues", variables);
        RestAssured.given().contentType(POST_JSON_CONTENT_TYPE).body(json).then().expect().statusCode(Response.Status.OK.getStatusCode()).when().post(VARIABLE_INSTANCE_QUERY_URL, new Object[0]);
        ((VariableInstanceQuery)Mockito.verify((Object)this.mockedQuery)).variableValueNotEquals("varName", (Object)"varValue");
        ((VariableInstanceQuery)Mockito.verify((Object)this.mockedQuery)).disableBinaryFetching();
        ((VariableInstanceQuery)Mockito.verify((Object)this.mockedQuery, (VerificationMode)Mockito.never())).disableCustomObjectDeserialization();
    }

    @Test
    public void testVariableValuesEqualsIgnoreCaseAsPost() {
        HashMap<String, String> variableJson = new HashMap<String, String>();
        variableJson.put("name", "varName");
        variableJson.put("value", "varValue");
        variableJson.put("operator", "eq");
        ArrayList<HashMap<String, String>> variables = new ArrayList<HashMap<String, String>>();
        variables.add(variableJson);
        HashMap<String, Serializable> json = new HashMap<String, Serializable>();
        json.put("variableValues", variables);
        json.put("variableValuesIgnoreCase", Boolean.valueOf(true));
        RestAssured.given().contentType(POST_JSON_CONTENT_TYPE).body(json).then().expect().statusCode(Response.Status.OK.getStatusCode()).when().post(VARIABLE_INSTANCE_QUERY_URL, new Object[0]);
        ((VariableInstanceQuery)Mockito.verify((Object)this.mockedQuery)).matchVariableValuesIgnoreCase();
        ((VariableInstanceQuery)Mockito.verify((Object)this.mockedQuery)).variableValueEquals("varName", (Object)"varValue");
        ((VariableInstanceQuery)Mockito.verify((Object)this.mockedQuery)).disableBinaryFetching();
        ((VariableInstanceQuery)Mockito.verify((Object)this.mockedQuery, (VerificationMode)Mockito.never())).disableCustomObjectDeserialization();
    }

    @Test
    public void testVariableValuesNotEqualsIgnoreCaseAsPost() {
        HashMap<String, String> variableJson = new HashMap<String, String>();
        variableJson.put("name", "varName");
        variableJson.put("value", "varValue");
        variableJson.put("operator", "neq");
        ArrayList<HashMap<String, String>> variables = new ArrayList<HashMap<String, String>>();
        variables.add(variableJson);
        HashMap<String, Serializable> json = new HashMap<String, Serializable>();
        json.put("variableValues", variables);
        json.put("variableValuesIgnoreCase", Boolean.valueOf(true));
        RestAssured.given().contentType(POST_JSON_CONTENT_TYPE).body(json).then().expect().statusCode(Response.Status.OK.getStatusCode()).when().post(VARIABLE_INSTANCE_QUERY_URL, new Object[0]);
        ((VariableInstanceQuery)Mockito.verify((Object)this.mockedQuery)).matchVariableValuesIgnoreCase();
        ((VariableInstanceQuery)Mockito.verify((Object)this.mockedQuery)).variableValueNotEquals("varName", (Object)"varValue");
        ((VariableInstanceQuery)Mockito.verify((Object)this.mockedQuery)).disableBinaryFetching();
        ((VariableInstanceQuery)Mockito.verify((Object)this.mockedQuery, (VerificationMode)Mockito.never())).disableCustomObjectDeserialization();
    }

    @Test
    public void testVariableValuesLikeIgnoreCaseAsPost() {
        HashMap<String, String> variableJson = new HashMap<String, String>();
        variableJson.put("name", "varName");
        variableJson.put("value", "varValue");
        variableJson.put("operator", "like");
        ArrayList<HashMap<String, String>> variables = new ArrayList<HashMap<String, String>>();
        variables.add(variableJson);
        HashMap<String, Serializable> json = new HashMap<String, Serializable>();
        json.put("variableValues", variables);
        json.put("variableValuesIgnoreCase", Boolean.valueOf(true));
        RestAssured.given().contentType(POST_JSON_CONTENT_TYPE).body(json).then().expect().statusCode(Response.Status.OK.getStatusCode()).when().post(VARIABLE_INSTANCE_QUERY_URL, new Object[0]);
        ((VariableInstanceQuery)Mockito.verify((Object)this.mockedQuery)).matchVariableValuesIgnoreCase();
        ((VariableInstanceQuery)Mockito.verify((Object)this.mockedQuery)).variableValueLike("varName", "varValue");
        ((VariableInstanceQuery)Mockito.verify((Object)this.mockedQuery)).disableBinaryFetching();
        ((VariableInstanceQuery)Mockito.verify((Object)this.mockedQuery, (VerificationMode)Mockito.never())).disableCustomObjectDeserialization();
    }

    @Test
    public void testVariableNamesEqualsIgnoreCaseAsPost() {
        HashMap<String, String> variableJson = new HashMap<String, String>();
        variableJson.put("name", "varName");
        variableJson.put("value", "varValue");
        variableJson.put("operator", "eq");
        ArrayList<HashMap<String, String>> variables = new ArrayList<HashMap<String, String>>();
        variables.add(variableJson);
        HashMap<String, Serializable> json = new HashMap<String, Serializable>();
        json.put("variableValues", variables);
        json.put("variableNamesIgnoreCase", Boolean.valueOf(true));
        RestAssured.given().contentType(POST_JSON_CONTENT_TYPE).body(json).then().expect().statusCode(Response.Status.OK.getStatusCode()).when().post(VARIABLE_INSTANCE_QUERY_URL, new Object[0]);
        ((VariableInstanceQuery)Mockito.verify((Object)this.mockedQuery)).matchVariableNamesIgnoreCase();
        ((VariableInstanceQuery)Mockito.verify((Object)this.mockedQuery)).variableValueEquals("varName", (Object)"varValue");
        ((VariableInstanceQuery)Mockito.verify((Object)this.mockedQuery)).disableBinaryFetching();
        ((VariableInstanceQuery)Mockito.verify((Object)this.mockedQuery, (VerificationMode)Mockito.never())).disableCustomObjectDeserialization();
    }

    @Test
    public void testVariableNamesNotEqualsIgnoreCaseAsPost() {
        HashMap<String, String> variableJson = new HashMap<String, String>();
        variableJson.put("name", "varName");
        variableJson.put("value", "varValue");
        variableJson.put("operator", "neq");
        ArrayList<HashMap<String, String>> variables = new ArrayList<HashMap<String, String>>();
        variables.add(variableJson);
        HashMap<String, Serializable> json = new HashMap<String, Serializable>();
        json.put("variableValues", variables);
        json.put("variableNamesIgnoreCase", Boolean.valueOf(true));
        RestAssured.given().contentType(POST_JSON_CONTENT_TYPE).body(json).then().expect().statusCode(Response.Status.OK.getStatusCode()).when().post(VARIABLE_INSTANCE_QUERY_URL, new Object[0]);
        ((VariableInstanceQuery)Mockito.verify((Object)this.mockedQuery)).matchVariableNamesIgnoreCase();
        ((VariableInstanceQuery)Mockito.verify((Object)this.mockedQuery)).variableValueNotEquals("varName", (Object)"varValue");
        ((VariableInstanceQuery)Mockito.verify((Object)this.mockedQuery)).disableBinaryFetching();
        ((VariableInstanceQuery)Mockito.verify((Object)this.mockedQuery, (VerificationMode)Mockito.never())).disableCustomObjectDeserialization();
    }

    @Test
    public void testMultipleVariableParameters() {
        String variableName1 = "varName";
        String variableValue1 = "varValue";
        String variableParameter1 = variableName1 + "_eq_" + variableValue1;
        String variableName2 = "anotherVarName";
        String variableValue2 = "anotherVarValue";
        String variableParameter2 = variableName2 + "_neq_" + variableValue2;
        String queryValue = variableParameter1 + "," + variableParameter2;
        RestAssured.given().queryParam("variableValues", new Object[]{queryValue}).then().expect().statusCode(Response.Status.OK.getStatusCode()).when().get(VARIABLE_INSTANCE_QUERY_URL, new Object[0]);
        ((VariableInstanceQuery)Mockito.verify((Object)this.mockedQuery)).variableValueEquals(variableName1, (Object)variableValue1);
        ((VariableInstanceQuery)Mockito.verify((Object)this.mockedQuery)).variableValueNotEquals(variableName2, (Object)variableValue2);
        ((VariableInstanceQuery)Mockito.verify((Object)this.mockedQuery)).disableBinaryFetching();
        ((VariableInstanceQuery)Mockito.verify((Object)this.mockedQuery, (VerificationMode)Mockito.never())).disableCustomObjectDeserialization();
    }

    @Test
    public void testMultipleVariableParametersAsPost() {
        String variableName = "varName";
        String variableValue = "varValue";
        String anotherVariableName = "anotherVarName";
        Integer anotherVariableValue = 30;
        HashMap<String, String> variableJson = new HashMap<String, String>();
        variableJson.put("name", variableName);
        variableJson.put("operator", "eq");
        variableJson.put("value", variableValue);
        HashMap<String, Object> anotherVariableJson = new HashMap<String, Object>();
        anotherVariableJson.put("name", anotherVariableName);
        anotherVariableJson.put("operator", "neq");
        anotherVariableJson.put("value", anotherVariableValue);
        ArrayList<HashMap<String, Object>> variables = new ArrayList<HashMap<String, Object>>();
        variables.add(variableJson);
        variables.add(anotherVariableJson);
        HashMap<String, ArrayList<HashMap<String, Object>>> json = new HashMap<String, ArrayList<HashMap<String, Object>>>();
        json.put("variableValues", variables);
        RestAssured.given().contentType(POST_JSON_CONTENT_TYPE).body(json).then().expect().statusCode(Response.Status.OK.getStatusCode()).when().post(VARIABLE_INSTANCE_QUERY_URL, new Object[0]);
        ((VariableInstanceQuery)Mockito.verify((Object)this.mockedQuery)).variableValueEquals(variableName, (Object)variableValue);
        ((VariableInstanceQuery)Mockito.verify((Object)this.mockedQuery)).variableValueNotEquals((String)Mockito.eq((Object)anotherVariableName), MockitoHamcrest.argThat((Matcher)EqualsPrimitiveValue.numberValue(anotherVariableValue)));
        ((VariableInstanceQuery)Mockito.verify((Object)this.mockedQuery)).disableBinaryFetching();
        ((VariableInstanceQuery)Mockito.verify((Object)this.mockedQuery, (VerificationMode)Mockito.never())).disableCustomObjectDeserialization();
    }

    @Test
    public void testMultipleParameters() {
        String aProcessInstanceId = "aProcessInstanceId";
        String anotherProcessInstanceId = "anotherProcessInstanceId";
        String anExecutionId = "anExecutionId";
        String anotherExecutionId = "anotherExecutionId";
        String aTaskId = "aTaskId";
        String anotherTaskId = "anotherTaskId";
        String aVariableScopeId = "aVariableScopeId";
        String anotherVariableScopeId = "anotherVariableScopeId";
        String anActivityInstanceId = "anActivityInstanceId";
        String anotherActivityInstanceId = "anotherActivityInstanceId";
        RestAssured.given().queryParam("processInstanceIdIn", new Object[]{aProcessInstanceId + "," + anotherProcessInstanceId}).queryParam("executionIdIn", new Object[]{anExecutionId + "," + anotherExecutionId}).queryParam("taskIdIn", new Object[]{aTaskId + "," + anotherTaskId}).queryParam("variableScopeIdIn", new Object[]{aVariableScopeId + "," + anotherVariableScopeId}).queryParam("activityInstanceIdIn", new Object[]{anActivityInstanceId + "," + anotherActivityInstanceId}).then().expect().statusCode(Response.Status.OK.getStatusCode()).when().get(VARIABLE_INSTANCE_QUERY_URL, new Object[0]);
        ((VariableInstanceQuery)Mockito.verify((Object)this.mockedQuery)).processInstanceIdIn(new String[]{aProcessInstanceId, anotherProcessInstanceId});
        ((VariableInstanceQuery)Mockito.verify((Object)this.mockedQuery)).executionIdIn(new String[]{anExecutionId, anotherExecutionId});
        ((VariableInstanceQuery)Mockito.verify((Object)this.mockedQuery)).taskIdIn(new String[]{aTaskId, anotherTaskId});
        ((VariableInstanceQuery)Mockito.verify((Object)this.mockedQuery)).variableScopeIdIn(new String[]{aVariableScopeId, anotherVariableScopeId});
        ((VariableInstanceQuery)Mockito.verify((Object)this.mockedQuery)).activityInstanceIdIn(new String[]{anActivityInstanceId, anotherActivityInstanceId});
        ((VariableInstanceQuery)Mockito.verify((Object)this.mockedQuery)).disableBinaryFetching();
        ((VariableInstanceQuery)Mockito.verify((Object)this.mockedQuery, (VerificationMode)Mockito.never())).disableCustomObjectDeserialization();
    }

    @Test
    public void testMultipleParametersAsPost() {
        String aProcessInstanceId = "aProcessInstanceId";
        String anotherProcessInstanceId = "anotherProcessInstanceId";
        ArrayList<String> processDefinitionIdIn = new ArrayList<String>();
        processDefinitionIdIn.add(aProcessInstanceId);
        processDefinitionIdIn.add(anotherProcessInstanceId);
        String anExecutionId = "anExecutionId";
        String anotherExecutionId = "anotherExecutionId";
        ArrayList<String> executionIdIn = new ArrayList<String>();
        executionIdIn.add(anExecutionId);
        executionIdIn.add(anotherExecutionId);
        String aTaskId = "aTaskId";
        String anotherTaskId = "anotherTaskId";
        ArrayList<String> taskIdIn = new ArrayList<String>();
        taskIdIn.add(aTaskId);
        taskIdIn.add(anotherTaskId);
        String aVariableScopeId = "aVariableScopeId";
        String anotherVariableScopeId = "anotherVariableScopeId";
        ArrayList<String> variableScopeIdIn = new ArrayList<String>();
        variableScopeIdIn.add(aVariableScopeId);
        variableScopeIdIn.add(anotherVariableScopeId);
        String anActivityInstanceId = "anActivityInstanceId";
        String anotherActivityInstanceId = "anotherActivityInstanceId";
        ArrayList<String> activityInstanceIdIn = new ArrayList<String>();
        activityInstanceIdIn.add(anActivityInstanceId);
        activityInstanceIdIn.add(anotherActivityInstanceId);
        HashMap<String, ArrayList<String>> json = new HashMap<String, ArrayList<String>>();
        json.put("processInstanceIdIn", processDefinitionIdIn);
        json.put("executionIdIn", executionIdIn);
        json.put("taskIdIn", taskIdIn);
        json.put("variableScopeIdIn", variableScopeIdIn);
        json.put("activityInstanceIdIn", activityInstanceIdIn);
        RestAssured.given().contentType(POST_JSON_CONTENT_TYPE).body(json).then().expect().statusCode(Response.Status.OK.getStatusCode()).when().post(VARIABLE_INSTANCE_QUERY_URL, new Object[0]);
        ((VariableInstanceQuery)Mockito.verify((Object)this.mockedQuery)).processInstanceIdIn(new String[]{aProcessInstanceId, anotherProcessInstanceId});
        ((VariableInstanceQuery)Mockito.verify((Object)this.mockedQuery)).executionIdIn(new String[]{anExecutionId, anotherExecutionId});
        ((VariableInstanceQuery)Mockito.verify((Object)this.mockedQuery)).taskIdIn(new String[]{aTaskId, anotherTaskId});
        ((VariableInstanceQuery)Mockito.verify((Object)this.mockedQuery)).variableScopeIdIn(new String[]{aVariableScopeId, anotherVariableScopeId});
        ((VariableInstanceQuery)Mockito.verify((Object)this.mockedQuery)).activityInstanceIdIn(new String[]{anActivityInstanceId, anotherActivityInstanceId});
        ((VariableInstanceQuery)Mockito.verify((Object)this.mockedQuery)).disableBinaryFetching();
        ((VariableInstanceQuery)Mockito.verify((Object)this.mockedQuery, (VerificationMode)Mockito.never())).disableCustomObjectDeserialization();
    }

    @Test
    public void testQueryCount() {
        RestAssured.expect().statusCode(Response.Status.OK.getStatusCode()).body("count", Matchers.equalTo((Object)1), new Object[0]).when().get(VARIABLE_INSTANCE_COUNT_QUERY_URL, new Object[0]);
        ((VariableInstanceQuery)Mockito.verify((Object)this.mockedQuery)).count();
    }

    @Test
    public void testQueryCountForPost() {
        RestAssured.given().contentType(POST_JSON_CONTENT_TYPE).body("{}").expect().statusCode(Response.Status.OK.getStatusCode()).body("count", Matchers.equalTo((Object)1), new Object[0]).when().post(VARIABLE_INSTANCE_COUNT_QUERY_URL, new Object[0]);
        ((VariableInstanceQuery)Mockito.verify((Object)this.mockedQuery)).count();
    }
}

