/*
 * Decompiled with CFR 0.152.
 */
package org.eximeebpms.bpm.engine.rest.helper;

import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import org.eximeebpms.bpm.engine.variable.VariableMap;
import org.eximeebpms.bpm.engine.variable.value.TypedValue;
import org.hamcrest.BaseMatcher;
import org.hamcrest.Description;
import org.hamcrest.Matcher;

public class EqualsMap
extends BaseMatcher<Map<String, Object>> {
    protected Map<String, Object> mapToCompare;
    protected Map<String, Matcher<?>> matchers;

    public EqualsMap() {
    }

    public EqualsMap(Map<String, Object> mapToCompare) {
        this.mapToCompare = mapToCompare;
    }

    public boolean matches(Object argument) {
        if (this.mapToCompare != null) {
            return this.matchesExactly(argument);
        }
        if (this.matchers != null) {
            return this.matchesMatchers(argument);
        }
        return argument == null;
    }

    protected boolean matchesExactly(Object argument) {
        if (argument == null) {
            return false;
        }
        Map argumentMap = (Map)argument;
        Set<Map.Entry<String, Object>> setToCompare = this.mapToCompare.entrySet();
        Set argumentSet = argumentMap.entrySet();
        return setToCompare.equals(argumentSet);
    }

    protected boolean matchesMatchers(Object argument) {
        boolean containSameKeys;
        if (argument == null) {
            return false;
        }
        Map argumentMap = (Map)argument;
        boolean bl = containSameKeys = this.matchers.keySet().containsAll(argumentMap.keySet()) && argumentMap.keySet().containsAll(this.matchers.keySet());
        if (!containSameKeys) {
            return false;
        }
        for (String key : argumentMap.keySet()) {
            Matcher<?> matcher = this.matchers.get(key);
            TypedValue value = null;
            if (argumentMap instanceof VariableMap) {
                VariableMap varMap = (VariableMap)argumentMap;
                value = varMap.getValueTyped(key);
            } else {
                value = (TypedValue)argumentMap.get(key);
            }
            if (matcher.matches((Object)value)) continue;
            return false;
        }
        return true;
    }

    public static EqualsMap containsExactly(Map<String, Object> map) {
        EqualsMap matcher = new EqualsMap();
        matcher.mapToCompare = map;
        return matcher;
    }

    public static EqualsMap matchesExactly(Map<String, Matcher<?>> matchers) {
        EqualsMap matcher = new EqualsMap();
        matcher.matchers = matchers;
        return matcher;
    }

    public EqualsMap matcher(String key, Matcher<?> matcher) {
        if (this.matchers == null) {
            this.matchers = new HashMap();
        }
        this.matchers.put(key, matcher);
        return this;
    }

    public void describeTo(Description description) {
        StringBuilder sb = new StringBuilder();
        sb.append(((Object)((Object)this)).getClass().getSimpleName());
        sb.append(": ");
        sb.append("mapToCompare=");
        sb.append(this.mapToCompare);
        sb.append(" ");
        sb.append("matchers=");
        sb.append(this.matchers);
        description.appendText(sb.toString());
    }
}

