/*
 * Decompiled with CFR 0.152.
 */
package org.eximeebpms.bpm.engine.rest.helper;

import java.util.ArrayList;
import java.util.List;
import org.eximeebpms.bpm.engine.migration.MigrationInstruction;
import org.eximeebpms.bpm.engine.migration.MigrationInstructionBuilder;
import org.eximeebpms.bpm.engine.migration.MigrationInstructionsBuilder;
import org.eximeebpms.bpm.engine.migration.MigrationPlan;
import org.eximeebpms.bpm.engine.migration.MigrationPlanBuilder;
import org.eximeebpms.bpm.engine.rest.helper.FluentAnswer;
import org.eximeebpms.bpm.engine.rest.helper.MockMigrationInstructionBuilder;
import org.eximeebpms.bpm.engine.variable.VariableMap;
import org.mockito.Mockito;
import org.mockito.stubbing.Answer;

public class MockMigrationPlanBuilder {
    protected String sourceProcessDefinitionId;
    protected String targetProcessDefinitionId;
    protected List<MigrationInstruction> instructions = new ArrayList<MigrationInstruction>();
    protected VariableMap variables;

    public MockMigrationPlanBuilder sourceProcessDefinitionId(String sourceProcessDefinitionId) {
        this.sourceProcessDefinitionId = sourceProcessDefinitionId;
        return this;
    }

    public MockMigrationPlanBuilder targetProcessDefinitionId(String targetProcessDefinitionId) {
        this.targetProcessDefinitionId = targetProcessDefinitionId;
        return this;
    }

    public MockMigrationPlanBuilder instructions(List<MigrationInstruction> instructions) {
        this.instructions = instructions;
        return this;
    }

    public MockMigrationPlanBuilder instruction(MigrationInstruction instruction) {
        this.instructions.add(instruction);
        return this;
    }

    public MockMigrationPlanBuilder instruction(String sourceActivityId, String targetActivityId) {
        MigrationInstruction instructionMock = new MockMigrationInstructionBuilder().sourceActivityId(sourceActivityId).targetActivityId(targetActivityId).build();
        return this.instruction(instructionMock);
    }

    public MockMigrationPlanBuilder instruction(String sourceActivityId, String targetActivityId, Boolean updateEventTrigger) {
        MockMigrationInstructionBuilder instructionBuilder = new MockMigrationInstructionBuilder().sourceActivityId(sourceActivityId).targetActivityId(targetActivityId);
        if (Boolean.TRUE.equals(updateEventTrigger)) {
            instructionBuilder = instructionBuilder.updateEventTrigger();
        }
        MigrationInstruction instructionMock = instructionBuilder.build();
        return this.instruction(instructionMock);
    }

    public MigrationPlan build() {
        MigrationPlan migrationPlanMock = (MigrationPlan)Mockito.mock(MigrationPlan.class);
        Mockito.when((Object)migrationPlanMock.getSourceProcessDefinitionId()).thenReturn((Object)this.sourceProcessDefinitionId);
        Mockito.when((Object)migrationPlanMock.getTargetProcessDefinitionId()).thenReturn((Object)this.targetProcessDefinitionId);
        Mockito.when((Object)migrationPlanMock.getInstructions()).thenReturn(this.instructions);
        Mockito.when((Object)migrationPlanMock.getVariables()).thenReturn((Object)this.variables);
        return migrationPlanMock;
    }

    public JoinedMigrationPlanBuilderMock builder() {
        MigrationPlan migrationPlanMock = this.build();
        JoinedMigrationPlanBuilderMock migrationPlanBuilderMock = (JoinedMigrationPlanBuilderMock)Mockito.mock(JoinedMigrationPlanBuilderMock.class, (Answer)new FluentAnswer());
        Mockito.when((Object)migrationPlanBuilderMock.build()).thenReturn((Object)migrationPlanMock);
        return migrationPlanBuilderMock;
    }

    public MockMigrationPlanBuilder variables(VariableMap variables) {
        this.variables = variables;
        return this;
    }

    public static interface JoinedMigrationPlanBuilderMock
    extends MigrationPlanBuilder,
    MigrationInstructionBuilder,
    MigrationInstructionsBuilder {
    }
}

