/*
 * Decompiled with CFR 0.152.
 */
package org.eximeebpms.bpm.engine.rest.history;

import io.restassured.RestAssured;
import io.restassured.http.ContentType;
import io.restassured.path.json.JsonPath;
import io.restassured.response.Response;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.ws.rs.core.Response;
import org.eximeebpms.bpm.engine.AuthorizationException;
import org.eximeebpms.bpm.engine.history.CleanableHistoricProcessInstanceReport;
import org.eximeebpms.bpm.engine.history.CleanableHistoricProcessInstanceReportResult;
import org.eximeebpms.bpm.engine.rest.AbstractRestServiceTest;
import org.eximeebpms.bpm.engine.rest.exception.InvalidRequestException;
import org.eximeebpms.bpm.engine.rest.util.container.TestContainerRule;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matchers;
import org.junit.Assert;
import org.junit.Before;
import org.junit.ClassRule;
import org.junit.Test;
import org.mockito.InOrder;
import org.mockito.Mockito;

public class CleanableHistoricProcessInstanceReportServiceTest
extends AbstractRestServiceTest {
    private static final String EXAMPLE_PD_NAME = "aName";
    private static final String EXAMPLE_PD_KEY = "aKey";
    private static final int EXAMPLE_PD_VERSION = 42;
    private static final int EXAMPLE_TTL = 5;
    private static final long EXAMPLE_FINISHED_PI_COUNT = 10L;
    private static final long EXAMPLE_CLEANABLE_PI_COUNT = 5L;
    private static final String EXAMPLE_TENANT_ID = "aTenantId";
    protected static final String ANOTHER_EXAMPLE_PROCESS_DEFINITION_ID = "anotherDefId";
    protected static final String ANOTHER_EXAMPLE_PD_KEY = "anotherDefKey";
    protected static final String ANOTHER_EXAMPLE_TENANT_ID = "anotherTenantId";
    @ClassRule
    public static TestContainerRule rule = new TestContainerRule();
    protected static final String HISTORY_URL = "/rest-test/history/process-definition";
    protected static final String HISTORIC_REPORT_URL = "/rest-test/history/process-definition/cleanable-process-instance-report";
    protected static final String HISTORIC_REPORT_COUNT_URL = "/rest-test/history/process-definition/cleanable-process-instance-report/count";
    private CleanableHistoricProcessInstanceReport historicProcessInstanceReport;

    @Before
    public void setUpRuntimeData() {
        this.setupHistoryReportMock();
    }

    private void setupHistoryReportMock() {
        CleanableHistoricProcessInstanceReport report = (CleanableHistoricProcessInstanceReport)Mockito.mock(CleanableHistoricProcessInstanceReport.class);
        Mockito.when((Object)report.processDefinitionIdIn(new String[]{Mockito.anyString()})).thenReturn((Object)report);
        Mockito.when((Object)report.processDefinitionKeyIn(new String[]{Mockito.anyString()})).thenReturn((Object)report);
        CleanableHistoricProcessInstanceReportResult reportResult = (CleanableHistoricProcessInstanceReportResult)Mockito.mock(CleanableHistoricProcessInstanceReportResult.class);
        Mockito.when((Object)reportResult.getProcessDefinitionId()).thenReturn((Object)"aProcessDefinitionId");
        Mockito.when((Object)reportResult.getProcessDefinitionKey()).thenReturn((Object)EXAMPLE_PD_KEY);
        Mockito.when((Object)reportResult.getProcessDefinitionName()).thenReturn((Object)EXAMPLE_PD_NAME);
        Mockito.when((Object)reportResult.getProcessDefinitionVersion()).thenReturn((Object)42);
        Mockito.when((Object)reportResult.getHistoryTimeToLive()).thenReturn((Object)5);
        Mockito.when((Object)reportResult.getFinishedProcessInstanceCount()).thenReturn((Object)10L);
        Mockito.when((Object)reportResult.getCleanableProcessInstanceCount()).thenReturn((Object)5L);
        Mockito.when((Object)reportResult.getTenantId()).thenReturn((Object)EXAMPLE_TENANT_ID);
        CleanableHistoricProcessInstanceReportResult anotherReportResult = (CleanableHistoricProcessInstanceReportResult)Mockito.mock(CleanableHistoricProcessInstanceReportResult.class);
        Mockito.when((Object)anotherReportResult.getProcessDefinitionId()).thenReturn((Object)ANOTHER_EXAMPLE_PROCESS_DEFINITION_ID);
        Mockito.when((Object)anotherReportResult.getProcessDefinitionKey()).thenReturn((Object)ANOTHER_EXAMPLE_PD_KEY);
        Mockito.when((Object)anotherReportResult.getProcessDefinitionName()).thenReturn((Object)"pdName");
        Mockito.when((Object)anotherReportResult.getProcessDefinitionVersion()).thenReturn((Object)33);
        Mockito.when((Object)anotherReportResult.getHistoryTimeToLive()).thenReturn(null);
        Mockito.when((Object)anotherReportResult.getFinishedProcessInstanceCount()).thenReturn((Object)13L);
        Mockito.when((Object)anotherReportResult.getCleanableProcessInstanceCount()).thenReturn((Object)0L);
        Mockito.when((Object)anotherReportResult.getTenantId()).thenReturn((Object)ANOTHER_EXAMPLE_TENANT_ID);
        ArrayList<CleanableHistoricProcessInstanceReportResult> mocks = new ArrayList<CleanableHistoricProcessInstanceReportResult>();
        mocks.add(reportResult);
        mocks.add(anotherReportResult);
        Mockito.when((Object)report.list()).thenReturn(mocks);
        Mockito.when((Object)report.count()).thenReturn((Object)mocks.size());
        this.historicProcessInstanceReport = report;
        Mockito.when((Object)processEngine.getHistoryService().createCleanableHistoricProcessInstanceReport()).thenReturn((Object)this.historicProcessInstanceReport);
    }

    @Test
    public void testGetReport() {
        RestAssured.given().then().expect().statusCode(Response.Status.OK.getStatusCode()).contentType(ContentType.JSON).when().get(HISTORIC_REPORT_URL, new Object[0]);
        InOrder inOrder = Mockito.inOrder((Object[])new Object[]{this.historicProcessInstanceReport});
        ((CleanableHistoricProcessInstanceReport)inOrder.verify((Object)this.historicProcessInstanceReport)).list();
        Mockito.verifyNoMoreInteractions((Object[])new Object[]{this.historicProcessInstanceReport});
    }

    @Test
    public void testReportRetrieval() {
        Response response = (Response)RestAssured.given().then().expect().statusCode(Response.Status.OK.getStatusCode()).contentType(ContentType.JSON).when().get(HISTORIC_REPORT_URL, new Object[0]);
        InOrder inOrder = Mockito.inOrder((Object[])new Object[]{this.historicProcessInstanceReport});
        ((CleanableHistoricProcessInstanceReport)inOrder.verify((Object)this.historicProcessInstanceReport)).list();
        String content = response.asString();
        List reportResults = JsonPath.from((String)content).getList("");
        Assert.assertEquals((String)"There should be two report results returned.", (long)2L, (long)reportResults.size());
        Assert.assertNotNull(reportResults.get(0));
        String returnedDefinitionId = JsonPath.from((String)content).getString("[0].processDefinitionId");
        String returnedDefinitionKey = JsonPath.from((String)content).getString("[0].processDefinitionKey");
        String returnedDefinitionName = JsonPath.from((String)content).getString("[0].processDefinitionName");
        int returnedDefinitionVersion = JsonPath.from((String)content).getInt("[0].processDefinitionVersion");
        int returnedTTL = JsonPath.from((String)content).getInt("[0].historyTimeToLive");
        long returnedFinishedCount = JsonPath.from((String)content).getLong("[0].finishedProcessInstanceCount");
        long returnedCleanableCount = JsonPath.from((String)content).getLong("[0].cleanableProcessInstanceCount");
        String returnedTenantId = JsonPath.from((String)content).getString("[0].tenantId");
        Assert.assertEquals((Object)"aProcessDefinitionId", (Object)returnedDefinitionId);
        Assert.assertEquals((Object)EXAMPLE_PD_KEY, (Object)returnedDefinitionKey);
        Assert.assertEquals((Object)EXAMPLE_PD_NAME, (Object)returnedDefinitionName);
        Assert.assertEquals((long)42L, (long)returnedDefinitionVersion);
        Assert.assertEquals((long)5L, (long)returnedTTL);
        Assert.assertEquals((long)10L, (long)returnedFinishedCount);
        Assert.assertEquals((long)5L, (long)returnedCleanableCount);
        Assert.assertEquals((Object)EXAMPLE_TENANT_ID, (Object)returnedTenantId);
    }

    @Test
    public void testMissingAuthorization() {
        String message = "not authorized";
        Mockito.when((Object)this.historicProcessInstanceReport.list()).thenThrow(new Throwable[]{new AuthorizationException(message)});
        RestAssured.given().then().expect().statusCode(Response.Status.FORBIDDEN.getStatusCode()).contentType(ContentType.JSON).body("type", CoreMatchers.equalTo((Object)AuthorizationException.class.getSimpleName()), new Object[0]).body("message", CoreMatchers.equalTo((Object)message), new Object[0]).when().get(HISTORIC_REPORT_URL, new Object[0]);
    }

    @Test
    public void testQueryByDefinitionId() {
        RestAssured.given().queryParam("processDefinitionIdIn", new Object[]{"aProcessDefinitionId,anotherDefId"}).then().expect().statusCode(Response.Status.OK.getStatusCode()).contentType(ContentType.JSON).when().get(HISTORIC_REPORT_URL, new Object[0]);
        ((CleanableHistoricProcessInstanceReport)Mockito.verify((Object)this.historicProcessInstanceReport)).processDefinitionIdIn(new String[]{"aProcessDefinitionId", ANOTHER_EXAMPLE_PROCESS_DEFINITION_ID});
        ((CleanableHistoricProcessInstanceReport)Mockito.verify((Object)this.historicProcessInstanceReport)).list();
        Mockito.verifyNoMoreInteractions((Object[])new Object[]{this.historicProcessInstanceReport});
    }

    @Test
    public void testQueryByDefinitionKey() {
        RestAssured.given().queryParam("processDefinitionKeyIn", new Object[]{"aKey,anotherDefKey"}).then().expect().statusCode(Response.Status.OK.getStatusCode()).contentType(ContentType.JSON).when().get(HISTORIC_REPORT_URL, new Object[0]);
        ((CleanableHistoricProcessInstanceReport)Mockito.verify((Object)this.historicProcessInstanceReport)).processDefinitionKeyIn(new String[]{EXAMPLE_PD_KEY, ANOTHER_EXAMPLE_PD_KEY});
        ((CleanableHistoricProcessInstanceReport)Mockito.verify((Object)this.historicProcessInstanceReport)).list();
        Mockito.verifyNoMoreInteractions((Object[])new Object[]{this.historicProcessInstanceReport});
    }

    @Test
    public void testQueryByTenantId() {
        RestAssured.given().queryParam("tenantIdIn", new Object[]{"aTenantId,anotherTenantId"}).then().expect().statusCode(Response.Status.OK.getStatusCode()).contentType(ContentType.JSON).when().get(HISTORIC_REPORT_URL, new Object[0]);
        ((CleanableHistoricProcessInstanceReport)Mockito.verify((Object)this.historicProcessInstanceReport)).tenantIdIn(new String[]{EXAMPLE_TENANT_ID, ANOTHER_EXAMPLE_TENANT_ID});
        ((CleanableHistoricProcessInstanceReport)Mockito.verify((Object)this.historicProcessInstanceReport)).list();
        Mockito.verifyNoMoreInteractions((Object[])new Object[]{this.historicProcessInstanceReport});
    }

    @Test
    public void testQueryWithoutTenantId() {
        RestAssured.given().queryParam("withoutTenantId", new Object[]{true}).then().expect().statusCode(Response.Status.OK.getStatusCode()).contentType(ContentType.JSON).when().get(HISTORIC_REPORT_URL, new Object[0]);
        ((CleanableHistoricProcessInstanceReport)Mockito.verify((Object)this.historicProcessInstanceReport)).withoutTenantId();
        ((CleanableHistoricProcessInstanceReport)Mockito.verify((Object)this.historicProcessInstanceReport)).list();
        Mockito.verifyNoMoreInteractions((Object[])new Object[]{this.historicProcessInstanceReport});
    }

    @Test
    public void testQueryCompact() {
        RestAssured.given().queryParam("compact", new Object[]{true}).then().expect().statusCode(Response.Status.OK.getStatusCode()).contentType(ContentType.JSON).when().get(HISTORIC_REPORT_URL, new Object[0]);
        ((CleanableHistoricProcessInstanceReport)Mockito.verify((Object)this.historicProcessInstanceReport)).compact();
        ((CleanableHistoricProcessInstanceReport)Mockito.verify((Object)this.historicProcessInstanceReport)).list();
        Mockito.verifyNoMoreInteractions((Object[])new Object[]{this.historicProcessInstanceReport});
    }

    @Test
    public void testFullQuery() {
        RestAssured.given().params(this.getCompleteQueryParameters()).then().expect().statusCode(Response.Status.OK.getStatusCode()).contentType(ContentType.JSON).when().get(HISTORIC_REPORT_URL, new Object[0]);
        this.verifyQueryParameterInvocations();
        ((CleanableHistoricProcessInstanceReport)Mockito.verify((Object)this.historicProcessInstanceReport)).list();
    }

    @Test
    public void testQueryCount() {
        RestAssured.expect().statusCode(Response.Status.OK.getStatusCode()).body("count", CoreMatchers.equalTo((Object)2), new Object[0]).when().get(HISTORIC_REPORT_COUNT_URL, new Object[0]);
        ((CleanableHistoricProcessInstanceReport)Mockito.verify((Object)this.historicProcessInstanceReport)).count();
        Mockito.verifyNoMoreInteractions((Object[])new Object[]{this.historicProcessInstanceReport});
    }

    @Test
    public void testFullQueryCount() {
        RestAssured.given().params(this.getCompleteQueryParameters()).then().expect().statusCode(Response.Status.OK.getStatusCode()).body("count", CoreMatchers.equalTo((Object)2), new Object[0]).when().get(HISTORIC_REPORT_COUNT_URL, new Object[0]);
        this.verifyQueryParameterInvocations();
        ((CleanableHistoricProcessInstanceReport)Mockito.verify((Object)this.historicProcessInstanceReport)).count();
    }

    @Test
    public void testOrderByFinishedProcessInstanceAsc() {
        RestAssured.given().queryParam("sortBy", new Object[]{"finished"}).queryParam("sortOrder", new Object[]{"asc"}).then().expect().statusCode(Response.Status.OK.getStatusCode()).when().get(HISTORIC_REPORT_URL, new Object[0]);
        ((CleanableHistoricProcessInstanceReport)Mockito.verify((Object)this.historicProcessInstanceReport)).orderByFinished();
        ((CleanableHistoricProcessInstanceReport)Mockito.verify((Object)this.historicProcessInstanceReport)).asc();
        ((CleanableHistoricProcessInstanceReport)Mockito.verify((Object)this.historicProcessInstanceReport)).list();
        Mockito.verifyNoMoreInteractions((Object[])new Object[]{this.historicProcessInstanceReport});
    }

    @Test
    public void testOrderByFinishedProcessInstanceDesc() {
        RestAssured.given().queryParam("sortBy", new Object[]{"finished"}).queryParam("sortOrder", new Object[]{"desc"}).then().expect().statusCode(Response.Status.OK.getStatusCode()).when().get(HISTORIC_REPORT_URL, new Object[0]);
        ((CleanableHistoricProcessInstanceReport)Mockito.verify((Object)this.historicProcessInstanceReport)).orderByFinished();
        ((CleanableHistoricProcessInstanceReport)Mockito.verify((Object)this.historicProcessInstanceReport)).desc();
        ((CleanableHistoricProcessInstanceReport)Mockito.verify((Object)this.historicProcessInstanceReport)).list();
        Mockito.verifyNoMoreInteractions((Object[])new Object[]{this.historicProcessInstanceReport});
    }

    @Test
    public void testSortOrderParameterOnly() {
        RestAssured.given().queryParam("sortOrder", new Object[]{"asc"}).then().expect().statusCode(Response.Status.BAD_REQUEST.getStatusCode()).contentType(ContentType.JSON).body("type", CoreMatchers.equalTo((Object)InvalidRequestException.class.getSimpleName()), new Object[0]).body("message", Matchers.containsString((String)"Only a single sorting parameter specified. sortBy and sortOrder required"), new Object[0]).when().get(HISTORIC_REPORT_URL, new Object[0]);
    }

    @Test
    public void testInvalidSortingOptions() {
        this.executeAndVerifySorting("anInvalidSortByOption", "asc", Response.Status.BAD_REQUEST);
        this.executeAndVerifySorting("finished", "anInvalidSortOrderOption", Response.Status.BAD_REQUEST);
    }

    protected void executeAndVerifySorting(String sortBy, String sortOrder, Response.Status expectedStatus) {
        RestAssured.given().queryParam("sortBy", new Object[]{sortBy}).queryParam("sortOrder", new Object[]{sortOrder}).then().expect().statusCode(expectedStatus.getStatusCode()).when().get(HISTORIC_REPORT_URL, new Object[0]);
    }

    protected Map<String, Object> getCompleteQueryParameters() {
        HashMap<String, Object> parameters = new HashMap<String, Object>();
        parameters.put("processDefinitionIdIn", "aProcessDefinitionId,anotherDefId");
        parameters.put("processDefinitionKeyIn", "aKey,anotherDefKey");
        parameters.put("tenantIdIn", "aTenantId,anotherTenantId");
        parameters.put("withoutTenantId", true);
        parameters.put("compact", true);
        return parameters;
    }

    protected void verifyQueryParameterInvocations() {
        ((CleanableHistoricProcessInstanceReport)Mockito.verify((Object)this.historicProcessInstanceReport)).processDefinitionIdIn(new String[]{"aProcessDefinitionId", ANOTHER_EXAMPLE_PROCESS_DEFINITION_ID});
        ((CleanableHistoricProcessInstanceReport)Mockito.verify((Object)this.historicProcessInstanceReport)).processDefinitionKeyIn(new String[]{EXAMPLE_PD_KEY, ANOTHER_EXAMPLE_PD_KEY});
        ((CleanableHistoricProcessInstanceReport)Mockito.verify((Object)this.historicProcessInstanceReport)).tenantIdIn(new String[]{EXAMPLE_TENANT_ID, ANOTHER_EXAMPLE_TENANT_ID});
        ((CleanableHistoricProcessInstanceReport)Mockito.verify((Object)this.historicProcessInstanceReport)).withoutTenantId();
        ((CleanableHistoricProcessInstanceReport)Mockito.verify((Object)this.historicProcessInstanceReport)).compact();
    }
}

