/*
 * Decompiled with CFR 0.152.
 */
package org.eximeebpms.bpm.engine.rest.history;

import io.restassured.RestAssured;
import io.restassured.http.ContentType;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.ws.rs.core.Response;
import org.eximeebpms.bpm.engine.AuthorizationException;
import org.eximeebpms.bpm.engine.history.DurationReportResult;
import org.eximeebpms.bpm.engine.history.HistoricTaskInstanceReport;
import org.eximeebpms.bpm.engine.history.HistoricTaskInstanceReportResult;
import org.eximeebpms.bpm.engine.impl.calendar.DateTimeUtil;
import org.eximeebpms.bpm.engine.query.PeriodUnit;
import org.eximeebpms.bpm.engine.rest.AbstractRestServiceTest;
import org.eximeebpms.bpm.engine.rest.exception.InvalidRequestException;
import org.eximeebpms.bpm.engine.rest.helper.MockProvider;
import org.eximeebpms.bpm.engine.rest.util.container.TestContainerRule;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matchers;
import org.junit.Before;
import org.junit.ClassRule;
import org.junit.Test;
import org.mockito.Mockito;

public class HistoricTaskReportRestServiceTest
extends AbstractRestServiceTest {
    @ClassRule
    public static TestContainerRule rule = new TestContainerRule();
    protected static final String TASK_REPORT_URL = "/rest-test/history/task/report";
    protected HistoricTaskInstanceReport mockedReportQuery;

    @Before
    public void setUpRuntimeData() {
        this.mockedReportQuery = this.setUpMockReportQuery();
    }

    private HistoricTaskInstanceReport setUpMockReportQuery() {
        HistoricTaskInstanceReport mockedReportQuery = (HistoricTaskInstanceReport)Mockito.mock(HistoricTaskInstanceReport.class);
        List<HistoricTaskInstanceReportResult> taskReportResults = MockProvider.createMockHistoricTaskInstanceReport();
        List<HistoricTaskInstanceReportResult> taskReportResultsWithProcDef = MockProvider.createMockHistoricTaskInstanceReportWithProcDef();
        Mockito.when((Object)mockedReportQuery.completedAfter((Date)Mockito.any(Date.class))).thenReturn((Object)mockedReportQuery);
        Mockito.when((Object)mockedReportQuery.completedBefore((Date)Mockito.any(Date.class))).thenReturn((Object)mockedReportQuery);
        Mockito.when((Object)mockedReportQuery.countByTaskName()).thenReturn(taskReportResults);
        Mockito.when((Object)mockedReportQuery.countByProcessDefinitionKey()).thenReturn(taskReportResultsWithProcDef);
        List<DurationReportResult> durationReportByMonth = MockProvider.createMockHistoricTaskInstanceDurationReport(PeriodUnit.MONTH);
        Mockito.when((Object)mockedReportQuery.duration(PeriodUnit.MONTH)).thenReturn(durationReportByMonth);
        List<DurationReportResult> durationReportByQuarter = MockProvider.createMockHistoricTaskInstanceDurationReport(PeriodUnit.QUARTER);
        Mockito.when((Object)mockedReportQuery.duration(PeriodUnit.QUARTER)).thenReturn(durationReportByQuarter);
        Mockito.when((Object)processEngine.getHistoryService().createHistoricTaskInstanceReport()).thenReturn((Object)mockedReportQuery);
        return mockedReportQuery;
    }

    @Test
    public void testTaskCountMissingAuthorization() {
        String message = "not authorized";
        Mockito.when((Object)this.mockedReportQuery.countByTaskName()).thenThrow(new Throwable[]{new AuthorizationException(message)});
        RestAssured.given().queryParam("reportType", new Object[]{"count"}).queryParam("groupBy", new Object[]{"taskName"}).then().expect().statusCode(Response.Status.FORBIDDEN.getStatusCode()).contentType(ContentType.JSON).body("type", CoreMatchers.equalTo((Object)AuthorizationException.class.getSimpleName()), new Object[0]).body("message", CoreMatchers.equalTo((Object)message), new Object[0]).when().get(TASK_REPORT_URL, new Object[0]);
    }

    @Test
    public void testTaskCountByProcDefMissingAuthorization() {
        String message = "not authorized";
        Mockito.when((Object)this.mockedReportQuery.countByProcessDefinitionKey()).thenThrow(new Throwable[]{new AuthorizationException(message)});
        RestAssured.given().queryParam("reportType", new Object[]{"count"}).queryParam("groupBy", new Object[]{"processDefinition"}).then().expect().statusCode(Response.Status.FORBIDDEN.getStatusCode()).contentType(ContentType.JSON).body("type", CoreMatchers.equalTo((Object)AuthorizationException.class.getSimpleName()), new Object[0]).body("message", CoreMatchers.equalTo((Object)message), new Object[0]).when().get(TASK_REPORT_URL, new Object[0]);
    }

    @Test
    public void testTaskCountReport() {
        RestAssured.given().queryParam("reportType", new Object[]{"count"}).queryParam("groupBy", new Object[]{"taskName"}).then().expect().statusCode(Response.Status.OK.getStatusCode()).contentType(ContentType.JSON).body("[0].count", CoreMatchers.equalTo((Object)MockProvider.EXAMPLE_HISTORIC_TASK_REPORT_COUNT.intValue()), new Object[0]).body("[0].processDefinitionId", CoreMatchers.equalTo((Object)"aProcessDefinitionId:1:1"), new Object[0]).body("[0].processDefinitionName", CoreMatchers.equalTo((Object)"aProcessDefinitionName"), new Object[0]).body("[0].processDefinitionKey", CoreMatchers.equalTo((Object)"aProcessDefinition"), new Object[0]).body("[0].taskName", CoreMatchers.equalTo((Object)"aTaskName"), new Object[0]).body("[0].tenantId", CoreMatchers.equalTo((Object)"aTenantId"), new Object[0]).when().get(TASK_REPORT_URL, new Object[0]);
        ((HistoricTaskInstanceReport)Mockito.verify((Object)this.mockedReportQuery)).countByTaskName();
        Mockito.verifyNoMoreInteractions((Object[])new Object[]{this.mockedReportQuery});
    }

    @Test
    public void testTaskCountReportWithCompletedBefore() {
        RestAssured.given().queryParam("reportType", new Object[]{"count"}).queryParam("groupBy", new Object[]{"taskName"}).queryParam("completedBefore", new Object[]{MockProvider.EXAMPLE_HISTORIC_TASK_END_TIME}).then().expect().statusCode(Response.Status.OK.getStatusCode()).contentType(ContentType.JSON).when().get(TASK_REPORT_URL, new Object[0]);
        ((HistoricTaskInstanceReport)Mockito.verify((Object)this.mockedReportQuery)).completedBefore((Date)Mockito.any(Date.class));
        ((HistoricTaskInstanceReport)Mockito.verify((Object)this.mockedReportQuery)).countByTaskName();
        Mockito.verifyNoMoreInteractions((Object[])new Object[]{this.mockedReportQuery});
    }

    @Test
    public void testTaskCountReportWithCompletedAfter() {
        RestAssured.given().queryParam("reportType", new Object[]{"count"}).queryParam("groupBy", new Object[]{"taskName"}).queryParam("completedAfter", new Object[]{MockProvider.EXAMPLE_HISTORIC_TASK_START_TIME}).then().expect().statusCode(Response.Status.OK.getStatusCode()).contentType(ContentType.JSON).when().get(TASK_REPORT_URL, new Object[0]);
        ((HistoricTaskInstanceReport)Mockito.verify((Object)this.mockedReportQuery)).completedAfter((Date)Mockito.any(Date.class));
        ((HistoricTaskInstanceReport)Mockito.verify((Object)this.mockedReportQuery)).countByTaskName();
        Mockito.verifyNoMoreInteractions((Object[])new Object[]{this.mockedReportQuery});
    }

    @Test
    public void testTaskCountByProcDefReportWithCompletedBefore() {
        RestAssured.given().queryParam("reportType", new Object[]{"count"}).queryParam("completedBefore", new Object[]{MockProvider.EXAMPLE_HISTORIC_TASK_END_TIME}).queryParam("groupBy", new Object[]{"processDefinition"}).then().expect().statusCode(Response.Status.OK.getStatusCode()).contentType(ContentType.JSON).when().get(TASK_REPORT_URL, new Object[0]);
        ((HistoricTaskInstanceReport)Mockito.verify((Object)this.mockedReportQuery)).completedBefore((Date)Mockito.any(Date.class));
        ((HistoricTaskInstanceReport)Mockito.verify((Object)this.mockedReportQuery)).countByProcessDefinitionKey();
        Mockito.verifyNoMoreInteractions((Object[])new Object[]{this.mockedReportQuery});
    }

    @Test
    public void testTaskCountByProcDefReportWithCompletedAfter() {
        RestAssured.given().queryParam("reportType", new Object[]{"count"}).queryParam("completedAfter", new Object[]{MockProvider.EXAMPLE_HISTORIC_TASK_START_TIME}).queryParam("groupBy", new Object[]{"processDefinition"}).then().expect().statusCode(Response.Status.OK.getStatusCode()).contentType(ContentType.JSON).when().get(TASK_REPORT_URL, new Object[0]);
        ((HistoricTaskInstanceReport)Mockito.verify((Object)this.mockedReportQuery)).completedAfter((Date)Mockito.any(Date.class));
        ((HistoricTaskInstanceReport)Mockito.verify((Object)this.mockedReportQuery)).countByProcessDefinitionKey();
        Mockito.verifyNoMoreInteractions((Object[])new Object[]{this.mockedReportQuery});
    }

    @Test
    public void testTaskCountReportWithGroupByProcDef() {
        RestAssured.given().queryParam("reportType", new Object[]{"count"}).queryParam("groupBy", new Object[]{"processDefinition"}).then().expect().statusCode(Response.Status.OK.getStatusCode()).contentType(ContentType.JSON).when().get(TASK_REPORT_URL, new Object[0]);
        ((HistoricTaskInstanceReport)Mockito.verify((Object)this.mockedReportQuery)).countByProcessDefinitionKey();
        Mockito.verifyNoMoreInteractions((Object[])new Object[]{this.mockedReportQuery});
    }

    @Test
    public void testTaskCountReportWithGroupByTaskDef() {
        RestAssured.given().queryParam("reportType", new Object[]{"count"}).queryParam("groupBy", new Object[]{"taskName"}).then().expect().statusCode(Response.Status.OK.getStatusCode()).contentType(ContentType.JSON).when().get(TASK_REPORT_URL, new Object[0]);
        ((HistoricTaskInstanceReport)Mockito.verify((Object)this.mockedReportQuery)).countByTaskName();
        Mockito.verifyNoMoreInteractions((Object[])new Object[]{this.mockedReportQuery});
    }

    @Test
    public void testTaskCountReportWithGroupByAnyDef() {
        RestAssured.given().queryParam("reportType", new Object[]{"count"}).queryParam("groupBy", new Object[]{"anotherDefinition"}).then().expect().statusCode(Response.Status.BAD_REQUEST.getStatusCode()).body("type", CoreMatchers.equalTo((Object)InvalidRequestException.class.getSimpleName()), new Object[0]).body("message", Matchers.containsString((String)"groupBy parameter has invalid value: anotherDefinition"), new Object[0]).when().get(TASK_REPORT_URL, new Object[0]);
    }

    @Test
    public void testTaskCountWithAllParameters() {
        RestAssured.given().queryParam("reportType", new Object[]{"count"}).queryParam("groupBy", new Object[]{"processDefinition"}).queryParam("completedBefore", new Object[]{MockProvider.EXAMPLE_HISTORIC_TASK_INST_END_TIME}).queryParam("completedAfter", new Object[]{MockProvider.EXAMPLE_HISTORIC_TASK_INST_START_TIME}).then().expect().statusCode(Response.Status.OK.getStatusCode()).contentType(ContentType.JSON).body("[0].count", CoreMatchers.equalTo((Object)MockProvider.EXAMPLE_HISTORIC_TASK_REPORT_COUNT.intValue()), new Object[0]).body("[0].processDefinitionId", CoreMatchers.equalTo((Object)"aProcessDefinitionId:1:1"), new Object[0]).body("[0].processDefinitionName", CoreMatchers.equalTo((Object)"aProcessDefinitionName"), new Object[0]).body("[0].processDefinitionKey", CoreMatchers.equalTo((Object)"aProcessDefinition"), new Object[0]).body("[0].taskName", CoreMatchers.equalTo(null), new Object[0]).body("[0].tenantId", CoreMatchers.equalTo((Object)"aTenantId"), new Object[0]).when().get(TASK_REPORT_URL, new Object[0]);
        this.verifyStringStartParameterQueryInvocations();
        ((HistoricTaskInstanceReport)Mockito.verify((Object)this.mockedReportQuery)).countByProcessDefinitionKey();
        Mockito.verifyNoMoreInteractions((Object[])new Object[]{this.mockedReportQuery});
    }

    @Test
    public void testTaskCountWithAllParametersGroupByTask() {
        RestAssured.given().queryParam("reportType", new Object[]{"count"}).queryParam("groupBy", new Object[]{"taskName"}).queryParam("completedBefore", new Object[]{MockProvider.EXAMPLE_HISTORIC_TASK_INST_END_TIME}).queryParam("completedAfter", new Object[]{MockProvider.EXAMPLE_HISTORIC_TASK_INST_START_TIME}).then().expect().statusCode(Response.Status.OK.getStatusCode()).contentType(ContentType.JSON).body("[0].count", CoreMatchers.equalTo((Object)MockProvider.EXAMPLE_HISTORIC_TASK_REPORT_COUNT.intValue()), new Object[0]).body("[0].processDefinitionId", CoreMatchers.equalTo((Object)"aProcessDefinitionId:1:1"), new Object[0]).body("[0].processDefinitionName", CoreMatchers.equalTo((Object)"aProcessDefinitionName"), new Object[0]).body("[0].processDefinitionKey", CoreMatchers.equalTo((Object)"aProcessDefinition"), new Object[0]).body("[0].taskName", CoreMatchers.equalTo((Object)"aTaskName"), new Object[0]).body("[0].tenantId", CoreMatchers.equalTo((Object)"aTenantId"), new Object[0]).when().get(TASK_REPORT_URL, new Object[0]);
        this.verifyStringStartParameterQueryInvocations();
        ((HistoricTaskInstanceReport)Mockito.verify((Object)this.mockedReportQuery)).countByTaskName();
        Mockito.verifyNoMoreInteractions((Object[])new Object[]{this.mockedReportQuery});
    }

    @Test
    public void testTaskDurationMonthMissingAuthorization() {
        String message = "not authorized";
        Mockito.when((Object)this.mockedReportQuery.duration(PeriodUnit.MONTH)).thenThrow(new Throwable[]{new AuthorizationException(message)});
        RestAssured.given().queryParam("reportType", new Object[]{"duration"}).queryParam("periodUnit", new Object[]{"month"}).then().expect().statusCode(Response.Status.FORBIDDEN.getStatusCode()).contentType(ContentType.JSON).body("type", CoreMatchers.equalTo((Object)AuthorizationException.class.getSimpleName()), new Object[0]).body("message", CoreMatchers.equalTo((Object)message), new Object[0]).when().get(TASK_REPORT_URL, new Object[0]);
    }

    @Test
    public void testTaskDurationQuarterMissingAuthorization() {
        String message = "not authorized";
        Mockito.when((Object)this.mockedReportQuery.duration(PeriodUnit.QUARTER)).thenThrow(new Throwable[]{new AuthorizationException(message)});
        RestAssured.given().queryParam("reportType", new Object[]{"duration"}).queryParam("periodUnit", new Object[]{"quarter"}).then().expect().statusCode(Response.Status.FORBIDDEN.getStatusCode()).contentType(ContentType.JSON).body("type", CoreMatchers.equalTo((Object)AuthorizationException.class.getSimpleName()), new Object[0]).body("message", CoreMatchers.equalTo((Object)message), new Object[0]).when().get(TASK_REPORT_URL, new Object[0]);
    }

    @Test
    public void testWrongReportType() {
        RestAssured.given().queryParam("reportType", new Object[]{"abc"}).then().expect().statusCode(Response.Status.BAD_REQUEST.getStatusCode()).body("type", CoreMatchers.equalTo((Object)InvalidRequestException.class.getSimpleName()), new Object[0]).body("message", Matchers.containsString((String)"Cannot set query parameter 'reportType' to value 'abc'"), new Object[0]).when().get(TASK_REPORT_URL, new Object[0]);
    }

    @Test
    public void testTaskDurationReportWithoutDurationParam() {
        RestAssured.given().queryParam("periodUnit", new Object[]{"month"}).then().expect().statusCode(Response.Status.BAD_REQUEST.getStatusCode()).body("type", CoreMatchers.equalTo((Object)InvalidRequestException.class.getSimpleName()), new Object[0]).body("message", Matchers.containsString((String)"Parameter reportType is not set."), new Object[0]).when().get(TASK_REPORT_URL, new Object[0]);
    }

    @Test
    public void testTaskDurationQuarterReportWithoutDurationParam() {
        RestAssured.given().queryParam("periodUnit", new Object[]{"quarter"}).then().expect().statusCode(Response.Status.BAD_REQUEST.getStatusCode()).body("type", CoreMatchers.equalTo((Object)InvalidRequestException.class.getSimpleName()), new Object[0]).body("message", Matchers.containsString((String)"Parameter reportType is not set."), new Object[0]).when().get(TASK_REPORT_URL, new Object[0]);
    }

    @Test
    public void testTaskDurationReportWithInvalidPeriodUnit() {
        RestAssured.given().queryParam("periodUnit", new Object[]{"abc"}).then().expect().statusCode(Response.Status.BAD_REQUEST.getStatusCode()).contentType(ContentType.JSON).body("type", CoreMatchers.equalTo((Object)InvalidRequestException.class.getSimpleName()), new Object[0]).body("message", Matchers.containsString((String)"Cannot set query parameter 'periodUnit' to value 'abc'"), new Object[0]).when().get(TASK_REPORT_URL, new Object[0]);
    }

    @Test
    public void testTaskDurationReportWithMissingPeriodUnit() {
        RestAssured.given().queryParam("reportType", new Object[]{"duration"}).then().expect().statusCode(Response.Status.BAD_REQUEST.getStatusCode()).contentType(ContentType.JSON).body("type", CoreMatchers.equalTo((Object)InvalidRequestException.class.getSimpleName()), new Object[0]).body("message", Matchers.containsString((String)"periodUnit is null"), new Object[0]).when().get(TASK_REPORT_URL, new Object[0]);
    }

    @Test
    public void testTaskDurationReportByMonth() {
        RestAssured.given().queryParam("periodUnit", new Object[]{"month"}).queryParam("reportType", new Object[]{"duration"}).then().expect().statusCode(Response.Status.OK.getStatusCode()).contentType(ContentType.JSON).body("[0].average", CoreMatchers.equalTo((Object)10), new Object[0]).body("[0].maximum", CoreMatchers.equalTo((Object)15), new Object[0]).body("[0].minimum", CoreMatchers.equalTo((Object)5), new Object[0]).body("[0].period", CoreMatchers.equalTo((Object)1), new Object[0]).body("[0].periodUnit", CoreMatchers.equalTo((Object)PeriodUnit.MONTH.toString()), new Object[0]).when().get(TASK_REPORT_URL, new Object[0]);
        ((HistoricTaskInstanceReport)Mockito.verify((Object)this.mockedReportQuery)).duration(PeriodUnit.MONTH);
        Mockito.verifyNoMoreInteractions((Object[])new Object[]{this.mockedReportQuery});
    }

    @Test
    public void testTaskDurationReportByQuarter() {
        RestAssured.given().queryParam("periodUnit", new Object[]{"quarter"}).queryParam("reportType", new Object[]{"duration"}).then().expect().statusCode(Response.Status.OK.getStatusCode()).contentType(ContentType.JSON).body("[0].average", CoreMatchers.equalTo((Object)10), new Object[0]).body("[0].maximum", CoreMatchers.equalTo((Object)15), new Object[0]).body("[0].minimum", CoreMatchers.equalTo((Object)5), new Object[0]).body("[0].period", CoreMatchers.equalTo((Object)1), new Object[0]).body("[0].periodUnit", CoreMatchers.equalTo((Object)PeriodUnit.QUARTER.toString()), new Object[0]).when().get(TASK_REPORT_URL, new Object[0]);
        ((HistoricTaskInstanceReport)Mockito.verify((Object)this.mockedReportQuery)).duration(PeriodUnit.QUARTER);
        Mockito.verifyNoMoreInteractions((Object[])new Object[]{this.mockedReportQuery});
    }

    @Test
    public void testTaskDurationReportWithCompletedBeforeAndCompletedAfter() {
        RestAssured.given().queryParam("periodUnit", new Object[]{"month"}).queryParam("reportType", new Object[]{"duration"}).queryParam("completedBefore", new Object[]{MockProvider.EXAMPLE_HISTORIC_TASK_INST_START_TIME}).queryParam("completedAfter", new Object[]{MockProvider.EXAMPLE_HISTORIC_TASK_INST_END_TIME}).then().expect().statusCode(Response.Status.OK.getStatusCode()).contentType(ContentType.JSON).when().get(TASK_REPORT_URL, new Object[0]);
        this.verifyStringStartParameterQueryInvocations();
        ((HistoricTaskInstanceReport)Mockito.verify((Object)this.mockedReportQuery)).duration(PeriodUnit.MONTH);
        Mockito.verifyNoMoreInteractions((Object[])new Object[]{this.mockedReportQuery});
    }

    @Test
    public void testTaskDurationReportWithCompletedBefore() {
        RestAssured.given().queryParam("periodUnit", new Object[]{"month"}).queryParam("reportType", new Object[]{"duration"}).queryParam("completedBefore", new Object[]{MockProvider.EXAMPLE_HISTORIC_TASK_END_TIME}).then().expect().statusCode(Response.Status.OK.getStatusCode()).contentType(ContentType.JSON).when().get(TASK_REPORT_URL, new Object[0]);
        ((HistoricTaskInstanceReport)Mockito.verify((Object)this.mockedReportQuery)).completedBefore((Date)Mockito.any(Date.class));
        ((HistoricTaskInstanceReport)Mockito.verify((Object)this.mockedReportQuery)).duration(PeriodUnit.MONTH);
        Mockito.verifyNoMoreInteractions((Object[])new Object[]{this.mockedReportQuery});
    }

    @Test
    public void testTaskDurationReportWithCompletedAfter() {
        RestAssured.given().queryParam("periodUnit", new Object[]{"month"}).queryParam("reportType", new Object[]{"duration"}).queryParam("completedAfter", new Object[]{MockProvider.EXAMPLE_HISTORIC_TASK_START_TIME}).then().expect().statusCode(Response.Status.OK.getStatusCode()).contentType(ContentType.JSON).when().get(TASK_REPORT_URL, new Object[0]);
        ((HistoricTaskInstanceReport)Mockito.verify((Object)this.mockedReportQuery)).completedAfter((Date)Mockito.any(Date.class));
        ((HistoricTaskInstanceReport)Mockito.verify((Object)this.mockedReportQuery)).duration(PeriodUnit.MONTH);
        Mockito.verifyNoMoreInteractions((Object[])new Object[]{this.mockedReportQuery});
    }

    @Test
    public void testTaskDurationQuarterReportWithCompletedBeforeAndCompletedAfter() {
        RestAssured.given().queryParam("periodUnit", new Object[]{"quarter"}).queryParam("reportType", new Object[]{"duration"}).queryParam("completedBefore", new Object[]{MockProvider.EXAMPLE_HISTORIC_TASK_INST_START_TIME}).queryParam("completedAfter", new Object[]{MockProvider.EXAMPLE_HISTORIC_TASK_INST_END_TIME}).then().expect().statusCode(Response.Status.OK.getStatusCode()).contentType(ContentType.JSON).when().get(TASK_REPORT_URL, new Object[0]);
        this.verifyStringStartParameterQueryInvocations();
        ((HistoricTaskInstanceReport)Mockito.verify((Object)this.mockedReportQuery)).duration(PeriodUnit.QUARTER);
        Mockito.verifyNoMoreInteractions((Object[])new Object[]{this.mockedReportQuery});
    }

    @Test
    public void testTaskDurationQuarterReportWithCompletedBefore() {
        RestAssured.given().queryParam("periodUnit", new Object[]{"quarter"}).queryParam("reportType", new Object[]{"duration"}).queryParam("completedBefore", new Object[]{MockProvider.EXAMPLE_HISTORIC_TASK_END_TIME}).then().expect().statusCode(Response.Status.OK.getStatusCode()).contentType(ContentType.JSON).when().get(TASK_REPORT_URL, new Object[0]);
        ((HistoricTaskInstanceReport)Mockito.verify((Object)this.mockedReportQuery)).completedBefore((Date)Mockito.any(Date.class));
        ((HistoricTaskInstanceReport)Mockito.verify((Object)this.mockedReportQuery)).duration(PeriodUnit.QUARTER);
        Mockito.verifyNoMoreInteractions((Object[])new Object[]{this.mockedReportQuery});
    }

    @Test
    public void testTaskDurationQuarterReportWithCompletedAfter() {
        RestAssured.given().queryParam("periodUnit", new Object[]{"quarter"}).queryParam("reportType", new Object[]{"duration"}).queryParam("completedAfter", new Object[]{MockProvider.EXAMPLE_HISTORIC_TASK_START_TIME}).then().expect().statusCode(Response.Status.OK.getStatusCode()).contentType(ContentType.JSON).when().get(TASK_REPORT_URL, new Object[0]);
        ((HistoricTaskInstanceReport)Mockito.verify((Object)this.mockedReportQuery)).completedAfter((Date)Mockito.any(Date.class));
        ((HistoricTaskInstanceReport)Mockito.verify((Object)this.mockedReportQuery)).duration(PeriodUnit.QUARTER);
        Mockito.verifyNoMoreInteractions((Object[])new Object[]{this.mockedReportQuery});
    }

    private Map<String, String> getCompleteStartDateAsStringQueryParameters() {
        HashMap<String, String> parameters = new HashMap<String, String>();
        parameters.put("completedBefore", MockProvider.EXAMPLE_HISTORIC_TASK_INST_START_TIME);
        parameters.put("completedAfter", MockProvider.EXAMPLE_HISTORIC_TASK_INST_END_TIME);
        return parameters;
    }

    private void verifyStringStartParameterQueryInvocations() {
        Map<String, String> startDateParameters = this.getCompleteStartDateAsStringQueryParameters();
        ((HistoricTaskInstanceReport)Mockito.verify((Object)this.mockedReportQuery)).completedBefore(DateTimeUtil.parseDate((String)startDateParameters.get("completedBefore")));
        ((HistoricTaskInstanceReport)Mockito.verify((Object)this.mockedReportQuery)).completedAfter(DateTimeUtil.parseDate((String)startDateParameters.get("completedAfter")));
    }
}

