/*
 * Decompiled with CFR 0.152.
 */
package org.eximeebpms.bpm.engine.rest.history;

import io.restassured.RestAssured;
import io.restassured.http.ContentType;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;
import java.util.List;
import javax.ws.rs.core.Response;
import org.eximeebpms.bpm.engine.HistoryService;
import org.eximeebpms.bpm.engine.impl.cfg.ProcessEngineConfigurationImpl;
import org.eximeebpms.bpm.engine.impl.jobexecutor.historycleanup.BatchWindowManager;
import org.eximeebpms.bpm.engine.impl.jobexecutor.historycleanup.DefaultBatchWindowManager;
import org.eximeebpms.bpm.engine.impl.jobexecutor.historycleanup.HistoryCleanupHelper;
import org.eximeebpms.bpm.engine.impl.util.ClockUtil;
import org.eximeebpms.bpm.engine.rest.AbstractRestServiceTest;
import org.eximeebpms.bpm.engine.rest.helper.MockProvider;
import org.eximeebpms.bpm.engine.rest.mapper.JacksonConfigurator;
import org.eximeebpms.bpm.engine.rest.util.DateTimeUtils;
import org.eximeebpms.bpm.engine.rest.util.container.TestContainerRule;
import org.eximeebpms.bpm.engine.runtime.Job;
import org.hamcrest.CoreMatchers;
import org.junit.Before;
import org.junit.ClassRule;
import org.junit.Test;
import org.mockito.Mockito;

public class HistoryCleanupRestServiceInteractionTest
extends AbstractRestServiceTest {
    @ClassRule
    public static TestContainerRule rule = new TestContainerRule();
    protected static final String HISTORY_CLEANUP_URL = "/rest-test/history/cleanup";
    protected static final String FIND_HISTORY_CLEANUP_JOB_URL = "/rest-test/history/cleanup/job";
    protected static final String FIND_HISTORY_CLEANUP_JOBS_URL = "/rest-test/history/cleanup/jobs";
    protected static final String CONFIGURATION_URL = "/rest-test/history/cleanup/configuration";
    private HistoryService historyServiceMock;

    @Before
    public void setUpRuntimeData() {
        this.historyServiceMock = (HistoryService)Mockito.mock(HistoryService.class);
        Job mockJob = MockProvider.createMockJob();
        List<Job> mockJobs = MockProvider.createMockJobs();
        Mockito.when((Object)this.historyServiceMock.cleanUpHistoryAsync(Mockito.anyBoolean())).thenReturn((Object)mockJob);
        Mockito.when((Object)this.historyServiceMock.findHistoryCleanupJob()).thenReturn((Object)mockJob);
        Mockito.when((Object)this.historyServiceMock.findHistoryCleanupJobs()).thenReturn(mockJobs);
        Mockito.when((Object)processEngine.getHistoryService()).thenReturn((Object)this.historyServiceMock);
    }

    @Test
    public void testFindHistoryCleanupJob() {
        RestAssured.given().contentType(ContentType.JSON).then().expect().statusCode(Response.Status.OK.getStatusCode()).when().get(FIND_HISTORY_CLEANUP_JOB_URL, new Object[0]);
        ((HistoryService)Mockito.verify((Object)this.historyServiceMock)).findHistoryCleanupJob();
    }

    @Test
    public void testFindNoHistoryCleanupJob() {
        Mockito.when((Object)this.historyServiceMock.findHistoryCleanupJob()).thenReturn(null);
        RestAssured.given().contentType(ContentType.JSON).then().expect().statusCode(Response.Status.NOT_FOUND.getStatusCode()).when().get(FIND_HISTORY_CLEANUP_JOB_URL, new Object[0]);
        ((HistoryService)Mockito.verify((Object)this.historyServiceMock)).findHistoryCleanupJob();
    }

    @Test
    public void testFindHistoryCleanupJobs() {
        RestAssured.given().contentType(ContentType.JSON).then().expect().statusCode(Response.Status.OK.getStatusCode()).when().get(FIND_HISTORY_CLEANUP_JOBS_URL, new Object[0]);
        ((HistoryService)Mockito.verify((Object)this.historyServiceMock)).findHistoryCleanupJobs();
    }

    @Test
    public void testFindNoHistoryCleanupJobs() {
        Mockito.when((Object)this.historyServiceMock.findHistoryCleanupJobs()).thenReturn(null);
        RestAssured.given().contentType(ContentType.JSON).then().expect().statusCode(Response.Status.NOT_FOUND.getStatusCode()).when().get(FIND_HISTORY_CLEANUP_JOBS_URL, new Object[0]);
        ((HistoryService)Mockito.verify((Object)this.historyServiceMock)).findHistoryCleanupJobs();
    }

    @Test
    public void testHistoryCleanupImmediatelyDueDefault() {
        RestAssured.given().contentType(ContentType.JSON).then().expect().statusCode(Response.Status.OK.getStatusCode()).when().post(HISTORY_CLEANUP_URL, new Object[0]);
        ((HistoryService)Mockito.verify((Object)this.historyServiceMock)).cleanUpHistoryAsync(true);
    }

    @Test
    public void testHistoryCleanupImmediatelyDue() {
        RestAssured.given().contentType(ContentType.JSON).queryParam("immediatelyDue", new Object[]{true}).then().expect().statusCode(Response.Status.OK.getStatusCode()).when().post(HISTORY_CLEANUP_URL, new Object[0]);
        ((HistoryService)Mockito.verify((Object)this.historyServiceMock)).cleanUpHistoryAsync(true);
    }

    @Test
    public void testHistoryCleanup() {
        RestAssured.given().contentType(ContentType.JSON).queryParam("immediatelyDue", new Object[]{false}).then().expect().statusCode(Response.Status.OK.getStatusCode()).when().post(HISTORY_CLEANUP_URL, new Object[0]);
        ((HistoryService)Mockito.verify((Object)this.historyServiceMock)).cleanUpHistoryAsync(false);
    }

    @Test
    public void testHistoryConfigurationOutsideBatchWindow() throws ParseException {
        ProcessEngineConfigurationImpl processEngineConfigurationImplMock = (ProcessEngineConfigurationImpl)Mockito.mock(ProcessEngineConfigurationImpl.class);
        Date startDate = HistoryCleanupHelper.parseTimeConfiguration((String)"23:59");
        Date endDate = HistoryCleanupHelper.parseTimeConfiguration((String)"00:00");
        Mockito.when((Object)processEngine.getProcessEngineConfiguration()).thenReturn((Object)processEngineConfigurationImplMock);
        Mockito.when((Object)processEngineConfigurationImplMock.getHistoryCleanupBatchWindowStartTime()).thenReturn((Object)"23:59");
        Mockito.when((Object)processEngineConfigurationImplMock.getHistoryCleanupBatchWindowEndTime()).thenReturn((Object)"00:00");
        Mockito.when((Object)processEngineConfigurationImplMock.getBatchWindowManager()).thenReturn((Object)new DefaultBatchWindowManager());
        Mockito.when((Object)processEngineConfigurationImplMock.isHistoryCleanupEnabled()).thenReturn((Object)true);
        SimpleDateFormat sdf = new SimpleDateFormat(JacksonConfigurator.dateFormatString);
        Date now = sdf.parse("2017-09-01T22:00:00.000+0000");
        ClockUtil.setCurrentTime((Date)now);
        Calendar today = Calendar.getInstance();
        today.setTime(now);
        Calendar tomorrow = Calendar.getInstance();
        tomorrow.setTime(DateTimeUtils.addDays(now, 1));
        Date dateToday = DateTimeUtils.updateTime(today.getTime(), startDate);
        Date dateTomorrow = DateTimeUtils.updateTime(tomorrow.getTime(), endDate);
        RestAssured.given().contentType(ContentType.JSON).then().expect().statusCode(Response.Status.OK.getStatusCode()).body("batchWindowStartTime", CoreMatchers.containsString((String)sdf.format(dateToday)), new Object[0]).body("batchWindowEndTime", CoreMatchers.containsString((String)sdf.format(dateTomorrow)), new Object[0]).body("enabled", CoreMatchers.equalTo((Object)true), new Object[0]).when().get(CONFIGURATION_URL, new Object[0]);
    }

    @Test
    public void testHistoryConfigurationWithinBatchWindow() throws ParseException {
        ProcessEngineConfigurationImpl processEngineConfigurationImplMock = (ProcessEngineConfigurationImpl)Mockito.mock(ProcessEngineConfigurationImpl.class);
        Date startDate = HistoryCleanupHelper.parseTimeConfiguration((String)"22:00+0200");
        Date endDate = HistoryCleanupHelper.parseTimeConfiguration((String)"23:00+0200");
        Mockito.when((Object)processEngine.getProcessEngineConfiguration()).thenReturn((Object)processEngineConfigurationImplMock);
        Mockito.when((Object)processEngineConfigurationImplMock.getHistoryCleanupBatchWindowStartTime()).thenReturn((Object)"22:00+0200");
        Mockito.when((Object)processEngineConfigurationImplMock.getHistoryCleanupBatchWindowEndTime()).thenReturn((Object)"23:00+0200");
        Mockito.when((Object)processEngineConfigurationImplMock.getBatchWindowManager()).thenReturn((Object)new DefaultBatchWindowManager());
        Mockito.when((Object)processEngineConfigurationImplMock.isHistoryCleanupEnabled()).thenReturn((Object)true);
        SimpleDateFormat sdf = new SimpleDateFormat(JacksonConfigurator.dateFormatString);
        Date now = sdf.parse("2017-09-01T22:00:00.000+0200");
        ClockUtil.setCurrentTime((Date)now);
        Calendar today = Calendar.getInstance();
        today.setTime(now);
        Date dateToday = DateTimeUtils.updateTime(today.getTime(), startDate);
        Date dateTomorrow = DateTimeUtils.updateTime(today.getTime(), endDate);
        RestAssured.given().contentType(ContentType.JSON).then().expect().statusCode(Response.Status.OK.getStatusCode()).body("batchWindowStartTime", CoreMatchers.containsString((String)sdf.format(dateToday)), new Object[0]).body("batchWindowEndTime", CoreMatchers.containsString((String)sdf.format(dateTomorrow)), new Object[0]).body("enabled", CoreMatchers.equalTo((Object)true), new Object[0]).when().get(CONFIGURATION_URL, new Object[0]);
    }

    @Test
    public void testHistoryConfigurationWhenBatchNotDefined() {
        ProcessEngineConfigurationImpl processEngineConfigurationImplMock = (ProcessEngineConfigurationImpl)Mockito.mock(ProcessEngineConfigurationImpl.class);
        Mockito.when((Object)processEngine.getProcessEngineConfiguration()).thenReturn((Object)processEngineConfigurationImplMock);
        Mockito.when((Object)processEngineConfigurationImplMock.getHistoryCleanupBatchWindowStartTime()).thenReturn(null);
        Mockito.when((Object)processEngineConfigurationImplMock.getHistoryCleanupBatchWindowEndTime()).thenReturn(null);
        Mockito.when((Object)processEngineConfigurationImplMock.isHistoryCleanupEnabled()).thenReturn((Object)true);
        Mockito.when((Object)processEngineConfigurationImplMock.getBatchWindowManager()).thenReturn((Object)new DefaultBatchWindowManager());
        RestAssured.given().contentType(ContentType.JSON).then().expect().statusCode(Response.Status.OK.getStatusCode()).body("batchWindowStartTime", CoreMatchers.equalTo(null), new Object[0]).body("batchWindowEndTime", CoreMatchers.equalTo(null), new Object[0]).body("enabled", CoreMatchers.equalTo((Object)true), new Object[0]).when().get(CONFIGURATION_URL, new Object[0]);
    }

    @Test
    public void shouldReturnEnabledFalse() {
        ProcessEngineConfigurationImpl engineConfigMock = (ProcessEngineConfigurationImpl)Mockito.mock(ProcessEngineConfigurationImpl.class);
        Mockito.when((Object)processEngine.getProcessEngineConfiguration()).thenReturn((Object)engineConfigMock);
        BatchWindowManager batchWindowManager = (BatchWindowManager)Mockito.mock(BatchWindowManager.class);
        Mockito.when((Object)engineConfigMock.getBatchWindowManager()).thenReturn((Object)batchWindowManager);
        Mockito.when((Object)engineConfigMock.isHistoryCleanupEnabled()).thenReturn((Object)false);
        RestAssured.given().contentType(ContentType.JSON).then().expect().statusCode(Response.Status.OK.getStatusCode()).body("batchWindowStartTime", CoreMatchers.equalTo(null), new Object[0]).body("batchWindowEndTime", CoreMatchers.equalTo(null), new Object[0]).body("enabled", CoreMatchers.equalTo((Object)false), new Object[0]).when().get(CONFIGURATION_URL, new Object[0]);
    }
}

