/*
 * Decompiled with CFR 0.152.
 */
package org.eximeebpms.bpm.engine.rest.optimize;

import io.restassured.RestAssured;
import java.util.Date;
import javax.ws.rs.core.Response;
import org.eximeebpms.bpm.engine.ProcessEngine;
import org.eximeebpms.bpm.engine.impl.OptimizeService;
import org.eximeebpms.bpm.engine.impl.cfg.ProcessEngineConfigurationImpl;
import org.eximeebpms.bpm.engine.rest.AbstractRestServiceTest;
import org.eximeebpms.bpm.engine.rest.util.DateTimeUtils;
import org.eximeebpms.bpm.engine.rest.util.container.TestContainerRule;
import org.junit.Before;
import org.junit.ClassRule;
import org.junit.Test;
import org.mockito.Mockito;

public class OptimizeDecisionInstanceRestServiceTest
extends AbstractRestServiceTest {
    public static final String OPTIMIZE_DECISION_INSTANCE_PATH = "/rest-test/optimize/decision-instance";
    protected OptimizeService mockedOptimizeService;
    protected ProcessEngine namedProcessEngine;
    @ClassRule
    public static TestContainerRule rule = new TestContainerRule();

    @Before
    public void setUpRuntimeData() {
        this.mockedOptimizeService = (OptimizeService)Mockito.mock(OptimizeService.class);
        ProcessEngineConfigurationImpl mockedConfig = (ProcessEngineConfigurationImpl)Mockito.mock(ProcessEngineConfigurationImpl.class);
        this.namedProcessEngine = this.getProcessEngine("default");
        Mockito.when((Object)this.namedProcessEngine.getProcessEngineConfiguration()).thenReturn((Object)mockedConfig);
        Mockito.when((Object)mockedConfig.getOptimizeService()).thenReturn((Object)this.mockedOptimizeService);
    }

    @Test
    public void testNoQueryParameters() {
        RestAssured.given().then().expect().statusCode(Response.Status.OK.getStatusCode()).contentType("application/json").when().get(OPTIMIZE_DECISION_INSTANCE_PATH, new Object[0]);
        ((OptimizeService)Mockito.verify((Object)this.mockedOptimizeService)).getHistoricDecisionInstances(null, null, Integer.MAX_VALUE);
        Mockito.verifyNoMoreInteractions((Object[])new Object[]{this.mockedOptimizeService});
    }

    @Test
    public void testFinishedAfterQueryParameter() {
        Date now = new Date();
        RestAssured.given().queryParam("evaluatedAfter", new Object[]{DateTimeUtils.DATE_FORMAT_WITH_TIMEZONE.format(now)}).then().expect().statusCode(Response.Status.OK.getStatusCode()).contentType("application/json").when().get(OPTIMIZE_DECISION_INSTANCE_PATH, new Object[0]);
        ((OptimizeService)Mockito.verify((Object)this.mockedOptimizeService)).getHistoricDecisionInstances(now, null, Integer.MAX_VALUE);
        Mockito.verifyNoMoreInteractions((Object[])new Object[]{this.mockedOptimizeService});
    }

    @Test
    public void testFinishedAtQueryParameter() {
        Date now = new Date();
        RestAssured.given().queryParam("evaluatedAt", new Object[]{DateTimeUtils.DATE_FORMAT_WITH_TIMEZONE.format(now)}).then().expect().statusCode(Response.Status.OK.getStatusCode()).contentType("application/json").when().get(OPTIMIZE_DECISION_INSTANCE_PATH, new Object[0]);
        ((OptimizeService)Mockito.verify((Object)this.mockedOptimizeService)).getHistoricDecisionInstances(null, now, Integer.MAX_VALUE);
        Mockito.verifyNoMoreInteractions((Object[])new Object[]{this.mockedOptimizeService});
    }

    @Test
    public void testMaxResultsQueryParameter() {
        RestAssured.given().queryParam("maxResults", new Object[]{10}).then().expect().statusCode(Response.Status.OK.getStatusCode()).contentType("application/json").when().get(OPTIMIZE_DECISION_INSTANCE_PATH, new Object[0]);
        ((OptimizeService)Mockito.verify((Object)this.mockedOptimizeService)).getHistoricDecisionInstances(null, null, 10);
        Mockito.verifyNoMoreInteractions((Object[])new Object[]{this.mockedOptimizeService});
    }

    @Test
    public void testQueryParameterCombination() {
        Date now = new Date();
        RestAssured.given().queryParam("evaluatedAfter", new Object[]{DateTimeUtils.DATE_FORMAT_WITH_TIMEZONE.format(now)}).queryParam("evaluatedAt", new Object[]{DateTimeUtils.DATE_FORMAT_WITH_TIMEZONE.format(now)}).queryParam("maxResults", new Object[]{10}).then().expect().statusCode(Response.Status.OK.getStatusCode()).contentType("application/json").when().get(OPTIMIZE_DECISION_INSTANCE_PATH, new Object[0]);
        ((OptimizeService)Mockito.verify((Object)this.mockedOptimizeService)).getHistoricDecisionInstances(now, now, 10);
        Mockito.verifyNoMoreInteractions((Object[])new Object[]{this.mockedOptimizeService});
    }
}

