/*
 * Decompiled with CFR 0.152.
 */
package org.eximeebpms.bpm.engine.rest.optimize;

import io.restassured.RestAssured;
import io.restassured.path.json.JsonPath;
import io.restassured.response.Response;
import java.util.Collections;
import java.util.Date;
import javax.ws.rs.core.Response;
import org.eximeebpms.bpm.engine.ProcessEngine;
import org.eximeebpms.bpm.engine.impl.OptimizeService;
import org.eximeebpms.bpm.engine.impl.cfg.ProcessEngineConfigurationImpl;
import org.eximeebpms.bpm.engine.impl.persistence.entity.HistoricIncidentEntity;
import org.eximeebpms.bpm.engine.rest.AbstractRestServiceTest;
import org.eximeebpms.bpm.engine.rest.util.DateTimeUtils;
import org.eximeebpms.bpm.engine.rest.util.container.TestContainerRule;
import org.junit.Assert;
import org.junit.Before;
import org.junit.ClassRule;
import org.junit.Test;
import org.mockito.Mockito;

public class OptimizeOpenHistoricIncidentRestServiceTest
extends AbstractRestServiceTest {
    private static final String OPTIMIZE_OPEN_HISTORIC_INCIDENT_PATH = "/rest-test/optimize/incident/open";
    protected OptimizeService mockedOptimizeService;
    protected ProcessEngine namedProcessEngine;
    @ClassRule
    public static TestContainerRule rule = new TestContainerRule();

    @Before
    public void setUpRuntimeData() {
        this.mockedOptimizeService = (OptimizeService)Mockito.mock(OptimizeService.class);
        ProcessEngineConfigurationImpl mockedConfig = (ProcessEngineConfigurationImpl)Mockito.mock(ProcessEngineConfigurationImpl.class);
        this.namedProcessEngine = this.getProcessEngine("default");
        Mockito.when((Object)this.namedProcessEngine.getProcessEngineConfiguration()).thenReturn((Object)mockedConfig);
        Mockito.when((Object)mockedConfig.getOptimizeService()).thenReturn((Object)this.mockedOptimizeService);
    }

    @Test
    public void testNoQueryParameters() {
        RestAssured.given().then().expect().statusCode(Response.Status.OK.getStatusCode()).contentType("application/json").when().get(OPTIMIZE_OPEN_HISTORIC_INCIDENT_PATH, new Object[0]);
        ((OptimizeService)Mockito.verify((Object)this.mockedOptimizeService)).getOpenHistoricIncidents(null, null, Integer.MAX_VALUE);
        Mockito.verifyNoMoreInteractions((Object[])new Object[]{this.mockedOptimizeService});
    }

    @Test
    public void testCreatedAfterQueryParameter() {
        Date now = new Date();
        RestAssured.given().queryParam("createdAfter", new Object[]{DateTimeUtils.DATE_FORMAT_WITH_TIMEZONE.format(now)}).then().expect().statusCode(Response.Status.OK.getStatusCode()).contentType("application/json").when().get(OPTIMIZE_OPEN_HISTORIC_INCIDENT_PATH, new Object[0]);
        ((OptimizeService)Mockito.verify((Object)this.mockedOptimizeService)).getOpenHistoricIncidents(now, null, Integer.MAX_VALUE);
        Mockito.verifyNoMoreInteractions((Object[])new Object[]{this.mockedOptimizeService});
    }

    @Test
    public void testCreatedAtQueryParameter() {
        Date now = new Date();
        RestAssured.given().queryParam("createdAt", new Object[]{DateTimeUtils.DATE_FORMAT_WITH_TIMEZONE.format(now)}).then().expect().statusCode(Response.Status.OK.getStatusCode()).contentType("application/json").when().get(OPTIMIZE_OPEN_HISTORIC_INCIDENT_PATH, new Object[0]);
        ((OptimizeService)Mockito.verify((Object)this.mockedOptimizeService)).getOpenHistoricIncidents(null, now, Integer.MAX_VALUE);
        Mockito.verifyNoMoreInteractions((Object[])new Object[]{this.mockedOptimizeService});
    }

    @Test
    public void testMaxResultsQueryParameter() {
        RestAssured.given().queryParam("maxResults", new Object[]{10}).then().expect().statusCode(Response.Status.OK.getStatusCode()).contentType("application/json").when().get(OPTIMIZE_OPEN_HISTORIC_INCIDENT_PATH, new Object[0]);
        ((OptimizeService)Mockito.verify((Object)this.mockedOptimizeService)).getOpenHistoricIncidents(null, null, 10);
        Mockito.verifyNoMoreInteractions((Object[])new Object[]{this.mockedOptimizeService});
    }

    @Test
    public void testQueryParameterCombination() {
        Date now = new Date();
        RestAssured.given().queryParam("createdAfter", new Object[]{DateTimeUtils.DATE_FORMAT_WITH_TIMEZONE.format(now)}).queryParam("createdAt", new Object[]{DateTimeUtils.DATE_FORMAT_WITH_TIMEZONE.format(now)}).queryParam("maxResults", new Object[]{10}).then().expect().statusCode(Response.Status.OK.getStatusCode()).contentType("application/json").when().get(OPTIMIZE_OPEN_HISTORIC_INCIDENT_PATH, new Object[0]);
        ((OptimizeService)Mockito.verify((Object)this.mockedOptimizeService)).getOpenHistoricIncidents(now, now, 10);
        Mockito.verifyNoMoreInteractions((Object[])new Object[]{this.mockedOptimizeService});
    }

    @Test
    public void testPresenceOfProcessInstanceIdProperty() {
        HistoricIncidentEntity mock = (HistoricIncidentEntity)Mockito.mock(HistoricIncidentEntity.class);
        Mockito.when((Object)mock.getProcessInstanceId()).thenReturn((Object)"aProcInstId");
        Mockito.when((Object)this.mockedOptimizeService.getOpenHistoricIncidents(null, null, Integer.MAX_VALUE)).thenReturn(Collections.singletonList(mock));
        Response response = (Response)RestAssured.given().then().expect().statusCode(Response.Status.OK.getStatusCode()).contentType("application/json").when().get(OPTIMIZE_OPEN_HISTORIC_INCIDENT_PATH, new Object[0]);
        String content = response.asString();
        String processInstanceId = JsonPath.from((String)content).getString("[0].processInstanceId");
        Assert.assertEquals((Object)"aProcInstId", (Object)processInstanceId);
    }
}

