/*
 * Decompiled with CFR 0.152.
 */
package org.eximeebpms.bpm.engine.rest.util;

import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;

public abstract class DateTimeUtils {
    public static final SimpleDateFormat DATE_FORMAT_WITHOUT_TIMEZONE = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss");
    public static final SimpleDateFormat DATE_FORMAT_WITH_TIMEZONE = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss.SSSZ");

    public static String withTimezone(String dateString) {
        try {
            Date parse = DATE_FORMAT_WITHOUT_TIMEZONE.parse(dateString);
            return DateTimeUtils.withTimezone(parse);
        }
        catch (ParseException e) {
            throw new RuntimeException(e);
        }
    }

    public static String withTimezone(Date date) {
        return DATE_FORMAT_WITH_TIMEZONE.format(date);
    }

    public static Date updateTime(Date now, Date newTime) {
        Calendar c = Calendar.getInstance();
        c.setTime(now);
        Calendar newTimeCalendar = Calendar.getInstance();
        newTimeCalendar.setTime(newTime);
        c.set(15, newTimeCalendar.get(15));
        c.set(16, newTimeCalendar.get(16));
        c.set(11, newTimeCalendar.get(11));
        c.set(12, newTimeCalendar.get(12));
        c.set(13, newTimeCalendar.get(13));
        c.set(14, newTimeCalendar.get(14));
        return c.getTime();
    }

    public static Date addDays(Date date, int amount) {
        Calendar c = Calendar.getInstance();
        c.setTime(date);
        c.add(5, amount);
        return c.getTime();
    }
}

