/*
 * Decompiled with CFR 0.152.
 */
package org.eximeebpms.bpm.engine.rest.dto;

import com.fasterxml.jackson.databind.ObjectMapper;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import javax.ws.rs.core.MultivaluedMap;
import org.eximeebpms.bpm.engine.ProcessEngine;
import org.eximeebpms.bpm.engine.management.SchemaLogQuery;
import org.eximeebpms.bpm.engine.rest.dto.AbstractQueryDto;
import org.eximeebpms.bpm.engine.rest.dto.CamundaQueryParam;

public class SchemaLogQueryDto
extends AbstractQueryDto<SchemaLogQuery> {
    private static final String SORT_BY_TIMESTAMP_VALUE = "timestamp";
    private static final List<String> VALID_SORT_BY_VALUES = new ArrayList<String>();
    String version;

    public SchemaLogQueryDto() {
    }

    public SchemaLogQueryDto(ObjectMapper objectMapper, MultivaluedMap<String, String> queryParameters) {
        super(objectMapper, queryParameters);
    }

    public String getVersion() {
        return this.version;
    }

    @CamundaQueryParam(value="version")
    public void setVersion(String version) {
        this.version = version;
    }

    @Override
    protected boolean isValidSortByValue(String value) {
        return VALID_SORT_BY_VALUES.contains(value);
    }

    @Override
    protected SchemaLogQuery createNewQuery(ProcessEngine engine) {
        return engine.getManagementService().createSchemaLogQuery();
    }

    @Override
    protected void applyFilters(SchemaLogQuery query) {
        if (this.version != null) {
            query.version(this.version);
        }
    }

    @Override
    protected void applySortBy(SchemaLogQuery query, String sortBy, Map<String, Object> parameters, ProcessEngine engine) {
        if (sortBy.equals(SORT_BY_TIMESTAMP_VALUE)) {
            query.orderByTimestamp();
        }
    }

    static {
        VALID_SORT_BY_VALUES.add(SORT_BY_TIMESTAMP_VALUE);
    }
}

