/*
 * Decompiled with CFR 0.152.
 */
package org.eximeebpms.bpm.engine.rest.dto.history;

import com.fasterxml.jackson.databind.ObjectMapper;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Map;
import javax.ws.rs.core.MultivaluedMap;
import org.eximeebpms.bpm.engine.ProcessEngine;
import org.eximeebpms.bpm.engine.history.HistoricIncidentQuery;
import org.eximeebpms.bpm.engine.rest.dto.AbstractQueryDto;
import org.eximeebpms.bpm.engine.rest.dto.CamundaQueryParam;
import org.eximeebpms.bpm.engine.rest.dto.converter.BooleanConverter;
import org.eximeebpms.bpm.engine.rest.dto.converter.DateConverter;
import org.eximeebpms.bpm.engine.rest.dto.converter.StringArrayConverter;
import org.eximeebpms.bpm.engine.rest.dto.converter.StringListConverter;

public class HistoricIncidentQueryDto
extends AbstractQueryDto<HistoricIncidentQuery> {
    private static final String SORT_BY_INCIDENT_ID = "incidentId";
    private static final String SORT_BY_INCIDENT_MESSAGE = "incidentMessage";
    private static final String SORT_BY_CREATE_TIME = "createTime";
    private static final String SORT_BY_END_TIME = "endTime";
    private static final String SORT_BY_INCIDENT_TYPE = "incidentType";
    private static final String SORT_BY_EXECUTION_ID = "executionId";
    private static final String SORT_BY_ACTIVITY_ID = "activityId";
    private static final String SORT_BY_PROCESS_INSTANCE_ID = "processInstanceId";
    private static final String SORT_BY_PROCESS_DEFINITION_ID = "processDefinitionId";
    private static final String SORT_BY_PROCESS_DEFINITION_KEY = "processDefinitionKey";
    private static final String SORT_BY_CAUSE_INCIDENT_ID = "causeIncidentId";
    private static final String SORT_BY_ROOT_CAUSE_INCIDENT_ID = "rootCauseIncidentId";
    private static final String SORT_BY_CONFIGURATION = "configuration";
    private static final String SORT_BY_HISTORY_CONFIGURATION = "historyConfiguration";
    private static final String SORT_BY_TENANT_ID = "tenantId";
    private static final String SORT_BY_INCIDENT_STATE = "incidentState";
    private static final List<String> VALID_SORT_BY_VALUES = new ArrayList<String>();
    protected String incidentId;
    protected String incidentType;
    protected String incidentMessage;
    protected String incidentMessageLike;
    protected String processDefinitionId;
    protected String processDefinitionKey;
    protected String[] processDefinitionKeyIn;
    protected String processInstanceId;
    protected String executionId;
    protected Date createTimeBefore;
    protected Date createTimeAfter;
    protected Date endTimeBefore;
    protected Date endTimeAfter;
    protected String activityId;
    protected String failedActivityId;
    protected String causeIncidentId;
    protected String rootCauseIncidentId;
    protected String configuration;
    protected String historyConfiguration;
    protected Boolean open;
    protected Boolean resolved;
    protected Boolean deleted;
    protected List<String> tenantIds;
    protected Boolean withoutTenantId;
    protected List<String> jobDefinitionIds;

    public HistoricIncidentQueryDto() {
    }

    public HistoricIncidentQueryDto(ObjectMapper objectMapper, MultivaluedMap<String, String> queryParameters) {
        super(objectMapper, queryParameters);
    }

    @CamundaQueryParam(value="incidentId")
    public void setIncidentId(String incidentId) {
        this.incidentId = incidentId;
    }

    @CamundaQueryParam(value="incidentType")
    public void setIncidentType(String incidentType) {
        this.incidentType = incidentType;
    }

    @CamundaQueryParam(value="incidentMessage")
    public void setIncidentMessage(String incidentMessage) {
        this.incidentMessage = incidentMessage;
    }

    @CamundaQueryParam(value="incidentMessageLike")
    public void setIncidentMessageLike(String incidentMessageLike) {
        this.incidentMessageLike = incidentMessageLike;
    }

    @CamundaQueryParam(value="processDefinitionId")
    public void setProcessDefinitionId(String processDefinitionId) {
        this.processDefinitionId = processDefinitionId;
    }

    @CamundaQueryParam(value="processDefinitionKey")
    public void setProcessDefinitionKey(String processDefinitionKey) {
        this.processDefinitionKey = processDefinitionKey;
    }

    @CamundaQueryParam(value="processDefinitionKeyIn", converter=StringArrayConverter.class)
    public void setProcessDefinitionKeyIn(String[] processDefinitionKeyIn) {
        this.processDefinitionKeyIn = processDefinitionKeyIn;
    }

    @CamundaQueryParam(value="processInstanceId")
    public void setProcessInstanceId(String processInstanceId) {
        this.processInstanceId = processInstanceId;
    }

    @CamundaQueryParam(value="executionId")
    public void setExecutionId(String executionId) {
        this.executionId = executionId;
    }

    @CamundaQueryParam(value="createTimeBefore", converter=DateConverter.class)
    public void setCreateTimeBefore(Date createTimeBefore) {
        this.createTimeBefore = createTimeBefore;
    }

    @CamundaQueryParam(value="createTimeAfter", converter=DateConverter.class)
    public void setCreateTimeAfter(Date createTimeAfter) {
        this.createTimeAfter = createTimeAfter;
    }

    @CamundaQueryParam(value="endTimeBefore", converter=DateConverter.class)
    public void setEndTimeBefore(Date endTimeBefore) {
        this.endTimeBefore = endTimeBefore;
    }

    @CamundaQueryParam(value="endTimeAfter", converter=DateConverter.class)
    public void setEndTimeAfter(Date endTimeAfter) {
        this.endTimeAfter = endTimeAfter;
    }

    @CamundaQueryParam(value="activityId")
    public void setActivityId(String activityId) {
        this.activityId = activityId;
    }

    @CamundaQueryParam(value="failedActivityId")
    public void setFailedActivityId(String activityId) {
        this.failedActivityId = activityId;
    }

    @CamundaQueryParam(value="causeIncidentId")
    public void setCauseIncidentId(String causeIncidentId) {
        this.causeIncidentId = causeIncidentId;
    }

    @CamundaQueryParam(value="rootCauseIncidentId")
    public void setRootCauseIncidentId(String rootCauseIncidentId) {
        this.rootCauseIncidentId = rootCauseIncidentId;
    }

    @CamundaQueryParam(value="configuration")
    public void setConfiguration(String configuration) {
        this.configuration = configuration;
    }

    @CamundaQueryParam(value="historyConfiguration")
    public void setHistoryConfiguration(String historyConfiguration) {
        this.historyConfiguration = historyConfiguration;
    }

    @CamundaQueryParam(value="open", converter=BooleanConverter.class)
    public void setOpen(Boolean open) {
        this.open = open;
    }

    @CamundaQueryParam(value="resolved", converter=BooleanConverter.class)
    public void setResolved(Boolean resolved) {
        this.resolved = resolved;
    }

    @CamundaQueryParam(value="deleted", converter=BooleanConverter.class)
    public void setDeleted(Boolean deleted) {
        this.deleted = deleted;
    }

    @CamundaQueryParam(value="tenantIdIn", converter=StringListConverter.class)
    public void setTenantIdIn(List<String> tenantIds) {
        this.tenantIds = tenantIds;
    }

    @CamundaQueryParam(value="withoutTenantId", converter=BooleanConverter.class)
    public void setWithoutTenantId(Boolean withoutTenantId) {
        this.withoutTenantId = withoutTenantId;
    }

    @CamundaQueryParam(value="jobDefinitionIdIn", converter=StringListConverter.class)
    public void setJobDefinitionIdIn(List<String> jobDefinitionIds) {
        this.jobDefinitionIds = jobDefinitionIds;
    }

    @Override
    protected boolean isValidSortByValue(String value) {
        return VALID_SORT_BY_VALUES.contains(value);
    }

    @Override
    protected HistoricIncidentQuery createNewQuery(ProcessEngine engine) {
        return engine.getHistoryService().createHistoricIncidentQuery();
    }

    @Override
    protected void applyFilters(HistoricIncidentQuery query) {
        if (this.incidentId != null) {
            query.incidentId(this.incidentId);
        }
        if (this.incidentType != null) {
            query.incidentType(this.incidentType);
        }
        if (this.incidentMessage != null) {
            query.incidentMessage(this.incidentMessage);
        }
        if (this.incidentMessageLike != null) {
            query.incidentMessageLike(this.incidentMessageLike);
        }
        if (this.processDefinitionId != null) {
            query.processDefinitionId(this.processDefinitionId);
        }
        if (this.processDefinitionKey != null) {
            query.processDefinitionKey(this.processDefinitionKey);
        }
        if (this.processDefinitionKeyIn != null && this.processDefinitionKeyIn.length > 0) {
            query.processDefinitionKeyIn(this.processDefinitionKeyIn);
        }
        if (this.processInstanceId != null) {
            query.processInstanceId(this.processInstanceId);
        }
        if (this.executionId != null) {
            query.executionId(this.executionId);
        }
        if (this.createTimeBefore != null) {
            query.createTimeBefore(this.createTimeBefore);
        }
        if (this.createTimeAfter != null) {
            query.createTimeAfter(this.createTimeAfter);
        }
        if (this.endTimeBefore != null) {
            query.endTimeBefore(this.endTimeBefore);
        }
        if (this.endTimeAfter != null) {
            query.endTimeAfter(this.endTimeAfter);
        }
        if (this.activityId != null) {
            query.activityId(this.activityId);
        }
        if (this.failedActivityId != null) {
            query.failedActivityId(this.failedActivityId);
        }
        if (this.causeIncidentId != null) {
            query.causeIncidentId(this.causeIncidentId);
        }
        if (this.rootCauseIncidentId != null) {
            query.rootCauseIncidentId(this.rootCauseIncidentId);
        }
        if (this.configuration != null) {
            query.configuration(this.configuration);
        }
        if (this.historyConfiguration != null) {
            query.historyConfiguration(this.historyConfiguration);
        }
        if (this.open != null) {
            query.open();
        }
        if (this.resolved != null && this.resolved.booleanValue()) {
            query.resolved();
        }
        if (this.deleted != null && this.deleted.booleanValue()) {
            query.deleted();
        }
        if (this.tenantIds != null && !this.tenantIds.isEmpty()) {
            query.tenantIdIn(this.tenantIds.toArray(new String[this.tenantIds.size()]));
        }
        if (Boolean.TRUE.equals(this.withoutTenantId)) {
            query.withoutTenantId();
        }
        if (this.jobDefinitionIds != null && !this.jobDefinitionIds.isEmpty()) {
            query.jobDefinitionIdIn(this.jobDefinitionIds.toArray(new String[this.jobDefinitionIds.size()]));
        }
    }

    @Override
    protected void applySortBy(HistoricIncidentQuery query, String sortBy, Map<String, Object> parameters, ProcessEngine engine) {
        if (sortBy.equals(SORT_BY_INCIDENT_ID)) {
            query.orderByIncidentId();
        } else if (sortBy.equals(SORT_BY_INCIDENT_MESSAGE)) {
            query.orderByIncidentMessage();
        } else if (sortBy.equals(SORT_BY_CREATE_TIME)) {
            query.orderByCreateTime();
        } else if (sortBy.equals(SORT_BY_END_TIME)) {
            query.orderByEndTime();
        } else if (sortBy.equals(SORT_BY_INCIDENT_TYPE)) {
            query.orderByIncidentType();
        } else if (sortBy.equals(SORT_BY_EXECUTION_ID)) {
            query.orderByExecutionId();
        } else if (sortBy.equals(SORT_BY_ACTIVITY_ID)) {
            query.orderByActivityId();
        } else if (sortBy.equals(SORT_BY_PROCESS_INSTANCE_ID)) {
            query.orderByProcessInstanceId();
        } else if (sortBy.equals(SORT_BY_PROCESS_DEFINITION_KEY)) {
            query.orderByProcessDefinitionKey();
        } else if (sortBy.equals(SORT_BY_PROCESS_DEFINITION_ID)) {
            query.orderByProcessDefinitionId();
        } else if (sortBy.equals(SORT_BY_CAUSE_INCIDENT_ID)) {
            query.orderByCauseIncidentId();
        } else if (sortBy.equals(SORT_BY_ROOT_CAUSE_INCIDENT_ID)) {
            query.orderByRootCauseIncidentId();
        } else if (sortBy.equals(SORT_BY_CONFIGURATION)) {
            query.orderByConfiguration();
        } else if (sortBy.equals(SORT_BY_HISTORY_CONFIGURATION)) {
            query.orderByHistoryConfiguration();
        } else if (sortBy.equals(SORT_BY_TENANT_ID)) {
            query.orderByTenantId();
        } else if (sortBy.equals(SORT_BY_INCIDENT_STATE)) {
            query.orderByIncidentState();
        }
    }

    static {
        VALID_SORT_BY_VALUES.add(SORT_BY_INCIDENT_ID);
        VALID_SORT_BY_VALUES.add(SORT_BY_INCIDENT_MESSAGE);
        VALID_SORT_BY_VALUES.add(SORT_BY_CREATE_TIME);
        VALID_SORT_BY_VALUES.add(SORT_BY_END_TIME);
        VALID_SORT_BY_VALUES.add(SORT_BY_INCIDENT_TYPE);
        VALID_SORT_BY_VALUES.add(SORT_BY_EXECUTION_ID);
        VALID_SORT_BY_VALUES.add(SORT_BY_ACTIVITY_ID);
        VALID_SORT_BY_VALUES.add(SORT_BY_PROCESS_INSTANCE_ID);
        VALID_SORT_BY_VALUES.add(SORT_BY_PROCESS_DEFINITION_ID);
        VALID_SORT_BY_VALUES.add(SORT_BY_PROCESS_DEFINITION_KEY);
        VALID_SORT_BY_VALUES.add(SORT_BY_CAUSE_INCIDENT_ID);
        VALID_SORT_BY_VALUES.add(SORT_BY_ROOT_CAUSE_INCIDENT_ID);
        VALID_SORT_BY_VALUES.add(SORT_BY_CONFIGURATION);
        VALID_SORT_BY_VALUES.add(SORT_BY_HISTORY_CONFIGURATION);
        VALID_SORT_BY_VALUES.add(SORT_BY_TENANT_ID);
        VALID_SORT_BY_VALUES.add(SORT_BY_INCIDENT_STATE);
    }
}

