/*
 * Decompiled with CFR 0.152.
 */
package org.eximeebpms.bpm.engine.rest.hal;

import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eximeebpms.bpm.engine.ProcessEngine;
import org.eximeebpms.bpm.engine.rest.hal.Hal;
import org.eximeebpms.bpm.engine.rest.hal.HalLinkResolver;
import org.eximeebpms.bpm.engine.rest.hal.HalRelation;
import org.eximeebpms.bpm.engine.rest.hal.HalResource;

public class HalLinker {
    Map<HalRelation, Set<String>> linkedResources = new HashMap<HalRelation, Set<String>>();
    protected final Hal hal;
    protected final HalResource<?> resource;

    public HalLinker(Hal hal, HalResource<?> resource) {
        this.hal = hal;
        this.resource = resource;
    }

    public void createLink(HalRelation rel, String ... pathParams) {
        if (pathParams != null && pathParams.length > 0 && pathParams[0] != null) {
            Set<String> linkedResourceIds = this.linkedResources.get(rel);
            if (linkedResourceIds == null) {
                linkedResourceIds = new HashSet<String>();
                this.linkedResources.put(rel, linkedResourceIds);
            }
            linkedResourceIds.add(pathParams[pathParams.length - 1]);
            this.resource.addLink(rel.relName, rel.uriTemplate.build((Object[])pathParams));
        }
    }

    public Set<HalRelation> getLinkedRelations() {
        return this.linkedResources.keySet();
    }

    public Set<String> getLinkedResourceIdsByRelation(HalRelation relation) {
        Set<String> result = this.linkedResources.get(relation);
        if (result != null) {
            return result;
        }
        return Collections.emptySet();
    }

    public List<HalResource<?>> resolve(HalRelation relation, ProcessEngine processEngine) {
        HalLinkResolver linkResolver = this.hal.getLinkResolver(relation.resourceType);
        if (linkResolver != null) {
            Set<String> linkedIds = this.getLinkedResourceIdsByRelation(relation);
            if (!linkedIds.isEmpty()) {
                return linkResolver.resolveLinks(linkedIds.toArray(new String[linkedIds.size()]), processEngine);
            }
            return Collections.emptyList();
        }
        throw new RuntimeException("Cannot find HAL link resolver for resource type '" + relation.resourceType + "'.");
    }

    public void mergeLinks(HalResource<?> embedded) {
        for (Map.Entry<HalRelation, Set<String>> linkentry : embedded.linker.linkedResources.entrySet()) {
            Set<String> linkedIdSet = this.linkedResources.get(linkentry.getKey());
            if (linkedIdSet != null) {
                linkedIdSet.addAll((Collection<String>)linkentry.getValue());
                continue;
            }
            this.linkedResources.put(linkentry.getKey(), linkentry.getValue());
        }
    }
}

