/*
 * Decompiled with CFR 0.152.
 */
package org.eximeebpms.bpm.engine.rest.impl;

import com.fasterxml.jackson.databind.ObjectMapper;
import java.util.ArrayList;
import java.util.List;
import javax.ws.rs.core.MultivaluedMap;
import javax.ws.rs.core.UriInfo;
import org.eximeebpms.bpm.engine.rest.IncidentRestService;
import org.eximeebpms.bpm.engine.rest.dto.CountResultDto;
import org.eximeebpms.bpm.engine.rest.dto.runtime.IncidentDto;
import org.eximeebpms.bpm.engine.rest.dto.runtime.IncidentQueryDto;
import org.eximeebpms.bpm.engine.rest.impl.AbstractRestProcessEngineAware;
import org.eximeebpms.bpm.engine.rest.sub.repository.impl.IncidentResourceImpl;
import org.eximeebpms.bpm.engine.rest.sub.runtime.IncidentResource;
import org.eximeebpms.bpm.engine.rest.util.QueryUtil;
import org.eximeebpms.bpm.engine.runtime.Incident;
import org.eximeebpms.bpm.engine.runtime.IncidentQuery;

public class IncidentRestServiceImpl
extends AbstractRestProcessEngineAware
implements IncidentRestService {
    public IncidentRestServiceImpl(String engineName, ObjectMapper objectMapper) {
        super(engineName, objectMapper);
    }

    @Override
    public List<IncidentDto> getIncidents(UriInfo uriInfo, Integer firstResult, Integer maxResults) {
        IncidentQueryDto queryDto = new IncidentQueryDto(this.getObjectMapper(), (MultivaluedMap<String, String>)uriInfo.getQueryParameters());
        IncidentQuery query = (IncidentQuery)queryDto.toQuery(this.getProcessEngine());
        List<Incident> queryResult = QueryUtil.list(query, firstResult, maxResults);
        ArrayList<IncidentDto> result = new ArrayList<IncidentDto>();
        for (Incident incident : queryResult) {
            IncidentDto dto = IncidentDto.fromIncident(incident);
            result.add(dto);
        }
        return result;
    }

    @Override
    public CountResultDto getIncidentsCount(UriInfo uriInfo) {
        IncidentQueryDto queryDto = new IncidentQueryDto(this.getObjectMapper(), (MultivaluedMap<String, String>)uriInfo.getQueryParameters());
        IncidentQuery query = (IncidentQuery)queryDto.toQuery(this.getProcessEngine());
        long count = query.count();
        CountResultDto result = new CountResultDto();
        result.setCount(count);
        return result;
    }

    @Override
    public IncidentResource getIncident(String incidentId) {
        return new IncidentResourceImpl(this.getProcessEngine(), incidentId, this.getObjectMapper());
    }
}

