/*
 * Decompiled with CFR 0.152.
 */
package org.eximeebpms.bpm.engine.rest.sub.repository.impl;

import com.fasterxml.jackson.databind.ObjectMapper;
import java.net.URI;
import java.util.List;
import javax.ws.rs.core.MultivaluedMap;
import javax.ws.rs.core.Response;
import javax.ws.rs.core.UriInfo;
import org.eximeebpms.bpm.engine.ProcessEngineException;
import org.eximeebpms.bpm.engine.RepositoryService;
import org.eximeebpms.bpm.engine.exception.NotFoundException;
import org.eximeebpms.bpm.engine.exception.NotValidException;
import org.eximeebpms.bpm.engine.repository.Deployment;
import org.eximeebpms.bpm.engine.repository.DeploymentBuilder;
import org.eximeebpms.bpm.engine.repository.DeploymentWithDefinitions;
import org.eximeebpms.bpm.engine.rest.dto.repository.DeploymentDto;
import org.eximeebpms.bpm.engine.rest.dto.repository.DeploymentWithDefinitionsDto;
import org.eximeebpms.bpm.engine.rest.dto.repository.RedeploymentDto;
import org.eximeebpms.bpm.engine.rest.exception.InvalidRequestException;
import org.eximeebpms.bpm.engine.rest.impl.AbstractRestProcessEngineAware;
import org.eximeebpms.bpm.engine.rest.sub.repository.DeploymentResource;
import org.eximeebpms.bpm.engine.rest.sub.repository.DeploymentResourcesResource;
import org.eximeebpms.bpm.engine.rest.sub.repository.impl.DeploymentResourcesResourceImpl;

public class DeploymentResourceImpl
extends AbstractRestProcessEngineAware
implements DeploymentResource {
    protected String deploymentId;

    public DeploymentResourceImpl(String processEngineName, String deploymentId, String rootResourcePath, ObjectMapper objectMapper) {
        super(processEngineName, objectMapper);
        this.deploymentId = deploymentId;
        this.relativeRootResourcePath = rootResourcePath;
    }

    @Override
    public DeploymentDto getDeployment() {
        RepositoryService repositoryService = this.getProcessEngine().getRepositoryService();
        Deployment deployment = (Deployment)repositoryService.createDeploymentQuery().deploymentId(this.deploymentId).singleResult();
        if (deployment == null) {
            throw new InvalidRequestException(Response.Status.NOT_FOUND, "Deployment with id '" + this.deploymentId + "' does not exist");
        }
        return DeploymentDto.fromDeployment(deployment);
    }

    @Override
    public DeploymentResourcesResource getDeploymentResources() {
        return new DeploymentResourcesResourceImpl(this.getProcessEngine(), this.deploymentId);
    }

    @Override
    public DeploymentDto redeploy(UriInfo uriInfo, RedeploymentDto redeployment) {
        DeploymentWithDefinitions deployment = null;
        try {
            deployment = this.tryToRedeploy(redeployment);
        }
        catch (NotFoundException e) {
            throw this.createInvalidRequestException("redeploy", Response.Status.NOT_FOUND, (ProcessEngineException)((Object)e));
        }
        catch (NotValidException e) {
            throw this.createInvalidRequestException("redeploy", Response.Status.BAD_REQUEST, (ProcessEngineException)((Object)e));
        }
        DeploymentWithDefinitionsDto deploymentDto = DeploymentWithDefinitionsDto.fromDeployment(deployment);
        URI uri = uriInfo.getBaseUriBuilder().path(this.relativeRootResourcePath).path("/deployment").path(deployment.getId()).build(new Object[0]);
        deploymentDto.addReflexiveLink(uri, "GET", "self");
        return deploymentDto;
    }

    protected DeploymentWithDefinitions tryToRedeploy(RedeploymentDto redeployment) {
        RepositoryService repositoryService = this.getProcessEngine().getRepositoryService();
        DeploymentBuilder builder = repositoryService.createDeployment();
        builder.nameFromDeployment(this.deploymentId);
        String tenantId = this.getDeployment().getTenantId();
        if (tenantId != null) {
            builder.tenantId(tenantId);
        }
        if (redeployment != null) {
            builder = this.addRedeploymentResources(builder, redeployment);
        } else {
            builder.addDeploymentResources(this.deploymentId);
        }
        return builder.deployWithResult();
    }

    protected DeploymentBuilder addRedeploymentResources(DeploymentBuilder builder, RedeploymentDto redeployment) {
        boolean isResourceNameListEmpty;
        builder.source(redeployment.getSource());
        List<String> resourceIds = redeployment.getResourceIds();
        List<String> resourceNames = redeployment.getResourceNames();
        boolean isResourceIdListEmpty = resourceIds == null || resourceIds.isEmpty();
        boolean bl = isResourceNameListEmpty = resourceNames == null || resourceNames.isEmpty();
        if (isResourceIdListEmpty && isResourceNameListEmpty) {
            builder.addDeploymentResources(this.deploymentId);
        } else {
            if (!isResourceIdListEmpty) {
                builder.addDeploymentResourcesById(this.deploymentId, resourceIds);
            }
            if (!isResourceNameListEmpty) {
                builder.addDeploymentResourcesByName(this.deploymentId, resourceNames);
            }
        }
        return builder;
    }

    @Override
    public void deleteDeployment(String deploymentId, UriInfo uriInfo) {
        RepositoryService repositoryService = this.getProcessEngine().getRepositoryService();
        Deployment deployment = (Deployment)repositoryService.createDeploymentQuery().deploymentId(deploymentId).singleResult();
        if (deployment == null) {
            throw new InvalidRequestException(Response.Status.NOT_FOUND, "Deployment with id '" + deploymentId + "' do not exist");
        }
        boolean cascade = this.isQueryPropertyEnabled(uriInfo, "cascade");
        boolean skipCustomListeners = this.isQueryPropertyEnabled(uriInfo, "skipCustomListeners");
        boolean skipIoMappings = this.isQueryPropertyEnabled(uriInfo, "skipIoMappings");
        repositoryService.deleteDeployment(deploymentId, cascade, skipCustomListeners, skipIoMappings);
    }

    protected boolean isQueryPropertyEnabled(UriInfo uriInfo, String property) {
        MultivaluedMap queryParams = uriInfo.getQueryParameters();
        return queryParams.containsKey((Object)property) && ((List)queryParams.get((Object)property)).size() > 0 && "true".equals(((List)queryParams.get((Object)property)).get(0));
    }

    protected InvalidRequestException createInvalidRequestException(String action, Response.Status status, ProcessEngineException cause) {
        String errorMessage = String.format("Cannot %s deployment '%s': %s", action, this.deploymentId, cause.getMessage());
        return new InvalidRequestException(status, (Exception)((Object)cause), errorMessage);
    }
}

