/*
 * Decompiled with CFR 0.152.
 */
package org.eximeebpms.bpm.engine.rest.sub.runtime.impl;

import com.fasterxml.jackson.databind.ObjectMapper;
import java.util.Map;
import javax.ws.rs.core.Response;
import org.eximeebpms.bpm.engine.AuthorizationException;
import org.eximeebpms.bpm.engine.ProcessEngine;
import org.eximeebpms.bpm.engine.ProcessEngineException;
import org.eximeebpms.bpm.engine.RuntimeService;
import org.eximeebpms.bpm.engine.rest.dto.VariableValueDto;
import org.eximeebpms.bpm.engine.rest.dto.runtime.EventSubscriptionDto;
import org.eximeebpms.bpm.engine.rest.dto.runtime.ExecutionTriggerDto;
import org.eximeebpms.bpm.engine.rest.exception.InvalidRequestException;
import org.eximeebpms.bpm.engine.rest.exception.RestException;
import org.eximeebpms.bpm.engine.rest.sub.runtime.EventSubscriptionResource;
import org.eximeebpms.bpm.engine.runtime.EventSubscription;
import org.eximeebpms.bpm.engine.variable.VariableMap;

public class MessageEventSubscriptionResource
implements EventSubscriptionResource {
    protected static final String MESSAGE_EVENT_TYPE = "message";
    protected ProcessEngine engine;
    protected String executionId;
    protected String messageName;
    protected ObjectMapper objectMapper;

    public MessageEventSubscriptionResource(ProcessEngine engine, String executionId, String messageName, ObjectMapper objectMapper) {
        this.engine = engine;
        this.executionId = executionId;
        this.messageName = messageName;
        this.objectMapper = objectMapper;
    }

    @Override
    public EventSubscriptionDto getEventSubscription() {
        RuntimeService runtimeService = this.engine.getRuntimeService();
        EventSubscription eventSubscription = (EventSubscription)runtimeService.createEventSubscriptionQuery().executionId(this.executionId).eventName(this.messageName).eventType(MESSAGE_EVENT_TYPE).singleResult();
        if (eventSubscription == null) {
            String errorMessage = String.format("Message event subscription for execution %s named %s does not exist", this.executionId, this.messageName);
            throw new InvalidRequestException(Response.Status.NOT_FOUND, errorMessage);
        }
        return EventSubscriptionDto.fromEventSubscription(eventSubscription);
    }

    @Override
    public void triggerEvent(ExecutionTriggerDto triggerDto) {
        RuntimeService runtimeService = this.engine.getRuntimeService();
        try {
            VariableMap variables = VariableValueDto.toMap(triggerDto.getVariables(), this.engine, this.objectMapper);
            runtimeService.messageEventReceived(this.messageName, this.executionId, (Map)variables);
        }
        catch (AuthorizationException e) {
            throw e;
        }
        catch (ProcessEngineException e) {
            throw new RestException(Response.Status.INTERNAL_SERVER_ERROR, (Exception)((Object)e), String.format("Cannot trigger message %s for execution %s: %s", this.messageName, this.executionId, e.getMessage()));
        }
        catch (RestException e) {
            String errorMessage = String.format("Cannot trigger message %s for execution %s: %s", this.messageName, this.executionId, e.getMessage());
            throw new InvalidRequestException(e.getStatus(), e, errorMessage);
        }
    }
}

