/*
 * Copyright Camunda Services GmbH and/or licensed to Camunda Services GmbH
 * under one or more contributor license agreements. See the NOTICE file
 * distributed with this work for additional information regarding copyright
 * ownership. Camunda licenses this file to you under the Apache License,
 * Version 2.0; you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package org.eximeebpms.bpm.engine.rest.dto.runtime;

import org.eximeebpms.bpm.engine.runtime.Execution;

public class ExecutionDto {

  private String id;
  private String processInstanceId;
  private boolean ended;
  private String tenantId;

  public static ExecutionDto fromExecution(Execution execution) {
    ExecutionDto dto = new ExecutionDto();
    dto.id = execution.getId();
    dto.processInstanceId = execution.getProcessInstanceId();
    dto.ended = execution.isEnded();
    dto.tenantId = execution.getTenantId();

    return dto;
  }

  public String getId() {
    return id;
  }

  public String getProcessInstanceId() {
    return processInstanceId;
  }

  public boolean isEnded() {
    return ended;
  }

  public String getTenantId() {
    return tenantId;
  }

}
