/*
 * Decompiled with CFR 0.152.
 */
package org.eximeebpms.bpm.engine.rest.helper;

import org.eximeebpms.bpm.engine.history.HistoricVariableUpdate;
import org.eximeebpms.bpm.engine.impl.calendar.DateTimeUtil;
import org.eximeebpms.bpm.engine.variable.value.ObjectValue;
import org.eximeebpms.bpm.engine.variable.value.TypedValue;
import org.mockito.Mockito;

public class MockHistoricVariableUpdateBuilder {
    protected String id;
    protected String name;
    protected String variableInstanceId;
    protected TypedValue typedValue;
    protected String processDefinitionKey;
    protected String processDefinitionId;
    protected String processInstanceId;
    protected String errorMessage;
    protected String activityInstanceId;
    protected int revision;
    protected String time;
    protected String executionId;
    protected String taskId;
    protected String caseDefinitionKey;
    protected String caseDefinitionId;
    protected String caseInstanceId;
    protected String caseExecutionId;
    protected String tenantId;
    protected String userOperationId;
    protected boolean initial;

    public MockHistoricVariableUpdateBuilder id(String id) {
        this.id = id;
        return this;
    }

    public MockHistoricVariableUpdateBuilder name(String name) {
        this.name = name;
        return this;
    }

    public MockHistoricVariableUpdateBuilder variableInstanceId(String variableInstanceId) {
        this.variableInstanceId = variableInstanceId;
        return this;
    }

    public MockHistoricVariableUpdateBuilder typedValue(TypedValue value) {
        this.typedValue = value;
        return this;
    }

    public MockHistoricVariableUpdateBuilder processDefinitionKey(String processDefinitionKey) {
        this.processDefinitionKey = processDefinitionKey;
        return this;
    }

    public MockHistoricVariableUpdateBuilder processDefinitionId(String processDefinitionId) {
        this.processDefinitionId = processDefinitionId;
        return this;
    }

    public MockHistoricVariableUpdateBuilder processInstanceId(String processInstanceId) {
        this.processInstanceId = processInstanceId;
        return this;
    }

    public MockHistoricVariableUpdateBuilder errorMessage(String errorMessage) {
        this.errorMessage = errorMessage;
        return this;
    }

    public MockHistoricVariableUpdateBuilder activityInstanceId(String activityInstanceId) {
        this.activityInstanceId = activityInstanceId;
        return this;
    }

    public MockHistoricVariableUpdateBuilder executionId(String executionId) {
        this.executionId = executionId;
        return this;
    }

    public MockHistoricVariableUpdateBuilder taskId(String taskId) {
        this.taskId = taskId;
        return this;
    }

    public MockHistoricVariableUpdateBuilder time(String time) {
        this.time = time;
        return this;
    }

    public MockHistoricVariableUpdateBuilder revision(int revision) {
        this.revision = revision;
        return this;
    }

    public MockHistoricVariableUpdateBuilder caseDefinitionKey(String caseDefinitionKey) {
        this.caseDefinitionKey = caseDefinitionKey;
        return this;
    }

    public MockHistoricVariableUpdateBuilder caseDefinitionId(String caseDefinitionId) {
        this.caseDefinitionId = caseDefinitionId;
        return this;
    }

    public MockHistoricVariableUpdateBuilder caseInstanceId(String caseInstanceId) {
        this.caseInstanceId = caseInstanceId;
        return this;
    }

    public MockHistoricVariableUpdateBuilder caseExecutionId(String caseExecutionId) {
        this.caseExecutionId = caseExecutionId;
        return this;
    }

    public MockHistoricVariableUpdateBuilder tenantId(String tenantId) {
        this.tenantId = tenantId;
        return this;
    }

    public MockHistoricVariableUpdateBuilder userOperationId(String userOperationId) {
        this.userOperationId = userOperationId;
        return this;
    }

    public MockHistoricVariableUpdateBuilder initial(boolean initial) {
        this.initial = initial;
        return this;
    }

    public HistoricVariableUpdate build() {
        HistoricVariableUpdate mockVariable = (HistoricVariableUpdate)Mockito.mock(HistoricVariableUpdate.class);
        Mockito.when((Object)mockVariable.getId()).thenReturn((Object)this.id);
        Mockito.when((Object)mockVariable.getVariableName()).thenReturn((Object)this.name);
        Mockito.when((Object)mockVariable.getVariableInstanceId()).thenReturn((Object)this.variableInstanceId);
        Mockito.when((Object)mockVariable.getVariableTypeName()).thenReturn((Object)this.typedValue.getType().getName());
        if (ObjectValue.class.isAssignableFrom(this.typedValue.getClass())) {
            ObjectValue objectValue = (ObjectValue)this.typedValue;
            if (objectValue.isDeserialized()) {
                Mockito.when((Object)mockVariable.getValue()).thenReturn(this.typedValue.getValue());
            } else {
                Mockito.when((Object)mockVariable.getValue()).thenReturn(null);
            }
        } else {
            Mockito.when((Object)mockVariable.getValue()).thenReturn(this.typedValue.getValue());
        }
        Mockito.when((Object)mockVariable.getTypedValue()).thenReturn((Object)this.typedValue);
        Mockito.when((Object)mockVariable.getProcessDefinitionKey()).thenReturn((Object)this.processDefinitionKey);
        Mockito.when((Object)mockVariable.getProcessDefinitionId()).thenReturn((Object)this.processDefinitionId);
        Mockito.when((Object)mockVariable.getProcessInstanceId()).thenReturn((Object)this.processInstanceId);
        Mockito.when((Object)mockVariable.getErrorMessage()).thenReturn((Object)this.errorMessage);
        Mockito.when((Object)mockVariable.getRevision()).thenReturn((Object)this.revision);
        Mockito.when((Object)mockVariable.getTime()).thenReturn((Object)DateTimeUtil.parseDate((String)this.time));
        Mockito.when((Object)mockVariable.getActivityInstanceId()).thenReturn((Object)this.activityInstanceId);
        Mockito.when((Object)mockVariable.getTaskId()).thenReturn((Object)this.taskId);
        Mockito.when((Object)mockVariable.getExecutionId()).thenReturn((Object)this.executionId);
        Mockito.when((Object)mockVariable.getTypeName()).thenReturn((Object)this.typedValue.getType().getName());
        Mockito.when((Object)mockVariable.getCaseDefinitionKey()).thenReturn((Object)this.caseDefinitionKey);
        Mockito.when((Object)mockVariable.getCaseDefinitionId()).thenReturn((Object)this.caseDefinitionId);
        Mockito.when((Object)mockVariable.getCaseInstanceId()).thenReturn((Object)this.caseInstanceId);
        Mockito.when((Object)mockVariable.getCaseExecutionId()).thenReturn((Object)this.caseExecutionId);
        Mockito.when((Object)mockVariable.getTenantId()).thenReturn((Object)this.tenantId);
        Mockito.when((Object)mockVariable.getUserOperationId()).thenReturn((Object)this.userOperationId);
        Mockito.when((Object)mockVariable.isInitial()).thenReturn((Object)this.initial);
        return mockVariable;
    }

    public String getId() {
        return this.id;
    }

    public String getName() {
        return this.name;
    }

    public String getVariableInstanceId() {
        return this.variableInstanceId;
    }

    public Object getValue() {
        return this.typedValue.getValue();
    }

    public TypedValue getTypedValue() {
        return this.typedValue;
    }

    public String getProcessDefinitionKey() {
        return this.processDefinitionKey;
    }

    public String getProcessDefinitionId() {
        return this.processDefinitionId;
    }

    public String getProcessInstanceId() {
        return this.processInstanceId;
    }

    public String getErrorMessage() {
        return this.errorMessage;
    }

    public String getActivityInstanceId() {
        return this.activityInstanceId;
    }

    public int getRevision() {
        return this.revision;
    }

    public String getTime() {
        return this.time;
    }

    public String getExecutionId() {
        return this.executionId;
    }

    public String getTaskId() {
        return this.taskId;
    }

    public String getCaseDefinitionKey() {
        return this.caseDefinitionKey;
    }

    public String getCaseDefinitionId() {
        return this.caseDefinitionId;
    }

    public String getCaseInstanceId() {
        return this.caseInstanceId;
    }

    public String getCaseExecutionId() {
        return this.caseExecutionId;
    }

    public String getUserOperationId() {
        return this.userOperationId;
    }

    public String getTenantId() {
        return this.tenantId;
    }

    public boolean isInitial() {
        return this.initial;
    }
}

