/*
 * Decompiled with CFR 0.152.
 */
package org.eximeebpms.bpm.engine.rest.dto.authorization;

import com.fasterxml.jackson.databind.ObjectMapper;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import javax.ws.rs.core.MultivaluedMap;
import org.eximeebpms.bpm.engine.ProcessEngine;
import org.eximeebpms.bpm.engine.authorization.AuthorizationQuery;
import org.eximeebpms.bpm.engine.rest.dto.AbstractQueryDto;
import org.eximeebpms.bpm.engine.rest.dto.EximeeBPMSQueryParam;
import org.eximeebpms.bpm.engine.rest.dto.converter.IntegerConverter;
import org.eximeebpms.bpm.engine.rest.dto.converter.StringArrayConverter;

public class AuthorizationQueryDto
extends AbstractQueryDto<AuthorizationQuery> {
    private static final String SORT_BY_RESOURCE_TYPE = "resourceType";
    private static final String SORT_BY_RESOURCE_ID = "resourceId";
    private static final List<String> VALID_SORT_BY_VALUES = new ArrayList<String>();
    protected String id;
    protected Integer type;
    protected String[] userIdIn;
    protected String[] groupIdIn;
    protected Integer resourceType;
    protected String resourceId;

    public AuthorizationQueryDto() {
    }

    public AuthorizationQueryDto(ObjectMapper objectMapper, MultivaluedMap<String, String> queryParameters) {
        super(objectMapper, queryParameters);
    }

    @EximeeBPMSQueryParam(value="id")
    public void setId(String id) {
        this.id = id;
    }

    @EximeeBPMSQueryParam(value="type", converter=IntegerConverter.class)
    public void setType(Integer type) {
        this.type = type;
    }

    @EximeeBPMSQueryParam(value="userIdIn", converter=StringArrayConverter.class)
    public void setUserIdIn(String[] userIdIn) {
        this.userIdIn = userIdIn;
    }

    @EximeeBPMSQueryParam(value="groupIdIn", converter=StringArrayConverter.class)
    public void setGroupIdIn(String[] groupIdIn) {
        this.groupIdIn = groupIdIn;
    }

    @EximeeBPMSQueryParam(value="resourceType", converter=IntegerConverter.class)
    public void setResourceType(int resourceType) {
        this.resourceType = resourceType;
    }

    @EximeeBPMSQueryParam(value="resourceId")
    public void setResourceId(String resourceId) {
        this.resourceId = resourceId;
    }

    @Override
    protected boolean isValidSortByValue(String value) {
        return VALID_SORT_BY_VALUES.contains(value);
    }

    @Override
    protected AuthorizationQuery createNewQuery(ProcessEngine engine) {
        return engine.getAuthorizationService().createAuthorizationQuery();
    }

    @Override
    protected void applyFilters(AuthorizationQuery query) {
        if (this.id != null) {
            query.authorizationId(this.id);
        }
        if (this.type != null) {
            query.authorizationType(this.type);
        }
        if (this.userIdIn != null) {
            query.userIdIn(this.userIdIn);
        }
        if (this.groupIdIn != null) {
            query.groupIdIn(this.groupIdIn);
        }
        if (this.resourceType != null) {
            query.resourceType(this.resourceType.intValue());
        }
        if (this.resourceId != null) {
            query.resourceId(this.resourceId);
        }
    }

    @Override
    protected void applySortBy(AuthorizationQuery query, String sortBy, Map<String, Object> parameters, ProcessEngine engine) {
        if (sortBy.equals(SORT_BY_RESOURCE_ID)) {
            query.orderByResourceId();
        } else if (sortBy.equals(SORT_BY_RESOURCE_TYPE)) {
            query.orderByResourceType();
        }
    }

    static {
        VALID_SORT_BY_VALUES.add(SORT_BY_RESOURCE_TYPE);
        VALID_SORT_BY_VALUES.add(SORT_BY_RESOURCE_ID);
    }
}

