/*
 * Decompiled with CFR 0.152.
 */
package org.eximeebpms.bpm.engine.rest.dto.history;

import com.fasterxml.jackson.databind.ObjectMapper;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Map;
import javax.ws.rs.core.MultivaluedMap;
import javax.ws.rs.core.Response;
import org.eximeebpms.bpm.engine.ProcessEngine;
import org.eximeebpms.bpm.engine.history.HistoricDetailQuery;
import org.eximeebpms.bpm.engine.rest.dto.AbstractQueryDto;
import org.eximeebpms.bpm.engine.rest.dto.EximeeBPMSQueryParam;
import org.eximeebpms.bpm.engine.rest.dto.SortingDto;
import org.eximeebpms.bpm.engine.rest.dto.converter.BooleanConverter;
import org.eximeebpms.bpm.engine.rest.dto.converter.DateConverter;
import org.eximeebpms.bpm.engine.rest.dto.converter.StringArrayConverter;
import org.eximeebpms.bpm.engine.rest.dto.converter.StringListConverter;
import org.eximeebpms.bpm.engine.rest.exception.InvalidRequestException;

public class HistoricDetailQueryDto
extends AbstractQueryDto<HistoricDetailQuery> {
    private static final String SORT_BY_PROCESS_INSTANCE_ID = "processInstanceId";
    private static final String SORT_BY_VARIABLE_NAME = "variableName";
    private static final String SORT_BY_VARIABLE_TYPE = "variableType";
    private static final String SORT_BY_VARIABLE_REVISION = "variableRevision";
    private static final String SORT_BY_FORM_PROPERTY_ID = "formPropertyId";
    private static final String SORT_BY_TIME = "time";
    private static final String SORT_PARTIALLY_BY_OCCURENCE = "occurrence";
    private static final String SORT_BY_TENANT_ID = "tenantId";
    private static final List<String> VALID_SORT_BY_VALUES = new ArrayList<String>();
    protected String processInstanceId;
    protected String executionId;
    protected String activityInstanceId;
    protected String caseInstanceId;
    protected String caseExecutionId;
    protected String variableInstanceId;
    protected String[] variableTypeIn;
    protected String variableNameLike;
    protected String taskId;
    protected Boolean formFields;
    protected Boolean variableUpdates;
    protected Boolean excludeTaskDetails;
    protected List<String> tenantIds;
    protected Boolean withoutTenantId;
    protected String[] processInstanceIdIn;
    protected String userOperationId;
    private Date occurredBefore;
    private Date occurredAfter;
    protected Boolean initial;

    public HistoricDetailQueryDto() {
    }

    public HistoricDetailQueryDto(ObjectMapper objectMapper, MultivaluedMap<String, String> queryParameters) {
        super(objectMapper, queryParameters);
    }

    @EximeeBPMSQueryParam(value="processInstanceId")
    public void setProcessInstanceId(String processInstanceId) {
        this.processInstanceId = processInstanceId;
    }

    @EximeeBPMSQueryParam(value="executionId")
    public void setExecutionId(String executionId) {
        this.executionId = executionId;
    }

    @EximeeBPMSQueryParam(value="activityInstanceId")
    public void setActivityInstanceId(String activityInstanceId) {
        this.activityInstanceId = activityInstanceId;
    }

    @EximeeBPMSQueryParam(value="caseInstanceId")
    public void setCaseInstanceId(String caseInstanceId) {
        this.caseInstanceId = caseInstanceId;
    }

    @EximeeBPMSQueryParam(value="caseExecutionId")
    public void setCaseExecutionId(String caseExecutionId) {
        this.caseExecutionId = caseExecutionId;
    }

    @EximeeBPMSQueryParam(value="variableInstanceId")
    public void setVariableInstanceId(String variableInstanceId) {
        this.variableInstanceId = variableInstanceId;
    }

    @EximeeBPMSQueryParam(value="variableTypeIn", converter=StringArrayConverter.class)
    public void setVariableTypeIn(String[] variableTypeIn) {
        this.variableTypeIn = variableTypeIn;
    }

    @EximeeBPMSQueryParam(value="variableNameLike")
    public void setVariableNameLike(String variableNameLike) {
        this.variableNameLike = variableNameLike;
    }

    @EximeeBPMSQueryParam(value="taskId")
    public void setTaskId(String taskId) {
        this.taskId = taskId;
    }

    @EximeeBPMSQueryParam(value="formFields", converter=BooleanConverter.class)
    public void setFormFields(Boolean formFields) {
        this.formFields = formFields;
    }

    @EximeeBPMSQueryParam(value="variableUpdates", converter=BooleanConverter.class)
    public void setVariableUpdates(Boolean variableUpdates) {
        this.variableUpdates = variableUpdates;
    }

    @EximeeBPMSQueryParam(value="excludeTaskDetails", converter=BooleanConverter.class)
    public void setExcludeTaskDetails(Boolean excludeTaskDetails) {
        this.excludeTaskDetails = excludeTaskDetails;
    }

    @EximeeBPMSQueryParam(value="tenantIdIn", converter=StringListConverter.class)
    public void setTenantIdIn(List<String> tenantIds) {
        this.tenantIds = tenantIds;
    }

    @EximeeBPMSQueryParam(value="withoutTenantId", converter=BooleanConverter.class)
    public void setWithoutTenantId(Boolean withoutTenantId) {
        this.withoutTenantId = withoutTenantId;
    }

    @EximeeBPMSQueryParam(value="processInstanceIdIn", converter=StringArrayConverter.class)
    public void setProcessInstanceIdIn(String[] processInstanceIdIn) {
        this.processInstanceIdIn = processInstanceIdIn;
    }

    @EximeeBPMSQueryParam(value="userOperationId")
    public void setUserOperationId(String userOperationId) {
        this.userOperationId = userOperationId;
    }

    @EximeeBPMSQueryParam(value="occurredBefore", converter=DateConverter.class)
    public void setOccurredBefore(Date occurredBefore) {
        this.occurredBefore = occurredBefore;
    }

    @EximeeBPMSQueryParam(value="occurredAfter", converter=DateConverter.class)
    public void setOccurredAfter(Date occurredAfter) {
        this.occurredAfter = occurredAfter;
    }

    @EximeeBPMSQueryParam(value="initial", converter=BooleanConverter.class)
    public void setInitial(Boolean initial) {
        this.initial = initial;
    }

    @Override
    protected boolean isValidSortByValue(String value) {
        return VALID_SORT_BY_VALUES.contains(value);
    }

    @Override
    protected HistoricDetailQuery createNewQuery(ProcessEngine engine) {
        return engine.getHistoryService().createHistoricDetailQuery();
    }

    @Override
    protected boolean sortOptionsValid() {
        if (this.sortings != null) {
            for (SortingDto sorting : this.sortings) {
                String sortingOrder = sorting.getSortOrder();
                String sortingBy = sorting.getSortBy();
                if (!VALID_SORT_BY_VALUES.contains(sortingBy)) {
                    throw new InvalidRequestException(Response.Status.BAD_REQUEST, "sortBy parameter has invalid value: " + sortingBy);
                }
                if (sortingBy != null && sortingOrder != null) continue;
                return false;
            }
        }
        return super.sortOptionsValid();
    }

    @Override
    protected void applyFilters(HistoricDetailQuery query) {
        if (this.processInstanceId != null) {
            query.processInstanceId(this.processInstanceId);
        }
        if (this.executionId != null) {
            query.executionId(this.executionId);
        }
        if (this.activityInstanceId != null) {
            query.activityInstanceId(this.activityInstanceId);
        }
        if (this.caseInstanceId != null) {
            query.caseInstanceId(this.caseInstanceId);
        }
        if (this.caseExecutionId != null) {
            query.caseExecutionId(this.caseExecutionId);
        }
        if (this.variableInstanceId != null) {
            query.variableInstanceId(this.variableInstanceId);
        }
        if (this.variableTypeIn != null && this.variableTypeIn.length > 0) {
            query.variableTypeIn(this.variableTypeIn);
        }
        if (this.variableNameLike != null) {
            query.variableNameLike(this.variableNameLike);
        }
        if (this.taskId != null) {
            query.taskId(this.taskId);
        }
        if (this.formFields != null) {
            query.formFields();
        }
        if (this.variableUpdates != null) {
            query.variableUpdates();
        }
        if (this.excludeTaskDetails != null) {
            query.excludeTaskDetails();
        }
        if (this.tenantIds != null && !this.tenantIds.isEmpty()) {
            query.tenantIdIn(this.tenantIds.toArray(new String[this.tenantIds.size()]));
        }
        if (Boolean.TRUE.equals(this.withoutTenantId)) {
            query.withoutTenantId();
        }
        if (this.processInstanceIdIn != null && this.processInstanceIdIn.length > 0) {
            query.processInstanceIdIn(this.processInstanceIdIn);
        }
        if (this.userOperationId != null) {
            query.userOperationId(this.userOperationId);
        }
        if (this.occurredBefore != null) {
            query.occurredBefore(this.occurredBefore);
        }
        if (this.occurredAfter != null) {
            query.occurredAfter(this.occurredAfter);
        }
        if (Boolean.TRUE.equals(this.initial)) {
            query.initial();
        }
    }

    @Override
    protected void applySortBy(HistoricDetailQuery query, String sortBy, Map<String, Object> parameters, ProcessEngine engine) {
        if (sortBy.equals(SORT_BY_PROCESS_INSTANCE_ID)) {
            query.orderByProcessInstanceId();
        } else if (sortBy.equals(SORT_BY_VARIABLE_NAME)) {
            query.orderByVariableName();
        } else if (sortBy.equals(SORT_BY_VARIABLE_TYPE)) {
            query.orderByVariableType();
        } else if (sortBy.equals(SORT_BY_VARIABLE_REVISION)) {
            query.orderByVariableRevision();
        } else if (sortBy.equals(SORT_BY_FORM_PROPERTY_ID)) {
            query.orderByFormPropertyId();
        } else if (sortBy.equals(SORT_BY_TIME)) {
            query.orderByTime();
        } else if (sortBy.equals(SORT_PARTIALLY_BY_OCCURENCE)) {
            query.orderPartiallyByOccurrence();
        } else if (sortBy.equals(SORT_BY_TENANT_ID)) {
            query.orderByTenantId();
        }
    }

    static {
        VALID_SORT_BY_VALUES.add(SORT_BY_PROCESS_INSTANCE_ID);
        VALID_SORT_BY_VALUES.add(SORT_BY_VARIABLE_NAME);
        VALID_SORT_BY_VALUES.add(SORT_BY_VARIABLE_TYPE);
        VALID_SORT_BY_VALUES.add(SORT_BY_VARIABLE_REVISION);
        VALID_SORT_BY_VALUES.add(SORT_BY_FORM_PROPERTY_ID);
        VALID_SORT_BY_VALUES.add(SORT_BY_TIME);
        VALID_SORT_BY_VALUES.add(SORT_PARTIALLY_BY_OCCURENCE);
        VALID_SORT_BY_VALUES.add(SORT_BY_TENANT_ID);
    }
}

