/*
 * Decompiled with CFR 0.152.
 */
package org.eximeebpms.bpm.engine.rest.impl;

import com.fasterxml.jackson.databind.ObjectMapper;
import java.util.List;
import javax.ws.rs.core.Response;
import org.eximeebpms.bpm.engine.BadUserRequestException;
import org.eximeebpms.bpm.engine.batch.Batch;
import org.eximeebpms.bpm.engine.history.HistoricProcessInstanceQuery;
import org.eximeebpms.bpm.engine.rest.ModificationRestService;
import org.eximeebpms.bpm.engine.rest.dto.ModificationDto;
import org.eximeebpms.bpm.engine.rest.dto.batch.BatchDto;
import org.eximeebpms.bpm.engine.rest.dto.history.HistoricProcessInstanceQueryDto;
import org.eximeebpms.bpm.engine.rest.dto.runtime.ProcessInstanceQueryDto;
import org.eximeebpms.bpm.engine.rest.exception.InvalidRequestException;
import org.eximeebpms.bpm.engine.rest.impl.AbstractRestProcessEngineAware;
import org.eximeebpms.bpm.engine.runtime.ModificationBuilder;
import org.eximeebpms.bpm.engine.runtime.ProcessInstanceQuery;

public class ModificationRestServiceImpl
extends AbstractRestProcessEngineAware
implements ModificationRestService {
    public ModificationRestServiceImpl(String engineName, ObjectMapper objectMapper) {
        super(engineName, objectMapper);
    }

    @Override
    public void executeModification(ModificationDto modificationExecutionDto) {
        try {
            this.createModificationBuilder(modificationExecutionDto).execute();
        }
        catch (BadUserRequestException e) {
            throw new InvalidRequestException(Response.Status.BAD_REQUEST, e.getMessage());
        }
    }

    @Override
    public BatchDto executeModificationAsync(ModificationDto modificationExecutionDto) {
        Batch batch = null;
        try {
            batch = this.createModificationBuilder(modificationExecutionDto).executeAsync();
        }
        catch (BadUserRequestException e) {
            throw new InvalidRequestException(Response.Status.BAD_REQUEST, e.getMessage());
        }
        return BatchDto.fromBatch(batch);
    }

    private ModificationBuilder createModificationBuilder(ModificationDto dto) {
        HistoricProcessInstanceQueryDto historicProcessInstanceQueryDto;
        ModificationBuilder builder = this.getProcessEngine().getRuntimeService().createModification(dto.getProcessDefinitionId());
        if (dto.getInstructions() != null && !dto.getInstructions().isEmpty()) {
            dto.applyTo(builder, this.getProcessEngine(), this.objectMapper);
        }
        List<String> processInstanceIds = dto.getProcessInstanceIds();
        builder.processInstanceIds(processInstanceIds);
        ProcessInstanceQueryDto processInstanceQueryDto = dto.getProcessInstanceQuery();
        if (processInstanceQueryDto != null) {
            ProcessInstanceQuery processInstanceQuery = (ProcessInstanceQuery)processInstanceQueryDto.toQuery(this.getProcessEngine());
            builder.processInstanceQuery(processInstanceQuery);
        }
        if ((historicProcessInstanceQueryDto = dto.getHistoricProcessInstanceQuery()) != null) {
            HistoricProcessInstanceQuery historicProcessInstanceQuery = (HistoricProcessInstanceQuery)historicProcessInstanceQueryDto.toQuery(this.getProcessEngine());
            builder.historicProcessInstanceQuery(historicProcessInstanceQuery);
        }
        if (dto.isSkipCustomListeners()) {
            builder.skipCustomListeners();
        }
        if (dto.isSkipIoMappings()) {
            builder.skipIoMappings();
        }
        if (dto.getAnnotation() != null) {
            builder.setAnnotation(dto.getAnnotation());
        }
        return builder;
    }
}

