/*
 * Decompiled with CFR 0.152.
 */
package org.eximeebpms.bpm.engine.rest.impl;

import com.fasterxml.jackson.databind.ObjectMapper;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import javax.ws.rs.core.MediaType;
import javax.ws.rs.core.MultivaluedMap;
import javax.ws.rs.core.Request;
import javax.ws.rs.core.Response;
import javax.ws.rs.core.UriInfo;
import javax.ws.rs.core.Variant;
import org.eximeebpms.bpm.engine.ProcessEngine;
import org.eximeebpms.bpm.engine.TaskService;
import org.eximeebpms.bpm.engine.exception.NotValidException;
import org.eximeebpms.bpm.engine.rest.TaskRestService;
import org.eximeebpms.bpm.engine.rest.dto.CountResultDto;
import org.eximeebpms.bpm.engine.rest.dto.VariableValueDto;
import org.eximeebpms.bpm.engine.rest.dto.task.TaskDto;
import org.eximeebpms.bpm.engine.rest.dto.task.TaskQueryDto;
import org.eximeebpms.bpm.engine.rest.dto.task.TaskWithAttachmentAndCommentDto;
import org.eximeebpms.bpm.engine.rest.dto.task.TaskWithVariablesDto;
import org.eximeebpms.bpm.engine.rest.exception.InvalidRequestException;
import org.eximeebpms.bpm.engine.rest.hal.Hal;
import org.eximeebpms.bpm.engine.rest.hal.task.HalTaskList;
import org.eximeebpms.bpm.engine.rest.impl.AbstractRestProcessEngineAware;
import org.eximeebpms.bpm.engine.rest.sub.task.TaskReportResource;
import org.eximeebpms.bpm.engine.rest.sub.task.TaskResource;
import org.eximeebpms.bpm.engine.rest.sub.task.impl.TaskReportResourceImpl;
import org.eximeebpms.bpm.engine.rest.sub.task.impl.TaskResourceImpl;
import org.eximeebpms.bpm.engine.rest.util.QueryUtil;
import org.eximeebpms.bpm.engine.task.Task;
import org.eximeebpms.bpm.engine.task.TaskQuery;
import org.eximeebpms.bpm.engine.variable.VariableMap;

public class TaskRestServiceImpl
extends AbstractRestProcessEngineAware
implements TaskRestService {
    public static final List<Variant> VARIANTS = Variant.mediaTypes((MediaType[])new MediaType[]{MediaType.APPLICATION_JSON_TYPE, Hal.APPLICATION_HAL_JSON_TYPE}).add().build();

    public TaskRestServiceImpl(String engineName, ObjectMapper objectMapper) {
        super(engineName, objectMapper);
    }

    @Override
    public Object getTasks(Request request, UriInfo uriInfo, Integer firstResult, Integer maxResults) {
        Variant variant = request.selectVariant(VARIANTS);
        if (variant != null) {
            if (MediaType.APPLICATION_JSON_TYPE.equals((Object)variant.getMediaType())) {
                return this.getJsonTasks(uriInfo, firstResult, maxResults);
            }
            if (Hal.APPLICATION_HAL_JSON_TYPE.equals((Object)variant.getMediaType())) {
                return this.getHalTasks(uriInfo, firstResult, maxResults);
            }
        }
        throw new InvalidRequestException(Response.Status.NOT_ACCEPTABLE, "No acceptable content-type found");
    }

    public List<TaskDto> getJsonTasks(UriInfo uriInfo, Integer firstResult, Integer maxResults) {
        TaskQueryDto queryDto = new TaskQueryDto(this.getObjectMapper(), (MultivaluedMap<String, String>)uriInfo.getQueryParameters());
        return this.queryTasks(queryDto, firstResult, maxResults);
    }

    public HalTaskList getHalTasks(UriInfo uriInfo, Integer firstResult, Integer maxResults) {
        TaskQueryDto queryDto = new TaskQueryDto(this.getObjectMapper(), (MultivaluedMap<String, String>)uriInfo.getQueryParameters());
        ProcessEngine engine = this.getProcessEngine();
        TaskQuery query = (TaskQuery)queryDto.toQuery(engine);
        List<Task> matchingTasks = this.executeTaskQuery(firstResult, maxResults, query);
        long count = query.count();
        return HalTaskList.generate(matchingTasks, count, engine);
    }

    @Override
    public List<TaskDto> queryTasks(TaskQueryDto queryDto, Integer firstResult, Integer maxResults) {
        ProcessEngine engine = this.getProcessEngine();
        queryDto.setObjectMapper(this.getObjectMapper());
        TaskQuery query = (TaskQuery)queryDto.toQuery(engine);
        List<Task> matchingTasks = this.executeTaskQuery(firstResult, maxResults, query);
        boolean withTaskVariables = Boolean.TRUE.equals(queryDto.getWithTaskVariablesInReturn());
        boolean withTaskLocalVariables = Boolean.TRUE.equals(queryDto.getWithTaskLocalVariablesInReturn());
        boolean withCommentInfo = Boolean.TRUE.equals(queryDto.getWithCommentAttachmentInfo());
        if (withTaskVariables || withTaskLocalVariables) {
            return this.getVariablesForTasks(engine, matchingTasks, withTaskVariables, withCommentInfo);
        }
        List<TaskDto> tasks = withCommentInfo ? matchingTasks.stream().map(TaskWithAttachmentAndCommentDto::fromEntity).collect(Collectors.toList()) : matchingTasks.stream().map(TaskDto::fromEntity).collect(Collectors.toList());
        return tasks;
    }

    protected List<Task> executeTaskQuery(Integer firstResult, Integer maxResults, TaskQuery query) {
        query.initializeFormKeys();
        return QueryUtil.list(query, firstResult, maxResults);
    }

    @Override
    public CountResultDto getTasksCount(UriInfo uriInfo) {
        TaskQueryDto queryDto = new TaskQueryDto(this.getObjectMapper(), (MultivaluedMap<String, String>)uriInfo.getQueryParameters());
        return this.queryTasksCount(queryDto);
    }

    @Override
    public CountResultDto queryTasksCount(TaskQueryDto queryDto) {
        ProcessEngine engine = this.getProcessEngine();
        queryDto.setObjectMapper(this.getObjectMapper());
        TaskQuery query = (TaskQuery)queryDto.toQuery(engine);
        long count = query.count();
        CountResultDto result = new CountResultDto();
        result.setCount(count);
        return result;
    }

    @Override
    public TaskResource getTask(String id, boolean withCommentAttachmentInfo, boolean withTaskVariablesInReturn, boolean withTaskLocalVariablesInReturn) {
        return new TaskResourceImpl(this.getProcessEngine(), id, this.relativeRootResourcePath, this.getObjectMapper(), withCommentAttachmentInfo, withTaskVariablesInReturn, withTaskLocalVariablesInReturn);
    }

    @Override
    public void createTask(TaskDto taskDto) {
        ProcessEngine engine = this.getProcessEngine();
        TaskService taskService = engine.getTaskService();
        Task newTask = taskService.newTask(taskDto.getId());
        taskDto.updateTask(newTask);
        try {
            taskService.saveTask(newTask);
        }
        catch (NotValidException e) {
            throw new InvalidRequestException(Response.Status.BAD_REQUEST, (Exception)((Object)e), "Could not save task: " + e.getMessage());
        }
    }

    @Override
    public TaskReportResource getTaskReportResource() {
        return new TaskReportResourceImpl(this.getProcessEngine());
    }

    private List<TaskDto> getVariablesForTasks(ProcessEngine engine, List<Task> matchingTasks, boolean withTaskVariablesInReturn, boolean withCommentAndAttachments) {
        TaskService taskService = engine.getTaskService();
        ArrayList<TaskDto> tasks = new ArrayList<TaskDto>();
        for (Task task : matchingTasks) {
            VariableMap taskVariables = withTaskVariablesInReturn ? taskService.getVariablesTyped(task.getId(), true) : taskService.getVariablesLocalTyped(task.getId(), true);
            Map<String, VariableValueDto> taskVariablesDto = VariableValueDto.fromMap(taskVariables);
            if (withCommentAndAttachments) {
                tasks.add(TaskWithAttachmentAndCommentDto.fromEntity(task, taskVariablesDto));
                continue;
            }
            tasks.add(TaskWithVariablesDto.fromEntity(task, taskVariablesDto));
        }
        return tasks;
    }
}

