/*
 * Copyright Camunda Services GmbH and/or licensed to Camunda Services GmbH
 * under one or more contributor license agreements. See the NOTICE file
 * distributed with this work for additional information regarding copyright
 * ownership. Camunda licenses this file to you under the Apache License,
 * Version 2.0; you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package org.eximeebpms.bpm.engine.rest.dto.task;

import java.util.Map;
import lombok.NoArgsConstructor;
import org.eximeebpms.bpm.engine.rest.dto.VariableValueDto;
import org.eximeebpms.bpm.engine.task.Task;

@NoArgsConstructor
public class TaskWithAttachmentAndCommentDto extends TaskWithVariablesDto {

  private boolean hasAttachment;
  private boolean hasComment;

  public TaskWithAttachmentAndCommentDto(Task task, Map<String, VariableValueDto> variables) {
    super(task, variables);
  }

  public TaskWithAttachmentAndCommentDto(Task task) {
    super(task);
  }
  public boolean getAttachment() {
    return hasAttachment;
  }
  public void setAttachment(boolean hasAttachment) {
    this.hasAttachment = hasAttachment;
  }

  public boolean getComment() {
    return hasComment;
  }

  public void setComment(boolean hasComment) {
    this.hasComment = hasComment;
  }

  public static TaskDto fromEntity(Task task, Map<String, VariableValueDto> variables) {
    TaskWithAttachmentAndCommentDto result = new TaskWithAttachmentAndCommentDto(task, variables);
    result.hasAttachment = task.hasAttachment();
    result.hasComment = task.hasComment();
    return result;
  }

  public static TaskDto fromEntity(Task task) {
    return fromEntity(task, null);
  }
}
