/*
 * Decompiled with CFR 0.152.
 */
package org.eximeebpms.bpm.engine.rest.history;

import io.restassured.RestAssured;
import io.restassured.http.ContentType;
import io.restassured.path.json.JsonPath;
import io.restassured.response.Response;
import java.util.Arrays;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import javax.ws.rs.core.Response;
import org.eximeebpms.bpm.engine.BadUserRequestException;
import org.eximeebpms.bpm.engine.HistoryService;
import org.eximeebpms.bpm.engine.batch.Batch;
import org.eximeebpms.bpm.engine.history.HistoricDecisionInstance;
import org.eximeebpms.bpm.engine.history.HistoricDecisionInstanceQuery;
import org.eximeebpms.bpm.engine.history.SetRemovalTimeSelectModeForHistoricDecisionInstancesBuilder;
import org.eximeebpms.bpm.engine.history.SetRemovalTimeToHistoricDecisionInstancesBuilder;
import org.eximeebpms.bpm.engine.rest.AbstractRestServiceTest;
import org.eximeebpms.bpm.engine.rest.dto.batch.BatchDto;
import org.eximeebpms.bpm.engine.rest.dto.history.HistoricDecisionInstanceQueryDto;
import org.eximeebpms.bpm.engine.rest.exception.InvalidRequestException;
import org.eximeebpms.bpm.engine.rest.helper.MockProvider;
import org.eximeebpms.bpm.engine.rest.util.JsonPathUtil;
import org.eximeebpms.bpm.engine.rest.util.container.TestContainerRule;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.Matchers;
import org.junit.Assert;
import org.junit.Before;
import org.junit.ClassRule;
import org.junit.Test;
import org.mockito.InOrder;
import org.mockito.Mockito;
import org.mockito.stubbing.Answer;
import org.mockito.verification.VerificationMode;

public class HistoricDecisionInstanceRestServiceInteractionTest
extends AbstractRestServiceTest {
    @ClassRule
    public static TestContainerRule rule = new TestContainerRule();
    protected static final String HISTORIC_DECISION_INSTANCE_URL = "/rest-test/history/decision-instance";
    protected static final String HISTORIC_SINGLE_DECISION_INSTANCE_URL = "/rest-test/history/decision-instance/{id}";
    protected static final String HISTORIC_DECISION_INSTANCES_DELETE_ASYNC_URL = "/rest-test/history/decision-instance/delete";
    protected static final String SET_REMOVAL_TIME_HISTORIC_DECISION_INSTANCES_ASYNC_URL = "/rest-test/history/decision-instance/set-removal-time";
    protected HistoryService historyServiceMock;
    protected HistoricDecisionInstance historicInstanceMock;
    protected HistoricDecisionInstanceQuery historicQueryMock;

    @Before
    public void setUpRuntimeData() {
        this.historyServiceMock = (HistoryService)Mockito.mock(HistoryService.class);
        Mockito.when((Object)processEngine.getHistoryService()).thenReturn((Object)this.historyServiceMock);
        this.historicInstanceMock = MockProvider.createMockHistoricDecisionInstance();
        this.historicQueryMock = (HistoricDecisionInstanceQuery)Mockito.mock(HistoricDecisionInstanceQuery.class, (Answer)Mockito.RETURNS_DEEP_STUBS);
        Mockito.when((Object)this.historyServiceMock.createHistoricDecisionInstanceQuery()).thenReturn((Object)this.historicQueryMock);
        Mockito.when((Object)this.historicQueryMock.decisionInstanceId(Mockito.anyString())).thenReturn((Object)this.historicQueryMock);
        Mockito.when((Object)this.historicQueryMock.singleResult()).thenReturn((Object)this.historicInstanceMock);
    }

    @Test
    public void testGetSingleHistoricDecisionInstance() {
        Response response = (Response)RestAssured.given().pathParam("id", (Object)"aHistoricDecisionInstanceId").then().expect().statusCode(Response.Status.OK.getStatusCode()).when().get(HISTORIC_SINGLE_DECISION_INSTANCE_URL, new Object[0]);
        InOrder inOrder = Mockito.inOrder((Object[])new Object[]{this.historicQueryMock});
        ((HistoricDecisionInstanceQuery)inOrder.verify((Object)this.historicQueryMock)).decisionInstanceId("aHistoricDecisionInstanceId");
        ((HistoricDecisionInstanceQuery)inOrder.verify((Object)this.historicQueryMock)).singleResult();
        String content = response.asString();
        String returnedHistoricDecisionInstanceId = JsonPath.from((String)content).getString("id");
        String returnedDecisionDefinitionId = JsonPath.from((String)content).getString("decisionDefinitionId");
        String returnedDecisionDefinitionKey = JsonPath.from((String)content).getString("decisionDefinitionKey");
        String returnedDecisionDefinitionName = JsonPath.from((String)content).getString("decisionDefinitionName");
        String returnedEvaluationTime = JsonPath.from((String)content).getString("evaluationTime");
        String returnedProcessDefinitionId = JsonPath.from((String)content).getString("processDefinitionId");
        String returnedProcessDefinitionKey = JsonPath.from((String)content).getString("processDefinitionKey");
        String returnedProcessInstanceId = JsonPath.from((String)content).getString("processInstanceId");
        String returnedCaseDefinitionId = JsonPath.from((String)content).getString("caseDefinitionId");
        String returnedCaseDefinitionKey = JsonPath.from((String)content).getString("caseDefinitionKey");
        String returnedCaseInstanceId = JsonPath.from((String)content).getString("caseInstanceId");
        String returnedActivityId = JsonPath.from((String)content).getString("activityId");
        String returnedActivityInstanceId = JsonPath.from((String)content).getString("activityInstanceId");
        String returnedUserId = JsonPath.from((String)content).getString("userId");
        List returnedInputs = JsonPath.from((String)content).getList("inputs");
        List returnedOutputs = JsonPath.from((String)content).getList("outputs");
        Double returnedCollectResultValue = JsonPath.from((String)content).getDouble("collectResultValue");
        String returnedTenantId = JsonPath.from((String)content).getString("tenantId");
        String returnedRootDecisionInstanceId = JsonPath.from((String)content).getString("rootDecisionInstanceId");
        String returnedDecisionRequirementsDefinitionId = JsonPath.from((String)content).getString("decisionRequirementsDefinitionId");
        String returnedDecisionRequirementsDefinitionKey = JsonPath.from((String)content).getString("decisionRequirementsDefinitionKey");
        MatcherAssert.assertThat((Object)returnedHistoricDecisionInstanceId, (Matcher)Matchers.is((Object)"aHistoricDecisionInstanceId"));
        MatcherAssert.assertThat((Object)returnedDecisionDefinitionId, (Matcher)Matchers.is((Object)"aDecisionDefinitionId"));
        MatcherAssert.assertThat((Object)returnedDecisionDefinitionKey, (Matcher)Matchers.is((Object)"aDecisionDefinitionKey"));
        MatcherAssert.assertThat((Object)returnedDecisionDefinitionName, (Matcher)Matchers.is((Object)"aDecisionDefinitionName"));
        MatcherAssert.assertThat((Object)returnedEvaluationTime, (Matcher)Matchers.is((Object)MockProvider.EXAMPLE_HISTORIC_DECISION_INSTANCE_EVALUATION_TIME));
        MatcherAssert.assertThat((Object)returnedProcessDefinitionId, (Matcher)Matchers.is((Object)"aProcDefId"));
        MatcherAssert.assertThat((Object)returnedProcessDefinitionKey, (Matcher)Matchers.is((Object)"aKey"));
        MatcherAssert.assertThat((Object)returnedProcessInstanceId, (Matcher)Matchers.is((Object)"aProcInstId"));
        MatcherAssert.assertThat((Object)returnedCaseDefinitionId, (Matcher)Matchers.is((Object)"aCaseDefnitionId"));
        MatcherAssert.assertThat((Object)returnedCaseDefinitionKey, (Matcher)Matchers.is((Object)"aCaseDefinitionKey"));
        MatcherAssert.assertThat((Object)returnedCaseInstanceId, (Matcher)Matchers.is((Object)"aCaseInstId"));
        MatcherAssert.assertThat((Object)returnedActivityId, (Matcher)Matchers.is((Object)"aHistoricDecisionInstanceActivityId"));
        MatcherAssert.assertThat((Object)returnedActivityInstanceId, (Matcher)Matchers.is((Object)"aHistoricDecisionInstanceActivityInstanceId"));
        MatcherAssert.assertThat((Object)returnedUserId, (Matcher)Matchers.is((Object)"aUserId"));
        MatcherAssert.assertThat((Object)returnedInputs, (Matcher)Matchers.is((Matcher)Matchers.nullValue()));
        MatcherAssert.assertThat((Object)returnedOutputs, (Matcher)Matchers.is((Matcher)Matchers.nullValue()));
        MatcherAssert.assertThat((Object)returnedCollectResultValue, (Matcher)Matchers.is((Object)MockProvider.EXAMPLE_HISTORIC_DECISION_INSTANCE_COLLECT_RESULT_VALUE));
        MatcherAssert.assertThat((Object)returnedTenantId, (Matcher)Matchers.is((Object)"aTenantId"));
        MatcherAssert.assertThat((Object)returnedRootDecisionInstanceId, (Matcher)Matchers.is((Object)"aHistoricDecisionInstanceId"));
        MatcherAssert.assertThat((Object)returnedDecisionRequirementsDefinitionId, (Matcher)Matchers.is((Object)"aDecisionRequirementsDefinitionId"));
        MatcherAssert.assertThat((Object)returnedDecisionRequirementsDefinitionKey, (Matcher)Matchers.is((Object)"aDecisionRequirementsDefinitionKey"));
    }

    @Test
    public void testGetSingleHistoricDecisionInstanceWithInputs() {
        this.historicInstanceMock = MockProvider.createMockHistoricDecisionInstanceWithInputs();
        Mockito.when((Object)((HistoricDecisionInstance)this.historicQueryMock.singleResult())).thenReturn((Object)this.historicInstanceMock);
        Response response = (Response)RestAssured.given().pathParam("id", (Object)"aHistoricDecisionInstanceId").queryParam("includeInputs", new Object[]{true}).then().expect().statusCode(Response.Status.OK.getStatusCode()).when().get(HISTORIC_SINGLE_DECISION_INSTANCE_URL, new Object[0]);
        InOrder inOrder = Mockito.inOrder((Object[])new Object[]{this.historicQueryMock});
        ((HistoricDecisionInstanceQuery)inOrder.verify((Object)this.historicQueryMock)).decisionInstanceId("aHistoricDecisionInstanceId");
        ((HistoricDecisionInstanceQuery)inOrder.verify((Object)this.historicQueryMock)).includeInputs();
        ((HistoricDecisionInstanceQuery)inOrder.verify((Object)this.historicQueryMock, Mockito.never())).includeOutputs();
        ((HistoricDecisionInstanceQuery)inOrder.verify((Object)this.historicQueryMock)).singleResult();
        String content = response.asString();
        List returnedInputs = JsonPath.from((String)content).getList("inputs");
        List returnedOutputs = JsonPath.from((String)content).getList("outputs");
        MatcherAssert.assertThat((Object)returnedInputs, (Matcher)Matchers.is((Matcher)Matchers.notNullValue()));
        MatcherAssert.assertThat((Object)returnedInputs, (Matcher)Matchers.hasSize((int)3));
        MatcherAssert.assertThat((Object)returnedOutputs, (Matcher)Matchers.is((Matcher)Matchers.nullValue()));
    }

    @Test
    public void testGetSingleHistoricDecisionInstanceWithOutputs() {
        this.historicInstanceMock = MockProvider.createMockHistoricDecisionInstanceWithOutputs();
        Mockito.when((Object)((HistoricDecisionInstance)this.historicQueryMock.singleResult())).thenReturn((Object)this.historicInstanceMock);
        Response response = (Response)RestAssured.given().pathParam("id", (Object)"aHistoricDecisionInstanceId").queryParam("includeOutputs", new Object[]{true}).then().expect().statusCode(Response.Status.OK.getStatusCode()).when().get(HISTORIC_SINGLE_DECISION_INSTANCE_URL, new Object[0]);
        InOrder inOrder = Mockito.inOrder((Object[])new Object[]{this.historicQueryMock});
        ((HistoricDecisionInstanceQuery)inOrder.verify((Object)this.historicQueryMock)).decisionInstanceId("aHistoricDecisionInstanceId");
        ((HistoricDecisionInstanceQuery)inOrder.verify((Object)this.historicQueryMock, Mockito.never())).includeInputs();
        ((HistoricDecisionInstanceQuery)inOrder.verify((Object)this.historicQueryMock)).includeOutputs();
        ((HistoricDecisionInstanceQuery)inOrder.verify((Object)this.historicQueryMock)).singleResult();
        String content = response.asString();
        List returnedInputs = JsonPath.from((String)content).getList("inputs");
        List returnedOutputs = JsonPath.from((String)content).getList("outputs");
        MatcherAssert.assertThat((Object)returnedInputs, (Matcher)Matchers.is((Matcher)Matchers.nullValue()));
        MatcherAssert.assertThat((Object)returnedOutputs, (Matcher)Matchers.is((Matcher)Matchers.notNullValue()));
        MatcherAssert.assertThat((Object)returnedOutputs, (Matcher)Matchers.hasSize((int)3));
    }

    @Test
    public void testGetSingleHistoricDecisionInstanceWithInputsAndOutputs() {
        this.historicInstanceMock = MockProvider.createMockHistoricDecisionInstanceWithInputsAndOutputs();
        Mockito.when((Object)((HistoricDecisionInstance)this.historicQueryMock.singleResult())).thenReturn((Object)this.historicInstanceMock);
        Response response = (Response)RestAssured.given().pathParam("id", (Object)"aHistoricDecisionInstanceId").queryParam("includeInputs", new Object[]{true}).queryParam("includeOutputs", new Object[]{true}).then().expect().statusCode(Response.Status.OK.getStatusCode()).when().get(HISTORIC_SINGLE_DECISION_INSTANCE_URL, new Object[0]);
        InOrder inOrder = Mockito.inOrder((Object[])new Object[]{this.historicQueryMock});
        ((HistoricDecisionInstanceQuery)inOrder.verify((Object)this.historicQueryMock)).decisionInstanceId("aHistoricDecisionInstanceId");
        ((HistoricDecisionInstanceQuery)inOrder.verify((Object)this.historicQueryMock)).includeInputs();
        ((HistoricDecisionInstanceQuery)inOrder.verify((Object)this.historicQueryMock)).includeOutputs();
        ((HistoricDecisionInstanceQuery)inOrder.verify((Object)this.historicQueryMock)).singleResult();
        String content = response.asString();
        List returnedInputs = JsonPath.from((String)content).getList("inputs");
        List returnedOutputs = JsonPath.from((String)content).getList("outputs");
        MatcherAssert.assertThat((Object)returnedInputs, (Matcher)Matchers.is((Matcher)Matchers.notNullValue()));
        MatcherAssert.assertThat((Object)returnedInputs, (Matcher)Matchers.hasSize((int)3));
        MatcherAssert.assertThat((Object)returnedOutputs, (Matcher)Matchers.is((Matcher)Matchers.notNullValue()));
        MatcherAssert.assertThat((Object)returnedOutputs, (Matcher)Matchers.hasSize((int)3));
    }

    @Test
    public void testGetSingleHistoricDecisionInstanceWithDisabledBinaryFetching() {
        this.historicInstanceMock = MockProvider.createMockHistoricDecisionInstanceWithInputsAndOutputs();
        Mockito.when((Object)((HistoricDecisionInstance)this.historicQueryMock.singleResult())).thenReturn((Object)this.historicInstanceMock);
        RestAssured.given().pathParam("id", (Object)"aHistoricDecisionInstanceId").queryParam("disableBinaryFetching", new Object[]{true}).then().expect().statusCode(Response.Status.OK.getStatusCode()).when().get(HISTORIC_SINGLE_DECISION_INSTANCE_URL, new Object[0]);
        InOrder inOrder = Mockito.inOrder((Object[])new Object[]{this.historicQueryMock});
        ((HistoricDecisionInstanceQuery)inOrder.verify((Object)this.historicQueryMock)).decisionInstanceId("aHistoricDecisionInstanceId");
        ((HistoricDecisionInstanceQuery)inOrder.verify((Object)this.historicQueryMock)).disableBinaryFetching();
        ((HistoricDecisionInstanceQuery)inOrder.verify((Object)this.historicQueryMock)).singleResult();
    }

    @Test
    public void testGetSingleHistoricDecisionInstanceWithDisabledCustomObjectDeserialization() {
        this.historicInstanceMock = MockProvider.createMockHistoricDecisionInstanceWithInputsAndOutputs();
        Mockito.when((Object)((HistoricDecisionInstance)this.historicQueryMock.singleResult())).thenReturn((Object)this.historicInstanceMock);
        RestAssured.given().pathParam("id", (Object)"aHistoricDecisionInstanceId").queryParam("disableCustomObjectDeserialization", new Object[]{true}).then().expect().statusCode(Response.Status.OK.getStatusCode()).when().get(HISTORIC_SINGLE_DECISION_INSTANCE_URL, new Object[0]);
        InOrder inOrder = Mockito.inOrder((Object[])new Object[]{this.historicQueryMock});
        ((HistoricDecisionInstanceQuery)inOrder.verify((Object)this.historicQueryMock)).decisionInstanceId("aHistoricDecisionInstanceId");
        ((HistoricDecisionInstanceQuery)inOrder.verify((Object)this.historicQueryMock)).disableCustomObjectDeserialization();
        ((HistoricDecisionInstanceQuery)inOrder.verify((Object)this.historicQueryMock)).singleResult();
    }

    @Test
    public void testGetNonExistingHistoricCaseInstance() {
        Mockito.when((Object)((HistoricDecisionInstance)this.historicQueryMock.singleResult())).thenReturn(null);
        RestAssured.given().pathParam("id", (Object)"nonExistingId").then().expect().statusCode(Response.Status.NOT_FOUND.getStatusCode()).contentType(ContentType.JSON).body("type", Matchers.equalTo((Object)InvalidRequestException.class.getSimpleName()), new Object[0]).body("message", Matchers.equalTo((Object)"Historic decision instance with id 'nonExistingId' does not exist"), new Object[0]).when().get(HISTORIC_SINGLE_DECISION_INSTANCE_URL, new Object[0]);
    }

    @Test
    public void testDeleteAsync() {
        List<String> ids = Arrays.asList("aDecisionInstanceId");
        Batch batchEntity = MockProvider.createMockBatch();
        Mockito.when((Object)this.historyServiceMock.deleteHistoricDecisionInstancesAsync((List)Mockito.any(), (HistoricDecisionInstanceQuery)Mockito.any(), (String)Mockito.any())).thenReturn((Object)batchEntity);
        HashMap<String, Object> messageBodyJson = new HashMap<String, Object>();
        messageBodyJson.put("historicDecisionInstanceIds", ids);
        messageBodyJson.put("deleteReason", "a-delete-reason");
        Response response = (Response)RestAssured.given().contentType(ContentType.JSON).body(messageBodyJson).then().expect().statusCode(Response.Status.OK.getStatusCode()).when().post(HISTORIC_DECISION_INSTANCES_DELETE_ASYNC_URL, new Object[0]);
        this.verifyBatchJson(response.asString());
        ((HistoryService)Mockito.verify((Object)this.historyServiceMock, (VerificationMode)Mockito.times((int)1))).deleteHistoricDecisionInstancesAsync((List)Mockito.eq(ids), (HistoricDecisionInstanceQuery)Mockito.eq((Object)null), (String)Mockito.eq((Object)"a-delete-reason"));
    }

    @Test
    public void testDeleteAsyncWithQuery() {
        Batch batchEntity = MockProvider.createMockBatch();
        Mockito.when((Object)this.historyServiceMock.deleteHistoricDecisionInstancesAsync((List)Mockito.any(), (HistoricDecisionInstanceQuery)Mockito.any(), (String)Mockito.any())).thenReturn((Object)batchEntity);
        HashMap<String, Object> messageBodyJson = new HashMap<String, Object>();
        HistoricDecisionInstanceQueryDto query = new HistoricDecisionInstanceQueryDto();
        query.setDecisionDefinitionKey("decision");
        messageBodyJson.put("historicDecisionInstanceQuery", query);
        messageBodyJson.put("deleteReason", "a-delete-reason");
        Response response = (Response)RestAssured.given().contentType(ContentType.JSON).body(messageBodyJson).then().expect().statusCode(Response.Status.OK.getStatusCode()).when().post(HISTORIC_DECISION_INSTANCES_DELETE_ASYNC_URL, new Object[0]);
        this.verifyBatchJson(response.asString());
        ((HistoryService)Mockito.verify((Object)this.historyServiceMock, (VerificationMode)Mockito.times((int)1))).deleteHistoricDecisionInstancesAsync((List)Mockito.eq((Object)null), (HistoricDecisionInstanceQuery)Mockito.any(HistoricDecisionInstanceQuery.class), (String)Mockito.eq((Object)"a-delete-reason"));
    }

    @Test
    public void testDeleteAsyncWithIdsAndQuery() {
        Batch batchEntity = MockProvider.createMockBatch();
        Mockito.when((Object)this.historyServiceMock.deleteHistoricDecisionInstancesAsync(Mockito.anyList(), (HistoricDecisionInstanceQuery)Mockito.any(HistoricDecisionInstanceQuery.class), Mockito.anyString())).thenReturn((Object)batchEntity);
        HashMap<String, Object> messageBodyJson = new HashMap<String, Object>();
        HistoricDecisionInstanceQueryDto query = new HistoricDecisionInstanceQueryDto();
        query.setDecisionDefinitionKey("decision");
        messageBodyJson.put("historicDecisionInstanceQuery", query);
        List<String> ids = Arrays.asList("aDecisionInstanceId");
        messageBodyJson.put("historicDecisionInstanceIds", ids);
        messageBodyJson.put("deleteReason", "a-delete-reason");
        Response response = (Response)RestAssured.given().contentType(ContentType.JSON).body(messageBodyJson).then().expect().statusCode(Response.Status.OK.getStatusCode()).when().post(HISTORIC_DECISION_INSTANCES_DELETE_ASYNC_URL, new Object[0]);
        this.verifyBatchJson(response.asString());
        ((HistoryService)Mockito.verify((Object)this.historyServiceMock, (VerificationMode)Mockito.times((int)1))).deleteHistoricDecisionInstancesAsync((List)Mockito.eq(ids), (HistoricDecisionInstanceQuery)Mockito.any(HistoricDecisionInstanceQuery.class), (String)Mockito.eq((Object)"a-delete-reason"));
    }

    @Test
    public void testDeleteAsyncWithBadRequestQuery() {
        ((HistoryService)Mockito.doThrow((Throwable[])new Throwable[]{new BadUserRequestException("process instance ids are empty")}).when((Object)this.historyServiceMock)).deleteHistoricDecisionInstancesAsync((List)Mockito.eq((Object)null), (HistoricDecisionInstanceQuery)Mockito.eq((Object)null), (String)Mockito.any());
        RestAssured.given().contentType(ContentType.JSON).body("{}").then().expect().statusCode(Response.Status.BAD_REQUEST.getStatusCode()).when().post(HISTORIC_DECISION_INSTANCES_DELETE_ASYNC_URL, new Object[0]);
    }

    @Test
    public void shouldSetRemovalTime_ByIds() {
        SetRemovalTimeSelectModeForHistoricDecisionInstancesBuilder builderMock = (SetRemovalTimeSelectModeForHistoricDecisionInstancesBuilder)Mockito.mock(SetRemovalTimeSelectModeForHistoricDecisionInstancesBuilder.class, (Answer)Mockito.RETURNS_DEEP_STUBS);
        Mockito.when((Object)this.historyServiceMock.setRemovalTimeToHistoricDecisionInstances()).thenReturn((Object)builderMock);
        HashMap<String, Object> payload = new HashMap<String, Object>();
        payload.put("historicDecisionInstanceIds", Collections.singletonList("aDecisionInstanceId"));
        payload.put("calculatedRemovalTime", true);
        RestAssured.given().contentType(ContentType.JSON).body(payload).then().expect().statusCode(Response.Status.OK.getStatusCode()).when().post(SET_REMOVAL_TIME_HISTORIC_DECISION_INSTANCES_ASYNC_URL, new Object[0]);
        SetRemovalTimeSelectModeForHistoricDecisionInstancesBuilder builder = this.historyServiceMock.setRemovalTimeToHistoricDecisionInstances();
        ((SetRemovalTimeSelectModeForHistoricDecisionInstancesBuilder)Mockito.verify((Object)builder)).calculatedRemovalTime();
        ((SetRemovalTimeSelectModeForHistoricDecisionInstancesBuilder)Mockito.verify((Object)builder)).byIds(new String[]{"aDecisionInstanceId"});
        ((SetRemovalTimeSelectModeForHistoricDecisionInstancesBuilder)Mockito.verify((Object)builder)).byQuery(null);
        ((SetRemovalTimeSelectModeForHistoricDecisionInstancesBuilder)Mockito.verify((Object)builder)).executeAsync();
        Mockito.verifyNoMoreInteractions((Object[])new Object[]{builder});
    }

    @Test
    public void shouldSetRemovalTime_ByQuery() {
        SetRemovalTimeSelectModeForHistoricDecisionInstancesBuilder builderMock = (SetRemovalTimeSelectModeForHistoricDecisionInstancesBuilder)Mockito.mock(SetRemovalTimeSelectModeForHistoricDecisionInstancesBuilder.class, (Answer)Mockito.RETURNS_DEEP_STUBS);
        Mockito.when((Object)this.historyServiceMock.setRemovalTimeToHistoricDecisionInstances()).thenReturn((Object)builderMock);
        HashMap<String, Object> payload = new HashMap<String, Object>();
        payload.put("calculatedRemovalTime", true);
        payload.put("historicDecisionInstanceQuery", Collections.singletonMap("decisionInstanceId", "aDecisionInstanceId"));
        RestAssured.given().contentType(ContentType.JSON).body(payload).then().expect().statusCode(Response.Status.OK.getStatusCode()).when().post(SET_REMOVAL_TIME_HISTORIC_DECISION_INSTANCES_ASYNC_URL, new Object[0]);
        SetRemovalTimeSelectModeForHistoricDecisionInstancesBuilder builder = this.historyServiceMock.setRemovalTimeToHistoricDecisionInstances();
        ((HistoricDecisionInstanceQuery)Mockito.verify((Object)this.historicQueryMock)).decisionInstanceId("aDecisionInstanceId");
        ((SetRemovalTimeSelectModeForHistoricDecisionInstancesBuilder)Mockito.verify((Object)builder)).calculatedRemovalTime();
        ((SetRemovalTimeSelectModeForHistoricDecisionInstancesBuilder)Mockito.verify((Object)builder)).byIds(null);
        ((SetRemovalTimeSelectModeForHistoricDecisionInstancesBuilder)Mockito.verify((Object)builder)).byQuery(this.historicQueryMock);
        ((SetRemovalTimeSelectModeForHistoricDecisionInstancesBuilder)Mockito.verify((Object)builder)).executeAsync();
        Mockito.verifyNoMoreInteractions((Object[])new Object[]{builder});
    }

    @Test
    public void shouldSetRemovalTime_Absolute() {
        Date removalTime = new Date();
        SetRemovalTimeSelectModeForHistoricDecisionInstancesBuilder builderMock = (SetRemovalTimeSelectModeForHistoricDecisionInstancesBuilder)Mockito.mock(SetRemovalTimeSelectModeForHistoricDecisionInstancesBuilder.class, (Answer)Mockito.RETURNS_DEEP_STUBS);
        Mockito.when((Object)this.historyServiceMock.setRemovalTimeToHistoricDecisionInstances()).thenReturn((Object)builderMock);
        HashMap<String, Object> payload = new HashMap<String, Object>();
        payload.put("historicDecisionInstanceIds", Collections.singletonList("aDecisionInstanceId"));
        payload.put("absoluteRemovalTime", removalTime);
        RestAssured.given().contentType(ContentType.JSON).body(payload).then().expect().statusCode(Response.Status.OK.getStatusCode()).when().post(SET_REMOVAL_TIME_HISTORIC_DECISION_INSTANCES_ASYNC_URL, new Object[0]);
        SetRemovalTimeSelectModeForHistoricDecisionInstancesBuilder builder = this.historyServiceMock.setRemovalTimeToHistoricDecisionInstances();
        ((SetRemovalTimeSelectModeForHistoricDecisionInstancesBuilder)Mockito.verify((Object)builder)).absoluteRemovalTime(removalTime);
        ((SetRemovalTimeSelectModeForHistoricDecisionInstancesBuilder)Mockito.verify((Object)builder)).byIds(new String[]{"aDecisionInstanceId"});
        ((SetRemovalTimeSelectModeForHistoricDecisionInstancesBuilder)Mockito.verify((Object)builder)).byQuery(null);
        ((SetRemovalTimeSelectModeForHistoricDecisionInstancesBuilder)Mockito.verify((Object)builder)).executeAsync();
        Mockito.verifyNoMoreInteractions((Object[])new Object[]{builder});
    }

    @Test
    public void shouldNotSetRemovalTime_Absolute() {
        SetRemovalTimeSelectModeForHistoricDecisionInstancesBuilder builderMock = (SetRemovalTimeSelectModeForHistoricDecisionInstancesBuilder)Mockito.mock(SetRemovalTimeSelectModeForHistoricDecisionInstancesBuilder.class, (Answer)Mockito.RETURNS_DEEP_STUBS);
        Mockito.when((Object)this.historyServiceMock.setRemovalTimeToHistoricDecisionInstances()).thenReturn((Object)builderMock);
        HashMap<String, List<String>> payload = new HashMap<String, List<String>>();
        payload.put("historicDecisionInstanceIds", Collections.singletonList("aDecisionInstanceId"));
        payload.put("absoluteRemovalTime", null);
        RestAssured.given().contentType(ContentType.JSON).body(payload).then().expect().statusCode(Response.Status.OK.getStatusCode()).when().post(SET_REMOVAL_TIME_HISTORIC_DECISION_INSTANCES_ASYNC_URL, new Object[0]);
        SetRemovalTimeSelectModeForHistoricDecisionInstancesBuilder builder = this.historyServiceMock.setRemovalTimeToHistoricDecisionInstances();
        ((SetRemovalTimeToHistoricDecisionInstancesBuilder)Mockito.verify((Object)builder)).byIds(new String[]{"aDecisionInstanceId"});
        ((SetRemovalTimeToHistoricDecisionInstancesBuilder)Mockito.verify((Object)builder)).byQuery(null);
        ((SetRemovalTimeToHistoricDecisionInstancesBuilder)Mockito.verify((Object)builder)).executeAsync();
        Mockito.verifyNoMoreInteractions((Object[])new Object[]{builder});
    }

    @Test
    public void shouldClearRemovalTime() {
        SetRemovalTimeSelectModeForHistoricDecisionInstancesBuilder builderMock = (SetRemovalTimeSelectModeForHistoricDecisionInstancesBuilder)Mockito.mock(SetRemovalTimeSelectModeForHistoricDecisionInstancesBuilder.class, (Answer)Mockito.RETURNS_DEEP_STUBS);
        Mockito.when((Object)this.historyServiceMock.setRemovalTimeToHistoricDecisionInstances()).thenReturn((Object)builderMock);
        HashMap<String, Object> payload = new HashMap<String, Object>();
        payload.put("historicDecisionInstanceIds", Collections.singletonList("aDecisionInstanceId"));
        payload.put("clearedRemovalTime", true);
        RestAssured.given().contentType(ContentType.JSON).body(payload).then().expect().statusCode(Response.Status.OK.getStatusCode()).when().post(SET_REMOVAL_TIME_HISTORIC_DECISION_INSTANCES_ASYNC_URL, new Object[0]);
        SetRemovalTimeSelectModeForHistoricDecisionInstancesBuilder builder = this.historyServiceMock.setRemovalTimeToHistoricDecisionInstances();
        ((SetRemovalTimeSelectModeForHistoricDecisionInstancesBuilder)Mockito.verify((Object)builder)).clearedRemovalTime();
        ((SetRemovalTimeSelectModeForHistoricDecisionInstancesBuilder)Mockito.verify((Object)builder)).byIds(new String[]{"aDecisionInstanceId"});
        ((SetRemovalTimeSelectModeForHistoricDecisionInstancesBuilder)Mockito.verify((Object)builder)).byQuery(null);
        ((SetRemovalTimeSelectModeForHistoricDecisionInstancesBuilder)Mockito.verify((Object)builder)).executeAsync();
        Mockito.verifyNoMoreInteractions((Object[])new Object[]{builder});
    }

    @Test
    public void shouldSetRemovalTime_Response() {
        SetRemovalTimeSelectModeForHistoricDecisionInstancesBuilder builderMock = (SetRemovalTimeSelectModeForHistoricDecisionInstancesBuilder)Mockito.mock(SetRemovalTimeSelectModeForHistoricDecisionInstancesBuilder.class, (Answer)Mockito.RETURNS_DEEP_STUBS);
        Mockito.when((Object)this.historyServiceMock.setRemovalTimeToHistoricDecisionInstances()).thenReturn((Object)builderMock);
        Batch batchEntity = MockProvider.createMockBatch();
        Mockito.when((Object)builderMock.executeAsync()).thenReturn((Object)batchEntity);
        Response response = (Response)RestAssured.given().contentType(ContentType.JSON).body(Collections.emptyMap()).then().expect().statusCode(Response.Status.OK.getStatusCode()).when().post(SET_REMOVAL_TIME_HISTORIC_DECISION_INSTANCES_ASYNC_URL, new Object[0]);
        this.verifyBatchJson(response.asString());
    }

    @Test
    public void shouldSetRemovalTime_ThrowBadUserException() {
        SetRemovalTimeSelectModeForHistoricDecisionInstancesBuilder builderMock = (SetRemovalTimeSelectModeForHistoricDecisionInstancesBuilder)Mockito.mock(SetRemovalTimeSelectModeForHistoricDecisionInstancesBuilder.class, (Answer)Mockito.RETURNS_DEEP_STUBS);
        Mockito.when((Object)this.historyServiceMock.setRemovalTimeToHistoricDecisionInstances()).thenReturn((Object)builderMock);
        ((SetRemovalTimeSelectModeForHistoricDecisionInstancesBuilder)Mockito.doThrow(BadUserRequestException.class).when((Object)builderMock)).executeAsync();
        RestAssured.given().contentType(ContentType.JSON).body(Collections.emptyMap()).then().expect().statusCode(Response.Status.BAD_REQUEST.getStatusCode()).when().post(SET_REMOVAL_TIME_HISTORIC_DECISION_INSTANCES_ASYNC_URL, new Object[0]);
    }

    protected void verifyBatchJson(String batchJson) {
        BatchDto batch = (BatchDto)JsonPathUtil.from(batchJson).getObject("", BatchDto.class);
        Assert.assertNotNull((String)"The returned batch should not be null.", (Object)batch);
        Assert.assertEquals((Object)"aBatchId", (Object)batch.getId());
        Assert.assertEquals((Object)"aBatchType", (Object)batch.getType());
        Assert.assertEquals((long)10L, (long)batch.getTotalJobs());
        Assert.assertEquals((long)11L, (long)batch.getBatchJobsPerSeed());
        Assert.assertEquals((long)12L, (long)batch.getInvocationsPerBatchJob());
        Assert.assertEquals((Object)"aSeedJobDefinitionId", (Object)batch.getSeedJobDefinitionId());
        Assert.assertEquals((Object)"aMonitorJobDefinitionId", (Object)batch.getMonitorJobDefinitionId());
        Assert.assertEquals((Object)"aBatchJobDefinitionId", (Object)batch.getBatchJobDefinitionId());
        Assert.assertEquals((Object)"aTenantId", (Object)batch.getTenantId());
    }
}

