/*
 * Decompiled with CFR 0.152.
 */
package org.eximeebpms.bpm.engine.rest.standalone;

import java.util.HashMap;
import java.util.Map;
import org.eximeebpms.bpm.engine.rest.helper.EqualsMap;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class EqualsMapTest {
    protected Map<String, Object> map1;
    protected Map<String, Object> map2;

    @Before
    public void setUp() {
        this.map1 = new HashMap<String, Object>();
        this.map2 = new HashMap<String, Object>();
    }

    @Test
    public void testMapsSame() {
        Assert.assertTrue((boolean)new EqualsMap(this.map1).matches(this.map1));
    }

    @Test
    public void testMapsEqual() {
        this.map1.put("aKey", "aValue");
        this.map2.put("aKey", "aValue");
        Assert.assertTrue((boolean)new EqualsMap(this.map1).matches(this.map2));
        Assert.assertTrue((boolean)new EqualsMap(this.map2).matches(this.map1));
    }

    @Test
    public void testMapsNotEqual() {
        this.map1.put("aKey", "aValue");
        Assert.assertFalse((boolean)new EqualsMap(this.map1).matches(this.map2));
        Assert.assertFalse((boolean)new EqualsMap(this.map2).matches(this.map1));
    }

    @Test
    public void testMapsNull() {
        Assert.assertFalse((boolean)new EqualsMap(null).matches(this.map1));
        Assert.assertFalse((boolean)new EqualsMap(this.map1).matches(null));
        Assert.assertTrue((boolean)new EqualsMap(null).matches(null));
    }
}

