/*
 * Decompiled with CFR 0.152.
 */
package org.eximeebpms.bpm.engine.rest;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.type.TypeFactory;
import io.restassured.RestAssured;
import io.restassured.http.ContentType;
import io.restassured.response.Response;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.ws.rs.core.Response;
import org.eximeebpms.bpm.engine.CaseService;
import org.eximeebpms.bpm.engine.ProcessEngineException;
import org.eximeebpms.bpm.engine.exception.NotValidException;
import org.eximeebpms.bpm.engine.impl.util.IoUtil;
import org.eximeebpms.bpm.engine.rest.AbstractRestServiceTest;
import org.eximeebpms.bpm.engine.rest.dto.runtime.VariableNameDto;
import org.eximeebpms.bpm.engine.rest.exception.InvalidRequestException;
import org.eximeebpms.bpm.engine.rest.exception.RestException;
import org.eximeebpms.bpm.engine.rest.helper.ErrorMessageHelper;
import org.eximeebpms.bpm.engine.rest.helper.MockObjectValue;
import org.eximeebpms.bpm.engine.rest.helper.MockProvider;
import org.eximeebpms.bpm.engine.rest.helper.VariableTypeHelper;
import org.eximeebpms.bpm.engine.rest.helper.variable.EqualsNullValue;
import org.eximeebpms.bpm.engine.rest.helper.variable.EqualsObjectValue;
import org.eximeebpms.bpm.engine.rest.helper.variable.EqualsPrimitiveValue;
import org.eximeebpms.bpm.engine.rest.util.DateTimeUtils;
import org.eximeebpms.bpm.engine.rest.util.VariablesBuilder;
import org.eximeebpms.bpm.engine.rest.util.container.TestContainerRule;
import org.eximeebpms.bpm.engine.runtime.CaseExecution;
import org.eximeebpms.bpm.engine.runtime.CaseExecutionCommandBuilder;
import org.eximeebpms.bpm.engine.runtime.CaseExecutionQuery;
import org.eximeebpms.bpm.engine.variable.Variables;
import org.eximeebpms.bpm.engine.variable.value.BooleanValue;
import org.eximeebpms.bpm.engine.variable.value.FileValue;
import org.eximeebpms.bpm.engine.variable.value.ObjectValue;
import org.eximeebpms.bpm.engine.variable.value.TypedValue;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.Matchers;
import org.junit.Assert;
import org.junit.Before;
import org.junit.ClassRule;
import org.junit.Test;
import org.mockito.ArgumentCaptor;
import org.mockito.Mockito;
import org.mockito.hamcrest.MockitoHamcrest;
import org.mockito.verification.VerificationMode;

public class CaseExecutionRestServiceInteractionTest
extends AbstractRestServiceTest {
    @ClassRule
    public static TestContainerRule rule = new TestContainerRule();
    protected static final String CASE_EXECUTION_URL = "/rest-test/case-execution";
    protected static final String SINGLE_CASE_EXECUTION_URL = "/rest-test/case-execution/{id}";
    protected static final String CASE_EXECUTION_MANUAL_START_URL = "/rest-test/case-execution/{id}/manual-start";
    protected static final String CASE_EXECUTION_REENABLE_URL = "/rest-test/case-execution/{id}/reenable";
    protected static final String CASE_EXECUTION_DISABLE_URL = "/rest-test/case-execution/{id}/disable";
    protected static final String CASE_EXECUTION_COMPLETE_URL = "/rest-test/case-execution/{id}/complete";
    protected static final String CASE_EXECUTION_TERMINATE_URL = "/rest-test/case-execution/{id}/terminate";
    protected static final String CASE_EXECUTION_LOCAL_VARIABLES_URL = "/rest-test/case-execution/{id}/localVariables";
    protected static final String CASE_EXECUTION_VARIABLES_URL = "/rest-test/case-execution/{id}/variables";
    protected static final String SINGLE_CASE_EXECUTION_LOCAL_VARIABLE_URL = "/rest-test/case-execution/{id}/localVariables/{varId}";
    protected static final String SINGLE_CASE_EXECUTION_LOCAL_BINARY_VARIABLE_URL = "/rest-test/case-execution/{id}/localVariables/{varId}/data";
    protected static final String SINGLE_CASE_EXECUTION_VARIABLE_URL = "/rest-test/case-execution/{id}/variables/{varId}";
    protected static final String SINGLE_CASE_EXECUTION_BINARY_VARIABLE_URL = "/rest-test/case-execution/{id}/variables/{varId}/data";
    private CaseService caseServiceMock;
    private CaseExecutionQuery caseExecutionQueryMock;
    private CaseExecutionCommandBuilder caseExecutionCommandBuilderMock;

    @Before
    public void setUpRuntime() {
        CaseExecution mockCaseExecution = MockProvider.createMockCaseExecution();
        this.caseServiceMock = (CaseService)Mockito.mock(CaseService.class);
        Mockito.when((Object)processEngine.getCaseService()).thenReturn((Object)this.caseServiceMock);
        this.caseExecutionQueryMock = (CaseExecutionQuery)Mockito.mock(CaseExecutionQuery.class);
        Mockito.when((Object)this.caseServiceMock.createCaseExecutionQuery()).thenReturn((Object)this.caseExecutionQueryMock);
        Mockito.when((Object)this.caseExecutionQueryMock.caseExecutionId("aCaseExecutionId")).thenReturn((Object)this.caseExecutionQueryMock);
        Mockito.when((Object)((CaseExecution)this.caseExecutionQueryMock.singleResult())).thenReturn((Object)mockCaseExecution);
        Mockito.when((Object)this.caseServiceMock.getVariableTyped(Mockito.anyString(), Mockito.anyString(), Mockito.eq((boolean)true))).thenReturn((Object)EXAMPLE_VARIABLE_VALUE);
        Mockito.when((Object)this.caseServiceMock.getVariablesTyped(Mockito.anyString(), Mockito.eq((boolean)true))).thenReturn((Object)EXAMPLE_VARIABLES);
        Mockito.when((Object)this.caseServiceMock.getVariableLocalTyped(Mockito.anyString(), (String)Mockito.eq((Object)"aVariableKey"), Mockito.anyBoolean())).thenReturn((Object)EXAMPLE_VARIABLE_VALUE);
        Mockito.when((Object)this.caseServiceMock.getVariableLocalTyped(Mockito.anyString(), (String)Mockito.eq((Object)"aBytesVariableKey"), Mockito.eq((boolean)false))).thenReturn((Object)EXAMPLE_VARIABLE_VALUE_BYTES);
        Mockito.when((Object)this.caseServiceMock.getVariablesLocalTyped(Mockito.anyString(), Mockito.eq((boolean)true))).thenReturn((Object)EXAMPLE_VARIABLES);
        Mockito.when((Object)this.caseServiceMock.getVariablesTyped(Mockito.anyString(), (Collection)Mockito.any(), Mockito.eq((boolean)true))).thenReturn((Object)EXAMPLE_VARIABLES);
        Mockito.when((Object)this.caseServiceMock.getVariablesLocalTyped(Mockito.anyString(), (Collection)Mockito.any(), Mockito.eq((boolean)true))).thenReturn((Object)EXAMPLE_VARIABLES);
        this.caseExecutionCommandBuilderMock = (CaseExecutionCommandBuilder)Mockito.mock(CaseExecutionCommandBuilder.class);
        Mockito.when((Object)this.caseServiceMock.withCaseExecution("aCaseExecutionId")).thenReturn((Object)this.caseExecutionCommandBuilderMock);
        Mockito.when((Object)this.caseExecutionCommandBuilderMock.setVariable(Mockito.anyString(), Mockito.any())).thenReturn((Object)this.caseExecutionCommandBuilderMock);
        Mockito.when((Object)this.caseExecutionCommandBuilderMock.setVariableLocal(Mockito.anyString(), Mockito.any())).thenReturn((Object)this.caseExecutionCommandBuilderMock);
        Mockito.when((Object)this.caseExecutionCommandBuilderMock.setVariables((Map)Mockito.any())).thenReturn((Object)this.caseExecutionCommandBuilderMock);
        Mockito.when((Object)this.caseExecutionCommandBuilderMock.setVariablesLocal((Map)Mockito.any())).thenReturn((Object)this.caseExecutionCommandBuilderMock);
        Mockito.when((Object)this.caseExecutionCommandBuilderMock.removeVariable(Mockito.anyString())).thenReturn((Object)this.caseExecutionCommandBuilderMock);
        Mockito.when((Object)this.caseExecutionCommandBuilderMock.removeVariableLocal(Mockito.anyString())).thenReturn((Object)this.caseExecutionCommandBuilderMock);
        Mockito.when((Object)this.caseExecutionCommandBuilderMock.removeVariables((Collection)Mockito.any())).thenReturn((Object)this.caseExecutionCommandBuilderMock);
        Mockito.when((Object)this.caseExecutionCommandBuilderMock.removeVariablesLocal((Collection)Mockito.any())).thenReturn((Object)this.caseExecutionCommandBuilderMock);
    }

    @Test
    public void testCaseExecutionRetrieval() {
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("id", "aCaseExecutionId");
        RestAssured.given().pathParam("id", (Object)"aCaseExecutionId").then().expect().statusCode(Response.Status.OK.getStatusCode()).body("id", CoreMatchers.equalTo((Object)"aCaseExecutionId"), new Object[0]).body("caseInstanceId", CoreMatchers.equalTo((Object)"aCaseInstanceId"), new Object[0]).body("parentId", CoreMatchers.equalTo((Object)"aParentId"), new Object[0]).body("caseDefinitionId", CoreMatchers.equalTo((Object)"aCaseDefinitionId"), new Object[0]).body("activityId", CoreMatchers.equalTo((Object)"anActivityId"), new Object[0]).body("activityName", CoreMatchers.equalTo((Object)"anActivityName"), new Object[0]).body("activityType", CoreMatchers.equalTo((Object)"anActivityType"), new Object[0]).body("activityDescription", CoreMatchers.equalTo((Object)"anActivityDescription"), new Object[0]).body("tenantId", CoreMatchers.equalTo((Object)"aTenantId"), new Object[0]).body("required", CoreMatchers.equalTo((Object)true), new Object[0]).body("active", CoreMatchers.equalTo((Object)true), new Object[0]).body("enabled", CoreMatchers.equalTo((Object)true), new Object[0]).body("disabled", CoreMatchers.equalTo((Object)true), new Object[0]).when().get(SINGLE_CASE_EXECUTION_URL, new Object[0]);
        ((CaseService)Mockito.verify((Object)this.caseServiceMock)).createCaseExecutionQuery();
        ((CaseExecutionQuery)Mockito.verify((Object)this.caseExecutionQueryMock)).caseExecutionId("aCaseExecutionId");
        ((CaseExecutionQuery)Mockito.verify((Object)this.caseExecutionQueryMock)).singleResult();
    }

    @Test
    public void testManualStart() {
        RestAssured.given().pathParam("id", (Object)"aCaseExecutionId").contentType(ContentType.JSON).body("{}").then().expect().statusCode(Response.Status.NO_CONTENT.getStatusCode()).when().post(CASE_EXECUTION_MANUAL_START_URL, new Object[0]);
        ((CaseService)Mockito.verify((Object)this.caseServiceMock)).withCaseExecution("aCaseExecutionId");
        ((CaseExecutionCommandBuilder)Mockito.verify((Object)this.caseExecutionCommandBuilderMock)).manualStart();
    }

    @Test
    public void testUnsuccessfulManualStart() {
        ((CaseExecutionCommandBuilder)Mockito.doThrow((Throwable[])new Throwable[]{new NotValidException("expected exception")}).when((Object)this.caseExecutionCommandBuilderMock)).manualStart();
        RestAssured.given().pathParam("id", (Object)"aCaseExecutionId").contentType(ContentType.JSON).body("{}").then().expect().statusCode(Response.Status.BAD_REQUEST.getStatusCode()).body("type", CoreMatchers.equalTo((Object)InvalidRequestException.class.getSimpleName()), new Object[0]).body("message", Matchers.containsString((String)"Cannot manualStart case execution aCaseExecutionId: expected exception"), new Object[0]).when().post(CASE_EXECUTION_MANUAL_START_URL, new Object[0]);
        ((CaseService)Mockito.verify((Object)this.caseServiceMock)).withCaseExecution("aCaseExecutionId");
        ((CaseExecutionCommandBuilder)Mockito.verify((Object)this.caseExecutionCommandBuilderMock)).manualStart();
    }

    @Test
    public void testManualStartWithSetVariable() {
        String aVariableKey = "aKey";
        int aVariableValue = 123;
        String anotherVariableKey = "anotherKey";
        String anotherVariableValue = "abc";
        HashMap<String, Map<String, Object>> variablesJson = new HashMap<String, Map<String, Object>>();
        Map<String, Object> variables = VariablesBuilder.create().variable(aVariableKey, (Object)aVariableValue, "Integer").variable(anotherVariableKey, (Object)anotherVariableValue, "String").getVariables();
        variablesJson.put("variables", variables);
        RestAssured.given().pathParam("id", (Object)"aCaseExecutionId").contentType(ContentType.JSON).body(variablesJson).then().expect().statusCode(Response.Status.NO_CONTENT.getStatusCode()).when().post(CASE_EXECUTION_MANUAL_START_URL, new Object[0]);
        ((CaseService)Mockito.verify((Object)this.caseServiceMock)).withCaseExecution("aCaseExecutionId");
        ((CaseExecutionCommandBuilder)Mockito.verify((Object)this.caseExecutionCommandBuilderMock)).setVariable((String)Mockito.eq((Object)aVariableKey), MockitoHamcrest.argThat((Matcher)EqualsPrimitiveValue.integerValue(aVariableValue)));
        ((CaseExecutionCommandBuilder)Mockito.verify((Object)this.caseExecutionCommandBuilderMock)).setVariable((String)Mockito.eq((Object)anotherVariableKey), MockitoHamcrest.argThat((Matcher)EqualsPrimitiveValue.stringValue(anotherVariableValue)));
        ((CaseExecutionCommandBuilder)Mockito.verify((Object)this.caseExecutionCommandBuilderMock)).manualStart();
    }

    @Test
    public void testManualStartWithSetVariableLocal() {
        String aVariableKey = "aKey";
        int aVariableValue = 123;
        String anotherVariableKey = "anotherKey";
        String anotherVariableValue = "abc";
        HashMap<String, Map<String, Object>> variablesJson = new HashMap<String, Map<String, Object>>();
        Map<String, Object> variables = VariablesBuilder.create().variable(aVariableKey, aVariableValue, "Integer", true).variable(anotherVariableKey, anotherVariableValue, "String", true).getVariables();
        variablesJson.put("variables", variables);
        RestAssured.given().pathParam("id", (Object)"aCaseExecutionId").contentType(ContentType.JSON).body(variablesJson).then().expect().statusCode(Response.Status.NO_CONTENT.getStatusCode()).when().post(CASE_EXECUTION_MANUAL_START_URL, new Object[0]);
        ((CaseService)Mockito.verify((Object)this.caseServiceMock)).withCaseExecution("aCaseExecutionId");
        ((CaseExecutionCommandBuilder)Mockito.verify((Object)this.caseExecutionCommandBuilderMock)).setVariableLocal((String)Mockito.eq((Object)aVariableKey), MockitoHamcrest.argThat((Matcher)EqualsPrimitiveValue.integerValue(aVariableValue)));
        ((CaseExecutionCommandBuilder)Mockito.verify((Object)this.caseExecutionCommandBuilderMock)).setVariableLocal((String)Mockito.eq((Object)anotherVariableKey), MockitoHamcrest.argThat((Matcher)EqualsPrimitiveValue.stringValue(anotherVariableValue)));
        ((CaseExecutionCommandBuilder)Mockito.verify((Object)this.caseExecutionCommandBuilderMock)).manualStart();
    }

    @Test
    public void testManualStartWithSetVariableAndVariableLocal() {
        String aVariableKey = "aKey";
        int aVariableValue = 123;
        String anotherVariableKey = "anotherKey";
        String anotherVariableValue = "abc";
        HashMap<String, Map<String, Object>> variablesJson = new HashMap<String, Map<String, Object>>();
        Map<String, Object> variables = VariablesBuilder.create().variable(aVariableKey, (Object)aVariableValue, "Integer").variable(anotherVariableKey, anotherVariableValue, "String", true).getVariables();
        variablesJson.put("variables", variables);
        RestAssured.given().pathParam("id", (Object)"aCaseExecutionId").contentType(ContentType.JSON).body(variablesJson).then().expect().statusCode(Response.Status.NO_CONTENT.getStatusCode()).when().post(CASE_EXECUTION_MANUAL_START_URL, new Object[0]);
        ((CaseService)Mockito.verify((Object)this.caseServiceMock)).withCaseExecution("aCaseExecutionId");
        ((CaseExecutionCommandBuilder)Mockito.verify((Object)this.caseExecutionCommandBuilderMock)).setVariable((String)Mockito.eq((Object)aVariableKey), MockitoHamcrest.argThat((Matcher)EqualsPrimitiveValue.integerValue(aVariableValue)));
        ((CaseExecutionCommandBuilder)Mockito.verify((Object)this.caseExecutionCommandBuilderMock)).setVariableLocal((String)Mockito.eq((Object)anotherVariableKey), MockitoHamcrest.argThat((Matcher)EqualsPrimitiveValue.stringValue(anotherVariableValue)));
        ((CaseExecutionCommandBuilder)Mockito.verify((Object)this.caseExecutionCommandBuilderMock)).manualStart();
    }

    @Test
    public void testManualStartWithRemoveVariable() {
        String aVariableKey = "aKey";
        String anotherVariableKey = "anotherKey";
        ArrayList<VariableNameDto> variableNames = new ArrayList<VariableNameDto>();
        VariableNameDto firstVariableName = new VariableNameDto(aVariableKey);
        variableNames.add(firstVariableName);
        VariableNameDto secondVariableName = new VariableNameDto(anotherVariableKey);
        variableNames.add(secondVariableName);
        HashMap<String, ArrayList<VariableNameDto>> variablesJson = new HashMap<String, ArrayList<VariableNameDto>>();
        variablesJson.put("deletions", variableNames);
        RestAssured.given().pathParam("id", (Object)"aCaseExecutionId").contentType(ContentType.JSON).body(variablesJson).then().expect().statusCode(Response.Status.NO_CONTENT.getStatusCode()).when().post(CASE_EXECUTION_MANUAL_START_URL, new Object[0]);
        ((CaseService)Mockito.verify((Object)this.caseServiceMock)).withCaseExecution("aCaseExecutionId");
        ((CaseExecutionCommandBuilder)Mockito.verify((Object)this.caseExecutionCommandBuilderMock)).removeVariable(aVariableKey);
        ((CaseExecutionCommandBuilder)Mockito.verify((Object)this.caseExecutionCommandBuilderMock)).removeVariable(anotherVariableKey);
        ((CaseExecutionCommandBuilder)Mockito.verify((Object)this.caseExecutionCommandBuilderMock)).manualStart();
    }

    @Test
    public void testManualStartWithRemoveVariableLocal() {
        String aVariableKey = "aKey";
        String anotherVariableKey = "anotherKey";
        ArrayList<VariableNameDto> variableNames = new ArrayList<VariableNameDto>();
        VariableNameDto firstVariableName = new VariableNameDto(aVariableKey, true);
        variableNames.add(firstVariableName);
        VariableNameDto secondVariableName = new VariableNameDto(anotherVariableKey, true);
        variableNames.add(secondVariableName);
        HashMap<String, ArrayList<VariableNameDto>> variablesJson = new HashMap<String, ArrayList<VariableNameDto>>();
        variablesJson.put("deletions", variableNames);
        RestAssured.given().pathParam("id", (Object)"aCaseExecutionId").contentType(ContentType.JSON).body(variablesJson).then().expect().statusCode(Response.Status.NO_CONTENT.getStatusCode()).when().post(CASE_EXECUTION_MANUAL_START_URL, new Object[0]);
        ((CaseService)Mockito.verify((Object)this.caseServiceMock)).withCaseExecution("aCaseExecutionId");
        ((CaseExecutionCommandBuilder)Mockito.verify((Object)this.caseExecutionCommandBuilderMock)).removeVariableLocal(aVariableKey);
        ((CaseExecutionCommandBuilder)Mockito.verify((Object)this.caseExecutionCommandBuilderMock)).removeVariableLocal(anotherVariableKey);
        ((CaseExecutionCommandBuilder)Mockito.verify((Object)this.caseExecutionCommandBuilderMock)).manualStart();
    }

    @Test
    public void testManualStartWithRemoveVariableAndVariableLocal() {
        String aVariableKey = "aKey";
        String anotherVariableKey = "anotherKey";
        ArrayList<VariableNameDto> variableNames = new ArrayList<VariableNameDto>();
        VariableNameDto firstVariableName = new VariableNameDto(aVariableKey, true);
        variableNames.add(firstVariableName);
        VariableNameDto secondVariableName = new VariableNameDto(anotherVariableKey);
        variableNames.add(secondVariableName);
        HashMap<String, ArrayList<VariableNameDto>> variablesJson = new HashMap<String, ArrayList<VariableNameDto>>();
        variablesJson.put("deletions", variableNames);
        RestAssured.given().pathParam("id", (Object)"aCaseExecutionId").contentType(ContentType.JSON).body(variablesJson).then().expect().statusCode(Response.Status.NO_CONTENT.getStatusCode()).when().post(CASE_EXECUTION_MANUAL_START_URL, new Object[0]);
        ((CaseService)Mockito.verify((Object)this.caseServiceMock)).withCaseExecution("aCaseExecutionId");
        ((CaseExecutionCommandBuilder)Mockito.verify((Object)this.caseExecutionCommandBuilderMock)).removeVariableLocal(aVariableKey);
        ((CaseExecutionCommandBuilder)Mockito.verify((Object)this.caseExecutionCommandBuilderMock)).removeVariable(anotherVariableKey);
        ((CaseExecutionCommandBuilder)Mockito.verify((Object)this.caseExecutionCommandBuilderMock)).manualStart();
    }

    @Test
    public void testManualStartWithSetVariableAndRemoveVariable() {
        String aVariableKey = "aKey";
        String anotherVariableKey = "anotherKey";
        String anotherVariableValue = "abc";
        Map<String, Object> variables = VariablesBuilder.create().variable(anotherVariableKey, (Object)anotherVariableValue, "String").getVariables();
        ArrayList<VariableNameDto> variableNames = new ArrayList<VariableNameDto>();
        VariableNameDto firstVariableName = new VariableNameDto(aVariableKey);
        variableNames.add(firstVariableName);
        HashMap<String, Object> variablesJson = new HashMap<String, Object>();
        variablesJson.put("variables", variables);
        variablesJson.put("deletions", variableNames);
        RestAssured.given().pathParam("id", (Object)"aCaseExecutionId").contentType(ContentType.JSON).body(variablesJson).then().expect().statusCode(Response.Status.NO_CONTENT.getStatusCode()).when().post(CASE_EXECUTION_MANUAL_START_URL, new Object[0]);
        ((CaseService)Mockito.verify((Object)this.caseServiceMock)).withCaseExecution("aCaseExecutionId");
        ((CaseExecutionCommandBuilder)Mockito.verify((Object)this.caseExecutionCommandBuilderMock)).removeVariable(aVariableKey);
        ((CaseExecutionCommandBuilder)Mockito.verify((Object)this.caseExecutionCommandBuilderMock)).setVariable((String)Mockito.eq((Object)anotherVariableKey), MockitoHamcrest.argThat((Matcher)EqualsPrimitiveValue.stringValue(anotherVariableValue)));
        ((CaseExecutionCommandBuilder)Mockito.verify((Object)this.caseExecutionCommandBuilderMock)).manualStart();
    }

    @Test
    public void testManualStartWithSetVariableAndRemoveVariableLocal() {
        String aVariableKey = "aKey";
        String anotherVariableKey = "anotherKey";
        String anotherVariableValue = "abc";
        Map<String, Object> variables = VariablesBuilder.create().variable(anotherVariableKey, (Object)anotherVariableValue, "String").getVariables();
        ArrayList<VariableNameDto> variableNames = new ArrayList<VariableNameDto>();
        VariableNameDto firstVariableName = new VariableNameDto(aVariableKey, true);
        variableNames.add(firstVariableName);
        HashMap<String, Object> variablesJson = new HashMap<String, Object>();
        variablesJson.put("variables", variables);
        variablesJson.put("deletions", variableNames);
        RestAssured.given().pathParam("id", (Object)"aCaseExecutionId").contentType(ContentType.JSON).body(variablesJson).then().expect().statusCode(Response.Status.NO_CONTENT.getStatusCode()).when().post(CASE_EXECUTION_MANUAL_START_URL, new Object[0]);
        ((CaseService)Mockito.verify((Object)this.caseServiceMock)).withCaseExecution("aCaseExecutionId");
        ((CaseExecutionCommandBuilder)Mockito.verify((Object)this.caseExecutionCommandBuilderMock)).removeVariableLocal(aVariableKey);
        ((CaseExecutionCommandBuilder)Mockito.verify((Object)this.caseExecutionCommandBuilderMock)).setVariable((String)Mockito.eq((Object)anotherVariableKey), MockitoHamcrest.argThat((Matcher)EqualsPrimitiveValue.stringValue(anotherVariableValue)));
        ((CaseExecutionCommandBuilder)Mockito.verify((Object)this.caseExecutionCommandBuilderMock)).manualStart();
    }

    @Test
    public void testManualStartWithSetVariableLocalAndRemoveVariable() {
        String aVariableKey = "aKey";
        String anotherVariableKey = "anotherKey";
        String anotherVariableValue = "abc";
        Map<String, Object> variables = VariablesBuilder.create().variable(anotherVariableKey, anotherVariableValue, "String", true).getVariables();
        ArrayList<VariableNameDto> variableNames = new ArrayList<VariableNameDto>();
        VariableNameDto firstVariableName = new VariableNameDto(aVariableKey);
        variableNames.add(firstVariableName);
        HashMap<String, Object> variablesJson = new HashMap<String, Object>();
        variablesJson.put("variables", variables);
        variablesJson.put("deletions", variableNames);
        RestAssured.given().pathParam("id", (Object)"aCaseExecutionId").contentType(ContentType.JSON).body(variablesJson).then().expect().statusCode(Response.Status.NO_CONTENT.getStatusCode()).when().post(CASE_EXECUTION_MANUAL_START_URL, new Object[0]);
        ((CaseService)Mockito.verify((Object)this.caseServiceMock)).withCaseExecution("aCaseExecutionId");
        ((CaseExecutionCommandBuilder)Mockito.verify((Object)this.caseExecutionCommandBuilderMock)).removeVariable(aVariableKey);
        ((CaseExecutionCommandBuilder)Mockito.verify((Object)this.caseExecutionCommandBuilderMock)).setVariableLocal((String)Mockito.eq((Object)anotherVariableKey), MockitoHamcrest.argThat((Matcher)EqualsPrimitiveValue.stringValue(anotherVariableValue)));
        ((CaseExecutionCommandBuilder)Mockito.verify((Object)this.caseExecutionCommandBuilderMock)).manualStart();
    }

    @Test
    public void testManualStartWithSetVariableLocalAndRemoveVariableLocal() {
        String aVariableKey = "aKey";
        String anotherVariableKey = "anotherKey";
        String anotherVariableValue = "abc";
        Map<String, Object> variables = VariablesBuilder.create().variable(anotherVariableKey, anotherVariableValue, "String", true).getVariables();
        ArrayList<VariableNameDto> variableNames = new ArrayList<VariableNameDto>();
        VariableNameDto firstVariableName = new VariableNameDto(aVariableKey, true);
        variableNames.add(firstVariableName);
        HashMap<String, Object> variablesJson = new HashMap<String, Object>();
        variablesJson.put("variables", variables);
        variablesJson.put("deletions", variableNames);
        RestAssured.given().pathParam("id", (Object)"aCaseExecutionId").contentType(ContentType.JSON).body(variablesJson).then().expect().statusCode(Response.Status.NO_CONTENT.getStatusCode()).when().post(CASE_EXECUTION_MANUAL_START_URL, new Object[0]);
        ((CaseService)Mockito.verify((Object)this.caseServiceMock)).withCaseExecution("aCaseExecutionId");
        ((CaseExecutionCommandBuilder)Mockito.verify((Object)this.caseExecutionCommandBuilderMock)).removeVariableLocal(aVariableKey);
        ((CaseExecutionCommandBuilder)Mockito.verify((Object)this.caseExecutionCommandBuilderMock)).setVariableLocal((String)Mockito.eq((Object)anotherVariableKey), MockitoHamcrest.argThat((Matcher)EqualsPrimitiveValue.stringValue(anotherVariableValue)));
        ((CaseExecutionCommandBuilder)Mockito.verify((Object)this.caseExecutionCommandBuilderMock)).manualStart();
    }

    @Test
    public void testDisable() {
        RestAssured.given().pathParam("id", (Object)"aCaseExecutionId").contentType(ContentType.JSON).body("{}").then().expect().statusCode(Response.Status.NO_CONTENT.getStatusCode()).when().post(CASE_EXECUTION_DISABLE_URL, new Object[0]);
        ((CaseService)Mockito.verify((Object)this.caseServiceMock)).withCaseExecution("aCaseExecutionId");
        ((CaseExecutionCommandBuilder)Mockito.verify((Object)this.caseExecutionCommandBuilderMock)).disable();
    }

    @Test
    public void testUnsuccessfulDisable() {
        ((CaseExecutionCommandBuilder)Mockito.doThrow((Throwable[])new Throwable[]{new NotValidException("expected exception")}).when((Object)this.caseExecutionCommandBuilderMock)).disable();
        RestAssured.given().pathParam("id", (Object)"aCaseExecutionId").contentType(ContentType.JSON).body("{}").then().expect().statusCode(Response.Status.BAD_REQUEST.getStatusCode()).body("type", CoreMatchers.equalTo((Object)InvalidRequestException.class.getSimpleName()), new Object[0]).body("message", Matchers.containsString((String)"Cannot disable case execution aCaseExecutionId: expected exception"), new Object[0]).when().post(CASE_EXECUTION_DISABLE_URL, new Object[0]);
        ((CaseService)Mockito.verify((Object)this.caseServiceMock)).withCaseExecution("aCaseExecutionId");
        ((CaseExecutionCommandBuilder)Mockito.verify((Object)this.caseExecutionCommandBuilderMock)).disable();
    }

    @Test
    public void testDisableWithSetVariable() {
        String aVariableKey = "aKey";
        int aVariableValue = 123;
        String anotherVariableKey = "anotherKey";
        String anotherVariableValue = "abc";
        HashMap<String, Map<String, Object>> variablesJson = new HashMap<String, Map<String, Object>>();
        Map<String, Object> variables = VariablesBuilder.create().variable(aVariableKey, (Object)aVariableValue, "Integer").variable(anotherVariableKey, (Object)anotherVariableValue, "String").getVariables();
        variablesJson.put("variables", variables);
        RestAssured.given().pathParam("id", (Object)"aCaseExecutionId").contentType(ContentType.JSON).body(variablesJson).then().expect().statusCode(Response.Status.NO_CONTENT.getStatusCode()).when().post(CASE_EXECUTION_DISABLE_URL, new Object[0]);
        ((CaseService)Mockito.verify((Object)this.caseServiceMock)).withCaseExecution("aCaseExecutionId");
        ((CaseExecutionCommandBuilder)Mockito.verify((Object)this.caseExecutionCommandBuilderMock)).setVariable((String)Mockito.eq((Object)aVariableKey), MockitoHamcrest.argThat((Matcher)EqualsPrimitiveValue.integerValue(aVariableValue)));
        ((CaseExecutionCommandBuilder)Mockito.verify((Object)this.caseExecutionCommandBuilderMock)).setVariable((String)Mockito.eq((Object)anotherVariableKey), MockitoHamcrest.argThat((Matcher)EqualsPrimitiveValue.stringValue(anotherVariableValue)));
        ((CaseExecutionCommandBuilder)Mockito.verify((Object)this.caseExecutionCommandBuilderMock)).disable();
    }

    @Test
    public void testDisableWithSetVariableLocal() {
        String aVariableKey = "aKey";
        int aVariableValue = 123;
        String anotherVariableKey = "anotherKey";
        String anotherVariableValue = "abc";
        HashMap<String, Map<String, Object>> variablesJson = new HashMap<String, Map<String, Object>>();
        Map<String, Object> variables = VariablesBuilder.create().variable(aVariableKey, aVariableValue, "Integer", true).variable(anotherVariableKey, anotherVariableValue, "String", true).getVariables();
        variablesJson.put("variables", variables);
        RestAssured.given().pathParam("id", (Object)"aCaseExecutionId").contentType(ContentType.JSON).body(variablesJson).then().expect().statusCode(Response.Status.NO_CONTENT.getStatusCode()).when().post(CASE_EXECUTION_DISABLE_URL, new Object[0]);
        ((CaseService)Mockito.verify((Object)this.caseServiceMock)).withCaseExecution("aCaseExecutionId");
        ((CaseExecutionCommandBuilder)Mockito.verify((Object)this.caseExecutionCommandBuilderMock)).setVariableLocal((String)Mockito.eq((Object)aVariableKey), MockitoHamcrest.argThat((Matcher)EqualsPrimitiveValue.integerValue(aVariableValue)));
        ((CaseExecutionCommandBuilder)Mockito.verify((Object)this.caseExecutionCommandBuilderMock)).setVariableLocal((String)Mockito.eq((Object)anotherVariableKey), MockitoHamcrest.argThat((Matcher)EqualsPrimitiveValue.stringValue(anotherVariableValue)));
        ((CaseExecutionCommandBuilder)Mockito.verify((Object)this.caseExecutionCommandBuilderMock)).disable();
    }

    @Test
    public void testDisableWithSetVariableAndVariableLocal() {
        String aVariableKey = "aKey";
        int aVariableValue = 123;
        String anotherVariableKey = "anotherKey";
        String anotherVariableValue = "abc";
        HashMap<String, Map<String, Object>> variablesJson = new HashMap<String, Map<String, Object>>();
        Map<String, Object> variables = VariablesBuilder.create().variable(aVariableKey, (Object)aVariableValue, "Integer").variable(anotherVariableKey, anotherVariableValue, "String", true).getVariables();
        variablesJson.put("variables", variables);
        RestAssured.given().pathParam("id", (Object)"aCaseExecutionId").contentType(ContentType.JSON).body(variablesJson).then().expect().statusCode(Response.Status.NO_CONTENT.getStatusCode()).when().post(CASE_EXECUTION_DISABLE_URL, new Object[0]);
        ((CaseService)Mockito.verify((Object)this.caseServiceMock)).withCaseExecution("aCaseExecutionId");
        ((CaseExecutionCommandBuilder)Mockito.verify((Object)this.caseExecutionCommandBuilderMock)).setVariable((String)Mockito.eq((Object)aVariableKey), MockitoHamcrest.argThat((Matcher)EqualsPrimitiveValue.integerValue(aVariableValue)));
        ((CaseExecutionCommandBuilder)Mockito.verify((Object)this.caseExecutionCommandBuilderMock)).setVariableLocal((String)Mockito.eq((Object)anotherVariableKey), MockitoHamcrest.argThat((Matcher)EqualsPrimitiveValue.stringValue(anotherVariableValue)));
        ((CaseExecutionCommandBuilder)Mockito.verify((Object)this.caseExecutionCommandBuilderMock)).disable();
    }

    @Test
    public void testDisableWithRemoveVariable() {
        String aVariableKey = "aKey";
        String anotherVariableKey = "anotherKey";
        ArrayList<VariableNameDto> variableNames = new ArrayList<VariableNameDto>();
        VariableNameDto firstVariableName = new VariableNameDto(aVariableKey);
        variableNames.add(firstVariableName);
        VariableNameDto secondVariableName = new VariableNameDto(anotherVariableKey);
        variableNames.add(secondVariableName);
        HashMap<String, ArrayList<VariableNameDto>> variablesJson = new HashMap<String, ArrayList<VariableNameDto>>();
        variablesJson.put("deletions", variableNames);
        RestAssured.given().pathParam("id", (Object)"aCaseExecutionId").contentType(ContentType.JSON).body(variablesJson).then().expect().statusCode(Response.Status.NO_CONTENT.getStatusCode()).when().post(CASE_EXECUTION_DISABLE_URL, new Object[0]);
        ((CaseService)Mockito.verify((Object)this.caseServiceMock)).withCaseExecution("aCaseExecutionId");
        ((CaseExecutionCommandBuilder)Mockito.verify((Object)this.caseExecutionCommandBuilderMock)).removeVariable(aVariableKey);
        ((CaseExecutionCommandBuilder)Mockito.verify((Object)this.caseExecutionCommandBuilderMock)).removeVariable(anotherVariableKey);
        ((CaseExecutionCommandBuilder)Mockito.verify((Object)this.caseExecutionCommandBuilderMock)).disable();
    }

    @Test
    public void testDisableWithRemoveVariableLocal() {
        String aVariableKey = "aKey";
        String anotherVariableKey = "anotherKey";
        ArrayList<VariableNameDto> variableNames = new ArrayList<VariableNameDto>();
        VariableNameDto firstVariableName = new VariableNameDto(aVariableKey, true);
        variableNames.add(firstVariableName);
        VariableNameDto secondVariableName = new VariableNameDto(anotherVariableKey, true);
        variableNames.add(secondVariableName);
        HashMap<String, ArrayList<VariableNameDto>> variablesJson = new HashMap<String, ArrayList<VariableNameDto>>();
        variablesJson.put("deletions", variableNames);
        RestAssured.given().pathParam("id", (Object)"aCaseExecutionId").contentType(ContentType.JSON).body(variablesJson).then().expect().statusCode(Response.Status.NO_CONTENT.getStatusCode()).when().post(CASE_EXECUTION_DISABLE_URL, new Object[0]);
        ((CaseService)Mockito.verify((Object)this.caseServiceMock)).withCaseExecution("aCaseExecutionId");
        ((CaseExecutionCommandBuilder)Mockito.verify((Object)this.caseExecutionCommandBuilderMock)).removeVariableLocal(aVariableKey);
        ((CaseExecutionCommandBuilder)Mockito.verify((Object)this.caseExecutionCommandBuilderMock)).removeVariableLocal(anotherVariableKey);
        ((CaseExecutionCommandBuilder)Mockito.verify((Object)this.caseExecutionCommandBuilderMock)).disable();
    }

    @Test
    public void testDisableWithRemoveVariableAndVariableLocal() {
        String aVariableKey = "aKey";
        String anotherVariableKey = "anotherKey";
        ArrayList<VariableNameDto> variableNames = new ArrayList<VariableNameDto>();
        VariableNameDto firstVariableName = new VariableNameDto(aVariableKey, true);
        variableNames.add(firstVariableName);
        VariableNameDto secondVariableName = new VariableNameDto(anotherVariableKey);
        variableNames.add(secondVariableName);
        HashMap<String, ArrayList<VariableNameDto>> variablesJson = new HashMap<String, ArrayList<VariableNameDto>>();
        variablesJson.put("deletions", variableNames);
        RestAssured.given().pathParam("id", (Object)"aCaseExecutionId").contentType(ContentType.JSON).body(variablesJson).then().expect().statusCode(Response.Status.NO_CONTENT.getStatusCode()).when().post(CASE_EXECUTION_DISABLE_URL, new Object[0]);
        ((CaseService)Mockito.verify((Object)this.caseServiceMock)).withCaseExecution("aCaseExecutionId");
        ((CaseExecutionCommandBuilder)Mockito.verify((Object)this.caseExecutionCommandBuilderMock)).removeVariableLocal(aVariableKey);
        ((CaseExecutionCommandBuilder)Mockito.verify((Object)this.caseExecutionCommandBuilderMock)).removeVariable(anotherVariableKey);
        ((CaseExecutionCommandBuilder)Mockito.verify((Object)this.caseExecutionCommandBuilderMock)).disable();
    }

    @Test
    public void testDisableWithSetVariableAndRemoveVariable() {
        String aVariableKey = "aKey";
        String anotherVariableKey = "anotherKey";
        String anotherVariableValue = "abc";
        Map<String, Object> variables = VariablesBuilder.create().variable(anotherVariableKey, (Object)anotherVariableValue, "String").getVariables();
        ArrayList<VariableNameDto> variableNames = new ArrayList<VariableNameDto>();
        VariableNameDto firstVariableName = new VariableNameDto(aVariableKey);
        variableNames.add(firstVariableName);
        HashMap<String, Object> variablesJson = new HashMap<String, Object>();
        variablesJson.put("variables", variables);
        variablesJson.put("deletions", variableNames);
        RestAssured.given().pathParam("id", (Object)"aCaseExecutionId").contentType(ContentType.JSON).body(variablesJson).then().expect().statusCode(Response.Status.NO_CONTENT.getStatusCode()).when().post(CASE_EXECUTION_DISABLE_URL, new Object[0]);
        ((CaseService)Mockito.verify((Object)this.caseServiceMock)).withCaseExecution("aCaseExecutionId");
        ((CaseExecutionCommandBuilder)Mockito.verify((Object)this.caseExecutionCommandBuilderMock)).removeVariable(aVariableKey);
        ((CaseExecutionCommandBuilder)Mockito.verify((Object)this.caseExecutionCommandBuilderMock)).setVariable((String)Mockito.eq((Object)anotherVariableKey), MockitoHamcrest.argThat((Matcher)EqualsPrimitiveValue.stringValue(anotherVariableValue)));
        ((CaseExecutionCommandBuilder)Mockito.verify((Object)this.caseExecutionCommandBuilderMock)).disable();
    }

    @Test
    public void testDisableWithSetVariableAndRemoveVariableLocal() {
        String aVariableKey = "aKey";
        String anotherVariableKey = "anotherKey";
        String anotherVariableValue = "abc";
        Map<String, Object> variables = VariablesBuilder.create().variable(anotherVariableKey, (Object)anotherVariableValue, "String").getVariables();
        ArrayList<VariableNameDto> variableNames = new ArrayList<VariableNameDto>();
        VariableNameDto firstVariableName = new VariableNameDto(aVariableKey, true);
        variableNames.add(firstVariableName);
        HashMap<String, Object> variablesJson = new HashMap<String, Object>();
        variablesJson.put("variables", variables);
        variablesJson.put("deletions", variableNames);
        RestAssured.given().pathParam("id", (Object)"aCaseExecutionId").contentType(ContentType.JSON).body(variablesJson).then().expect().statusCode(Response.Status.NO_CONTENT.getStatusCode()).when().post(CASE_EXECUTION_DISABLE_URL, new Object[0]);
        ((CaseService)Mockito.verify((Object)this.caseServiceMock)).withCaseExecution("aCaseExecutionId");
        ((CaseExecutionCommandBuilder)Mockito.verify((Object)this.caseExecutionCommandBuilderMock)).removeVariableLocal(aVariableKey);
        ((CaseExecutionCommandBuilder)Mockito.verify((Object)this.caseExecutionCommandBuilderMock)).setVariable((String)Mockito.eq((Object)anotherVariableKey), MockitoHamcrest.argThat((Matcher)EqualsPrimitiveValue.stringValue(anotherVariableValue)));
        ((CaseExecutionCommandBuilder)Mockito.verify((Object)this.caseExecutionCommandBuilderMock)).disable();
    }

    @Test
    public void testDisableWithSetVariableLocalAndRemoveVariable() {
        String aVariableKey = "aKey";
        String anotherVariableKey = "anotherKey";
        String anotherVariableValue = "abc";
        Map<String, Object> variables = VariablesBuilder.create().variable(anotherVariableKey, anotherVariableValue, "String", true).getVariables();
        ArrayList<VariableNameDto> variableNames = new ArrayList<VariableNameDto>();
        VariableNameDto firstVariableName = new VariableNameDto(aVariableKey);
        variableNames.add(firstVariableName);
        HashMap<String, Object> variablesJson = new HashMap<String, Object>();
        variablesJson.put("variables", variables);
        variablesJson.put("deletions", variableNames);
        RestAssured.given().pathParam("id", (Object)"aCaseExecutionId").contentType(ContentType.JSON).body(variablesJson).then().expect().statusCode(Response.Status.NO_CONTENT.getStatusCode()).when().post(CASE_EXECUTION_DISABLE_URL, new Object[0]);
        ((CaseService)Mockito.verify((Object)this.caseServiceMock)).withCaseExecution("aCaseExecutionId");
        ((CaseExecutionCommandBuilder)Mockito.verify((Object)this.caseExecutionCommandBuilderMock)).removeVariable(aVariableKey);
        ((CaseExecutionCommandBuilder)Mockito.verify((Object)this.caseExecutionCommandBuilderMock)).setVariableLocal((String)Mockito.eq((Object)anotherVariableKey), MockitoHamcrest.argThat((Matcher)EqualsPrimitiveValue.stringValue(anotherVariableValue)));
        ((CaseExecutionCommandBuilder)Mockito.verify((Object)this.caseExecutionCommandBuilderMock)).disable();
    }

    @Test
    public void testDisableWithSetVariableLocalAndRemoveVariableLocal() {
        String aVariableKey = "aKey";
        String anotherVariableKey = "anotherKey";
        String anotherVariableValue = "abc";
        Map<String, Object> variables = VariablesBuilder.create().variable(anotherVariableKey, anotherVariableValue, "String", true).getVariables();
        ArrayList<VariableNameDto> variableNames = new ArrayList<VariableNameDto>();
        VariableNameDto firstVariableName = new VariableNameDto(aVariableKey, true);
        variableNames.add(firstVariableName);
        HashMap<String, Object> variablesJson = new HashMap<String, Object>();
        variablesJson.put("variables", variables);
        variablesJson.put("deletions", variableNames);
        RestAssured.given().pathParam("id", (Object)"aCaseExecutionId").contentType(ContentType.JSON).body(variablesJson).then().expect().statusCode(Response.Status.NO_CONTENT.getStatusCode()).when().post(CASE_EXECUTION_DISABLE_URL, new Object[0]);
        ((CaseService)Mockito.verify((Object)this.caseServiceMock)).withCaseExecution("aCaseExecutionId");
        ((CaseExecutionCommandBuilder)Mockito.verify((Object)this.caseExecutionCommandBuilderMock)).removeVariableLocal(aVariableKey);
        ((CaseExecutionCommandBuilder)Mockito.verify((Object)this.caseExecutionCommandBuilderMock)).setVariableLocal((String)Mockito.eq((Object)anotherVariableKey), MockitoHamcrest.argThat((Matcher)EqualsPrimitiveValue.stringValue(anotherVariableValue)));
        ((CaseExecutionCommandBuilder)Mockito.verify((Object)this.caseExecutionCommandBuilderMock)).disable();
    }

    @Test
    public void testReenable() {
        RestAssured.given().pathParam("id", (Object)"aCaseExecutionId").contentType(ContentType.JSON).body("{}").then().expect().statusCode(Response.Status.NO_CONTENT.getStatusCode()).when().post(CASE_EXECUTION_REENABLE_URL, new Object[0]);
        ((CaseService)Mockito.verify((Object)this.caseServiceMock)).withCaseExecution("aCaseExecutionId");
        ((CaseExecutionCommandBuilder)Mockito.verify((Object)this.caseExecutionCommandBuilderMock)).reenable();
    }

    @Test
    public void testUnsuccessfulReenable() {
        ((CaseExecutionCommandBuilder)Mockito.doThrow((Throwable[])new Throwable[]{new NotValidException("expected exception")}).when((Object)this.caseExecutionCommandBuilderMock)).reenable();
        RestAssured.given().pathParam("id", (Object)"aCaseExecutionId").contentType(ContentType.JSON).body("{}").then().expect().statusCode(Response.Status.BAD_REQUEST.getStatusCode()).body("type", CoreMatchers.equalTo((Object)InvalidRequestException.class.getSimpleName()), new Object[0]).body("message", Matchers.containsString((String)"Cannot reenable case execution aCaseExecutionId: expected exception"), new Object[0]).when().post(CASE_EXECUTION_REENABLE_URL, new Object[0]);
        ((CaseService)Mockito.verify((Object)this.caseServiceMock)).withCaseExecution("aCaseExecutionId");
        ((CaseExecutionCommandBuilder)Mockito.verify((Object)this.caseExecutionCommandBuilderMock)).reenable();
    }

    @Test
    public void testReenableWithSetVariable() {
        String aVariableKey = "aKey";
        int aVariableValue = 123;
        String anotherVariableKey = "anotherKey";
        String anotherVariableValue = "abc";
        HashMap<String, Map<String, Object>> variablesJson = new HashMap<String, Map<String, Object>>();
        Map<String, Object> variables = VariablesBuilder.create().variable(aVariableKey, (Object)aVariableValue, "Integer").variable(anotherVariableKey, (Object)anotherVariableValue, "String").getVariables();
        variablesJson.put("variables", variables);
        RestAssured.given().pathParam("id", (Object)"aCaseExecutionId").contentType(ContentType.JSON).body(variablesJson).then().expect().statusCode(Response.Status.NO_CONTENT.getStatusCode()).when().post(CASE_EXECUTION_REENABLE_URL, new Object[0]);
        ((CaseService)Mockito.verify((Object)this.caseServiceMock)).withCaseExecution("aCaseExecutionId");
        ((CaseExecutionCommandBuilder)Mockito.verify((Object)this.caseExecutionCommandBuilderMock)).setVariable((String)Mockito.eq((Object)aVariableKey), MockitoHamcrest.argThat((Matcher)EqualsPrimitiveValue.integerValue(aVariableValue)));
        ((CaseExecutionCommandBuilder)Mockito.verify((Object)this.caseExecutionCommandBuilderMock)).setVariable((String)Mockito.eq((Object)anotherVariableKey), MockitoHamcrest.argThat((Matcher)EqualsPrimitiveValue.stringValue(anotherVariableValue)));
        ((CaseExecutionCommandBuilder)Mockito.verify((Object)this.caseExecutionCommandBuilderMock)).reenable();
    }

    @Test
    public void testReenableWithSetVariableLocal() {
        String aVariableKey = "aKey";
        int aVariableValue = 123;
        String anotherVariableKey = "anotherKey";
        String anotherVariableValue = "abc";
        HashMap<String, Map<String, Object>> variablesJson = new HashMap<String, Map<String, Object>>();
        Map<String, Object> variables = VariablesBuilder.create().variable(aVariableKey, aVariableValue, "Integer", true).variable(anotherVariableKey, anotherVariableValue, "String", true).getVariables();
        variablesJson.put("variables", variables);
        RestAssured.given().pathParam("id", (Object)"aCaseExecutionId").contentType(ContentType.JSON).body(variablesJson).then().expect().statusCode(Response.Status.NO_CONTENT.getStatusCode()).when().post(CASE_EXECUTION_REENABLE_URL, new Object[0]);
        ((CaseService)Mockito.verify((Object)this.caseServiceMock)).withCaseExecution("aCaseExecutionId");
        ((CaseExecutionCommandBuilder)Mockito.verify((Object)this.caseExecutionCommandBuilderMock)).setVariableLocal((String)Mockito.eq((Object)aVariableKey), MockitoHamcrest.argThat((Matcher)EqualsPrimitiveValue.integerValue(aVariableValue)));
        ((CaseExecutionCommandBuilder)Mockito.verify((Object)this.caseExecutionCommandBuilderMock)).setVariableLocal((String)Mockito.eq((Object)anotherVariableKey), MockitoHamcrest.argThat((Matcher)EqualsPrimitiveValue.stringValue(anotherVariableValue)));
        ((CaseExecutionCommandBuilder)Mockito.verify((Object)this.caseExecutionCommandBuilderMock)).reenable();
    }

    @Test
    public void testReenableWithSetVariableAndVariableLocal() {
        String aVariableKey = "aKey";
        int aVariableValue = 123;
        String anotherVariableKey = "anotherKey";
        String anotherVariableValue = "abc";
        HashMap<String, Map<String, Object>> variablesJson = new HashMap<String, Map<String, Object>>();
        Map<String, Object> variables = VariablesBuilder.create().variable(aVariableKey, (Object)aVariableValue, "Integer").variable(anotherVariableKey, anotherVariableValue, "String", true).getVariables();
        variablesJson.put("variables", variables);
        RestAssured.given().pathParam("id", (Object)"aCaseExecutionId").contentType(ContentType.JSON).body(variablesJson).then().expect().statusCode(Response.Status.NO_CONTENT.getStatusCode()).when().post(CASE_EXECUTION_REENABLE_URL, new Object[0]);
        ((CaseService)Mockito.verify((Object)this.caseServiceMock)).withCaseExecution("aCaseExecutionId");
        ((CaseExecutionCommandBuilder)Mockito.verify((Object)this.caseExecutionCommandBuilderMock)).setVariable((String)Mockito.eq((Object)aVariableKey), MockitoHamcrest.argThat((Matcher)EqualsPrimitiveValue.integerValue(aVariableValue)));
        ((CaseExecutionCommandBuilder)Mockito.verify((Object)this.caseExecutionCommandBuilderMock)).setVariableLocal((String)Mockito.eq((Object)anotherVariableKey), MockitoHamcrest.argThat((Matcher)EqualsPrimitiveValue.stringValue(anotherVariableValue)));
        ((CaseExecutionCommandBuilder)Mockito.verify((Object)this.caseExecutionCommandBuilderMock)).reenable();
    }

    @Test
    public void testReenableWithRemoveVariable() {
        String aVariableKey = "aKey";
        String anotherVariableKey = "anotherKey";
        ArrayList<VariableNameDto> variableNames = new ArrayList<VariableNameDto>();
        VariableNameDto firstVariableName = new VariableNameDto(aVariableKey);
        variableNames.add(firstVariableName);
        VariableNameDto secondVariableName = new VariableNameDto(anotherVariableKey);
        variableNames.add(secondVariableName);
        HashMap<String, ArrayList<VariableNameDto>> variablesJson = new HashMap<String, ArrayList<VariableNameDto>>();
        variablesJson.put("deletions", variableNames);
        RestAssured.given().pathParam("id", (Object)"aCaseExecutionId").contentType(ContentType.JSON).body(variablesJson).then().expect().statusCode(Response.Status.NO_CONTENT.getStatusCode()).when().post(CASE_EXECUTION_REENABLE_URL, new Object[0]);
        ((CaseService)Mockito.verify((Object)this.caseServiceMock)).withCaseExecution("aCaseExecutionId");
        ((CaseExecutionCommandBuilder)Mockito.verify((Object)this.caseExecutionCommandBuilderMock)).removeVariable(aVariableKey);
        ((CaseExecutionCommandBuilder)Mockito.verify((Object)this.caseExecutionCommandBuilderMock)).removeVariable(anotherVariableKey);
        ((CaseExecutionCommandBuilder)Mockito.verify((Object)this.caseExecutionCommandBuilderMock)).reenable();
    }

    @Test
    public void testReenableWithRemoveVariableLocal() {
        String aVariableKey = "aKey";
        String anotherVariableKey = "anotherKey";
        ArrayList<VariableNameDto> variableNames = new ArrayList<VariableNameDto>();
        VariableNameDto firstVariableName = new VariableNameDto(aVariableKey, true);
        variableNames.add(firstVariableName);
        VariableNameDto secondVariableName = new VariableNameDto(anotherVariableKey, true);
        variableNames.add(secondVariableName);
        HashMap<String, ArrayList<VariableNameDto>> variablesJson = new HashMap<String, ArrayList<VariableNameDto>>();
        variablesJson.put("deletions", variableNames);
        RestAssured.given().pathParam("id", (Object)"aCaseExecutionId").contentType(ContentType.JSON).body(variablesJson).then().expect().statusCode(Response.Status.NO_CONTENT.getStatusCode()).when().post(CASE_EXECUTION_REENABLE_URL, new Object[0]);
        ((CaseService)Mockito.verify((Object)this.caseServiceMock)).withCaseExecution("aCaseExecutionId");
        ((CaseExecutionCommandBuilder)Mockito.verify((Object)this.caseExecutionCommandBuilderMock)).removeVariableLocal(aVariableKey);
        ((CaseExecutionCommandBuilder)Mockito.verify((Object)this.caseExecutionCommandBuilderMock)).removeVariableLocal(anotherVariableKey);
        ((CaseExecutionCommandBuilder)Mockito.verify((Object)this.caseExecutionCommandBuilderMock)).reenable();
    }

    @Test
    public void testReenableWithRemoveVariableAndVariableLocal() {
        String aVariableKey = "aKey";
        String anotherVariableKey = "anotherKey";
        ArrayList<VariableNameDto> variableNames = new ArrayList<VariableNameDto>();
        VariableNameDto firstVariableName = new VariableNameDto(aVariableKey, true);
        variableNames.add(firstVariableName);
        VariableNameDto secondVariableName = new VariableNameDto(anotherVariableKey);
        variableNames.add(secondVariableName);
        HashMap<String, ArrayList<VariableNameDto>> variablesJson = new HashMap<String, ArrayList<VariableNameDto>>();
        variablesJson.put("deletions", variableNames);
        RestAssured.given().pathParam("id", (Object)"aCaseExecutionId").contentType(ContentType.JSON).body(variablesJson).then().expect().statusCode(Response.Status.NO_CONTENT.getStatusCode()).when().post(CASE_EXECUTION_REENABLE_URL, new Object[0]);
        ((CaseService)Mockito.verify((Object)this.caseServiceMock)).withCaseExecution("aCaseExecutionId");
        ((CaseExecutionCommandBuilder)Mockito.verify((Object)this.caseExecutionCommandBuilderMock)).removeVariableLocal(aVariableKey);
        ((CaseExecutionCommandBuilder)Mockito.verify((Object)this.caseExecutionCommandBuilderMock)).removeVariable(anotherVariableKey);
        ((CaseExecutionCommandBuilder)Mockito.verify((Object)this.caseExecutionCommandBuilderMock)).reenable();
    }

    @Test
    public void testReenableWithSetVariableAndRemoveVariable() {
        String aVariableKey = "aKey";
        String anotherVariableKey = "anotherKey";
        String anotherVariableValue = "abc";
        Map<String, Object> variables = VariablesBuilder.create().variable(anotherVariableKey, (Object)anotherVariableValue, "String").getVariables();
        ArrayList<VariableNameDto> variableNames = new ArrayList<VariableNameDto>();
        VariableNameDto firstVariableName = new VariableNameDto(aVariableKey);
        variableNames.add(firstVariableName);
        HashMap<String, Object> variablesJson = new HashMap<String, Object>();
        variablesJson.put("variables", variables);
        variablesJson.put("deletions", variableNames);
        RestAssured.given().pathParam("id", (Object)"aCaseExecutionId").contentType(ContentType.JSON).body(variablesJson).then().expect().statusCode(Response.Status.NO_CONTENT.getStatusCode()).when().post(CASE_EXECUTION_REENABLE_URL, new Object[0]);
        ((CaseService)Mockito.verify((Object)this.caseServiceMock)).withCaseExecution("aCaseExecutionId");
        ((CaseExecutionCommandBuilder)Mockito.verify((Object)this.caseExecutionCommandBuilderMock)).removeVariable(aVariableKey);
        ((CaseExecutionCommandBuilder)Mockito.verify((Object)this.caseExecutionCommandBuilderMock)).setVariable((String)Mockito.eq((Object)anotherVariableKey), MockitoHamcrest.argThat((Matcher)EqualsPrimitiveValue.stringValue(anotherVariableValue)));
        ((CaseExecutionCommandBuilder)Mockito.verify((Object)this.caseExecutionCommandBuilderMock)).reenable();
    }

    @Test
    public void testReenableWithSetVariableAndRemoveVariableLocal() {
        String aVariableKey = "aKey";
        String anotherVariableKey = "anotherKey";
        String anotherVariableValue = "abc";
        Map<String, Object> variables = VariablesBuilder.create().variable(anotherVariableKey, (Object)anotherVariableValue, "String").getVariables();
        ArrayList<VariableNameDto> variableNames = new ArrayList<VariableNameDto>();
        VariableNameDto firstVariableName = new VariableNameDto(aVariableKey, true);
        variableNames.add(firstVariableName);
        HashMap<String, Object> variablesJson = new HashMap<String, Object>();
        variablesJson.put("variables", variables);
        variablesJson.put("deletions", variableNames);
        RestAssured.given().pathParam("id", (Object)"aCaseExecutionId").contentType(ContentType.JSON).body(variablesJson).then().expect().statusCode(Response.Status.NO_CONTENT.getStatusCode()).when().post(CASE_EXECUTION_REENABLE_URL, new Object[0]);
        ((CaseService)Mockito.verify((Object)this.caseServiceMock)).withCaseExecution("aCaseExecutionId");
        ((CaseExecutionCommandBuilder)Mockito.verify((Object)this.caseExecutionCommandBuilderMock)).removeVariableLocal(aVariableKey);
        ((CaseExecutionCommandBuilder)Mockito.verify((Object)this.caseExecutionCommandBuilderMock)).setVariable((String)Mockito.eq((Object)anotherVariableKey), MockitoHamcrest.argThat((Matcher)EqualsPrimitiveValue.stringValue(anotherVariableValue)));
        ((CaseExecutionCommandBuilder)Mockito.verify((Object)this.caseExecutionCommandBuilderMock)).reenable();
    }

    @Test
    public void testReenableWithSetVariableLocalAndRemoveVariable() {
        String aVariableKey = "aKey";
        String anotherVariableKey = "anotherKey";
        String anotherVariableValue = "abc";
        Map<String, Object> variables = VariablesBuilder.create().variable(anotherVariableKey, anotherVariableValue, "String", true).getVariables();
        ArrayList<VariableNameDto> variableNames = new ArrayList<VariableNameDto>();
        VariableNameDto firstVariableName = new VariableNameDto(aVariableKey);
        variableNames.add(firstVariableName);
        HashMap<String, Object> variablesJson = new HashMap<String, Object>();
        variablesJson.put("variables", variables);
        variablesJson.put("deletions", variableNames);
        RestAssured.given().pathParam("id", (Object)"aCaseExecutionId").contentType(ContentType.JSON).body(variablesJson).then().expect().statusCode(Response.Status.NO_CONTENT.getStatusCode()).when().post(CASE_EXECUTION_REENABLE_URL, new Object[0]);
        ((CaseService)Mockito.verify((Object)this.caseServiceMock)).withCaseExecution("aCaseExecutionId");
        ((CaseExecutionCommandBuilder)Mockito.verify((Object)this.caseExecutionCommandBuilderMock)).removeVariable(aVariableKey);
        ((CaseExecutionCommandBuilder)Mockito.verify((Object)this.caseExecutionCommandBuilderMock)).setVariableLocal((String)Mockito.eq((Object)anotherVariableKey), MockitoHamcrest.argThat((Matcher)EqualsPrimitiveValue.stringValue(anotherVariableValue)));
        ((CaseExecutionCommandBuilder)Mockito.verify((Object)this.caseExecutionCommandBuilderMock)).reenable();
    }

    @Test
    public void testReenableWithSetVariableLocalAndRemoveVariableLocal() {
        String aVariableKey = "aKey";
        String anotherVariableKey = "anotherKey";
        String anotherVariableValue = "abc";
        Map<String, Object> variables = VariablesBuilder.create().variable(anotherVariableKey, anotherVariableValue, "String", true).getVariables();
        ArrayList<VariableNameDto> variableNames = new ArrayList<VariableNameDto>();
        VariableNameDto firstVariableName = new VariableNameDto(aVariableKey, true);
        variableNames.add(firstVariableName);
        HashMap<String, Object> variablesJson = new HashMap<String, Object>();
        variablesJson.put("variables", variables);
        variablesJson.put("deletions", variableNames);
        RestAssured.given().pathParam("id", (Object)"aCaseExecutionId").contentType(ContentType.JSON).body(variablesJson).then().expect().statusCode(Response.Status.NO_CONTENT.getStatusCode()).when().post(CASE_EXECUTION_REENABLE_URL, new Object[0]);
        ((CaseService)Mockito.verify((Object)this.caseServiceMock)).withCaseExecution("aCaseExecutionId");
        ((CaseExecutionCommandBuilder)Mockito.verify((Object)this.caseExecutionCommandBuilderMock)).removeVariableLocal(aVariableKey);
        ((CaseExecutionCommandBuilder)Mockito.verify((Object)this.caseExecutionCommandBuilderMock)).setVariableLocal((String)Mockito.eq((Object)anotherVariableKey), MockitoHamcrest.argThat((Matcher)EqualsPrimitiveValue.stringValue(anotherVariableValue)));
        ((CaseExecutionCommandBuilder)Mockito.verify((Object)this.caseExecutionCommandBuilderMock)).reenable();
    }

    @Test
    public void testGetLocalVariables() {
        Response response = (Response)RestAssured.given().pathParam("id", (Object)"aCaseExecutionId").then().expect().statusCode(Response.Status.OK.getStatusCode()).body("aVariableKey", Matchers.notNullValue(), new Object[0]).body("aVariableKey.value", CoreMatchers.equalTo((Object)EXAMPLE_VARIABLE_VALUE.getValue()), new Object[0]).body("aVariableKey.type", CoreMatchers.equalTo((Object)"String"), new Object[0]).when().get(CASE_EXECUTION_LOCAL_VARIABLES_URL, new Object[0]);
        Assert.assertEquals((String)"Should return exactly one variable", (long)1L, (long)response.jsonPath().getMap("").size());
        ((CaseService)Mockito.verify((Object)this.caseServiceMock)).getVariablesLocalTyped("aCaseExecutionId", true);
    }

    @Test
    public void testGetVariables() {
        Response response = (Response)RestAssured.given().pathParam("id", (Object)"aCaseExecutionId").then().expect().statusCode(Response.Status.OK.getStatusCode()).body("aVariableKey", Matchers.notNullValue(), new Object[0]).body("aVariableKey.value", CoreMatchers.equalTo((Object)EXAMPLE_VARIABLE_VALUE.getValue()), new Object[0]).body("aVariableKey.type", CoreMatchers.equalTo((Object)VariableTypeHelper.toExpectedValueTypeName(EXAMPLE_VARIABLE_VALUE.getType())), new Object[0]).when().get(CASE_EXECUTION_VARIABLES_URL, new Object[0]);
        Assert.assertEquals((String)"Should return exactly one variable", (long)1L, (long)response.jsonPath().getMap("").size());
        ((CaseService)Mockito.verify((Object)this.caseServiceMock)).getVariablesTyped("aCaseExecutionId", true);
    }

    @Test
    public void testGetLocalObjectVariables() {
        String variableKey = "aVariableId";
        List<String> payload = Arrays.asList("a", "b");
        MockObjectValue variableValue = MockObjectValue.fromObjectValue((ObjectValue)Variables.objectValue(payload).serializationDataFormat("application/json").create()).objectTypeName(ArrayList.class.getName()).serializedValue("a serialized value");
        Mockito.when((Object)this.caseServiceMock.getVariablesLocalTyped((String)Mockito.eq((Object)"aCaseExecutionId"), Mockito.anyBoolean())).thenReturn((Object)Variables.createVariables().putValueTyped(variableKey, (TypedValue)variableValue));
        RestAssured.given().pathParam("id", (Object)"aCaseExecutionId").then().expect().statusCode(Response.Status.OK.getStatusCode()).body(variableKey + ".value", CoreMatchers.equalTo(payload), new Object[0]).body(variableKey + ".type", CoreMatchers.equalTo((Object)"Object"), new Object[0]).body(variableKey + ".valueInfo.serializationDataFormat", CoreMatchers.equalTo((Object)"application/json"), new Object[0]).body(variableKey + ".valueInfo.objectTypeName", CoreMatchers.equalTo((Object)ArrayList.class.getName()), new Object[0]).when().get(CASE_EXECUTION_LOCAL_VARIABLES_URL, new Object[0]);
        ((CaseService)Mockito.verify((Object)this.caseServiceMock)).getVariablesLocalTyped("aCaseExecutionId", true);
    }

    @Test
    public void testGetLocalObjectVariablesSerialized() {
        String variableKey = "aVariableId";
        ObjectValue variableValue = (ObjectValue)Variables.serializedObjectValue((String)"a serialized value").serializationDataFormat("application/json").objectTypeName(ArrayList.class.getName()).create();
        Mockito.when((Object)this.caseServiceMock.getVariablesLocalTyped((String)Mockito.eq((Object)"aCaseExecutionId"), Mockito.anyBoolean())).thenReturn((Object)Variables.createVariables().putValueTyped(variableKey, (TypedValue)variableValue));
        RestAssured.given().pathParam("id", (Object)"aCaseExecutionId").queryParam("deserializeValues", new Object[]{false}).then().expect().statusCode(Response.Status.OK.getStatusCode()).body(variableKey + ".value", CoreMatchers.equalTo((Object)"a serialized value"), new Object[0]).body(variableKey + ".type", CoreMatchers.equalTo((Object)"Object"), new Object[0]).body(variableKey + ".valueInfo.serializationDataFormat", CoreMatchers.equalTo((Object)"application/json"), new Object[0]).body(variableKey + ".valueInfo.objectTypeName", CoreMatchers.equalTo((Object)ArrayList.class.getName()), new Object[0]).when().get(CASE_EXECUTION_LOCAL_VARIABLES_URL, new Object[0]);
        ((CaseService)Mockito.verify((Object)this.caseServiceMock)).getVariablesLocalTyped("aCaseExecutionId", false);
    }

    @Test
    public void testGetLocalVariablesForNonExistingExecution() {
        Mockito.when((Object)this.caseServiceMock.getVariablesLocalTyped(Mockito.anyString(), Mockito.anyBoolean())).thenThrow(new Throwable[]{new ProcessEngineException("expected exception")});
        RestAssured.given().pathParam("id", (Object)"aNonExistingExecutionId").then().expect().statusCode(Response.Status.INTERNAL_SERVER_ERROR.getStatusCode()).contentType(ContentType.JSON).body("type", CoreMatchers.equalTo((Object)ProcessEngineException.class.getSimpleName()), new Object[0]).body("message", CoreMatchers.equalTo((Object)"expected exception"), new Object[0]).when().get(CASE_EXECUTION_LOCAL_VARIABLES_URL, new Object[0]);
        ((CaseService)Mockito.verify((Object)this.caseServiceMock)).getVariablesLocalTyped("aNonExistingExecutionId", true);
    }

    @Test
    public void testGetVariablesForNonExistingExecution() {
        Mockito.when((Object)this.caseServiceMock.getVariablesTyped(Mockito.anyString(), Mockito.anyBoolean())).thenThrow(new Throwable[]{new ProcessEngineException("expected exception")});
        RestAssured.given().pathParam("id", (Object)"aNonExistingExecutionId").then().expect().statusCode(Response.Status.INTERNAL_SERVER_ERROR.getStatusCode()).contentType(ContentType.JSON).body("type", CoreMatchers.equalTo((Object)ProcessEngineException.class.getSimpleName()), new Object[0]).body("message", CoreMatchers.equalTo((Object)"expected exception"), new Object[0]).when().get(CASE_EXECUTION_VARIABLES_URL, new Object[0]);
        ((CaseService)Mockito.verify((Object)this.caseServiceMock)).getVariablesTyped("aNonExistingExecutionId", true);
    }

    @Test
    public void testGetFileVariable() {
        String variableKey = "aVariableKey";
        byte[] byteContent = "some bytes".getBytes();
        String filename = "test.txt";
        String mimeType = "text/plain";
        FileValue variableValue = (FileValue)Variables.fileValue((String)filename).file(byteContent).mimeType(mimeType).create();
        Mockito.when((Object)this.caseServiceMock.getVariableTyped("aCaseInstId", variableKey, true)).thenReturn((Object)variableValue);
        RestAssured.given().pathParam("id", (Object)"aCaseInstId").pathParam("varId", (Object)variableKey).then().expect().statusCode(Response.Status.OK.getStatusCode()).contentType(ContentType.JSON.toString()).and().body("valueInfo.mimeType", CoreMatchers.equalTo((Object)mimeType), new Object[0]).body("valueInfo.filename", CoreMatchers.equalTo((Object)filename), new Object[0]).body("value", CoreMatchers.nullValue(), new Object[0]).when().get(SINGLE_CASE_EXECUTION_VARIABLE_URL, new Object[0]);
    }

    @Test
    public void testGetNullFileVariable() {
        String variableKey = "aVariableKey";
        String filename = "test.txt";
        String mimeType = "text/plain";
        FileValue variableValue = (FileValue)Variables.fileValue((String)filename).mimeType(mimeType).create();
        Mockito.when((Object)this.caseServiceMock.getVariableTyped((String)Mockito.eq((Object)"aCaseInstId"), (String)Mockito.eq((Object)variableKey), Mockito.anyBoolean())).thenReturn((Object)variableValue);
        RestAssured.given().pathParam("id", (Object)"aCaseInstId").pathParam("varId", (Object)variableKey).then().expect().statusCode(Response.Status.OK.getStatusCode()).contentType(ContentType.TEXT.toString()).and().body(Matchers.is((Matcher)CoreMatchers.equalTo((Object)"")), new Matcher[0]).when().get(SINGLE_CASE_EXECUTION_BINARY_VARIABLE_URL, new Object[0]);
    }

    @Test
    public void testGetFileVariableDownloadWithType() {
        String variableKey = "aVariableKey";
        byte[] byteContent = "some bytes".getBytes();
        String filename = "test.txt";
        FileValue variableValue = (FileValue)Variables.fileValue((String)filename).file(byteContent).mimeType(ContentType.TEXT.toString()).create();
        Mockito.when((Object)this.caseServiceMock.getVariableTyped((String)Mockito.eq((Object)"aCaseInstId"), (String)Mockito.eq((Object)variableKey), Mockito.anyBoolean())).thenReturn((Object)variableValue);
        RestAssured.given().pathParam("id", (Object)"aCaseInstId").pathParam("varId", (Object)variableKey).then().expect().statusCode(Response.Status.OK.getStatusCode()).contentType(ContentType.TEXT.toString()).and().body(Matchers.is((Matcher)CoreMatchers.equalTo((Object)new String(byteContent))), new Matcher[0]).when().get(SINGLE_CASE_EXECUTION_BINARY_VARIABLE_URL, new Object[0]);
    }

    @Test
    public void testGetFileVariableDownloadWithTypeAndEncoding() {
        String variableKey = "aVariableKey";
        byte[] byteContent = "some bytes".getBytes();
        String filename = "test.txt";
        String encoding = "UTF-8";
        FileValue variableValue = (FileValue)Variables.fileValue((String)filename).file(byteContent).mimeType(ContentType.TEXT.toString()).encoding(encoding).create();
        Mockito.when((Object)this.caseServiceMock.getVariableTyped((String)Mockito.eq((Object)"aCaseInstId"), (String)Mockito.eq((Object)variableKey), Mockito.anyBoolean())).thenReturn((Object)variableValue);
        Response response = (Response)RestAssured.given().pathParam("id", (Object)"aCaseInstId").pathParam("varId", (Object)variableKey).then().expect().statusCode(Response.Status.OK.getStatusCode()).body(Matchers.is((Matcher)CoreMatchers.equalTo((Object)new String(byteContent))), new Matcher[0]).when().get(SINGLE_CASE_EXECUTION_BINARY_VARIABLE_URL, new Object[0]);
        String contentType = response.contentType().replaceAll(" ", "");
        MatcherAssert.assertThat((Object)contentType, (Matcher)Matchers.is((Object)(String.valueOf(ContentType.TEXT) + ";charset=" + encoding)));
    }

    @Test
    public void testGetFileVariableDownloadWithoutType() {
        String variableKey = "aVariableKey";
        byte[] byteContent = "some bytes".getBytes();
        String filename = "test.txt";
        FileValue variableValue = (FileValue)Variables.fileValue((String)filename).file(byteContent).create();
        Mockito.when((Object)this.caseServiceMock.getVariableTyped((String)Mockito.eq((Object)"aCaseInstId"), (String)Mockito.eq((Object)variableKey), Mockito.anyBoolean())).thenReturn((Object)variableValue);
        RestAssured.given().pathParam("id", (Object)"aCaseInstId").pathParam("varId", (Object)variableKey).then().expect().statusCode(Response.Status.OK.getStatusCode()).contentType("application/octet-stream").and().body(Matchers.is((Matcher)CoreMatchers.equalTo((Object)new String(byteContent))), new Matcher[0]).header("Content-Disposition", Matchers.containsString((String)filename)).when().get(SINGLE_CASE_EXECUTION_BINARY_VARIABLE_URL, new Object[0]);
    }

    @Test
    public void testCannotDownloadVariableOtherThanFile() {
        String variableKey = "aVariableKey";
        BooleanValue variableValue = Variables.booleanValue((Boolean)true);
        Mockito.when((Object)this.caseServiceMock.getVariableTyped((String)Mockito.eq((Object)"aCaseInstId"), (String)Mockito.eq((Object)variableKey), Mockito.anyBoolean())).thenReturn((Object)variableValue);
        RestAssured.given().pathParam("id", (Object)"aCaseInstId").pathParam("varId", (Object)variableKey).then().expect().statusCode(Response.Status.BAD_REQUEST.getStatusCode()).contentType("application/json").when().get(SINGLE_CASE_EXECUTION_LOCAL_BINARY_VARIABLE_URL, new Object[0]);
    }

    @Test
    public void testLocalVariableModification() {
        HashMap<String, Object> messageBodyJson = new HashMap<String, Object>();
        String variableKey = "aKey";
        int variableValue = 123;
        Map<String, Object> modifications = VariablesBuilder.create().variable(variableKey, variableValue).getVariables();
        messageBodyJson.put("modifications", modifications);
        ArrayList<String> deletions = new ArrayList<String>();
        deletions.add("deleteKey");
        messageBodyJson.put("deletions", deletions);
        RestAssured.given().pathParam("id", (Object)"aCaseExecutionId").contentType(ContentType.JSON).body(messageBodyJson).then().expect().statusCode(Response.Status.NO_CONTENT.getStatusCode()).when().post(CASE_EXECUTION_LOCAL_VARIABLES_URL, new Object[0]);
        HashMap<String, Integer> expectedMap = new HashMap<String, Integer>();
        expectedMap.put(variableKey, variableValue);
        ((CaseService)Mockito.verify((Object)this.caseServiceMock)).withCaseExecution("aCaseExecutionId");
        ((CaseExecutionCommandBuilder)Mockito.verify((Object)this.caseExecutionCommandBuilderMock)).removeVariablesLocal((Collection)Mockito.eq(deletions));
        ((CaseExecutionCommandBuilder)Mockito.verify((Object)this.caseExecutionCommandBuilderMock)).setVariablesLocal((Map)Mockito.eq(expectedMap));
        ((CaseExecutionCommandBuilder)Mockito.verify((Object)this.caseExecutionCommandBuilderMock)).execute();
    }

    @Test
    public void testVariableModification() {
        HashMap<String, Object> messageBodyJson = new HashMap<String, Object>();
        String variableKey = "aKey";
        int variableValue = 123;
        Map<String, Object> modifications = VariablesBuilder.create().variable(variableKey, variableValue).getVariables();
        messageBodyJson.put("modifications", modifications);
        ArrayList<String> deletions = new ArrayList<String>();
        deletions.add("deleteKey");
        messageBodyJson.put("deletions", deletions);
        RestAssured.given().pathParam("id", (Object)"aCaseExecutionId").contentType(ContentType.JSON).body(messageBodyJson).then().expect().statusCode(Response.Status.NO_CONTENT.getStatusCode()).when().post(CASE_EXECUTION_VARIABLES_URL, new Object[0]);
        HashMap<String, Integer> expectedMap = new HashMap<String, Integer>();
        expectedMap.put(variableKey, variableValue);
        ((CaseService)Mockito.verify((Object)this.caseServiceMock)).withCaseExecution("aCaseExecutionId");
        ((CaseExecutionCommandBuilder)Mockito.verify((Object)this.caseExecutionCommandBuilderMock)).removeVariables((Collection)Mockito.eq(deletions));
        ((CaseExecutionCommandBuilder)Mockito.verify((Object)this.caseExecutionCommandBuilderMock)).setVariables((Map)Mockito.eq(expectedMap));
        ((CaseExecutionCommandBuilder)Mockito.verify((Object)this.caseExecutionCommandBuilderMock)).execute();
    }

    @Test
    public void testLocalVariableModificationForNonExistingExecution() {
        Mockito.when((Object)this.caseServiceMock.withCaseExecution("aNonExistingExecutionId")).thenReturn((Object)this.caseExecutionCommandBuilderMock);
        ((CaseExecutionCommandBuilder)Mockito.doThrow((Throwable[])new Throwable[]{new ProcessEngineException("expected exception")}).when((Object)this.caseExecutionCommandBuilderMock)).execute();
        HashMap<String, Map<String, Object>> messageBodyJson = new HashMap<String, Map<String, Object>>();
        String variableKey = "aKey";
        int variableValue = 123;
        Map<String, Object> modifications = VariablesBuilder.create().variable(variableKey, variableValue).getVariables();
        messageBodyJson.put("modifications", modifications);
        RestAssured.given().pathParam("id", (Object)"aNonExistingExecutionId").contentType(ContentType.JSON).body(messageBodyJson).then().expect().statusCode(Response.Status.INTERNAL_SERVER_ERROR.getStatusCode()).contentType(ContentType.JSON).body("type", CoreMatchers.equalTo((Object)RestException.class.getSimpleName()), new Object[0]).body("message", CoreMatchers.equalTo((Object)"Cannot modify variables for case execution aNonExistingExecutionId: expected exception"), new Object[0]).when().post(CASE_EXECUTION_LOCAL_VARIABLES_URL, new Object[0]);
        HashMap<String, Integer> expectedMap = new HashMap<String, Integer>();
        expectedMap.put(variableKey, variableValue);
        ((CaseService)Mockito.verify((Object)this.caseServiceMock)).withCaseExecution("aNonExistingExecutionId");
        ((CaseExecutionCommandBuilder)Mockito.verify((Object)this.caseExecutionCommandBuilderMock)).removeVariablesLocal(null);
        ((CaseExecutionCommandBuilder)Mockito.verify((Object)this.caseExecutionCommandBuilderMock)).setVariablesLocal((Map)Mockito.eq(expectedMap));
        ((CaseExecutionCommandBuilder)Mockito.verify((Object)this.caseExecutionCommandBuilderMock)).execute();
    }

    @Test
    public void testVariableModificationForNonExistingExecution() {
        Mockito.when((Object)this.caseServiceMock.withCaseExecution("aNonExistingExecutionId")).thenReturn((Object)this.caseExecutionCommandBuilderMock);
        ((CaseExecutionCommandBuilder)Mockito.doThrow((Throwable[])new Throwable[]{new ProcessEngineException("expected exception")}).when((Object)this.caseExecutionCommandBuilderMock)).execute();
        HashMap<String, Map<String, Object>> messageBodyJson = new HashMap<String, Map<String, Object>>();
        String variableKey = "aKey";
        int variableValue = 123;
        Map<String, Object> modifications = VariablesBuilder.create().variable(variableKey, variableValue).getVariables();
        messageBodyJson.put("modifications", modifications);
        RestAssured.given().pathParam("id", (Object)"aNonExistingExecutionId").contentType(ContentType.JSON).body(messageBodyJson).then().expect().statusCode(Response.Status.INTERNAL_SERVER_ERROR.getStatusCode()).contentType(ContentType.JSON).body("type", CoreMatchers.equalTo((Object)RestException.class.getSimpleName()), new Object[0]).body("message", CoreMatchers.equalTo((Object)"Cannot modify variables for case execution aNonExistingExecutionId: expected exception"), new Object[0]).when().post(CASE_EXECUTION_VARIABLES_URL, new Object[0]);
        HashMap<String, Integer> expectedMap = new HashMap<String, Integer>();
        expectedMap.put(variableKey, variableValue);
        ((CaseService)Mockito.verify((Object)this.caseServiceMock)).withCaseExecution("aNonExistingExecutionId");
        ((CaseExecutionCommandBuilder)Mockito.verify((Object)this.caseExecutionCommandBuilderMock)).removeVariables(null);
        ((CaseExecutionCommandBuilder)Mockito.verify((Object)this.caseExecutionCommandBuilderMock)).setVariables((Map)Mockito.eq(expectedMap));
        ((CaseExecutionCommandBuilder)Mockito.verify((Object)this.caseExecutionCommandBuilderMock)).execute();
    }

    @Test
    public void testEmptyLocalVariableModification() {
        RestAssured.given().pathParam("id", (Object)"aCaseExecutionId").contentType(ContentType.JSON).body("{}").then().expect().statusCode(Response.Status.NO_CONTENT.getStatusCode()).when().post(CASE_EXECUTION_LOCAL_VARIABLES_URL, new Object[0]);
        ((CaseService)Mockito.verify((Object)this.caseServiceMock)).withCaseExecution("aCaseExecutionId");
        ((CaseExecutionCommandBuilder)Mockito.verify((Object)this.caseExecutionCommandBuilderMock)).removeVariablesLocal(null);
        ((CaseExecutionCommandBuilder)Mockito.verify((Object)this.caseExecutionCommandBuilderMock)).setVariablesLocal(null);
        ((CaseExecutionCommandBuilder)Mockito.verify((Object)this.caseExecutionCommandBuilderMock)).execute();
    }

    @Test
    public void testEmptyVariableModification() {
        RestAssured.given().pathParam("id", (Object)"aCaseExecutionId").contentType(ContentType.JSON).body("{}").then().expect().statusCode(Response.Status.NO_CONTENT.getStatusCode()).when().post(CASE_EXECUTION_VARIABLES_URL, new Object[0]);
        ((CaseService)Mockito.verify((Object)this.caseServiceMock)).withCaseExecution("aCaseExecutionId");
        ((CaseExecutionCommandBuilder)Mockito.verify((Object)this.caseExecutionCommandBuilderMock)).removeVariables(null);
        ((CaseExecutionCommandBuilder)Mockito.verify((Object)this.caseExecutionCommandBuilderMock)).setVariables(null);
        ((CaseExecutionCommandBuilder)Mockito.verify((Object)this.caseExecutionCommandBuilderMock)).execute();
    }

    @Test
    public void testGetSingleLocalVariable() {
        RestAssured.given().pathParam("id", (Object)"aCaseExecutionId").pathParam("varId", (Object)"aVariableKey").then().expect().statusCode(Response.Status.OK.getStatusCode()).body("value", Matchers.is((Object)EXAMPLE_VARIABLE_VALUE.getValue()), new Object[0]).body("type", Matchers.is((Object)VariableTypeHelper.toExpectedValueTypeName(EXAMPLE_VARIABLE_VALUE.getType())), new Object[0]).when().get(SINGLE_CASE_EXECUTION_LOCAL_VARIABLE_URL, new Object[0]);
        ((CaseService)Mockito.verify((Object)this.caseServiceMock)).getVariableLocalTyped("aCaseExecutionId", "aVariableKey", true);
    }

    @Test
    public void testGetSingleLocalVariableData() {
        RestAssured.given().pathParam("id", (Object)"aCaseExecutionId").pathParam("varId", (Object)"aBytesVariableKey").then().expect().statusCode(Response.Status.OK.getStatusCode()).contentType("application/octet-stream").when().get(SINGLE_CASE_EXECUTION_LOCAL_BINARY_VARIABLE_URL, new Object[0]);
        ((CaseService)Mockito.verify((Object)this.caseServiceMock)).getVariableLocalTyped("aCaseExecutionId", "aBytesVariableKey", false);
    }

    @Test
    public void testGetSingleLocalVariableDataNonExisting() {
        RestAssured.given().pathParam("id", (Object)"aCaseExecutionId").pathParam("varId", (Object)"nonExisting").then().expect().statusCode(Response.Status.NOT_FOUND.getStatusCode()).body("type", Matchers.is((Object)InvalidRequestException.class.getSimpleName()), new Object[0]).body("message", Matchers.is((Object)"case execution variable with name nonExisting does not exist"), new Object[0]).when().get(SINGLE_CASE_EXECUTION_LOCAL_BINARY_VARIABLE_URL, new Object[0]);
        ((CaseService)Mockito.verify((Object)this.caseServiceMock)).getVariableLocalTyped("aCaseExecutionId", "nonExisting", false);
    }

    @Test
    public void testGetSingleLocalVariabledataNotBinary() {
        RestAssured.given().pathParam("id", (Object)"aCaseExecutionId").pathParam("varId", (Object)"aVariableKey").then().expect().statusCode(Response.Status.BAD_REQUEST.getStatusCode()).when().get(SINGLE_CASE_EXECUTION_LOCAL_BINARY_VARIABLE_URL, new Object[0]);
        ((CaseService)Mockito.verify((Object)this.caseServiceMock)).getVariableLocalTyped("aCaseExecutionId", "aVariableKey", false);
    }

    @Test
    public void testGetSingleVariable() {
        RestAssured.given().pathParam("id", (Object)"aCaseExecutionId").pathParam("varId", (Object)"aVariableKey").then().expect().statusCode(Response.Status.OK.getStatusCode()).body("value", Matchers.is((Object)EXAMPLE_VARIABLE_VALUE.getValue()), new Object[0]).body("type", Matchers.is((Object)VariableTypeHelper.toExpectedValueTypeName(EXAMPLE_VARIABLE_VALUE.getType())), new Object[0]).when().get(SINGLE_CASE_EXECUTION_VARIABLE_URL, new Object[0]);
        ((CaseService)Mockito.verify((Object)this.caseServiceMock)).getVariableTyped("aCaseExecutionId", "aVariableKey", true);
    }

    @Test
    public void testGetSingleLocalObjectVariable() {
        String variableKey = "aVariableId";
        List<String> payload = Arrays.asList("a", "b");
        MockObjectValue variableValue = MockObjectValue.fromObjectValue((ObjectValue)Variables.objectValue(payload).serializationDataFormat("application/json").create()).objectTypeName(ArrayList.class.getName()).serializedValue("a serialized value");
        Mockito.when((Object)this.caseServiceMock.getVariableLocalTyped((String)Mockito.eq((Object)"aCaseExecutionId"), (String)Mockito.eq((Object)variableKey), Mockito.anyBoolean())).thenReturn((Object)variableValue);
        RestAssured.given().pathParam("id", (Object)"aCaseExecutionId").pathParam("varId", (Object)variableKey).then().expect().statusCode(Response.Status.OK.getStatusCode()).body("value", CoreMatchers.equalTo(payload), new Object[0]).body("type", CoreMatchers.equalTo((Object)"Object"), new Object[0]).body("valueInfo.serializationDataFormat", CoreMatchers.equalTo((Object)"application/json"), new Object[0]).body("valueInfo.objectTypeName", CoreMatchers.equalTo((Object)ArrayList.class.getName()), new Object[0]).when().get(SINGLE_CASE_EXECUTION_LOCAL_VARIABLE_URL, new Object[0]);
        ((CaseService)Mockito.verify((Object)this.caseServiceMock)).getVariableLocalTyped("aCaseExecutionId", variableKey, true);
    }

    @Test
    public void testGetSingleLocalObjectVariableSerialized() {
        String variableKey = "aVariableId";
        ObjectValue variableValue = (ObjectValue)Variables.serializedObjectValue((String)"a serialized value").serializationDataFormat("application/json").objectTypeName(ArrayList.class.getName()).create();
        Mockito.when((Object)this.caseServiceMock.getVariableLocalTyped((String)Mockito.eq((Object)"aCaseExecutionId"), (String)Mockito.eq((Object)variableKey), Mockito.anyBoolean())).thenReturn((Object)variableValue);
        RestAssured.given().pathParam("id", (Object)"aCaseExecutionId").pathParam("varId", (Object)variableKey).queryParam("deserializeValue", new Object[]{false}).then().expect().statusCode(Response.Status.OK.getStatusCode()).body("value", CoreMatchers.equalTo((Object)"a serialized value"), new Object[0]).body("type", CoreMatchers.equalTo((Object)"Object"), new Object[0]).body("valueInfo.serializationDataFormat", CoreMatchers.equalTo((Object)"application/json"), new Object[0]).body("valueInfo.objectTypeName", CoreMatchers.equalTo((Object)ArrayList.class.getName()), new Object[0]).when().get(SINGLE_CASE_EXECUTION_LOCAL_VARIABLE_URL, new Object[0]);
        ((CaseService)Mockito.verify((Object)this.caseServiceMock)).getVariableLocalTyped("aCaseExecutionId", variableKey, false);
    }

    @Test
    public void testNonExistingLocalVariable() {
        Mockito.when((Object)this.caseServiceMock.getVariableLocalTyped((String)Mockito.eq((Object)"aCaseExecutionId"), (String)Mockito.eq((Object)"aVariableKey"), Mockito.eq((boolean)true))).thenReturn(null);
        RestAssured.given().pathParam("id", (Object)"aCaseExecutionId").pathParam("varId", (Object)"aVariableKey").then().expect().statusCode(Response.Status.NOT_FOUND.getStatusCode()).body("type", Matchers.is((Object)InvalidRequestException.class.getSimpleName()), new Object[0]).body("message", Matchers.is((Object)"case execution variable with name aVariableKey does not exist"), new Object[0]).when().get(SINGLE_CASE_EXECUTION_LOCAL_VARIABLE_URL, new Object[0]);
    }

    @Test
    public void testNonExistingVariable() {
        Mockito.when((Object)this.caseServiceMock.getVariableTyped((String)Mockito.eq((Object)"aCaseExecutionId"), (String)Mockito.eq((Object)"aVariableKey"), Mockito.eq((boolean)true))).thenReturn(null);
        RestAssured.given().pathParam("id", (Object)"aCaseExecutionId").pathParam("varId", (Object)"aVariableKey").then().expect().statusCode(Response.Status.NOT_FOUND.getStatusCode()).body("type", Matchers.is((Object)InvalidRequestException.class.getSimpleName()), new Object[0]).body("message", Matchers.is((Object)"case execution variable with name aVariableKey does not exist"), new Object[0]).when().get(SINGLE_CASE_EXECUTION_VARIABLE_URL, new Object[0]);
    }

    @Test
    public void testGetLocalVariableForNonExistingExecution() {
        Mockito.when((Object)this.caseServiceMock.getVariableLocalTyped((String)Mockito.eq((Object)"aCaseExecutionId"), (String)Mockito.eq((Object)"aVariableKey"), Mockito.eq((boolean)true))).thenThrow(new Throwable[]{new ProcessEngineException("expected exception")});
        RestAssured.given().pathParam("id", (Object)"aCaseExecutionId").pathParam("varId", (Object)"aVariableKey").then().expect().statusCode(Response.Status.INTERNAL_SERVER_ERROR.getStatusCode()).body("type", Matchers.is((Object)RestException.class.getSimpleName()), new Object[0]).body("message", Matchers.is((Object)"Cannot get case execution variable aVariableKey: expected exception"), new Object[0]).when().get(SINGLE_CASE_EXECUTION_LOCAL_VARIABLE_URL, new Object[0]);
    }

    @Test
    public void testGetVariableForNonExistingExecution() {
        Mockito.when((Object)this.caseServiceMock.getVariableTyped((String)Mockito.eq((Object)"aCaseExecutionId"), (String)Mockito.eq((Object)"aVariableKey"), Mockito.eq((boolean)true))).thenThrow(new Throwable[]{new ProcessEngineException("expected exception")});
        RestAssured.given().pathParam("id", (Object)"aCaseExecutionId").pathParam("varId", (Object)"aVariableKey").then().expect().statusCode(Response.Status.INTERNAL_SERVER_ERROR.getStatusCode()).body("type", Matchers.is((Object)RestException.class.getSimpleName()), new Object[0]).body("message", Matchers.is((Object)"Cannot get case execution variable aVariableKey: expected exception"), new Object[0]).when().get(SINGLE_CASE_EXECUTION_VARIABLE_URL, new Object[0]);
    }

    @Test
    public void testPutSingleLocalVariable() {
        Map<String, Object> variableJson = VariablesBuilder.getVariableValueMap(EXAMPLE_VARIABLE_VALUE.getValue(), EXAMPLE_VARIABLE_VALUE.getType().getName());
        RestAssured.given().pathParam("id", (Object)"aCaseExecutionId").pathParam("varId", (Object)"aVariableKey").contentType(ContentType.JSON).body(variableJson).then().expect().statusCode(Response.Status.NO_CONTENT.getStatusCode()).when().put(SINGLE_CASE_EXECUTION_LOCAL_VARIABLE_URL, new Object[0]);
        ((CaseService)Mockito.verify((Object)this.caseServiceMock)).withCaseExecution("aCaseExecutionId");
        ((CaseExecutionCommandBuilder)Mockito.verify((Object)this.caseExecutionCommandBuilderMock)).setVariableLocal("aVariableKey", (Object)EXAMPLE_VARIABLE_VALUE);
        ((CaseExecutionCommandBuilder)Mockito.verify((Object)this.caseExecutionCommandBuilderMock)).execute();
    }

    @Test
    public void testPutSingleVariable() {
        Map<String, Object> variableJson = VariablesBuilder.getVariableValueMap(EXAMPLE_VARIABLE_VALUE.getValue(), EXAMPLE_VARIABLE_VALUE.getType().getName());
        RestAssured.given().pathParam("id", (Object)"aCaseExecutionId").pathParam("varId", (Object)"aVariableKey").contentType(ContentType.JSON).body(variableJson).then().expect().statusCode(Response.Status.NO_CONTENT.getStatusCode()).when().put(SINGLE_CASE_EXECUTION_VARIABLE_URL, new Object[0]);
        ((CaseService)Mockito.verify((Object)this.caseServiceMock)).withCaseExecution("aCaseExecutionId");
        ((CaseExecutionCommandBuilder)Mockito.verify((Object)this.caseExecutionCommandBuilderMock)).setVariable("aVariableKey", (Object)EXAMPLE_VARIABLE_VALUE);
        ((CaseExecutionCommandBuilder)Mockito.verify((Object)this.caseExecutionCommandBuilderMock)).execute();
    }

    @Test
    public void testPutSingleLocalVariableWithTypeInteger() {
        String variableKey = "aVariableKey";
        Integer variableValue = 123;
        String type = "Integer";
        Map<String, Object> variableJson = VariablesBuilder.getVariableValueMap((Object)variableValue, type);
        RestAssured.given().pathParam("id", (Object)"aCaseExecutionId").pathParam("varId", (Object)variableKey).contentType(ContentType.JSON).body(variableJson).then().expect().statusCode(Response.Status.NO_CONTENT.getStatusCode()).when().put(SINGLE_CASE_EXECUTION_LOCAL_VARIABLE_URL, new Object[0]);
        ((CaseService)Mockito.verify((Object)this.caseServiceMock)).withCaseExecution("aCaseExecutionId");
        ((CaseExecutionCommandBuilder)Mockito.verify((Object)this.caseExecutionCommandBuilderMock)).setVariableLocal((String)Mockito.eq((Object)variableKey), MockitoHamcrest.argThat((Matcher)EqualsPrimitiveValue.integerValue(variableValue)));
        ((CaseExecutionCommandBuilder)Mockito.verify((Object)this.caseExecutionCommandBuilderMock)).execute();
    }

    @Test
    public void testPutSingleVariableWithTypeInteger() {
        String variableKey = "aVariableKey";
        Integer variableValue = 123;
        String type = "Integer";
        Map<String, Object> variableJson = VariablesBuilder.getVariableValueMap((Object)variableValue, type);
        RestAssured.given().pathParam("id", (Object)"aCaseExecutionId").pathParam("varId", (Object)variableKey).contentType(ContentType.JSON).body(variableJson).then().expect().statusCode(Response.Status.NO_CONTENT.getStatusCode()).when().put(SINGLE_CASE_EXECUTION_VARIABLE_URL, new Object[0]);
        ((CaseService)Mockito.verify((Object)this.caseServiceMock)).withCaseExecution("aCaseExecutionId");
        ((CaseExecutionCommandBuilder)Mockito.verify((Object)this.caseExecutionCommandBuilderMock)).setVariable((String)Mockito.eq((Object)variableKey), MockitoHamcrest.argThat((Matcher)EqualsPrimitiveValue.integerValue(variableValue)));
        ((CaseExecutionCommandBuilder)Mockito.verify((Object)this.caseExecutionCommandBuilderMock)).execute();
    }

    @Test
    public void testPutSingleLocalVariableWithUnparseableInteger() {
        String variableKey = "aVariableKey";
        String variableValue = "1abc";
        String type = "Integer";
        Map<String, Object> variableJson = VariablesBuilder.getVariableValueMap((Object)variableValue, type);
        RestAssured.given().pathParam("id", (Object)"aCaseExecutionId").pathParam("varId", (Object)variableKey).contentType(ContentType.JSON).body(variableJson).then().expect().statusCode(Response.Status.BAD_REQUEST.getStatusCode()).body("type", CoreMatchers.equalTo((Object)InvalidRequestException.class.getSimpleName()), new Object[0]).body("message", CoreMatchers.equalTo((Object)("Cannot put case execution variable aVariableKey: " + ErrorMessageHelper.getExpectedFailingConversionMessage(variableValue, type, Integer.class))), new Object[0]).when().put(SINGLE_CASE_EXECUTION_LOCAL_VARIABLE_URL, new Object[0]);
    }

    @Test
    public void testPutSingleVariableWithUnparseableInteger() {
        String variableKey = "aVariableKey";
        String variableValue = "1abc";
        String type = "Integer";
        Map<String, Object> variableJson = VariablesBuilder.getVariableValueMap((Object)variableValue, type);
        RestAssured.given().pathParam("id", (Object)"aCaseExecutionId").pathParam("varId", (Object)variableKey).contentType(ContentType.JSON).body(variableJson).then().expect().statusCode(Response.Status.BAD_REQUEST.getStatusCode()).body("type", CoreMatchers.equalTo((Object)InvalidRequestException.class.getSimpleName()), new Object[0]).body("message", CoreMatchers.equalTo((Object)("Cannot put case execution variable aVariableKey: " + ErrorMessageHelper.getExpectedFailingConversionMessage(variableValue, type, Integer.class))), new Object[0]).when().put(SINGLE_CASE_EXECUTION_VARIABLE_URL, new Object[0]);
    }

    @Test
    public void testPutSingleLocalVariableWithTypeShort() {
        String variableKey = "aVariableKey";
        Short variableValue = 123;
        String type = "Short";
        Map<String, Object> variableJson = VariablesBuilder.getVariableValueMap((Object)variableValue, type);
        RestAssured.given().pathParam("id", (Object)"aCaseExecutionId").pathParam("varId", (Object)variableKey).contentType(ContentType.JSON).body(variableJson).then().expect().statusCode(Response.Status.NO_CONTENT.getStatusCode()).when().put(SINGLE_CASE_EXECUTION_LOCAL_VARIABLE_URL, new Object[0]);
        ((CaseService)Mockito.verify((Object)this.caseServiceMock)).withCaseExecution("aCaseExecutionId");
        ((CaseExecutionCommandBuilder)Mockito.verify((Object)this.caseExecutionCommandBuilderMock)).setVariableLocal((String)Mockito.eq((Object)variableKey), MockitoHamcrest.argThat((Matcher)EqualsPrimitiveValue.shortValue(variableValue)));
        ((CaseExecutionCommandBuilder)Mockito.verify((Object)this.caseExecutionCommandBuilderMock)).execute();
    }

    @Test
    public void testPutSingleVariableWithTypeShort() {
        String variableKey = "aVariableKey";
        Short variableValue = 123;
        String type = "Short";
        Map<String, Object> variableJson = VariablesBuilder.getVariableValueMap((Object)variableValue, type);
        RestAssured.given().pathParam("id", (Object)"aCaseExecutionId").pathParam("varId", (Object)variableKey).contentType(ContentType.JSON).body(variableJson).then().expect().statusCode(Response.Status.NO_CONTENT.getStatusCode()).when().put(SINGLE_CASE_EXECUTION_VARIABLE_URL, new Object[0]);
        ((CaseService)Mockito.verify((Object)this.caseServiceMock)).withCaseExecution("aCaseExecutionId");
        ((CaseExecutionCommandBuilder)Mockito.verify((Object)this.caseExecutionCommandBuilderMock)).setVariable((String)Mockito.eq((Object)variableKey), MockitoHamcrest.argThat((Matcher)EqualsPrimitiveValue.shortValue(variableValue)));
        ((CaseExecutionCommandBuilder)Mockito.verify((Object)this.caseExecutionCommandBuilderMock)).execute();
    }

    @Test
    public void testPutSingleLocalVariableWithUnparseableShort() {
        String variableKey = "aVariableKey";
        String variableValue = "1abc";
        String type = "Short";
        Map<String, Object> variableJson = VariablesBuilder.getVariableValueMap((Object)variableValue, type);
        RestAssured.given().pathParam("id", (Object)"aCaseExecutionId").pathParam("varId", (Object)variableKey).contentType(ContentType.JSON).body(variableJson).then().expect().statusCode(Response.Status.BAD_REQUEST.getStatusCode()).body("type", CoreMatchers.equalTo((Object)InvalidRequestException.class.getSimpleName()), new Object[0]).body("message", CoreMatchers.equalTo((Object)("Cannot put case execution variable aVariableKey: " + ErrorMessageHelper.getExpectedFailingConversionMessage(variableValue, type, Short.class))), new Object[0]).when().put(SINGLE_CASE_EXECUTION_LOCAL_VARIABLE_URL, new Object[0]);
    }

    @Test
    public void testPutSingleVariableWithUnparseableShort() {
        String variableKey = "aVariableKey";
        String variableValue = "1abc";
        String type = "Short";
        Map<String, Object> variableJson = VariablesBuilder.getVariableValueMap((Object)variableValue, type);
        RestAssured.given().pathParam("id", (Object)"aCaseExecutionId").pathParam("varId", (Object)variableKey).contentType(ContentType.JSON).body(variableJson).then().expect().statusCode(Response.Status.BAD_REQUEST.getStatusCode()).body("type", CoreMatchers.equalTo((Object)InvalidRequestException.class.getSimpleName()), new Object[0]).body("message", CoreMatchers.equalTo((Object)("Cannot put case execution variable aVariableKey: " + ErrorMessageHelper.getExpectedFailingConversionMessage(variableValue, type, Short.class))), new Object[0]).when().put(SINGLE_CASE_EXECUTION_VARIABLE_URL, new Object[0]);
    }

    @Test
    public void testPutSingleLocalVariableWithTypeLong() {
        String variableKey = "aVariableKey";
        Long variableValue = 123L;
        String type = "Long";
        Map<String, Object> variableJson = VariablesBuilder.getVariableValueMap((Object)variableValue, type);
        RestAssured.given().pathParam("id", (Object)"aCaseExecutionId").pathParam("varId", (Object)variableKey).contentType(ContentType.JSON).body(variableJson).then().expect().statusCode(Response.Status.NO_CONTENT.getStatusCode()).when().put(SINGLE_CASE_EXECUTION_LOCAL_VARIABLE_URL, new Object[0]);
        ((CaseService)Mockito.verify((Object)this.caseServiceMock)).withCaseExecution("aCaseExecutionId");
        ((CaseExecutionCommandBuilder)Mockito.verify((Object)this.caseExecutionCommandBuilderMock)).setVariableLocal((String)Mockito.eq((Object)variableKey), MockitoHamcrest.argThat((Matcher)EqualsPrimitiveValue.longValue(variableValue)));
        ((CaseExecutionCommandBuilder)Mockito.verify((Object)this.caseExecutionCommandBuilderMock)).execute();
    }

    @Test
    public void testPutSingleVariableWithTypeLong() {
        String variableKey = "aVariableKey";
        Long variableValue = 123L;
        String type = "Long";
        Map<String, Object> variableJson = VariablesBuilder.getVariableValueMap((Object)variableValue, type);
        RestAssured.given().pathParam("id", (Object)"aCaseExecutionId").pathParam("varId", (Object)variableKey).contentType(ContentType.JSON).body(variableJson).then().expect().statusCode(Response.Status.NO_CONTENT.getStatusCode()).when().put(SINGLE_CASE_EXECUTION_VARIABLE_URL, new Object[0]);
        ((CaseService)Mockito.verify((Object)this.caseServiceMock)).withCaseExecution("aCaseExecutionId");
        ((CaseExecutionCommandBuilder)Mockito.verify((Object)this.caseExecutionCommandBuilderMock)).setVariable((String)Mockito.eq((Object)variableKey), MockitoHamcrest.argThat((Matcher)EqualsPrimitiveValue.longValue(variableValue)));
        ((CaseExecutionCommandBuilder)Mockito.verify((Object)this.caseExecutionCommandBuilderMock)).execute();
    }

    @Test
    public void testPutSingleLocalVariableWithUnparseableLong() {
        String variableKey = "aVariableKey";
        String variableValue = "1abc";
        String type = "Long";
        Map<String, Object> variableJson = VariablesBuilder.getVariableValueMap((Object)variableValue, type);
        RestAssured.given().pathParam("id", (Object)"aCaseExecutionId").pathParam("varId", (Object)variableKey).contentType(ContentType.JSON).body(variableJson).then().expect().statusCode(Response.Status.BAD_REQUEST.getStatusCode()).body("type", CoreMatchers.equalTo((Object)InvalidRequestException.class.getSimpleName()), new Object[0]).body("message", CoreMatchers.equalTo((Object)("Cannot put case execution variable aVariableKey: " + ErrorMessageHelper.getExpectedFailingConversionMessage(variableValue, type, Long.class))), new Object[0]).when().put(SINGLE_CASE_EXECUTION_LOCAL_VARIABLE_URL, new Object[0]);
    }

    @Test
    public void testPutSingleVariableWithUnparseableLong() {
        String variableKey = "aVariableKey";
        String variableValue = "1abc";
        String type = "Long";
        Map<String, Object> variableJson = VariablesBuilder.getVariableValueMap((Object)variableValue, type);
        RestAssured.given().pathParam("id", (Object)"aCaseExecutionId").pathParam("varId", (Object)variableKey).contentType(ContentType.JSON).body(variableJson).then().expect().statusCode(Response.Status.BAD_REQUEST.getStatusCode()).body("type", CoreMatchers.equalTo((Object)InvalidRequestException.class.getSimpleName()), new Object[0]).body("message", CoreMatchers.equalTo((Object)("Cannot put case execution variable aVariableKey: " + ErrorMessageHelper.getExpectedFailingConversionMessage(variableValue, type, Long.class))), new Object[0]).when().put(SINGLE_CASE_EXECUTION_LOCAL_VARIABLE_URL, new Object[0]);
    }

    @Test
    public void testPutSingleLocalVariableWithTypeDouble() {
        String variableKey = "aVariableKey";
        Double variableValue = 123.456;
        String type = "Double";
        Map<String, Object> variableJson = VariablesBuilder.getVariableValueMap((Object)variableValue, type);
        RestAssured.given().pathParam("id", (Object)"aCaseExecutionId").pathParam("varId", (Object)variableKey).contentType(ContentType.JSON).body(variableJson).then().expect().statusCode(Response.Status.NO_CONTENT.getStatusCode()).when().put(SINGLE_CASE_EXECUTION_LOCAL_VARIABLE_URL, new Object[0]);
        ((CaseService)Mockito.verify((Object)this.caseServiceMock)).withCaseExecution("aCaseExecutionId");
        ((CaseExecutionCommandBuilder)Mockito.verify((Object)this.caseExecutionCommandBuilderMock)).setVariableLocal((String)Mockito.eq((Object)variableKey), MockitoHamcrest.argThat((Matcher)EqualsPrimitiveValue.doubleValue(variableValue)));
        ((CaseExecutionCommandBuilder)Mockito.verify((Object)this.caseExecutionCommandBuilderMock)).execute();
    }

    @Test
    public void testPutSingleVariableWithTypeDouble() {
        String variableKey = "aVariableKey";
        Double variableValue = 123.456;
        String type = "Double";
        Map<String, Object> variableJson = VariablesBuilder.getVariableValueMap((Object)variableValue, type);
        RestAssured.given().pathParam("id", (Object)"aCaseExecutionId").pathParam("varId", (Object)variableKey).contentType(ContentType.JSON).body(variableJson).then().expect().statusCode(Response.Status.NO_CONTENT.getStatusCode()).when().put(SINGLE_CASE_EXECUTION_VARIABLE_URL, new Object[0]);
        ((CaseService)Mockito.verify((Object)this.caseServiceMock)).withCaseExecution("aCaseExecutionId");
        ((CaseExecutionCommandBuilder)Mockito.verify((Object)this.caseExecutionCommandBuilderMock)).setVariable((String)Mockito.eq((Object)variableKey), MockitoHamcrest.argThat((Matcher)EqualsPrimitiveValue.doubleValue(variableValue)));
        ((CaseExecutionCommandBuilder)Mockito.verify((Object)this.caseExecutionCommandBuilderMock)).execute();
    }

    @Test
    public void testPutSingleLocalVariableWithUnparseableDouble() {
        String variableKey = "aVariableKey";
        String variableValue = "1abc";
        String type = "Double";
        Map<String, Object> variableJson = VariablesBuilder.getVariableValueMap((Object)variableValue, type);
        RestAssured.given().pathParam("id", (Object)"aCaseExecutionId").pathParam("varId", (Object)variableKey).contentType(ContentType.JSON).body(variableJson).then().expect().statusCode(Response.Status.BAD_REQUEST.getStatusCode()).body("type", CoreMatchers.equalTo((Object)InvalidRequestException.class.getSimpleName()), new Object[0]).body("message", CoreMatchers.equalTo((Object)("Cannot put case execution variable aVariableKey: " + ErrorMessageHelper.getExpectedFailingConversionMessage(variableValue, type, Double.class))), new Object[0]).when().put(SINGLE_CASE_EXECUTION_LOCAL_VARIABLE_URL, new Object[0]);
    }

    @Test
    public void testPutSingleVariableWithUnparseableDouble() {
        String variableKey = "aVariableKey";
        String variableValue = "1abc";
        String type = "Double";
        Map<String, Object> variableJson = VariablesBuilder.getVariableValueMap((Object)variableValue, type);
        RestAssured.given().pathParam("id", (Object)"aCaseExecutionId").pathParam("varId", (Object)variableKey).contentType(ContentType.JSON).body(variableJson).then().expect().statusCode(Response.Status.BAD_REQUEST.getStatusCode()).body("type", CoreMatchers.equalTo((Object)InvalidRequestException.class.getSimpleName()), new Object[0]).body("message", CoreMatchers.equalTo((Object)("Cannot put case execution variable aVariableKey: " + ErrorMessageHelper.getExpectedFailingConversionMessage(variableValue, type, Double.class))), new Object[0]).when().put(SINGLE_CASE_EXECUTION_VARIABLE_URL, new Object[0]);
    }

    @Test
    public void testPutSingleLocalVariableWithTypeBoolean() {
        String variableKey = "aVariableKey";
        Boolean variableValue = true;
        String type = "Boolean";
        Map<String, Object> variableJson = VariablesBuilder.getVariableValueMap((Object)variableValue, type);
        RestAssured.given().pathParam("id", (Object)"aCaseExecutionId").pathParam("varId", (Object)variableKey).contentType(ContentType.JSON).body(variableJson).then().expect().statusCode(Response.Status.NO_CONTENT.getStatusCode()).when().put(SINGLE_CASE_EXECUTION_LOCAL_VARIABLE_URL, new Object[0]);
        ((CaseService)Mockito.verify((Object)this.caseServiceMock)).withCaseExecution("aCaseExecutionId");
        ((CaseExecutionCommandBuilder)Mockito.verify((Object)this.caseExecutionCommandBuilderMock)).setVariableLocal((String)Mockito.eq((Object)variableKey), MockitoHamcrest.argThat((Matcher)EqualsPrimitiveValue.booleanValue(variableValue)));
        ((CaseExecutionCommandBuilder)Mockito.verify((Object)this.caseExecutionCommandBuilderMock)).execute();
    }

    @Test
    public void testPutSingleVariableWithTypeBoolean() {
        String variableKey = "aVariableKey";
        Boolean variableValue = true;
        String type = "Boolean";
        Map<String, Object> variableJson = VariablesBuilder.getVariableValueMap((Object)variableValue, type);
        RestAssured.given().pathParam("id", (Object)"aCaseExecutionId").pathParam("varId", (Object)variableKey).contentType(ContentType.JSON).body(variableJson).then().expect().statusCode(Response.Status.NO_CONTENT.getStatusCode()).when().put(SINGLE_CASE_EXECUTION_VARIABLE_URL, new Object[0]);
        ((CaseService)Mockito.verify((Object)this.caseServiceMock)).withCaseExecution("aCaseExecutionId");
        ((CaseExecutionCommandBuilder)Mockito.verify((Object)this.caseExecutionCommandBuilderMock)).setVariable((String)Mockito.eq((Object)variableKey), MockitoHamcrest.argThat((Matcher)EqualsPrimitiveValue.booleanValue(variableValue)));
        ((CaseExecutionCommandBuilder)Mockito.verify((Object)this.caseExecutionCommandBuilderMock)).execute();
    }

    @Test
    public void testPutSingleLocalVariableWithTypeDate() throws Exception {
        Date now = new Date();
        String variableKey = "aVariableKey";
        String variableValue = DateTimeUtils.DATE_FORMAT_WITH_TIMEZONE.format(now);
        String type = "Date";
        Date expectedValue = DateTimeUtils.DATE_FORMAT_WITH_TIMEZONE.parse(variableValue);
        Map<String, Object> variableJson = VariablesBuilder.getVariableValueMap((Object)variableValue, type);
        RestAssured.given().pathParam("id", (Object)"aCaseExecutionId").pathParam("varId", (Object)variableKey).contentType(ContentType.JSON).body(variableJson).then().expect().statusCode(Response.Status.NO_CONTENT.getStatusCode()).when().put(SINGLE_CASE_EXECUTION_LOCAL_VARIABLE_URL, new Object[0]);
        ((CaseService)Mockito.verify((Object)this.caseServiceMock)).withCaseExecution("aCaseExecutionId");
        ((CaseExecutionCommandBuilder)Mockito.verify((Object)this.caseExecutionCommandBuilderMock)).setVariableLocal((String)Mockito.eq((Object)variableKey), MockitoHamcrest.argThat((Matcher)EqualsPrimitiveValue.dateValue(expectedValue)));
        ((CaseExecutionCommandBuilder)Mockito.verify((Object)this.caseExecutionCommandBuilderMock)).execute();
    }

    @Test
    public void testPutSingleVariableWithTypeDate() throws Exception {
        Date now = new Date();
        String variableKey = "aVariableKey";
        String variableValue = DateTimeUtils.DATE_FORMAT_WITH_TIMEZONE.format(now);
        String type = "Date";
        Date expectedValue = DateTimeUtils.DATE_FORMAT_WITH_TIMEZONE.parse(variableValue);
        Map<String, Object> variableJson = VariablesBuilder.getVariableValueMap((Object)variableValue, type);
        RestAssured.given().pathParam("id", (Object)"aCaseExecutionId").pathParam("varId", (Object)variableKey).contentType(ContentType.JSON).body(variableJson).then().expect().statusCode(Response.Status.NO_CONTENT.getStatusCode()).when().put(SINGLE_CASE_EXECUTION_VARIABLE_URL, new Object[0]);
        ((CaseService)Mockito.verify((Object)this.caseServiceMock)).withCaseExecution("aCaseExecutionId");
        ((CaseExecutionCommandBuilder)Mockito.verify((Object)this.caseExecutionCommandBuilderMock)).setVariable((String)Mockito.eq((Object)variableKey), MockitoHamcrest.argThat((Matcher)EqualsPrimitiveValue.dateValue(expectedValue)));
        ((CaseExecutionCommandBuilder)Mockito.verify((Object)this.caseExecutionCommandBuilderMock)).execute();
    }

    @Test
    public void testPutSingleLocalVariableWithUnparseableDate() {
        String variableKey = "aVariableKey";
        String variableValue = "1abc";
        String type = "Date";
        Map<String, Object> variableJson = VariablesBuilder.getVariableValueMap((Object)variableValue, type);
        RestAssured.given().pathParam("id", (Object)"aCaseExecutionId").pathParam("varId", (Object)variableKey).contentType(ContentType.JSON).body(variableJson).then().expect().statusCode(Response.Status.BAD_REQUEST.getStatusCode()).body("type", CoreMatchers.equalTo((Object)InvalidRequestException.class.getSimpleName()), new Object[0]).body("message", CoreMatchers.equalTo((Object)("Cannot put case execution variable aVariableKey: " + ErrorMessageHelper.getExpectedFailingConversionMessage(variableValue, type, Date.class))), new Object[0]).when().put(SINGLE_CASE_EXECUTION_LOCAL_VARIABLE_URL, new Object[0]);
    }

    @Test
    public void testPutSingleVariableWithUnparseableDate() {
        String variableKey = "aVariableKey";
        String variableValue = "1abc";
        String type = "Date";
        Map<String, Object> variableJson = VariablesBuilder.getVariableValueMap((Object)variableValue, type);
        RestAssured.given().pathParam("id", (Object)"aCaseExecutionId").pathParam("varId", (Object)variableKey).contentType(ContentType.JSON).body(variableJson).then().expect().statusCode(Response.Status.BAD_REQUEST.getStatusCode()).body("type", CoreMatchers.equalTo((Object)InvalidRequestException.class.getSimpleName()), new Object[0]).body("message", CoreMatchers.equalTo((Object)("Cannot put case execution variable aVariableKey: " + ErrorMessageHelper.getExpectedFailingConversionMessage(variableValue, type, Date.class))), new Object[0]).when().put(SINGLE_CASE_EXECUTION_VARIABLE_URL, new Object[0]);
    }

    @Test
    public void testPutSingleLocalVariableWithNotSupportedType() {
        String variableKey = "aVariableKey";
        String variableValue = "1abc";
        String type = "X";
        Map<String, Object> variableJson = VariablesBuilder.getVariableValueMap((Object)variableValue, type);
        RestAssured.given().pathParam("id", (Object)"aCaseExecutionId").pathParam("varId", (Object)variableKey).contentType(ContentType.JSON).body(variableJson).then().expect().statusCode(Response.Status.BAD_REQUEST.getStatusCode()).body("type", CoreMatchers.equalTo((Object)InvalidRequestException.class.getSimpleName()), new Object[0]).body("message", CoreMatchers.equalTo((Object)"Cannot put case execution variable aVariableKey: Unsupported value type 'X'"), new Object[0]).when().put(SINGLE_CASE_EXECUTION_LOCAL_VARIABLE_URL, new Object[0]);
    }

    @Test
    public void testPutSingleVariableWithNotSupportedType() {
        String variableKey = "aVariableKey";
        String variableValue = "1abc";
        String type = "X";
        Map<String, Object> variableJson = VariablesBuilder.getVariableValueMap((Object)variableValue, type);
        RestAssured.given().pathParam("id", (Object)"aCaseExecutionId").pathParam("varId", (Object)variableKey).contentType(ContentType.JSON).body(variableJson).then().expect().statusCode(Response.Status.BAD_REQUEST.getStatusCode()).body("type", CoreMatchers.equalTo((Object)InvalidRequestException.class.getSimpleName()), new Object[0]).body("message", CoreMatchers.equalTo((Object)"Cannot put case execution variable aVariableKey: Unsupported value type 'X'"), new Object[0]).when().put(SINGLE_CASE_EXECUTION_VARIABLE_URL, new Object[0]);
    }

    @Test
    public void testPutSingleLocalBinaryVariable() throws Exception {
        byte[] bytes = "someContent".getBytes();
        String variableKey = "aVariableKey";
        RestAssured.given().pathParam("id", (Object)"aCaseExecutionId").pathParam("varId", (Object)variableKey).multiPart("data", null, bytes).expect().statusCode(Response.Status.NO_CONTENT.getStatusCode()).when().post(SINGLE_CASE_EXECUTION_LOCAL_BINARY_VARIABLE_URL, new Object[0]);
        ((CaseService)Mockito.verify((Object)this.caseServiceMock)).withCaseExecution("aCaseExecutionId");
        ((CaseExecutionCommandBuilder)Mockito.verify((Object)this.caseExecutionCommandBuilderMock)).setVariableLocal((String)Mockito.eq((Object)variableKey), MockitoHamcrest.argThat((Matcher)EqualsPrimitiveValue.bytesValue(bytes)));
        ((CaseExecutionCommandBuilder)Mockito.verify((Object)this.caseExecutionCommandBuilderMock)).execute();
    }

    @Test
    public void testPutSingleBinaryVariable() throws Exception {
        byte[] bytes = "someContent".getBytes();
        String variableKey = "aVariableKey";
        RestAssured.given().pathParam("id", (Object)"aCaseExecutionId").pathParam("varId", (Object)variableKey).multiPart("data", null, bytes, "application/octet-stream").expect().statusCode(Response.Status.NO_CONTENT.getStatusCode()).when().post(SINGLE_CASE_EXECUTION_BINARY_VARIABLE_URL, new Object[0]);
        ((CaseService)Mockito.verify((Object)this.caseServiceMock)).withCaseExecution("aCaseExecutionId");
        ((CaseExecutionCommandBuilder)Mockito.verify((Object)this.caseExecutionCommandBuilderMock)).setVariable((String)Mockito.eq((Object)variableKey), MockitoHamcrest.argThat((Matcher)EqualsPrimitiveValue.bytesValue(bytes)));
        ((CaseExecutionCommandBuilder)Mockito.verify((Object)this.caseExecutionCommandBuilderMock)).execute();
    }

    @Test
    public void testPutSingleLocalBinaryVariableWithValueType() throws Exception {
        byte[] bytes = "someContent".getBytes();
        String variableKey = "aVariableKey";
        RestAssured.given().pathParam("id", (Object)"aCaseExecutionId").pathParam("varId", (Object)variableKey).multiPart("data", null, bytes).multiPart("valueType", "Bytes", "text/plain").expect().statusCode(Response.Status.NO_CONTENT.getStatusCode()).when().post(SINGLE_CASE_EXECUTION_LOCAL_BINARY_VARIABLE_URL, new Object[0]);
        ((CaseService)Mockito.verify((Object)this.caseServiceMock)).withCaseExecution("aCaseExecutionId");
        ((CaseExecutionCommandBuilder)Mockito.verify((Object)this.caseExecutionCommandBuilderMock)).setVariableLocal((String)Mockito.eq((Object)variableKey), MockitoHamcrest.argThat((Matcher)EqualsPrimitiveValue.bytesValue(bytes)));
        ((CaseExecutionCommandBuilder)Mockito.verify((Object)this.caseExecutionCommandBuilderMock)).execute();
    }

    @Test
    public void testPutSingleBinaryVariableWithValueType() {
        byte[] bytes = "someContent".getBytes();
        String variableKey = "aVariableKey";
        RestAssured.given().pathParam("id", (Object)"aCaseExecutionId").pathParam("varId", (Object)variableKey).multiPart("data", null, bytes).multiPart("valueType", "Bytes", "text/plain").expect().statusCode(Response.Status.NO_CONTENT.getStatusCode()).when().post(SINGLE_CASE_EXECUTION_LOCAL_BINARY_VARIABLE_URL, new Object[0]);
        ((CaseService)Mockito.verify((Object)this.caseServiceMock)).withCaseExecution("aCaseExecutionId");
        ((CaseExecutionCommandBuilder)Mockito.verify((Object)this.caseExecutionCommandBuilderMock)).setVariableLocal((String)Mockito.eq((Object)variableKey), MockitoHamcrest.argThat((Matcher)EqualsPrimitiveValue.bytesValue(bytes)));
        ((CaseExecutionCommandBuilder)Mockito.verify((Object)this.caseExecutionCommandBuilderMock)).execute();
    }

    @Test
    public void testPutSingleLocalBinaryVariableWithNoValue() throws Exception {
        byte[] bytes = new byte[]{};
        String variableKey = "aVariableKey";
        RestAssured.given().pathParam("id", (Object)"aCaseExecutionId").pathParam("varId", (Object)variableKey).multiPart("data", null, bytes).expect().statusCode(Response.Status.NO_CONTENT.getStatusCode()).when().post(SINGLE_CASE_EXECUTION_LOCAL_BINARY_VARIABLE_URL, new Object[0]);
        ((CaseService)Mockito.verify((Object)this.caseServiceMock)).withCaseExecution("aCaseExecutionId");
        ((CaseExecutionCommandBuilder)Mockito.verify((Object)this.caseExecutionCommandBuilderMock)).setVariableLocal((String)Mockito.eq((Object)variableKey), MockitoHamcrest.argThat((Matcher)EqualsPrimitiveValue.bytesValue(bytes)));
        ((CaseExecutionCommandBuilder)Mockito.verify((Object)this.caseExecutionCommandBuilderMock)).execute();
    }

    @Test
    public void testPutSingleBinaryVariableWithNoValue() throws Exception {
        byte[] bytes = new byte[]{};
        String variableKey = "aVariableKey";
        RestAssured.given().pathParam("id", (Object)"aCaseExecutionId").pathParam("varId", (Object)variableKey).multiPart("data", null, bytes).expect().statusCode(Response.Status.NO_CONTENT.getStatusCode()).when().post(SINGLE_CASE_EXECUTION_BINARY_VARIABLE_URL, new Object[0]);
        ((CaseService)Mockito.verify((Object)this.caseServiceMock)).withCaseExecution("aCaseExecutionId");
        ((CaseExecutionCommandBuilder)Mockito.verify((Object)this.caseExecutionCommandBuilderMock)).setVariable((String)Mockito.eq((Object)variableKey), MockitoHamcrest.argThat((Matcher)EqualsPrimitiveValue.bytesValue(bytes)));
        ((CaseExecutionCommandBuilder)Mockito.verify((Object)this.caseExecutionCommandBuilderMock)).execute();
    }

    @Test
    public void testPutSingleLocalSerializableVariableFromJson() throws Exception {
        ArrayList<String> serializable = new ArrayList<String>();
        serializable.add("foo");
        ObjectMapper mapper = new ObjectMapper();
        String jsonBytes = mapper.writeValueAsString(serializable);
        String typeName = TypeFactory.defaultInstance().constructType(serializable.getClass()).toCanonical();
        String variableKey = "aVariableKey";
        RestAssured.given().pathParam("id", (Object)"aCaseExecutionId").pathParam("varId", (Object)variableKey).multiPart("data", jsonBytes, "application/json").multiPart("type", typeName, "text/plain").expect().statusCode(Response.Status.NO_CONTENT.getStatusCode()).when().post(SINGLE_CASE_EXECUTION_LOCAL_BINARY_VARIABLE_URL, new Object[0]);
        ((CaseService)Mockito.verify((Object)this.caseServiceMock)).withCaseExecution("aCaseExecutionId");
        ((CaseExecutionCommandBuilder)Mockito.verify((Object)this.caseExecutionCommandBuilderMock)).setVariableLocal((String)Mockito.eq((Object)variableKey), MockitoHamcrest.argThat((Matcher)EqualsObjectValue.objectValueMatcher().isDeserialized().value(serializable)));
        ((CaseExecutionCommandBuilder)Mockito.verify((Object)this.caseExecutionCommandBuilderMock)).execute();
    }

    @Test
    public void testPutSingleSerializableVariableFormJson() throws Exception {
        ArrayList<String> serializable = new ArrayList<String>();
        serializable.add("foo");
        ObjectMapper mapper = new ObjectMapper();
        String jsonBytes = mapper.writeValueAsString(serializable);
        String typeName = TypeFactory.defaultInstance().constructType(serializable.getClass()).toCanonical();
        String variableKey = "aVariableKey";
        RestAssured.given().pathParam("id", (Object)"aCaseExecutionId").pathParam("varId", (Object)variableKey).multiPart("data", jsonBytes, "application/json").multiPart("type", typeName, "text/plain").expect().statusCode(Response.Status.NO_CONTENT.getStatusCode()).when().post(SINGLE_CASE_EXECUTION_BINARY_VARIABLE_URL, new Object[0]);
        ((CaseService)Mockito.verify((Object)this.caseServiceMock)).withCaseExecution("aCaseExecutionId");
        ((CaseExecutionCommandBuilder)Mockito.verify((Object)this.caseExecutionCommandBuilderMock)).setVariable((String)Mockito.eq((Object)variableKey), MockitoHamcrest.argThat((Matcher)EqualsObjectValue.objectValueMatcher().isDeserialized().value(serializable)));
        ((CaseExecutionCommandBuilder)Mockito.verify((Object)this.caseExecutionCommandBuilderMock)).execute();
    }

    @Test
    public void testPutSingleLocalSerializableVariableUnsupportedMediaType() throws Exception {
        ArrayList<String> serializable = new ArrayList<String>();
        serializable.add("foo");
        ObjectMapper mapper = new ObjectMapper();
        String jsonBytes = mapper.writeValueAsString(serializable);
        String typeName = TypeFactory.defaultInstance().constructType(serializable.getClass()).toCanonical();
        String variableKey = "aVariableKey";
        RestAssured.given().pathParam("id", (Object)"aCaseExecutionId").pathParam("varId", (Object)variableKey).multiPart("data", jsonBytes, "unsupported").multiPart("type", typeName, "text/plain").expect().statusCode(Response.Status.BAD_REQUEST.getStatusCode()).body(Matchers.containsString((String)"Unrecognized content type for serialized java type: unsupported"), new Matcher[0]).when().post(SINGLE_CASE_EXECUTION_LOCAL_BINARY_VARIABLE_URL, new Object[0]);
        ((CaseService)Mockito.verify((Object)this.caseServiceMock, (VerificationMode)Mockito.never())).withCaseExecution("aCaseExecutionId");
    }

    @Test
    public void testPutSingleSerializableVariableUnsupportedMediaType() throws Exception {
        ArrayList<String> serializable = new ArrayList<String>();
        serializable.add("foo");
        ObjectMapper mapper = new ObjectMapper();
        String jsonBytes = mapper.writeValueAsString(serializable);
        String typeName = TypeFactory.defaultInstance().constructType(serializable.getClass()).toCanonical();
        String variableKey = "aVariableKey";
        RestAssured.given().pathParam("id", (Object)"aCaseExecutionId").pathParam("varId", (Object)variableKey).multiPart("data", jsonBytes, "unsupported").multiPart("type", typeName, "text/plain").expect().statusCode(Response.Status.BAD_REQUEST.getStatusCode()).body(Matchers.containsString((String)"Unrecognized content type for serialized java type: unsupported"), new Matcher[0]).when().post(SINGLE_CASE_EXECUTION_BINARY_VARIABLE_URL, new Object[0]);
        ((CaseService)Mockito.verify((Object)this.caseServiceMock, (VerificationMode)Mockito.never())).withCaseExecution("aCaseExecutionId");
    }

    @Test
    public void testPutSingleLocalVariableWithNoValue() {
        String variableKey = "aVariableKey";
        RestAssured.given().pathParam("id", (Object)"aCaseExecutionId").pathParam("varId", (Object)variableKey).contentType(ContentType.JSON).body("{}").then().expect().statusCode(Response.Status.NO_CONTENT.getStatusCode()).when().put(SINGLE_CASE_EXECUTION_LOCAL_VARIABLE_URL, new Object[0]);
        ((CaseService)Mockito.verify((Object)this.caseServiceMock)).withCaseExecution("aCaseExecutionId");
        ((CaseExecutionCommandBuilder)Mockito.verify((Object)this.caseExecutionCommandBuilderMock)).setVariableLocal((String)Mockito.eq((Object)variableKey), MockitoHamcrest.argThat((Matcher)EqualsNullValue.matcher()));
        ((CaseExecutionCommandBuilder)Mockito.verify((Object)this.caseExecutionCommandBuilderMock)).execute();
    }

    @Test
    public void testPutSingleVariableWithNoValue() {
        String variableKey = "aVariableKey";
        RestAssured.given().pathParam("id", (Object)"aCaseExecutionId").pathParam("varId", (Object)variableKey).contentType(ContentType.JSON).body("{}").then().expect().statusCode(Response.Status.NO_CONTENT.getStatusCode()).when().put(SINGLE_CASE_EXECUTION_VARIABLE_URL, new Object[0]);
        ((CaseService)Mockito.verify((Object)this.caseServiceMock)).withCaseExecution("aCaseExecutionId");
        ((CaseExecutionCommandBuilder)Mockito.verify((Object)this.caseExecutionCommandBuilderMock)).setVariable((String)Mockito.eq((Object)variableKey), MockitoHamcrest.argThat((Matcher)EqualsNullValue.matcher()));
        ((CaseExecutionCommandBuilder)Mockito.verify((Object)this.caseExecutionCommandBuilderMock)).execute();
    }

    @Test
    public void testPutLocalVariableForNonExistingExecution() {
        String variableKey = "aVariableKey";
        String variableValue = "aVariableValue";
        Map<String, Object> variableJson = VariablesBuilder.getVariableValueMap(variableValue);
        ((CaseExecutionCommandBuilder)Mockito.doThrow((Throwable[])new Throwable[]{new ProcessEngineException("expected exception")}).when((Object)this.caseExecutionCommandBuilderMock)).execute();
        RestAssured.given().pathParam("id", (Object)"aCaseExecutionId").pathParam("varId", (Object)variableKey).contentType(ContentType.JSON).body(variableJson).then().expect().statusCode(Response.Status.INTERNAL_SERVER_ERROR.getStatusCode()).body("type", Matchers.is((Object)RestException.class.getSimpleName()), new Object[0]).body("message", Matchers.is((Object)("Cannot put case execution variable " + variableKey + ": expected exception")), new Object[0]).when().put(SINGLE_CASE_EXECUTION_LOCAL_VARIABLE_URL, new Object[0]);
    }

    @Test
    public void testPostSingleLocalFileVariableWithEncodingAndMimeType() throws Exception {
        byte[] value = "some text".getBytes();
        String variableKey = "aVariableKey";
        String encoding = "utf-8";
        String filename = "test.txt";
        String mimetype = "text/plain";
        RestAssured.given().pathParam("id", (Object)"aCaseExecutionId").pathParam("varId", (Object)variableKey).multiPart("data", filename, value, mimetype + "; encoding=" + encoding).multiPart("valueType", "File", "text/plain").expect().statusCode(Response.Status.NO_CONTENT.getStatusCode()).when().post(SINGLE_CASE_EXECUTION_LOCAL_BINARY_VARIABLE_URL, new Object[0]);
        ArgumentCaptor captor = ArgumentCaptor.forClass(FileValue.class);
        ((CaseService)Mockito.verify((Object)this.caseServiceMock)).withCaseExecution("aCaseExecutionId");
        ((CaseExecutionCommandBuilder)Mockito.verify((Object)this.caseExecutionCommandBuilderMock)).setVariableLocal((String)Mockito.eq((Object)variableKey), captor.capture());
        FileValue captured = (FileValue)captor.getValue();
        MatcherAssert.assertThat((Object)captured.getEncoding(), (Matcher)Matchers.is((Object)encoding));
        MatcherAssert.assertThat((Object)captured.getFilename(), (Matcher)Matchers.is((Object)filename));
        MatcherAssert.assertThat((Object)captured.getMimeType(), (Matcher)Matchers.is((Object)mimetype));
        MatcherAssert.assertThat((Object)IoUtil.readInputStream((InputStream)captured.getValue(), null), (Matcher)Matchers.is((Object)value));
    }

    @Test
    public void testPostSingleLocalFileVariableWithMimeType() throws Exception {
        byte[] value = "some text".getBytes();
        String variableKey = "aVariableKey";
        String filename = "test.txt";
        String mimetype = "text/plain";
        RestAssured.given().pathParam("id", (Object)"aCaseExecutionId").pathParam("varId", (Object)variableKey).multiPart("data", filename, value, mimetype).multiPart("valueType", "File", "text/plain").header("accept", (Object)"application/json", new Object[0]).expect().statusCode(Response.Status.NO_CONTENT.getStatusCode()).when().post(SINGLE_CASE_EXECUTION_LOCAL_BINARY_VARIABLE_URL, new Object[0]);
        ArgumentCaptor captor = ArgumentCaptor.forClass(FileValue.class);
        ((CaseService)Mockito.verify((Object)this.caseServiceMock)).withCaseExecution("aCaseExecutionId");
        ((CaseExecutionCommandBuilder)Mockito.verify((Object)this.caseExecutionCommandBuilderMock)).setVariableLocal((String)Mockito.eq((Object)variableKey), captor.capture());
        FileValue captured = (FileValue)captor.getValue();
        MatcherAssert.assertThat((Object)captured.getEncoding(), (Matcher)Matchers.is((Matcher)CoreMatchers.nullValue()));
        MatcherAssert.assertThat((Object)captured.getFilename(), (Matcher)Matchers.is((Object)filename));
        MatcherAssert.assertThat((Object)captured.getMimeType(), (Matcher)Matchers.is((Object)mimetype));
        MatcherAssert.assertThat((Object)IoUtil.readInputStream((InputStream)captured.getValue(), null), (Matcher)Matchers.is((Object)value));
    }

    @Test
    public void testPostSingleLocalFileVariableWithEncoding() throws Exception {
        byte[] value = "some text".getBytes();
        String variableKey = "aVariableKey";
        String encoding = "utf-8";
        String filename = "test.txt";
        RestAssured.given().pathParam("id", (Object)"aCaseExecutionId").pathParam("varId", (Object)variableKey).multiPart("data", filename, value, "encoding=" + encoding).multiPart("valueType", "File", "text/plain").header("accept", (Object)"application/json", new Object[0]).expect().statusCode(Response.Status.BAD_REQUEST.getStatusCode()).when().post(SINGLE_CASE_EXECUTION_LOCAL_BINARY_VARIABLE_URL, new Object[0]);
    }

    @Test
    public void testPostSingleLocalFileVariableOnlyFilename() throws Exception {
        String variableKey = "aVariableKey";
        String filename = "test.txt";
        RestAssured.given().pathParam("id", (Object)"aCaseExecutionId").pathParam("varId", (Object)variableKey).multiPart("data", filename, new byte[0]).multiPart("valueType", "File", "text/plain").header("accept", (Object)"application/json", new Object[0]).expect().statusCode(Response.Status.NO_CONTENT.getStatusCode()).when().post(SINGLE_CASE_EXECUTION_LOCAL_BINARY_VARIABLE_URL, new Object[0]);
        ArgumentCaptor captor = ArgumentCaptor.forClass(FileValue.class);
        ((CaseService)Mockito.verify((Object)this.caseServiceMock)).withCaseExecution("aCaseExecutionId");
        ((CaseExecutionCommandBuilder)Mockito.verify((Object)this.caseExecutionCommandBuilderMock)).setVariableLocal((String)Mockito.eq((Object)variableKey), captor.capture());
        FileValue captured = (FileValue)captor.getValue();
        MatcherAssert.assertThat((Object)captured.getEncoding(), (Matcher)Matchers.is((Matcher)CoreMatchers.nullValue()));
        MatcherAssert.assertThat((Object)captured.getFilename(), (Matcher)Matchers.is((Object)filename));
        MatcherAssert.assertThat((Object)captured.getMimeType(), (Matcher)Matchers.is((Object)"application/octet-stream"));
        MatcherAssert.assertThat((Object)captured.getValue().available(), (Matcher)Matchers.is((Object)0));
    }

    @Test
    public void testPostSingleFileVariable() throws Exception {
        byte[] value = "some text".getBytes();
        String variableKey = "aVariableKey";
        String encoding = "utf-8";
        String filename = "test.txt";
        String mimetype = "text/plain";
        RestAssured.given().pathParam("id", (Object)"aCaseExecutionId").pathParam("varId", (Object)variableKey).multiPart("data", filename, value, mimetype + "; encoding=" + encoding).header("accept", (Object)"application/json", new Object[0]).multiPart("valueType", "File", "text/plain").expect().statusCode(Response.Status.NO_CONTENT.getStatusCode()).when().post(SINGLE_CASE_EXECUTION_BINARY_VARIABLE_URL, new Object[0]);
        ArgumentCaptor captor = ArgumentCaptor.forClass(FileValue.class);
        ((CaseService)Mockito.verify((Object)this.caseServiceMock)).withCaseExecution("aCaseExecutionId");
        ((CaseExecutionCommandBuilder)Mockito.verify((Object)this.caseExecutionCommandBuilderMock)).setVariable((String)Mockito.eq((Object)variableKey), captor.capture());
        FileValue captured = (FileValue)captor.getValue();
        MatcherAssert.assertThat((Object)captured.getEncoding(), (Matcher)Matchers.is((Object)encoding));
        MatcherAssert.assertThat((Object)captured.getFilename(), (Matcher)Matchers.is((Object)filename));
        MatcherAssert.assertThat((Object)captured.getMimeType(), (Matcher)Matchers.is((Object)mimetype));
        MatcherAssert.assertThat((Object)IoUtil.readInputStream((InputStream)captured.getValue(), null), (Matcher)Matchers.is((Object)value));
    }

    @Test
    public void testPutVariableForNonExistingExecution() {
        String variableKey = "aVariableKey";
        String variableValue = "aVariableValue";
        Map<String, Object> variableJson = VariablesBuilder.getVariableValueMap(variableValue);
        ((CaseExecutionCommandBuilder)Mockito.doThrow((Throwable[])new Throwable[]{new ProcessEngineException("expected exception")}).when((Object)this.caseExecutionCommandBuilderMock)).execute();
        RestAssured.given().pathParam("id", (Object)"aCaseExecutionId").pathParam("varId", (Object)variableKey).contentType(ContentType.JSON).body(variableJson).then().expect().statusCode(Response.Status.INTERNAL_SERVER_ERROR.getStatusCode()).body("type", Matchers.is((Object)RestException.class.getSimpleName()), new Object[0]).body("message", Matchers.is((Object)("Cannot put case execution variable " + variableKey + ": expected exception")), new Object[0]).when().put(SINGLE_CASE_EXECUTION_VARIABLE_URL, new Object[0]);
    }

    @Test
    public void testDeleteSingleLocalVariable() {
        String variableKey = "aVariableKey";
        RestAssured.given().pathParam("id", (Object)"aCaseExecutionId").pathParam("varId", (Object)variableKey).then().expect().statusCode(Response.Status.NO_CONTENT.getStatusCode()).when().delete(SINGLE_CASE_EXECUTION_LOCAL_VARIABLE_URL, new Object[0]);
        ((CaseService)Mockito.verify((Object)this.caseServiceMock)).withCaseExecution("aCaseExecutionId");
        ((CaseExecutionCommandBuilder)Mockito.verify((Object)this.caseExecutionCommandBuilderMock)).removeVariableLocal(variableKey);
        ((CaseExecutionCommandBuilder)Mockito.verify((Object)this.caseExecutionCommandBuilderMock)).execute();
    }

    @Test
    public void testDeleteSingleVariable() {
        String variableKey = "aVariableKey";
        RestAssured.given().pathParam("id", (Object)"aCaseExecutionId").pathParam("varId", (Object)variableKey).then().expect().statusCode(Response.Status.NO_CONTENT.getStatusCode()).when().delete(SINGLE_CASE_EXECUTION_VARIABLE_URL, new Object[0]);
        ((CaseService)Mockito.verify((Object)this.caseServiceMock)).withCaseExecution("aCaseExecutionId");
        ((CaseExecutionCommandBuilder)Mockito.verify((Object)this.caseExecutionCommandBuilderMock)).removeVariable(variableKey);
        ((CaseExecutionCommandBuilder)Mockito.verify((Object)this.caseExecutionCommandBuilderMock)).execute();
    }

    @Test
    public void testDeleteLocalVariableForNonExistingExecution() {
        String variableKey = "aVariableKey";
        ((CaseExecutionCommandBuilder)Mockito.doThrow((Throwable[])new Throwable[]{new ProcessEngineException("expected exception")}).when((Object)this.caseExecutionCommandBuilderMock)).execute();
        RestAssured.given().pathParam("id", (Object)"aCaseExecutionId").pathParam("varId", (Object)variableKey).then().expect().statusCode(Response.Status.INTERNAL_SERVER_ERROR.getStatusCode()).contentType(ContentType.JSON).body("type", Matchers.is((Object)RestException.class.getSimpleName()), new Object[0]).body("message", Matchers.is((Object)("Cannot delete case execution variable " + variableKey + ": expected exception")), new Object[0]).when().delete(SINGLE_CASE_EXECUTION_LOCAL_VARIABLE_URL, new Object[0]);
    }

    @Test
    public void testDeleteVariableForNonExistingExecution() {
        String variableKey = "aVariableKey";
        ((CaseExecutionCommandBuilder)Mockito.doThrow((Throwable[])new Throwable[]{new ProcessEngineException("expected exception")}).when((Object)this.caseExecutionCommandBuilderMock)).execute();
        RestAssured.given().pathParam("id", (Object)"aCaseExecutionId").pathParam("varId", (Object)variableKey).then().expect().statusCode(Response.Status.INTERNAL_SERVER_ERROR.getStatusCode()).contentType(ContentType.JSON).body("type", Matchers.is((Object)RestException.class.getSimpleName()), new Object[0]).body("message", Matchers.is((Object)("Cannot delete case execution variable " + variableKey + ": expected exception")), new Object[0]).when().delete(SINGLE_CASE_EXECUTION_VARIABLE_URL, new Object[0]);
    }

    @Test
    public void testComplete() {
        RestAssured.given().pathParam("id", (Object)"aCaseExecutionId").contentType(ContentType.JSON).body("{}").then().expect().statusCode(Response.Status.NO_CONTENT.getStatusCode()).when().post(CASE_EXECUTION_COMPLETE_URL, new Object[0]);
        ((CaseService)Mockito.verify((Object)this.caseServiceMock)).withCaseExecution("aCaseExecutionId");
        ((CaseExecutionCommandBuilder)Mockito.verify((Object)this.caseExecutionCommandBuilderMock)).complete();
    }

    @Test
    public void testUnsuccessfulComplete() {
        ((CaseExecutionCommandBuilder)Mockito.doThrow((Throwable[])new Throwable[]{new NotValidException("expected exception")}).when((Object)this.caseExecutionCommandBuilderMock)).complete();
        RestAssured.given().pathParam("id", (Object)"aCaseExecutionId").contentType(ContentType.JSON).body("{}").then().expect().statusCode(Response.Status.BAD_REQUEST.getStatusCode()).body("type", CoreMatchers.equalTo((Object)InvalidRequestException.class.getSimpleName()), new Object[0]).body("message", Matchers.containsString((String)"Cannot complete case execution aCaseExecutionId: expected exception"), new Object[0]).when().post(CASE_EXECUTION_COMPLETE_URL, new Object[0]);
        ((CaseService)Mockito.verify((Object)this.caseServiceMock)).withCaseExecution("aCaseExecutionId");
        ((CaseExecutionCommandBuilder)Mockito.verify((Object)this.caseExecutionCommandBuilderMock)).complete();
    }

    @Test
    public void testCompleteWithSetVariable() {
        String aVariableKey = "aKey";
        int aVariableValue = 123;
        String anotherVariableKey = "anotherKey";
        String anotherVariableValue = "abc";
        HashMap<String, Map<String, Object>> variablesJson = new HashMap<String, Map<String, Object>>();
        Map<String, Object> variables = VariablesBuilder.create().variable(aVariableKey, (Object)aVariableValue, "Integer").variable(anotherVariableKey, (Object)anotherVariableValue, "String").getVariables();
        variablesJson.put("variables", variables);
        RestAssured.given().pathParam("id", (Object)"aCaseExecutionId").contentType(ContentType.JSON).body(variablesJson).then().expect().statusCode(Response.Status.NO_CONTENT.getStatusCode()).when().post(CASE_EXECUTION_COMPLETE_URL, new Object[0]);
        ((CaseService)Mockito.verify((Object)this.caseServiceMock)).withCaseExecution("aCaseExecutionId");
        ((CaseExecutionCommandBuilder)Mockito.verify((Object)this.caseExecutionCommandBuilderMock)).setVariable((String)Mockito.eq((Object)aVariableKey), MockitoHamcrest.argThat((Matcher)EqualsPrimitiveValue.integerValue(aVariableValue)));
        ((CaseExecutionCommandBuilder)Mockito.verify((Object)this.caseExecutionCommandBuilderMock)).setVariable((String)Mockito.eq((Object)anotherVariableKey), MockitoHamcrest.argThat((Matcher)EqualsPrimitiveValue.stringValue(anotherVariableValue)));
        ((CaseExecutionCommandBuilder)Mockito.verify((Object)this.caseExecutionCommandBuilderMock)).complete();
    }

    @Test
    public void testCompleteWithSetVariableLocal() {
        String aVariableKey = "aKey";
        int aVariableValue = 123;
        String anotherVariableKey = "anotherKey";
        String anotherVariableValue = "abc";
        HashMap<String, Map<String, Object>> variablesJson = new HashMap<String, Map<String, Object>>();
        Map<String, Object> variables = VariablesBuilder.create().variable(aVariableKey, aVariableValue, "Integer", true).variable(anotherVariableKey, anotherVariableValue, "String", true).getVariables();
        variablesJson.put("variables", variables);
        RestAssured.given().pathParam("id", (Object)"aCaseExecutionId").contentType(ContentType.JSON).body(variablesJson).then().expect().statusCode(Response.Status.NO_CONTENT.getStatusCode()).when().post(CASE_EXECUTION_COMPLETE_URL, new Object[0]);
        ((CaseService)Mockito.verify((Object)this.caseServiceMock)).withCaseExecution("aCaseExecutionId");
        ((CaseExecutionCommandBuilder)Mockito.verify((Object)this.caseExecutionCommandBuilderMock)).setVariableLocal((String)Mockito.eq((Object)aVariableKey), MockitoHamcrest.argThat((Matcher)EqualsPrimitiveValue.integerValue(aVariableValue)));
        ((CaseExecutionCommandBuilder)Mockito.verify((Object)this.caseExecutionCommandBuilderMock)).setVariableLocal((String)Mockito.eq((Object)anotherVariableKey), MockitoHamcrest.argThat((Matcher)EqualsPrimitiveValue.stringValue(anotherVariableValue)));
        ((CaseExecutionCommandBuilder)Mockito.verify((Object)this.caseExecutionCommandBuilderMock)).complete();
    }

    @Test
    public void testCompleteWithSetVariableAndVariableLocal() {
        String aVariableKey = "aKey";
        int aVariableValue = 123;
        String anotherVariableKey = "anotherKey";
        String anotherVariableValue = "abc";
        HashMap<String, Map<String, Object>> variablesJson = new HashMap<String, Map<String, Object>>();
        Map<String, Object> variables = VariablesBuilder.create().variable(aVariableKey, (Object)aVariableValue, "Integer").variable(anotherVariableKey, anotherVariableValue, "String", true).getVariables();
        variablesJson.put("variables", variables);
        RestAssured.given().pathParam("id", (Object)"aCaseExecutionId").contentType(ContentType.JSON).body(variablesJson).then().expect().statusCode(Response.Status.NO_CONTENT.getStatusCode()).when().post(CASE_EXECUTION_COMPLETE_URL, new Object[0]);
        ((CaseService)Mockito.verify((Object)this.caseServiceMock)).withCaseExecution("aCaseExecutionId");
        ((CaseExecutionCommandBuilder)Mockito.verify((Object)this.caseExecutionCommandBuilderMock)).setVariable((String)Mockito.eq((Object)aVariableKey), MockitoHamcrest.argThat((Matcher)EqualsPrimitiveValue.integerValue(aVariableValue)));
        ((CaseExecutionCommandBuilder)Mockito.verify((Object)this.caseExecutionCommandBuilderMock)).setVariableLocal((String)Mockito.eq((Object)anotherVariableKey), MockitoHamcrest.argThat((Matcher)EqualsPrimitiveValue.stringValue(anotherVariableValue)));
        ((CaseExecutionCommandBuilder)Mockito.verify((Object)this.caseExecutionCommandBuilderMock)).complete();
    }

    @Test
    public void testCompleteWithRemoveVariable() {
        String aVariableKey = "aKey";
        String anotherVariableKey = "anotherKey";
        ArrayList<VariableNameDto> variableNames = new ArrayList<VariableNameDto>();
        VariableNameDto firstVariableName = new VariableNameDto(aVariableKey);
        variableNames.add(firstVariableName);
        VariableNameDto secondVariableName = new VariableNameDto(anotherVariableKey);
        variableNames.add(secondVariableName);
        HashMap<String, ArrayList<VariableNameDto>> variablesJson = new HashMap<String, ArrayList<VariableNameDto>>();
        variablesJson.put("deletions", variableNames);
        RestAssured.given().pathParam("id", (Object)"aCaseExecutionId").contentType(ContentType.JSON).body(variablesJson).then().expect().statusCode(Response.Status.NO_CONTENT.getStatusCode()).when().post(CASE_EXECUTION_COMPLETE_URL, new Object[0]);
        ((CaseService)Mockito.verify((Object)this.caseServiceMock)).withCaseExecution("aCaseExecutionId");
        ((CaseExecutionCommandBuilder)Mockito.verify((Object)this.caseExecutionCommandBuilderMock)).removeVariable(aVariableKey);
        ((CaseExecutionCommandBuilder)Mockito.verify((Object)this.caseExecutionCommandBuilderMock)).removeVariable(anotherVariableKey);
        ((CaseExecutionCommandBuilder)Mockito.verify((Object)this.caseExecutionCommandBuilderMock)).complete();
    }

    @Test
    public void testCompleteWithRemoveVariableLocal() {
        String aVariableKey = "aKey";
        String anotherVariableKey = "anotherKey";
        ArrayList<VariableNameDto> variableNames = new ArrayList<VariableNameDto>();
        VariableNameDto firstVariableName = new VariableNameDto(aVariableKey, true);
        variableNames.add(firstVariableName);
        VariableNameDto secondVariableName = new VariableNameDto(anotherVariableKey, true);
        variableNames.add(secondVariableName);
        HashMap<String, ArrayList<VariableNameDto>> variablesJson = new HashMap<String, ArrayList<VariableNameDto>>();
        variablesJson.put("deletions", variableNames);
        RestAssured.given().pathParam("id", (Object)"aCaseExecutionId").contentType(ContentType.JSON).body(variablesJson).then().expect().statusCode(Response.Status.NO_CONTENT.getStatusCode()).when().post(CASE_EXECUTION_COMPLETE_URL, new Object[0]);
        ((CaseService)Mockito.verify((Object)this.caseServiceMock)).withCaseExecution("aCaseExecutionId");
        ((CaseExecutionCommandBuilder)Mockito.verify((Object)this.caseExecutionCommandBuilderMock)).removeVariableLocal(aVariableKey);
        ((CaseExecutionCommandBuilder)Mockito.verify((Object)this.caseExecutionCommandBuilderMock)).removeVariableLocal(anotherVariableKey);
        ((CaseExecutionCommandBuilder)Mockito.verify((Object)this.caseExecutionCommandBuilderMock)).complete();
    }

    @Test
    public void testCompleteWithRemoveVariableAndVariableLocal() {
        String aVariableKey = "aKey";
        String anotherVariableKey = "anotherKey";
        ArrayList<VariableNameDto> variableNames = new ArrayList<VariableNameDto>();
        VariableNameDto firstVariableName = new VariableNameDto(aVariableKey, true);
        variableNames.add(firstVariableName);
        VariableNameDto secondVariableName = new VariableNameDto(anotherVariableKey);
        variableNames.add(secondVariableName);
        HashMap<String, ArrayList<VariableNameDto>> variablesJson = new HashMap<String, ArrayList<VariableNameDto>>();
        variablesJson.put("deletions", variableNames);
        RestAssured.given().pathParam("id", (Object)"aCaseExecutionId").contentType(ContentType.JSON).body(variablesJson).then().expect().statusCode(Response.Status.NO_CONTENT.getStatusCode()).when().post(CASE_EXECUTION_COMPLETE_URL, new Object[0]);
        ((CaseService)Mockito.verify((Object)this.caseServiceMock)).withCaseExecution("aCaseExecutionId");
        ((CaseExecutionCommandBuilder)Mockito.verify((Object)this.caseExecutionCommandBuilderMock)).removeVariableLocal(aVariableKey);
        ((CaseExecutionCommandBuilder)Mockito.verify((Object)this.caseExecutionCommandBuilderMock)).removeVariable(anotherVariableKey);
        ((CaseExecutionCommandBuilder)Mockito.verify((Object)this.caseExecutionCommandBuilderMock)).complete();
    }

    @Test
    public void testCompleteWithSetVariableAndRemoveVariable() {
        String aVariableKey = "aKey";
        String anotherVariableKey = "anotherKey";
        String anotherVariableValue = "abc";
        Map<String, Object> variables = VariablesBuilder.create().variable(anotherVariableKey, (Object)anotherVariableValue, "String").getVariables();
        ArrayList<VariableNameDto> variableNames = new ArrayList<VariableNameDto>();
        VariableNameDto firstVariableName = new VariableNameDto(aVariableKey);
        variableNames.add(firstVariableName);
        HashMap<String, Object> variablesJson = new HashMap<String, Object>();
        variablesJson.put("variables", variables);
        variablesJson.put("deletions", variableNames);
        RestAssured.given().pathParam("id", (Object)"aCaseExecutionId").contentType(ContentType.JSON).body(variablesJson).then().expect().statusCode(Response.Status.NO_CONTENT.getStatusCode()).when().post(CASE_EXECUTION_COMPLETE_URL, new Object[0]);
        ((CaseService)Mockito.verify((Object)this.caseServiceMock)).withCaseExecution("aCaseExecutionId");
        ((CaseExecutionCommandBuilder)Mockito.verify((Object)this.caseExecutionCommandBuilderMock)).removeVariable(aVariableKey);
        ((CaseExecutionCommandBuilder)Mockito.verify((Object)this.caseExecutionCommandBuilderMock)).setVariable((String)Mockito.eq((Object)anotherVariableKey), MockitoHamcrest.argThat((Matcher)EqualsPrimitiveValue.stringValue(anotherVariableValue)));
        ((CaseExecutionCommandBuilder)Mockito.verify((Object)this.caseExecutionCommandBuilderMock)).complete();
    }

    @Test
    public void testCompleteWithSetVariableAndRemoveVariableLocal() {
        String aVariableKey = "aKey";
        String anotherVariableKey = "anotherKey";
        String anotherVariableValue = "abc";
        Map<String, Object> variables = VariablesBuilder.create().variable(anotherVariableKey, (Object)anotherVariableValue, "String").getVariables();
        ArrayList<VariableNameDto> variableNames = new ArrayList<VariableNameDto>();
        VariableNameDto firstVariableName = new VariableNameDto(aVariableKey, true);
        variableNames.add(firstVariableName);
        HashMap<String, Object> variablesJson = new HashMap<String, Object>();
        variablesJson.put("variables", variables);
        variablesJson.put("deletions", variableNames);
        RestAssured.given().pathParam("id", (Object)"aCaseExecutionId").contentType(ContentType.JSON).body(variablesJson).then().expect().statusCode(Response.Status.NO_CONTENT.getStatusCode()).when().post(CASE_EXECUTION_COMPLETE_URL, new Object[0]);
        ((CaseService)Mockito.verify((Object)this.caseServiceMock)).withCaseExecution("aCaseExecutionId");
        ((CaseExecutionCommandBuilder)Mockito.verify((Object)this.caseExecutionCommandBuilderMock)).removeVariableLocal(aVariableKey);
        ((CaseExecutionCommandBuilder)Mockito.verify((Object)this.caseExecutionCommandBuilderMock)).setVariable((String)Mockito.eq((Object)anotherVariableKey), MockitoHamcrest.argThat((Matcher)EqualsPrimitiveValue.stringValue(anotherVariableValue)));
        ((CaseExecutionCommandBuilder)Mockito.verify((Object)this.caseExecutionCommandBuilderMock)).complete();
    }

    @Test
    public void testCompleteWithSetVariableLocalAndRemoveVariable() {
        String aVariableKey = "aKey";
        String anotherVariableKey = "anotherKey";
        String anotherVariableValue = "abc";
        Map<String, Object> variables = VariablesBuilder.create().variable(anotherVariableKey, anotherVariableValue, "String", true).getVariables();
        ArrayList<VariableNameDto> variableNames = new ArrayList<VariableNameDto>();
        VariableNameDto firstVariableName = new VariableNameDto(aVariableKey);
        variableNames.add(firstVariableName);
        HashMap<String, Object> variablesJson = new HashMap<String, Object>();
        variablesJson.put("variables", variables);
        variablesJson.put("deletions", variableNames);
        RestAssured.given().pathParam("id", (Object)"aCaseExecutionId").contentType(ContentType.JSON).body(variablesJson).then().expect().statusCode(Response.Status.NO_CONTENT.getStatusCode()).when().post(CASE_EXECUTION_COMPLETE_URL, new Object[0]);
        ((CaseService)Mockito.verify((Object)this.caseServiceMock)).withCaseExecution("aCaseExecutionId");
        ((CaseExecutionCommandBuilder)Mockito.verify((Object)this.caseExecutionCommandBuilderMock)).removeVariable(aVariableKey);
        ((CaseExecutionCommandBuilder)Mockito.verify((Object)this.caseExecutionCommandBuilderMock)).setVariableLocal((String)Mockito.eq((Object)anotherVariableKey), MockitoHamcrest.argThat((Matcher)EqualsPrimitiveValue.stringValue(anotherVariableValue)));
        ((CaseExecutionCommandBuilder)Mockito.verify((Object)this.caseExecutionCommandBuilderMock)).complete();
    }

    @Test
    public void testCompleteWithSetVariableLocalAndRemoveVariableLocal() {
        String aVariableKey = "aKey";
        String anotherVariableKey = "anotherKey";
        String anotherVariableValue = "abc";
        Map<String, Object> variables = VariablesBuilder.create().variable(anotherVariableKey, anotherVariableValue, "String", true).getVariables();
        ArrayList<VariableNameDto> variableNames = new ArrayList<VariableNameDto>();
        VariableNameDto firstVariableName = new VariableNameDto(aVariableKey, true);
        variableNames.add(firstVariableName);
        HashMap<String, Object> variablesJson = new HashMap<String, Object>();
        variablesJson.put("variables", variables);
        variablesJson.put("deletions", variableNames);
        RestAssured.given().pathParam("id", (Object)"aCaseExecutionId").contentType(ContentType.JSON).body(variablesJson).then().expect().statusCode(Response.Status.NO_CONTENT.getStatusCode()).when().post(CASE_EXECUTION_COMPLETE_URL, new Object[0]);
        ((CaseService)Mockito.verify((Object)this.caseServiceMock)).withCaseExecution("aCaseExecutionId");
        ((CaseExecutionCommandBuilder)Mockito.verify((Object)this.caseExecutionCommandBuilderMock)).removeVariableLocal(aVariableKey);
        ((CaseExecutionCommandBuilder)Mockito.verify((Object)this.caseExecutionCommandBuilderMock)).setVariableLocal((String)Mockito.eq((Object)anotherVariableKey), MockitoHamcrest.argThat((Matcher)EqualsPrimitiveValue.stringValue(anotherVariableValue)));
        ((CaseExecutionCommandBuilder)Mockito.verify((Object)this.caseExecutionCommandBuilderMock)).complete();
    }

    @Test
    public void testTerminate() {
        RestAssured.given().pathParam("id", (Object)"aCaseExecutionId").contentType(ContentType.JSON).body("{}").then().expect().statusCode(Response.Status.NO_CONTENT.getStatusCode()).when().post(CASE_EXECUTION_TERMINATE_URL, new Object[0]);
        ((CaseService)Mockito.verify((Object)this.caseServiceMock)).withCaseExecution("aCaseExecutionId");
        ((CaseExecutionCommandBuilder)Mockito.verify((Object)this.caseExecutionCommandBuilderMock)).terminate();
    }

    @Test
    public void testUnsuccessfulTerminate() {
        ((CaseExecutionCommandBuilder)Mockito.doThrow((Throwable[])new Throwable[]{new NotValidException("expected exception")}).when((Object)this.caseExecutionCommandBuilderMock)).terminate();
        RestAssured.given().pathParam("id", (Object)"aCaseExecutionId").contentType(ContentType.JSON).body("{}").then().expect().statusCode(Response.Status.BAD_REQUEST.getStatusCode()).body("type", CoreMatchers.equalTo((Object)InvalidRequestException.class.getSimpleName()), new Object[0]).body("message", Matchers.containsString((String)"Cannot terminate case execution aCaseExecutionId: expected exception"), new Object[0]).when().post(CASE_EXECUTION_TERMINATE_URL, new Object[0]);
        ((CaseService)Mockito.verify((Object)this.caseServiceMock)).withCaseExecution("aCaseExecutionId");
        ((CaseExecutionCommandBuilder)Mockito.verify((Object)this.caseExecutionCommandBuilderMock)).terminate();
    }

    @Test
    public void testTerminateWithSetVariable() {
        String aVariableKey = "aKey";
        int aVariableValue = 123;
        String anotherVariableKey = "anotherKey";
        String anotherVariableValue = "abc";
        HashMap<String, Map<String, Object>> variablesJson = new HashMap<String, Map<String, Object>>();
        Map<String, Object> variables = VariablesBuilder.create().variable(aVariableKey, (Object)aVariableValue, "Integer").variable(anotherVariableKey, (Object)anotherVariableValue, "String").getVariables();
        variablesJson.put("variables", variables);
        RestAssured.given().pathParam("id", (Object)"aCaseExecutionId").contentType(ContentType.JSON).body(variablesJson).then().expect().statusCode(Response.Status.NO_CONTENT.getStatusCode()).when().post(CASE_EXECUTION_TERMINATE_URL, new Object[0]);
        ((CaseService)Mockito.verify((Object)this.caseServiceMock)).withCaseExecution("aCaseExecutionId");
        ((CaseExecutionCommandBuilder)Mockito.verify((Object)this.caseExecutionCommandBuilderMock)).setVariable((String)Mockito.eq((Object)aVariableKey), MockitoHamcrest.argThat((Matcher)EqualsPrimitiveValue.integerValue(aVariableValue)));
        ((CaseExecutionCommandBuilder)Mockito.verify((Object)this.caseExecutionCommandBuilderMock)).setVariable((String)Mockito.eq((Object)anotherVariableKey), MockitoHamcrest.argThat((Matcher)EqualsPrimitiveValue.stringValue(anotherVariableValue)));
        ((CaseExecutionCommandBuilder)Mockito.verify((Object)this.caseExecutionCommandBuilderMock)).terminate();
    }

    @Test
    public void testTerminateWithSetVariableLocal() {
        String aVariableKey = "aKey";
        int aVariableValue = 123;
        String anotherVariableKey = "anotherKey";
        String anotherVariableValue = "abc";
        HashMap<String, Map<String, Object>> variablesJson = new HashMap<String, Map<String, Object>>();
        Map<String, Object> variables = VariablesBuilder.create().variable(aVariableKey, aVariableValue, "Integer", true).variable(anotherVariableKey, anotherVariableValue, "String", true).getVariables();
        variablesJson.put("variables", variables);
        RestAssured.given().pathParam("id", (Object)"aCaseExecutionId").contentType(ContentType.JSON).body(variablesJson).then().expect().statusCode(Response.Status.NO_CONTENT.getStatusCode()).when().post(CASE_EXECUTION_TERMINATE_URL, new Object[0]);
        ((CaseService)Mockito.verify((Object)this.caseServiceMock)).withCaseExecution("aCaseExecutionId");
        ((CaseExecutionCommandBuilder)Mockito.verify((Object)this.caseExecutionCommandBuilderMock)).setVariableLocal((String)Mockito.eq((Object)aVariableKey), MockitoHamcrest.argThat((Matcher)EqualsPrimitiveValue.integerValue(aVariableValue)));
        ((CaseExecutionCommandBuilder)Mockito.verify((Object)this.caseExecutionCommandBuilderMock)).setVariableLocal((String)Mockito.eq((Object)anotherVariableKey), MockitoHamcrest.argThat((Matcher)EqualsPrimitiveValue.stringValue(anotherVariableValue)));
        ((CaseExecutionCommandBuilder)Mockito.verify((Object)this.caseExecutionCommandBuilderMock)).terminate();
    }

    @Test
    public void testTerminateWithSetVariableAndVariableLocal() {
        String aVariableKey = "aKey";
        int aVariableValue = 123;
        String anotherVariableKey = "anotherKey";
        String anotherVariableValue = "abc";
        HashMap<String, Map<String, Object>> variablesJson = new HashMap<String, Map<String, Object>>();
        Map<String, Object> variables = VariablesBuilder.create().variable(aVariableKey, (Object)aVariableValue, "Integer").variable(anotherVariableKey, anotherVariableValue, "String", true).getVariables();
        variablesJson.put("variables", variables);
        RestAssured.given().pathParam("id", (Object)"aCaseExecutionId").contentType(ContentType.JSON).body(variablesJson).then().expect().statusCode(Response.Status.NO_CONTENT.getStatusCode()).when().post(CASE_EXECUTION_TERMINATE_URL, new Object[0]);
        ((CaseService)Mockito.verify((Object)this.caseServiceMock)).withCaseExecution("aCaseExecutionId");
        ((CaseExecutionCommandBuilder)Mockito.verify((Object)this.caseExecutionCommandBuilderMock)).setVariable((String)Mockito.eq((Object)aVariableKey), MockitoHamcrest.argThat((Matcher)EqualsPrimitiveValue.integerValue(aVariableValue)));
        ((CaseExecutionCommandBuilder)Mockito.verify((Object)this.caseExecutionCommandBuilderMock)).setVariableLocal((String)Mockito.eq((Object)anotherVariableKey), MockitoHamcrest.argThat((Matcher)EqualsPrimitiveValue.stringValue(anotherVariableValue)));
        ((CaseExecutionCommandBuilder)Mockito.verify((Object)this.caseExecutionCommandBuilderMock)).terminate();
    }

    @Test
    public void testTerminateWithRemoveVariable() {
        String aVariableKey = "aKey";
        String anotherVariableKey = "anotherKey";
        ArrayList<VariableNameDto> variableNames = new ArrayList<VariableNameDto>();
        VariableNameDto firstVariableName = new VariableNameDto(aVariableKey);
        variableNames.add(firstVariableName);
        VariableNameDto secondVariableName = new VariableNameDto(anotherVariableKey);
        variableNames.add(secondVariableName);
        HashMap<String, ArrayList<VariableNameDto>> variablesJson = new HashMap<String, ArrayList<VariableNameDto>>();
        variablesJson.put("deletions", variableNames);
        RestAssured.given().pathParam("id", (Object)"aCaseExecutionId").contentType(ContentType.JSON).body(variablesJson).then().expect().statusCode(Response.Status.NO_CONTENT.getStatusCode()).when().post(CASE_EXECUTION_TERMINATE_URL, new Object[0]);
        ((CaseService)Mockito.verify((Object)this.caseServiceMock)).withCaseExecution("aCaseExecutionId");
        ((CaseExecutionCommandBuilder)Mockito.verify((Object)this.caseExecutionCommandBuilderMock)).removeVariable(aVariableKey);
        ((CaseExecutionCommandBuilder)Mockito.verify((Object)this.caseExecutionCommandBuilderMock)).removeVariable(anotherVariableKey);
        ((CaseExecutionCommandBuilder)Mockito.verify((Object)this.caseExecutionCommandBuilderMock)).terminate();
    }

    @Test
    public void testTerminateWithRemoveVariableLocal() {
        String aVariableKey = "aKey";
        String anotherVariableKey = "anotherKey";
        ArrayList<VariableNameDto> variableNames = new ArrayList<VariableNameDto>();
        VariableNameDto firstVariableName = new VariableNameDto(aVariableKey, true);
        variableNames.add(firstVariableName);
        VariableNameDto secondVariableName = new VariableNameDto(anotherVariableKey, true);
        variableNames.add(secondVariableName);
        HashMap<String, ArrayList<VariableNameDto>> variablesJson = new HashMap<String, ArrayList<VariableNameDto>>();
        variablesJson.put("deletions", variableNames);
        RestAssured.given().pathParam("id", (Object)"aCaseExecutionId").contentType(ContentType.JSON).body(variablesJson).then().expect().statusCode(Response.Status.NO_CONTENT.getStatusCode()).when().post(CASE_EXECUTION_TERMINATE_URL, new Object[0]);
        ((CaseService)Mockito.verify((Object)this.caseServiceMock)).withCaseExecution("aCaseExecutionId");
        ((CaseExecutionCommandBuilder)Mockito.verify((Object)this.caseExecutionCommandBuilderMock)).removeVariableLocal(aVariableKey);
        ((CaseExecutionCommandBuilder)Mockito.verify((Object)this.caseExecutionCommandBuilderMock)).removeVariableLocal(anotherVariableKey);
        ((CaseExecutionCommandBuilder)Mockito.verify((Object)this.caseExecutionCommandBuilderMock)).terminate();
    }

    @Test
    public void testTerminateWithRemoveVariableAndVariableLocal() {
        String aVariableKey = "aKey";
        String anotherVariableKey = "anotherKey";
        ArrayList<VariableNameDto> variableNames = new ArrayList<VariableNameDto>();
        VariableNameDto firstVariableName = new VariableNameDto(aVariableKey, true);
        variableNames.add(firstVariableName);
        VariableNameDto secondVariableName = new VariableNameDto(anotherVariableKey);
        variableNames.add(secondVariableName);
        HashMap<String, ArrayList<VariableNameDto>> variablesJson = new HashMap<String, ArrayList<VariableNameDto>>();
        variablesJson.put("deletions", variableNames);
        RestAssured.given().pathParam("id", (Object)"aCaseExecutionId").contentType(ContentType.JSON).body(variablesJson).then().expect().statusCode(Response.Status.NO_CONTENT.getStatusCode()).when().post(CASE_EXECUTION_TERMINATE_URL, new Object[0]);
        ((CaseService)Mockito.verify((Object)this.caseServiceMock)).withCaseExecution("aCaseExecutionId");
        ((CaseExecutionCommandBuilder)Mockito.verify((Object)this.caseExecutionCommandBuilderMock)).removeVariableLocal(aVariableKey);
        ((CaseExecutionCommandBuilder)Mockito.verify((Object)this.caseExecutionCommandBuilderMock)).removeVariable(anotherVariableKey);
        ((CaseExecutionCommandBuilder)Mockito.verify((Object)this.caseExecutionCommandBuilderMock)).terminate();
    }

    @Test
    public void testTerminateWithSetVariableAndRemoveVariable() {
        String aVariableKey = "aKey";
        String anotherVariableKey = "anotherKey";
        String anotherVariableValue = "abc";
        Map<String, Object> variables = VariablesBuilder.create().variable(anotherVariableKey, (Object)anotherVariableValue, "String").getVariables();
        ArrayList<VariableNameDto> variableNames = new ArrayList<VariableNameDto>();
        VariableNameDto firstVariableName = new VariableNameDto(aVariableKey);
        variableNames.add(firstVariableName);
        HashMap<String, Object> variablesJson = new HashMap<String, Object>();
        variablesJson.put("variables", variables);
        variablesJson.put("deletions", variableNames);
        RestAssured.given().pathParam("id", (Object)"aCaseExecutionId").contentType(ContentType.JSON).body(variablesJson).then().expect().statusCode(Response.Status.NO_CONTENT.getStatusCode()).when().post(CASE_EXECUTION_TERMINATE_URL, new Object[0]);
        ((CaseService)Mockito.verify((Object)this.caseServiceMock)).withCaseExecution("aCaseExecutionId");
        ((CaseExecutionCommandBuilder)Mockito.verify((Object)this.caseExecutionCommandBuilderMock)).removeVariable(aVariableKey);
        ((CaseExecutionCommandBuilder)Mockito.verify((Object)this.caseExecutionCommandBuilderMock)).setVariable((String)Mockito.eq((Object)anotherVariableKey), MockitoHamcrest.argThat((Matcher)EqualsPrimitiveValue.stringValue(anotherVariableValue)));
        ((CaseExecutionCommandBuilder)Mockito.verify((Object)this.caseExecutionCommandBuilderMock)).terminate();
    }

    @Test
    public void testTerminateWithSetVariableAndRemoveVariableLocal() {
        String aVariableKey = "aKey";
        String anotherVariableKey = "anotherKey";
        String anotherVariableValue = "abc";
        Map<String, Object> variables = VariablesBuilder.create().variable(anotherVariableKey, (Object)anotherVariableValue, "String").getVariables();
        ArrayList<VariableNameDto> variableNames = new ArrayList<VariableNameDto>();
        VariableNameDto firstVariableName = new VariableNameDto(aVariableKey, true);
        variableNames.add(firstVariableName);
        HashMap<String, Object> variablesJson = new HashMap<String, Object>();
        variablesJson.put("variables", variables);
        variablesJson.put("deletions", variableNames);
        RestAssured.given().pathParam("id", (Object)"aCaseExecutionId").contentType(ContentType.JSON).body(variablesJson).then().expect().statusCode(Response.Status.NO_CONTENT.getStatusCode()).when().post(CASE_EXECUTION_TERMINATE_URL, new Object[0]);
        ((CaseService)Mockito.verify((Object)this.caseServiceMock)).withCaseExecution("aCaseExecutionId");
        ((CaseExecutionCommandBuilder)Mockito.verify((Object)this.caseExecutionCommandBuilderMock)).removeVariableLocal(aVariableKey);
        ((CaseExecutionCommandBuilder)Mockito.verify((Object)this.caseExecutionCommandBuilderMock)).setVariable((String)Mockito.eq((Object)anotherVariableKey), MockitoHamcrest.argThat((Matcher)EqualsPrimitiveValue.stringValue(anotherVariableValue)));
        ((CaseExecutionCommandBuilder)Mockito.verify((Object)this.caseExecutionCommandBuilderMock)).terminate();
    }

    @Test
    public void testTerminateWithSetVariableLocalAndRemoveVariable() {
        String aVariableKey = "aKey";
        String anotherVariableKey = "anotherKey";
        String anotherVariableValue = "abc";
        Map<String, Object> variables = VariablesBuilder.create().variable(anotherVariableKey, anotherVariableValue, "String", true).getVariables();
        ArrayList<VariableNameDto> variableNames = new ArrayList<VariableNameDto>();
        VariableNameDto firstVariableName = new VariableNameDto(aVariableKey);
        variableNames.add(firstVariableName);
        HashMap<String, Object> variablesJson = new HashMap<String, Object>();
        variablesJson.put("variables", variables);
        variablesJson.put("deletions", variableNames);
        RestAssured.given().pathParam("id", (Object)"aCaseExecutionId").contentType(ContentType.JSON).body(variablesJson).then().expect().statusCode(Response.Status.NO_CONTENT.getStatusCode()).when().post(CASE_EXECUTION_TERMINATE_URL, new Object[0]);
        ((CaseService)Mockito.verify((Object)this.caseServiceMock)).withCaseExecution("aCaseExecutionId");
        ((CaseExecutionCommandBuilder)Mockito.verify((Object)this.caseExecutionCommandBuilderMock)).removeVariable(aVariableKey);
        ((CaseExecutionCommandBuilder)Mockito.verify((Object)this.caseExecutionCommandBuilderMock)).setVariableLocal((String)Mockito.eq((Object)anotherVariableKey), MockitoHamcrest.argThat((Matcher)EqualsPrimitiveValue.stringValue(anotherVariableValue)));
        ((CaseExecutionCommandBuilder)Mockito.verify((Object)this.caseExecutionCommandBuilderMock)).terminate();
    }

    @Test
    public void testTerminateWithSetVariableLocalAndRemoveVariableLocal() {
        String aVariableKey = "aKey";
        String anotherVariableKey = "anotherKey";
        String anotherVariableValue = "abc";
        Map<String, Object> variables = VariablesBuilder.create().variable(anotherVariableKey, anotherVariableValue, "String", true).getVariables();
        ArrayList<VariableNameDto> variableNames = new ArrayList<VariableNameDto>();
        VariableNameDto firstVariableName = new VariableNameDto(aVariableKey, true);
        variableNames.add(firstVariableName);
        HashMap<String, Object> variablesJson = new HashMap<String, Object>();
        variablesJson.put("variables", variables);
        variablesJson.put("deletions", variableNames);
        RestAssured.given().pathParam("id", (Object)"aCaseExecutionId").contentType(ContentType.JSON).body(variablesJson).then().expect().statusCode(Response.Status.NO_CONTENT.getStatusCode()).when().post(CASE_EXECUTION_TERMINATE_URL, new Object[0]);
        ((CaseService)Mockito.verify((Object)this.caseServiceMock)).withCaseExecution("aCaseExecutionId");
        ((CaseExecutionCommandBuilder)Mockito.verify((Object)this.caseExecutionCommandBuilderMock)).removeVariableLocal(aVariableKey);
        ((CaseExecutionCommandBuilder)Mockito.verify((Object)this.caseExecutionCommandBuilderMock)).setVariableLocal((String)Mockito.eq((Object)anotherVariableKey), MockitoHamcrest.argThat((Matcher)EqualsPrimitiveValue.stringValue(anotherVariableValue)));
        ((CaseExecutionCommandBuilder)Mockito.verify((Object)this.caseExecutionCommandBuilderMock)).terminate();
    }
}

