/*
 * Decompiled with CFR 0.152.
 */
package org.eximeebpms.bpm.engine.rest;

import io.restassured.RestAssured;
import io.restassured.http.ContentType;
import java.util.ArrayList;
import java.util.List;
import javax.ws.rs.core.Response;
import org.eximeebpms.bpm.engine.identity.Group;
import org.eximeebpms.bpm.engine.identity.GroupQuery;
import org.eximeebpms.bpm.engine.identity.User;
import org.eximeebpms.bpm.engine.identity.UserQuery;
import org.eximeebpms.bpm.engine.rest.AbstractRestServiceTest;
import org.eximeebpms.bpm.engine.rest.dto.identity.BasicUserCredentialsDto;
import org.eximeebpms.bpm.engine.rest.exception.InvalidRequestException;
import org.eximeebpms.bpm.engine.rest.helper.MockProvider;
import org.eximeebpms.bpm.engine.rest.util.container.TestContainerRule;
import org.hamcrest.Matchers;
import org.junit.Before;
import org.junit.ClassRule;
import org.junit.Test;
import org.mockito.Mockito;

public class IdentityRestServiceQueryTest
extends AbstractRestServiceTest {
    protected static final String TEST_USERNAME = "testUsername";
    protected static final String TEST_PASSWORD = "testPassword";
    @ClassRule
    public static TestContainerRule rule = new TestContainerRule();
    protected static final String IDENTITY_URL = "/rest-test/identity";
    protected static final String TASK_GROUPS_URL = "/rest-test/identity/groups";
    protected static final String VERIFY_USER_URL = "/rest-test/identity/verify";
    private User mockUser;

    @Before
    public void setUpRuntimeData() {
        this.createMockIdentityQueries();
    }

    private void createMockIdentityQueries() {
        UserQuery sampleUserQuery = (UserQuery)Mockito.mock(UserQuery.class);
        ArrayList<User> mockUsers = new ArrayList<User>();
        this.mockUser = MockProvider.createMockUser();
        mockUsers.add(this.mockUser);
        Mockito.when((Object)sampleUserQuery.unlimitedList()).thenReturn(mockUsers);
        Mockito.when((Object)sampleUserQuery.memberOfGroup(Mockito.anyString())).thenReturn((Object)sampleUserQuery);
        Mockito.when((Object)sampleUserQuery.count()).thenReturn((Object)mockUsers.size());
        GroupQuery sampleGroupQuery = (GroupQuery)Mockito.mock(GroupQuery.class);
        List<Group> mockGroups = MockProvider.createMockGroups();
        Mockito.when((Object)sampleGroupQuery.unlimitedList()).thenReturn(mockGroups);
        Mockito.when((Object)sampleGroupQuery.groupMember(Mockito.anyString())).thenReturn((Object)sampleGroupQuery);
        Mockito.when((Object)sampleGroupQuery.orderByGroupName()).thenReturn((Object)sampleGroupQuery);
        Mockito.when((Object)sampleGroupQuery.orderByGroupId()).thenReturn((Object)sampleGroupQuery);
        Mockito.when((Object)sampleGroupQuery.orderByGroupType()).thenReturn((Object)sampleGroupQuery);
        Mockito.when((Object)((GroupQuery)sampleGroupQuery.asc())).thenReturn((Object)sampleGroupQuery);
        Mockito.when((Object)((GroupQuery)sampleGroupQuery.desc())).thenReturn((Object)sampleGroupQuery);
        Mockito.when((Object)processEngine.getIdentityService().createGroupQuery()).thenReturn((Object)sampleGroupQuery);
        Mockito.when((Object)processEngine.getIdentityService().createUserQuery()).thenReturn((Object)sampleUserQuery);
    }

    @Test
    public void testGroupInfoQuery() {
        RestAssured.given().queryParam("userId", new Object[]{"name"}).then().expect().statusCode(Response.Status.OK.getStatusCode()).body("groups.size()", Matchers.is((Object)1), new Object[0]).body("groups[0].id", Matchers.equalTo((Object)"groupId1"), new Object[0]).body("groups[0].name", Matchers.equalTo((Object)"group1"), new Object[0]).body("groupUsers.size()", Matchers.is((Object)1), new Object[0]).body("groupUsers[0].id", Matchers.equalTo((Object)this.mockUser.getId()), new Object[0]).when().get(TASK_GROUPS_URL, new Object[0]);
    }

    @Test
    public void testGroupInfoQueryWithMissingUserParameter() {
        RestAssured.expect().statusCode(Response.Status.BAD_REQUEST.getStatusCode()).contentType(ContentType.JSON).body("type", Matchers.equalTo((Object)InvalidRequestException.class.getSimpleName()), new Object[0]).body("message", Matchers.equalTo((Object)"No user id was supplied"), new Object[0]).when().get(TASK_GROUPS_URL, new Object[0]);
    }

    @Test
    public void verifyUserWithMissingParameter() {
        RestAssured.given().body((Object)new BasicUserCredentialsDto()).contentType(ContentType.JSON).expect().statusCode(Response.Status.BAD_REQUEST.getStatusCode()).contentType(ContentType.JSON).body("type", Matchers.equalTo((Object)InvalidRequestException.class.getSimpleName()), new Object[0]).body("message", Matchers.equalTo((Object)"Username and password are required"), new Object[0]).when().post(VERIFY_USER_URL, new Object[0]);
    }

    @Test
    public void verifyUser() {
        Mockito.when((Object)processEngine.getIdentityService().checkPassword(TEST_USERNAME, TEST_PASSWORD)).thenReturn((Object)true);
        BasicUserCredentialsDto userCredentialsDto = new BasicUserCredentialsDto();
        userCredentialsDto.setUsername(TEST_USERNAME);
        userCredentialsDto.setUsername(TEST_PASSWORD);
        RestAssured.given().body((Object)userCredentialsDto).contentType(ContentType.JSON).expect().statusCode(Response.Status.BAD_REQUEST.getStatusCode()).contentType(ContentType.JSON).body("type", Matchers.equalTo((Object)InvalidRequestException.class.getSimpleName()), new Object[0]).body("message", Matchers.equalTo((Object)"Username and password are required"), new Object[0]).when().post(VERIFY_USER_URL, new Object[0]);
    }
}

