/*
 * Decompiled with CFR 0.152.
 */
package org.eximeebpms.bpm.engine.rest;

import ch.qos.logback.classic.Level;
import ch.qos.logback.classic.spi.ILoggingEvent;
import io.restassured.RestAssured;
import java.sql.SQLException;
import java.util.Collection;
import java.util.List;
import org.apache.ibatis.exceptions.PersistenceException;
import org.assertj.core.api.Assertions;
import org.eximeebpms.bpm.engine.ProcessEnginePersistenceException;
import org.eximeebpms.bpm.engine.identity.UserQuery;
import org.eximeebpms.bpm.engine.impl.util.ExceptionUtil;
import org.eximeebpms.bpm.engine.rest.AbstractRestServiceTest;
import org.eximeebpms.bpm.engine.rest.util.container.TestContainerRule;
import org.eximeebpms.commons.testing.ProcessEngineLoggingRule;
import org.hamcrest.Matchers;
import org.junit.ClassRule;
import org.junit.Rule;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;
import org.mockito.Mockito;

@RunWith(value=Parameterized.class)
public class PersistenceConnectionExceptionLoggingTest
extends AbstractRestServiceTest {
    @ClassRule
    public static TestContainerRule rule = new TestContainerRule();
    @Rule
    public ProcessEngineLoggingRule loggingRule = new ProcessEngineLoggingRule().watch(new String[]{"org.eximeebpms.bpm.engine.rest.exception"});
    protected static final String USER_QUERY_URL = "/rest-test/user";
    private final ConnectionSubclass subclass;

    public PersistenceConnectionExceptionLoggingTest(ConnectionSubclass subclass) {
        this.subclass = subclass;
    }

    /*
     * Exception decompiling
     */
    @Parameterized.Parameters(name="{index}: {0}")
    public static Collection<Object[]> data() {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * java.lang.UnsupportedOperationException
         *     at org.benf.cfr.reader.bytecode.analysis.parse.expression.NewAnonymousArray.getDimSize(NewAnonymousArray.java:142)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op4rewriters.LambdaRewriter.isNewArrayLambda(LambdaRewriter.java:455)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op4rewriters.LambdaRewriter.rewriteDynamicExpression(LambdaRewriter.java:409)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op4rewriters.LambdaRewriter.rewriteDynamicExpression(LambdaRewriter.java:167)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op4rewriters.LambdaRewriter.rewriteExpression(LambdaRewriter.java:105)
         *     at org.benf.cfr.reader.bytecode.analysis.parse.rewriters.ExpressionRewriterHelper.applyForwards(ExpressionRewriterHelper.java:12)
         *     at org.benf.cfr.reader.bytecode.analysis.parse.expression.AbstractMemberFunctionInvokation.applyExpressionRewriterToArgs(AbstractMemberFunctionInvokation.java:101)
         *     at org.benf.cfr.reader.bytecode.analysis.parse.expression.AbstractMemberFunctionInvokation.applyExpressionRewriter(AbstractMemberFunctionInvokation.java:88)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op4rewriters.LambdaRewriter.rewriteExpression(LambdaRewriter.java:103)
         *     at org.benf.cfr.reader.bytecode.analysis.parse.expression.AbstractMemberFunctionInvokation.applyExpressionRewriter(AbstractMemberFunctionInvokation.java:87)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op4rewriters.LambdaRewriter.rewriteExpression(LambdaRewriter.java:103)
         *     at org.benf.cfr.reader.bytecode.analysis.structured.statement.StructuredReturn.rewriteExpressions(StructuredReturn.java:99)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op4rewriters.LambdaRewriter.rewrite(LambdaRewriter.java:88)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.rewriteLambdas(Op04StructuredStatement.java:1137)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:912)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    @Test
    public void shouldLogPersistenceConnectionExceptionOnError() {
        this.stubFailingUserQuery(this.subclass);
        String expectedMessage = "An exception occurred in the persistence layer. Please check the server logs for a detailed message and the entire exception stack trace.";
        RestAssured.given().queryParam("firstName", new Object[]{"firstName"}).then().expect().statusCode(500).body("type", Matchers.equalTo((Object)"ProcessEnginePersistenceException"), new Object[0]).body("message", Matchers.equalTo((Object)expectedMessage), new Object[0]).body("code", Matchers.equalTo((Object)0), new Object[0]).when().get(USER_QUERY_URL, new Object[0]);
        this.verifyLogs(Level.ERROR, expectedMessage);
    }

    protected void verifyLogs(Level logLevel, String message) {
        List logs = this.loggingRule.getLog();
        Assertions.assertThat((List)logs).hasSize(1);
        Assertions.assertThat((Object)((ILoggingEvent)logs.get(0)).getLevel()).isEqualTo((Object)logLevel);
        Assertions.assertThat((String)((ILoggingEvent)logs.get(0)).getMessage()).containsIgnoringCase((CharSequence)message);
    }

    protected void stubFailingUserQuery(ConnectionSubclass subclass) {
        UserQuery result = (UserQuery)Mockito.mock(UserQuery.class);
        Mockito.when((Object)result.list()).thenThrow(new Throwable[]{this.createPersistenceException("list", subclass)});
        Mockito.when((Object)processEngine.getIdentityService().createUserQuery()).thenReturn((Object)result);
    }

    private ProcessEnginePersistenceException createPersistenceException(String operation, ConnectionSubclass subclass) {
        SQLException sqlException = new SQLException(subclass.message(), subclass.sqlState());
        PersistenceException persistenceException = new PersistenceException("Failed to execute " + operation, (Throwable)sqlException);
        return ExceptionUtil.wrapPersistenceException((Exception)persistenceException);
    }

    public static enum ConnectionSubclass {
        CLIENT_UNABLE("001", "SQL-client unable to establish SQL-connection"),
        NAME_IN_USE("002", "connection name in use"),
        NOT_EXISTS("003", "connection does not exist"),
        SERVER_REJECT("004", "SQL-server rejected establishment of SQL-connection"),
        FAILURE("006", "connection failure"),
        UNKNOWN_TX_RESOLUTION("007", "transaction resolution unknown"),
        UNKNOWN("XXX", "This is a dummy subclass");

        private final String subclass;
        private final String message;

        private ConnectionSubclass(String subclass, String message) {
            this.subclass = subclass;
            this.message = message;
        }

        public String sqlState() {
            return "08" + this.subclass;
        }

        public String message() {
            return this.message;
        }
    }
}

