/*
 * Decompiled with CFR 0.152.
 */
package org.eximeebpms.bpm.engine.rest.helper;

import java.util.Collections;
import java.util.List;
import org.eximeebpms.bpm.engine.migration.MigrationInstruction;
import org.mockito.Mockito;

public class MockMigrationInstructionBuilder {
    protected List<String> sourceActivityIds;
    protected List<String> targetActivityIds;
    protected boolean updateEventTrigger = false;

    public MockMigrationInstructionBuilder sourceActivityIds(List<String> sourceActivityIds) {
        this.sourceActivityIds = sourceActivityIds;
        return this;
    }

    public MockMigrationInstructionBuilder sourceActivityId(String sourceActivityId) {
        this.sourceActivityIds = Collections.singletonList(sourceActivityId);
        return this;
    }

    public MockMigrationInstructionBuilder targetActivityIds(List<String> targetActivityIds) {
        this.targetActivityIds = targetActivityIds;
        return this;
    }

    public MockMigrationInstructionBuilder targetActivityId(String targetActivityId) {
        this.targetActivityIds = Collections.singletonList(targetActivityId);
        return this;
    }

    public MockMigrationInstructionBuilder updateEventTrigger() {
        this.updateEventTrigger = true;
        return this;
    }

    public MigrationInstruction build() {
        MigrationInstruction migrationInstructionMock = (MigrationInstruction)Mockito.mock(MigrationInstruction.class);
        Mockito.when((Object)migrationInstructionMock.getSourceActivityId()).thenReturn((Object)this.sourceActivityIds.get(0));
        Mockito.when((Object)migrationInstructionMock.getTargetActivityId()).thenReturn((Object)this.targetActivityIds.get(0));
        Mockito.when((Object)migrationInstructionMock.isUpdateEventTrigger()).thenReturn((Object)this.updateEventTrigger);
        return migrationInstructionMock;
    }
}

