/*
 * Decompiled with CFR 0.152.
 */
package org.eximeebpms.bpm.engine.rest.dto.history;

import com.fasterxml.jackson.databind.ObjectMapper;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import javax.ws.rs.core.MultivaluedMap;
import org.eximeebpms.bpm.engine.ProcessEngine;
import org.eximeebpms.bpm.engine.history.CleanableHistoricDecisionInstanceReport;
import org.eximeebpms.bpm.engine.rest.dto.AbstractQueryDto;
import org.eximeebpms.bpm.engine.rest.dto.EximeeBPMSQueryParam;
import org.eximeebpms.bpm.engine.rest.dto.converter.BooleanConverter;
import org.eximeebpms.bpm.engine.rest.dto.converter.StringArrayConverter;

public class CleanableHistoricDecisionInstanceReportDto
extends AbstractQueryDto<CleanableHistoricDecisionInstanceReport> {
    protected String[] decisionDefinitionIdIn;
    protected String[] decisionDefinitionKeyIn;
    protected String[] tenantIdIn;
    protected Boolean withoutTenantId;
    protected Boolean compact;
    protected static final String SORT_BY_FINISHED_VALUE = "finished";
    public static final List<String> VALID_SORT_BY_VALUES = new ArrayList<String>();

    public CleanableHistoricDecisionInstanceReportDto() {
    }

    public CleanableHistoricDecisionInstanceReportDto(ObjectMapper objectMapper, MultivaluedMap<String, String> queryParameters) {
        super(objectMapper, queryParameters);
    }

    @EximeeBPMSQueryParam(value="decisionDefinitionIdIn", converter=StringArrayConverter.class)
    public void setDecisionDefinitionIdIn(String[] decisionDefinitionIdIn) {
        this.decisionDefinitionIdIn = decisionDefinitionIdIn;
    }

    @EximeeBPMSQueryParam(value="decisionDefinitionKeyIn", converter=StringArrayConverter.class)
    public void setDecisionDefinitionKeyIn(String[] decisionDefinitionKeyIn) {
        this.decisionDefinitionKeyIn = decisionDefinitionKeyIn;
    }

    @EximeeBPMSQueryParam(value="tenantIdIn", converter=StringArrayConverter.class)
    public void setTenantIdIn(String[] tenantIdIn) {
        this.tenantIdIn = tenantIdIn;
    }

    @EximeeBPMSQueryParam(value="withoutTenantId", converter=BooleanConverter.class)
    public void setWithoutTenantId(Boolean withoutTenantId) {
        this.withoutTenantId = withoutTenantId;
    }

    @EximeeBPMSQueryParam(value="compact", converter=BooleanConverter.class)
    public void setCompact(Boolean compact) {
        this.compact = compact;
    }

    @Override
    protected boolean isValidSortByValue(String value) {
        return VALID_SORT_BY_VALUES.contains(value);
    }

    @Override
    protected CleanableHistoricDecisionInstanceReport createNewQuery(ProcessEngine engine) {
        return engine.getHistoryService().createCleanableHistoricDecisionInstanceReport();
    }

    @Override
    protected void applyFilters(CleanableHistoricDecisionInstanceReport query) {
        if (this.decisionDefinitionIdIn != null && this.decisionDefinitionIdIn.length > 0) {
            query.decisionDefinitionIdIn(this.decisionDefinitionIdIn);
        }
        if (this.decisionDefinitionKeyIn != null && this.decisionDefinitionKeyIn.length > 0) {
            query.decisionDefinitionKeyIn(this.decisionDefinitionKeyIn);
        }
        if (Boolean.TRUE.equals(this.withoutTenantId)) {
            query.withoutTenantId();
        }
        if (this.tenantIdIn != null && this.tenantIdIn.length > 0) {
            query.tenantIdIn(this.tenantIdIn);
        }
        if (Boolean.TRUE.equals(this.compact)) {
            query.compact();
        }
    }

    @Override
    protected void applySortBy(CleanableHistoricDecisionInstanceReport query, String sortBy, Map<String, Object> parameters, ProcessEngine engine) {
        if (sortBy.equals(SORT_BY_FINISHED_VALUE)) {
            query.orderByFinished();
        }
    }

    static {
        VALID_SORT_BY_VALUES.add(SORT_BY_FINISHED_VALUE);
    }
}

