/*
 * Decompiled with CFR 0.152.
 */
package org.eximeebpms.bpm.engine.rest.dto.history.batch;

import com.fasterxml.jackson.databind.ObjectMapper;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import javax.ws.rs.core.MultivaluedMap;
import org.eximeebpms.bpm.engine.ProcessEngine;
import org.eximeebpms.bpm.engine.history.CleanableHistoricBatchReport;
import org.eximeebpms.bpm.engine.rest.dto.AbstractQueryDto;

public class CleanableHistoricBatchReportDto
extends AbstractQueryDto<CleanableHistoricBatchReport> {
    protected static final String SORT_BY_FINISHED_VALUE = "finished";
    public static final List<String> VALID_SORT_BY_VALUES = new ArrayList<String>();

    public CleanableHistoricBatchReportDto(ObjectMapper objectMapper, MultivaluedMap<String, String> queryParameters) {
        super(objectMapper, queryParameters);
    }

    @Override
    protected boolean isValidSortByValue(String value) {
        return VALID_SORT_BY_VALUES.contains(value);
    }

    @Override
    protected CleanableHistoricBatchReport createNewQuery(ProcessEngine engine) {
        return engine.getHistoryService().createCleanableHistoricBatchReport();
    }

    @Override
    protected void applyFilters(CleanableHistoricBatchReport query) {
    }

    @Override
    protected void applySortBy(CleanableHistoricBatchReport query, String sortBy, Map<String, Object> parameters, ProcessEngine engine) {
        if (sortBy.equals(SORT_BY_FINISHED_VALUE)) {
            query.orderByFinishedBatchOperation();
        }
    }

    static {
        VALID_SORT_BY_VALUES.add(SORT_BY_FINISHED_VALUE);
    }
}

