/*
 * Decompiled with CFR 0.152.
 */
package org.eximeebpms.bpm.engine.rest.dto.identity;

import com.fasterxml.jackson.databind.ObjectMapper;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import javax.ws.rs.core.MultivaluedMap;
import org.eximeebpms.bpm.engine.ProcessEngine;
import org.eximeebpms.bpm.engine.identity.GroupQuery;
import org.eximeebpms.bpm.engine.rest.dto.AbstractQueryDto;
import org.eximeebpms.bpm.engine.rest.dto.EximeeBPMSQueryParam;
import org.eximeebpms.bpm.engine.rest.dto.converter.StringArrayConverter;

public class GroupQueryDto
extends AbstractQueryDto<GroupQuery> {
    private static final String SORT_BY_GROUP_ID_VALUE = "id";
    private static final String SORT_BY_GROUP_NAME_VALUE = "name";
    private static final String SORT_BY_GROUP_TYPE_VALUE = "type";
    private static final List<String> VALID_SORT_BY_VALUES = new ArrayList<String>();
    protected String id;
    protected String[] ids;
    protected String name;
    protected String nameLike;
    protected String type;
    protected String member;
    protected String tenantId;

    public GroupQueryDto() {
    }

    public GroupQueryDto(ObjectMapper objectMapper, MultivaluedMap<String, String> queryParameters) {
        super(objectMapper, queryParameters);
    }

    @EximeeBPMSQueryParam(value="id")
    public void setId(String groupId) {
        this.id = groupId;
    }

    @EximeeBPMSQueryParam(value="idIn", converter=StringArrayConverter.class)
    public void setIdIn(String[] groupIds) {
        this.ids = groupIds;
    }

    @EximeeBPMSQueryParam(value="name")
    public void setName(String groupName) {
        this.name = groupName;
    }

    @EximeeBPMSQueryParam(value="nameLike")
    public void setNameLike(String groupNameLike) {
        this.nameLike = groupNameLike;
    }

    @EximeeBPMSQueryParam(value="type")
    public void setType(String groupType) {
        this.type = groupType;
    }

    @EximeeBPMSQueryParam(value="member")
    public void setMember(String member) {
        this.member = member;
    }

    @EximeeBPMSQueryParam(value="memberOfTenant")
    public void setMemberOfTenant(String tenantId) {
        this.tenantId = tenantId;
    }

    @Override
    protected boolean isValidSortByValue(String value) {
        return VALID_SORT_BY_VALUES.contains(value);
    }

    @Override
    protected GroupQuery createNewQuery(ProcessEngine engine) {
        return engine.getIdentityService().createGroupQuery();
    }

    @Override
    protected void applyFilters(GroupQuery query) {
        if (this.id != null) {
            query.groupId(this.id);
        }
        if (this.ids != null) {
            query.groupIdIn(this.ids);
        }
        if (this.name != null) {
            query.groupName(this.name);
        }
        if (this.nameLike != null) {
            query.groupNameLike(this.nameLike);
        }
        if (this.type != null) {
            query.groupType(this.type);
        }
        if (this.member != null) {
            query.groupMember(this.member);
        }
        if (this.tenantId != null) {
            query.memberOfTenant(this.tenantId);
        }
    }

    @Override
    protected void applySortBy(GroupQuery query, String sortBy, Map<String, Object> parameters, ProcessEngine engine) {
        if (sortBy.equals(SORT_BY_GROUP_ID_VALUE)) {
            query.orderByGroupId();
        } else if (sortBy.equals(SORT_BY_GROUP_NAME_VALUE)) {
            query.orderByGroupName();
        } else if (sortBy.equals(SORT_BY_GROUP_TYPE_VALUE)) {
            query.orderByGroupType();
        }
    }

    static {
        VALID_SORT_BY_VALUES.add(SORT_BY_GROUP_ID_VALUE);
        VALID_SORT_BY_VALUES.add(SORT_BY_GROUP_NAME_VALUE);
        VALID_SORT_BY_VALUES.add(SORT_BY_GROUP_TYPE_VALUE);
    }
}

