/*
 * Decompiled with CFR 0.152.
 */
package org.eximeebpms.bpm.engine.rest.dto.repository;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eximeebpms.bpm.engine.repository.CaseDefinition;
import org.eximeebpms.bpm.engine.repository.DecisionDefinition;
import org.eximeebpms.bpm.engine.repository.DecisionRequirementsDefinition;
import org.eximeebpms.bpm.engine.repository.DeploymentWithDefinitions;
import org.eximeebpms.bpm.engine.repository.ProcessDefinition;
import org.eximeebpms.bpm.engine.rest.dto.repository.CaseDefinitionDto;
import org.eximeebpms.bpm.engine.rest.dto.repository.DecisionDefinitionDto;
import org.eximeebpms.bpm.engine.rest.dto.repository.DecisionRequirementsDefinitionDto;
import org.eximeebpms.bpm.engine.rest.dto.repository.DeploymentDto;
import org.eximeebpms.bpm.engine.rest.dto.repository.ProcessDefinitionDto;

public class DeploymentWithDefinitionsDto
extends DeploymentDto {
    protected Map<String, ProcessDefinitionDto> deployedProcessDefinitions;
    protected Map<String, CaseDefinitionDto> deployedCaseDefinitions;
    protected Map<String, DecisionDefinitionDto> deployedDecisionDefinitions;
    protected Map<String, DecisionRequirementsDefinitionDto> deployedDecisionRequirementsDefinitions;

    public Map<String, ProcessDefinitionDto> getDeployedProcessDefinitions() {
        return this.deployedProcessDefinitions;
    }

    public Map<String, CaseDefinitionDto> getDeployedCaseDefinitions() {
        return this.deployedCaseDefinitions;
    }

    public Map<String, DecisionDefinitionDto> getDeployedDecisionDefinitions() {
        return this.deployedDecisionDefinitions;
    }

    public Map<String, DecisionRequirementsDefinitionDto> getDeployedDecisionRequirementsDefinitions() {
        return this.deployedDecisionRequirementsDefinitions;
    }

    public static DeploymentWithDefinitionsDto fromDeployment(DeploymentWithDefinitions deployment) {
        DeploymentWithDefinitionsDto dto = new DeploymentWithDefinitionsDto();
        dto.id = deployment.getId();
        dto.name = deployment.getName();
        dto.source = deployment.getSource();
        dto.deploymentTime = deployment.getDeploymentTime();
        dto.tenantId = deployment.getTenantId();
        DeploymentWithDefinitionsDto.initDeployedResourceLists(deployment, dto);
        return dto;
    }

    private static void initDeployedResourceLists(DeploymentWithDefinitions deployment, DeploymentWithDefinitionsDto dto) {
        List deployedDecisionRequirementsDefinitions;
        List deployedDecisionDefinitions;
        List deployedCaseDefinitions;
        List deployedProcessDefinitions = deployment.getDeployedProcessDefinitions();
        if (deployedProcessDefinitions != null) {
            dto.deployedProcessDefinitions = new HashMap<String, ProcessDefinitionDto>();
            for (ProcessDefinition processDefinition : deployedProcessDefinitions) {
                dto.deployedProcessDefinitions.put(processDefinition.getId(), ProcessDefinitionDto.fromProcessDefinition(processDefinition));
            }
        }
        if ((deployedCaseDefinitions = deployment.getDeployedCaseDefinitions()) != null) {
            dto.deployedCaseDefinitions = new HashMap<String, CaseDefinitionDto>();
            for (CaseDefinition caseDefinition : deployedCaseDefinitions) {
                dto.deployedCaseDefinitions.put(caseDefinition.getId(), CaseDefinitionDto.fromCaseDefinition(caseDefinition));
            }
        }
        if ((deployedDecisionDefinitions = deployment.getDeployedDecisionDefinitions()) != null) {
            dto.deployedDecisionDefinitions = new HashMap<String, DecisionDefinitionDto>();
            for (DecisionDefinition decisionDefinition : deployedDecisionDefinitions) {
                dto.deployedDecisionDefinitions.put(decisionDefinition.getId(), DecisionDefinitionDto.fromDecisionDefinition(decisionDefinition));
            }
        }
        if ((deployedDecisionRequirementsDefinitions = deployment.getDeployedDecisionRequirementsDefinitions()) != null) {
            dto.deployedDecisionRequirementsDefinitions = new HashMap<String, DecisionRequirementsDefinitionDto>();
            for (DecisionRequirementsDefinition drd : deployedDecisionRequirementsDefinitions) {
                dto.deployedDecisionRequirementsDefinitions.put(drd.getId(), DecisionRequirementsDefinitionDto.fromDecisionRequirementsDefinition(drd));
            }
        }
    }
}

