/*
 * Decompiled with CFR 0.152.
 */
package org.eximeebpms.bpm.engine.rest.dto.task;

import javax.ws.rs.core.Response;
import org.eximeebpms.bpm.engine.rest.exception.InvalidRequestException;
import org.eximeebpms.bpm.engine.task.IdentityLink;

public class IdentityLinkDto {
    protected String userId;
    protected String groupId;
    protected String type;

    public String getUserId() {
        return this.userId;
    }

    public void setUserId(String userId) {
        this.userId = userId;
    }

    public String getGroupId() {
        return this.groupId;
    }

    public void setGroupId(String groupId) {
        this.groupId = groupId;
    }

    public String getType() {
        return this.type;
    }

    public void setType(String type) {
        this.type = type;
    }

    public static IdentityLinkDto fromIdentityLink(IdentityLink identityLink) {
        IdentityLinkDto dto = new IdentityLinkDto();
        dto.userId = identityLink.getUserId();
        dto.groupId = identityLink.getGroupId();
        dto.type = identityLink.getType();
        return dto;
    }

    public void validate() {
        if (this.userId != null && this.groupId != null) {
            throw new InvalidRequestException(Response.Status.BAD_REQUEST, "Identity Link requires userId or groupId, but not both.");
        }
        if (this.userId == null && this.groupId == null) {
            throw new InvalidRequestException(Response.Status.BAD_REQUEST, "Identity Link requires userId or groupId.");
        }
    }
}

