/*
 * Decompiled with CFR 0.152.
 */
package org.eximeebpms.bpm.engine.rest.hal.caseDefinition;

import javax.ws.rs.core.UriBuilder;
import org.eximeebpms.bpm.engine.ProcessEngine;
import org.eximeebpms.bpm.engine.repository.CaseDefinition;
import org.eximeebpms.bpm.engine.rest.CaseDefinitionRestService;
import org.eximeebpms.bpm.engine.rest.DeploymentRestService;
import org.eximeebpms.bpm.engine.rest.hal.HalIdResource;
import org.eximeebpms.bpm.engine.rest.hal.HalRelation;
import org.eximeebpms.bpm.engine.rest.hal.HalResource;
import org.eximeebpms.bpm.engine.rest.sub.repository.DeploymentResourcesResource;
import org.eximeebpms.bpm.engine.rest.util.ApplicationContextPathUtil;

public class HalCaseDefinition
extends HalResource<HalCaseDefinition>
implements HalIdResource {
    public static final HalRelation REL_SELF = HalRelation.build("self", CaseDefinitionRestService.class, UriBuilder.fromPath((String)"/case-definition").path("{id}"));
    public static final HalRelation REL_DEPLOYMENT = HalRelation.build("deployment", DeploymentRestService.class, UriBuilder.fromPath((String)"/deployment").path("{id}"));
    public static final HalRelation REL_DEPLOYMENT_RESOURCE = HalRelation.build("resource", DeploymentResourcesResource.class, UriBuilder.fromPath((String)"/deployment").path("{deploymentId}").path("resources").path("{resourceId}"));
    protected String id;
    protected String key;
    protected String category;
    protected String name;
    protected int version;
    protected String resource;
    protected String deploymentId;
    protected String contextPath;

    public static HalCaseDefinition fromCaseDefinition(CaseDefinition caseDefinition, ProcessEngine processEngine) {
        HalCaseDefinition halCaseDefinition = new HalCaseDefinition();
        halCaseDefinition.id = caseDefinition.getId();
        halCaseDefinition.key = caseDefinition.getKey();
        halCaseDefinition.category = caseDefinition.getCategory();
        halCaseDefinition.name = caseDefinition.getName();
        halCaseDefinition.version = caseDefinition.getVersion();
        halCaseDefinition.resource = caseDefinition.getResourceName();
        halCaseDefinition.deploymentId = caseDefinition.getDeploymentId();
        halCaseDefinition.contextPath = ApplicationContextPathUtil.getApplicationPathForDeployment(processEngine, caseDefinition.getDeploymentId());
        halCaseDefinition.linker.createLink(REL_SELF, caseDefinition.getId());
        halCaseDefinition.linker.createLink(REL_DEPLOYMENT, caseDefinition.getDeploymentId());
        halCaseDefinition.linker.createLink(REL_DEPLOYMENT_RESOURCE, caseDefinition.getDeploymentId(), caseDefinition.getResourceName());
        return halCaseDefinition;
    }

    @Override
    public String getId() {
        return this.id;
    }

    public String getKey() {
        return this.key;
    }

    public String getCategory() {
        return this.category;
    }

    public String getName() {
        return this.name;
    }

    public int getVersion() {
        return this.version;
    }

    public String getResource() {
        return this.resource;
    }

    public String getDeploymentId() {
        return this.deploymentId;
    }

    public String getContextPath() {
        return this.contextPath;
    }
}

