/*
 * Decompiled with CFR 0.152.
 */
package org.eximeebpms.bpm.engine.rest.hal.identitylink;

import java.util.ArrayList;
import java.util.List;
import javax.ws.rs.core.Response;
import org.eximeebpms.bpm.engine.ProcessEngine;
import org.eximeebpms.bpm.engine.TaskService;
import org.eximeebpms.bpm.engine.rest.exception.InvalidRequestException;
import org.eximeebpms.bpm.engine.rest.hal.HalResource;
import org.eximeebpms.bpm.engine.rest.hal.cache.HalCachingLinkResolver;
import org.eximeebpms.bpm.engine.rest.hal.identitylink.HalIdentityLink;
import org.eximeebpms.bpm.engine.task.IdentityLink;

public class HalIdentityLinkResolver
extends HalCachingLinkResolver {
    @Override
    protected Class<?> getHalResourceClass() {
        return HalIdentityLink.class;
    }

    @Override
    public List<HalResource<?>> resolveLinks(String[] linkedIds, ProcessEngine processEngine) {
        if (linkedIds.length > 1) {
            throw new InvalidRequestException(Response.Status.INTERNAL_SERVER_ERROR, "The identity link resolver can only handle one task id");
        }
        return super.resolveLinks(linkedIds, processEngine);
    }

    @Override
    protected List<HalResource<?>> resolveNotCachedLinks(String[] linkedIds, ProcessEngine processEngine) {
        TaskService taskService = processEngine.getTaskService();
        List identityLinks = taskService.getIdentityLinksForTask(linkedIds[0]);
        ArrayList resolvedIdentityLinks = new ArrayList();
        for (IdentityLink identityLink : identityLinks) {
            resolvedIdentityLinks.add(HalIdentityLink.fromIdentityLink(identityLink));
        }
        return resolvedIdentityLinks;
    }

    @Override
    protected void putIntoCache(List<HalResource<?>> notCachedResources) {
        if (notCachedResources != null && !notCachedResources.isEmpty()) {
            String taskId = this.getResourceId(notCachedResources.get(0));
            this.getCache().put(taskId, notCachedResources);
        }
    }

    @Override
    protected String getResourceId(HalResource<?> resource) {
        return ((HalIdentityLink)resource).getTaskId();
    }
}

