/*
 * Decompiled with CFR 0.152.
 */
package org.eximeebpms.bpm.engine.rest.impl;

import com.fasterxml.jackson.databind.ObjectMapper;
import org.eximeebpms.bpm.engine.AuthorizationService;
import org.eximeebpms.bpm.engine.IdentityService;
import org.eximeebpms.bpm.engine.ProcessEngine;
import org.eximeebpms.bpm.engine.authorization.Permission;
import org.eximeebpms.bpm.engine.authorization.Resource;
import org.eximeebpms.bpm.engine.impl.identity.Authentication;
import org.eximeebpms.bpm.engine.rest.impl.AbstractRestProcessEngineAware;

public abstract class AbstractAuthorizedRestResource
extends AbstractRestProcessEngineAware {
    protected final Resource resource;
    protected final String resourceId;

    public AbstractAuthorizedRestResource(String processEngineName, Resource resource, String resourceId, ObjectMapper objectMapper) {
        super(processEngineName, objectMapper);
        this.resource = resource;
        this.resourceId = resourceId;
    }

    protected boolean isAuthorized(Permission permission, Resource resource, String resourceId) {
        ProcessEngine processEngine = this.getProcessEngine();
        if (!processEngine.getProcessEngineConfiguration().isAuthorizationEnabled()) {
            return true;
        }
        IdentityService identityService = processEngine.getIdentityService();
        AuthorizationService authorizationService = processEngine.getAuthorizationService();
        Authentication authentication = identityService.getCurrentAuthentication();
        if (authentication == null) {
            return true;
        }
        return authorizationService.isUserAuthorized(authentication.getUserId(), authentication.getGroupIds(), permission, resource, resourceId);
    }

    protected boolean isAuthorized(Permission permission, Resource resource) {
        return this.isAuthorized(permission, resource, this.resourceId);
    }

    protected boolean isAuthorized(Permission permission) {
        return this.isAuthorized(permission, this.resource);
    }
}

