/*
 * Decompiled with CFR 0.152.
 */
package org.eximeebpms.bpm.engine.rest.impl;

import com.fasterxml.jackson.databind.ObjectMapper;
import java.util.ArrayList;
import java.util.List;
import javax.ws.rs.core.MultivaluedMap;
import javax.ws.rs.core.Response;
import javax.ws.rs.core.UriInfo;
import org.eximeebpms.bpm.engine.ProcessEngine;
import org.eximeebpms.bpm.engine.repository.CaseDefinition;
import org.eximeebpms.bpm.engine.repository.CaseDefinitionQuery;
import org.eximeebpms.bpm.engine.rest.CaseDefinitionRestService;
import org.eximeebpms.bpm.engine.rest.dto.CountResultDto;
import org.eximeebpms.bpm.engine.rest.dto.repository.CaseDefinitionDto;
import org.eximeebpms.bpm.engine.rest.dto.repository.CaseDefinitionQueryDto;
import org.eximeebpms.bpm.engine.rest.exception.RestException;
import org.eximeebpms.bpm.engine.rest.impl.AbstractRestProcessEngineAware;
import org.eximeebpms.bpm.engine.rest.sub.repository.CaseDefinitionResource;
import org.eximeebpms.bpm.engine.rest.sub.repository.impl.CaseDefinitionResourceImpl;
import org.eximeebpms.bpm.engine.rest.util.QueryUtil;

public class CaseDefinitionRestServiceImpl
extends AbstractRestProcessEngineAware
implements CaseDefinitionRestService {
    public CaseDefinitionRestServiceImpl(String engineName, ObjectMapper objectMapper) {
        super(engineName, objectMapper);
    }

    @Override
    public CaseDefinitionResource getCaseDefinitionByKey(String caseDefinitionKey) {
        CaseDefinition caseDefinition = (CaseDefinition)this.getProcessEngine().getRepositoryService().createCaseDefinitionQuery().caseDefinitionKey(caseDefinitionKey).withoutTenantId().latestVersion().singleResult();
        if (caseDefinition == null) {
            String errorMessage = String.format("No matching case definition with key: %s and no tenant-id", caseDefinitionKey);
            throw new RestException(Response.Status.NOT_FOUND, errorMessage);
        }
        return this.getCaseDefinitionById(caseDefinition.getId());
    }

    @Override
    public CaseDefinitionResource getCaseDefinitionByKeyAndTenantId(String caseDefinitionKey, String tenantId) {
        CaseDefinition caseDefinition = (CaseDefinition)this.getProcessEngine().getRepositoryService().createCaseDefinitionQuery().caseDefinitionKey(caseDefinitionKey).tenantIdIn(new String[]{tenantId}).latestVersion().singleResult();
        if (caseDefinition == null) {
            String errorMessage = String.format("No matching case definition with key: %s and tenant-id: %s", caseDefinitionKey, tenantId);
            throw new RestException(Response.Status.NOT_FOUND, errorMessage);
        }
        return this.getCaseDefinitionById(caseDefinition.getId());
    }

    @Override
    public CaseDefinitionResource getCaseDefinitionById(String caseDefinitionId) {
        return new CaseDefinitionResourceImpl(this.getProcessEngine(), caseDefinitionId, this.relativeRootResourcePath, this.getObjectMapper());
    }

    @Override
    public List<CaseDefinitionDto> getCaseDefinitions(UriInfo uriInfo, Integer firstResult, Integer maxResults) {
        CaseDefinitionQueryDto queryDto = new CaseDefinitionQueryDto(this.getObjectMapper(), (MultivaluedMap<String, String>)uriInfo.getQueryParameters());
        ArrayList<CaseDefinitionDto> definitions = new ArrayList<CaseDefinitionDto>();
        ProcessEngine engine = this.getProcessEngine();
        CaseDefinitionQuery query = (CaseDefinitionQuery)queryDto.toQuery(engine);
        List<CaseDefinition> matchingDefinitions = QueryUtil.list(query, firstResult, maxResults);
        for (CaseDefinition definition : matchingDefinitions) {
            CaseDefinitionDto def = CaseDefinitionDto.fromCaseDefinition(definition);
            definitions.add(def);
        }
        return definitions;
    }

    @Override
    public CountResultDto getCaseDefinitionsCount(UriInfo uriInfo) {
        CaseDefinitionQueryDto queryDto = new CaseDefinitionQueryDto(this.getObjectMapper(), (MultivaluedMap<String, String>)uriInfo.getQueryParameters());
        ProcessEngine engine = this.getProcessEngine();
        CaseDefinitionQuery query = (CaseDefinitionQuery)queryDto.toQuery(engine);
        long count = query.count();
        CountResultDto result = new CountResultDto();
        result.setCount(count);
        return result;
    }
}

