/*
 * Decompiled with CFR 0.152.
 */
package org.eximeebpms.bpm.engine.rest.impl;

import com.fasterxml.jackson.databind.ObjectMapper;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import javax.ws.rs.core.Response;
import org.eximeebpms.bpm.engine.RuntimeService;
import org.eximeebpms.bpm.engine.rest.ConditionRestService;
import org.eximeebpms.bpm.engine.rest.dto.VariableValueDto;
import org.eximeebpms.bpm.engine.rest.dto.condition.EvaluationConditionDto;
import org.eximeebpms.bpm.engine.rest.dto.runtime.ProcessInstanceDto;
import org.eximeebpms.bpm.engine.rest.exception.InvalidRequestException;
import org.eximeebpms.bpm.engine.rest.impl.AbstractRestProcessEngineAware;
import org.eximeebpms.bpm.engine.runtime.ConditionEvaluationBuilder;
import org.eximeebpms.bpm.engine.runtime.ProcessInstance;
import org.eximeebpms.bpm.engine.variable.VariableMap;

public class ConditionRestServiceImpl
extends AbstractRestProcessEngineAware
implements ConditionRestService {
    public ConditionRestServiceImpl(String engineName, ObjectMapper objectMapper) {
        super(engineName, objectMapper);
    }

    @Override
    public List<ProcessInstanceDto> evaluateCondition(EvaluationConditionDto conditionDto) {
        if (conditionDto.getTenantId() != null && conditionDto.isWithoutTenantId()) {
            throw new InvalidRequestException(Response.Status.BAD_REQUEST, "Parameter 'tenantId' cannot be used together with parameter 'withoutTenantId'.");
        }
        ConditionEvaluationBuilder builder = this.createConditionEvaluationBuilder(conditionDto);
        List processInstances = builder.evaluateStartConditions();
        ArrayList<ProcessInstanceDto> result = new ArrayList<ProcessInstanceDto>();
        for (ProcessInstance processInstance : processInstances) {
            result.add(ProcessInstanceDto.fromProcessInstance(processInstance));
        }
        return result;
    }

    protected ConditionEvaluationBuilder createConditionEvaluationBuilder(EvaluationConditionDto conditionDto) {
        RuntimeService runtimeService = this.getProcessEngine().getRuntimeService();
        ObjectMapper objectMapper = this.getObjectMapper();
        VariableMap variables = VariableValueDto.toMap(conditionDto.getVariables(), this.getProcessEngine(), objectMapper);
        ConditionEvaluationBuilder builder = runtimeService.createConditionEvaluation();
        if (variables != null && !variables.isEmpty()) {
            builder.setVariables((Map)variables);
        }
        if (conditionDto.getBusinessKey() != null) {
            builder.processInstanceBusinessKey(conditionDto.getBusinessKey());
        }
        if (conditionDto.getProcessDefinitionId() != null) {
            builder.processDefinitionId(conditionDto.getProcessDefinitionId());
        }
        if (conditionDto.getTenantId() != null) {
            builder.tenantId(conditionDto.getTenantId());
        } else if (conditionDto.isWithoutTenantId()) {
            builder.withoutTenantId();
        }
        return builder;
    }
}

