/*
 * Decompiled with CFR 0.152.
 */
package org.eximeebpms.bpm.engine.rest.impl.history;

import com.fasterxml.jackson.databind.ObjectMapper;
import java.util.ArrayList;
import java.util.List;
import javax.ws.rs.core.MultivaluedMap;
import javax.ws.rs.core.UriInfo;
import org.eximeebpms.bpm.engine.ProcessEngine;
import org.eximeebpms.bpm.engine.history.HistoricDetail;
import org.eximeebpms.bpm.engine.history.HistoricDetailQuery;
import org.eximeebpms.bpm.engine.rest.dto.CountResultDto;
import org.eximeebpms.bpm.engine.rest.dto.history.HistoricDetailDto;
import org.eximeebpms.bpm.engine.rest.dto.history.HistoricDetailQueryDto;
import org.eximeebpms.bpm.engine.rest.history.HistoricDetailRestService;
import org.eximeebpms.bpm.engine.rest.sub.history.HistoricDetailResource;
import org.eximeebpms.bpm.engine.rest.sub.history.impl.HistoricDetailResourceImpl;
import org.eximeebpms.bpm.engine.rest.util.QueryUtil;

public class HistoricDetailRestServiceImpl
implements HistoricDetailRestService {
    protected ObjectMapper objectMapper;
    protected ProcessEngine processEngine;

    public HistoricDetailRestServiceImpl(ObjectMapper objectMapper, ProcessEngine processEngine) {
        this.objectMapper = objectMapper;
        this.processEngine = processEngine;
    }

    @Override
    public HistoricDetailResource historicDetail(String detailId) {
        return new HistoricDetailResourceImpl(detailId, this.processEngine);
    }

    @Override
    public List<HistoricDetailDto> getHistoricDetails(UriInfo uriInfo, Integer firstResult, Integer maxResults, boolean deserializeObjectValues) {
        HistoricDetailQueryDto queryDto = new HistoricDetailQueryDto(this.objectMapper, (MultivaluedMap<String, String>)uriInfo.getQueryParameters());
        HistoricDetailQuery query = (HistoricDetailQuery)queryDto.toQuery(this.processEngine);
        return this.executeHistoricDetailQuery(query, firstResult, maxResults, deserializeObjectValues);
    }

    @Override
    public List<HistoricDetailDto> queryHistoricDetails(HistoricDetailQueryDto queryDto, Integer firstResult, Integer maxResults, boolean deserializeObjectValues) {
        HistoricDetailQuery query = (HistoricDetailQuery)queryDto.toQuery(this.processEngine);
        return this.executeHistoricDetailQuery(query, firstResult, maxResults, deserializeObjectValues);
    }

    @Override
    public CountResultDto getHistoricDetailsCount(UriInfo uriInfo) {
        HistoricDetailQueryDto queryDto = new HistoricDetailQueryDto(this.objectMapper, (MultivaluedMap<String, String>)uriInfo.getQueryParameters());
        HistoricDetailQuery query = (HistoricDetailQuery)queryDto.toQuery(this.processEngine);
        long count = query.count();
        CountResultDto result = new CountResultDto();
        result.setCount(count);
        return result;
    }

    private List<HistoricDetailDto> executeHistoricDetailQuery(HistoricDetailQuery query, Integer firstResult, Integer maxResults, boolean deserializeObjectValues) {
        query.disableBinaryFetching();
        if (!deserializeObjectValues) {
            query.disableCustomObjectDeserialization();
        }
        List<HistoricDetail> queryResult = QueryUtil.list(query, firstResult, maxResults);
        ArrayList<HistoricDetailDto> result = new ArrayList<HistoricDetailDto>();
        for (HistoricDetail historicDetail : queryResult) {
            HistoricDetailDto dto = HistoricDetailDto.fromHistoricDetail(historicDetail);
            result.add(dto);
        }
        return result;
    }
}

