/*
 * Decompiled with CFR 0.152.
 */
package org.eximeebpms.bpm.engine.rest.impl.history;

import com.fasterxml.jackson.databind.ObjectMapper;
import java.util.ArrayList;
import java.util.List;
import javax.ws.rs.core.MultivaluedMap;
import javax.ws.rs.core.UriInfo;
import org.eximeebpms.bpm.engine.ProcessEngine;
import org.eximeebpms.bpm.engine.history.CleanableHistoricProcessInstanceReport;
import org.eximeebpms.bpm.engine.history.CleanableHistoricProcessInstanceReportResult;
import org.eximeebpms.bpm.engine.history.HistoricActivityStatistics;
import org.eximeebpms.bpm.engine.history.HistoricActivityStatisticsQuery;
import org.eximeebpms.bpm.engine.rest.dto.CountResultDto;
import org.eximeebpms.bpm.engine.rest.dto.history.CleanableHistoricProcessInstanceReportDto;
import org.eximeebpms.bpm.engine.rest.dto.history.CleanableHistoricProcessInstanceReportResultDto;
import org.eximeebpms.bpm.engine.rest.dto.history.HistoricActivityStatisticsDto;
import org.eximeebpms.bpm.engine.rest.history.HistoricProcessDefinitionRestService;
import org.eximeebpms.bpm.engine.rest.impl.AbstractRestProcessEngineAware;
import org.eximeebpms.bpm.engine.rest.impl.history.HistoricActivityStatisticsQueryDto;
import org.eximeebpms.bpm.engine.rest.util.QueryUtil;

public class HistoricProcessDefinitionRestServiceImpl
extends AbstractRestProcessEngineAware
implements HistoricProcessDefinitionRestService {
    public HistoricProcessDefinitionRestServiceImpl(ObjectMapper objectMapper, ProcessEngine processEngine) {
        super(processEngine.getName(), objectMapper);
    }

    @Override
    public List<HistoricActivityStatisticsDto> getHistoricActivityStatistics(UriInfo uriInfo, String processDefinitionId) {
        HistoricActivityStatisticsQueryDto queryDto = new HistoricActivityStatisticsQueryDto(this.getObjectMapper(), processDefinitionId, (MultivaluedMap<String, String>)uriInfo.getQueryParameters());
        HistoricActivityStatisticsQuery query = (HistoricActivityStatisticsQuery)queryDto.toQuery(this.getProcessEngine());
        ArrayList<HistoricActivityStatisticsDto> result = new ArrayList<HistoricActivityStatisticsDto>();
        List statistics = query.unlimitedList();
        for (HistoricActivityStatistics currentStatistics : statistics) {
            result.add(HistoricActivityStatisticsDto.fromHistoricActivityStatistics(currentStatistics));
        }
        return result;
    }

    @Override
    public List<CleanableHistoricProcessInstanceReportResultDto> getCleanableHistoricProcessInstanceReport(UriInfo uriInfo, Integer firstResult, Integer maxResults) {
        CleanableHistoricProcessInstanceReportDto queryDto = new CleanableHistoricProcessInstanceReportDto(this.objectMapper, (MultivaluedMap<String, String>)uriInfo.getQueryParameters());
        CleanableHistoricProcessInstanceReport query = (CleanableHistoricProcessInstanceReport)queryDto.toQuery(this.getProcessEngine());
        List<CleanableHistoricProcessInstanceReportResult> reportResult = QueryUtil.list(query, firstResult, maxResults);
        return CleanableHistoricProcessInstanceReportResultDto.convert(reportResult);
    }

    @Override
    public CountResultDto getCleanableHistoricProcessInstanceReportCount(UriInfo uriInfo) {
        CleanableHistoricProcessInstanceReportDto queryDto = new CleanableHistoricProcessInstanceReportDto(this.objectMapper, (MultivaluedMap<String, String>)uriInfo.getQueryParameters());
        queryDto.setObjectMapper(this.objectMapper);
        CleanableHistoricProcessInstanceReport query = (CleanableHistoricProcessInstanceReport)queryDto.toQuery(this.getProcessEngine());
        long count = query.count();
        CountResultDto result = new CountResultDto();
        result.setCount(count);
        return result;
    }
}

