/*
 * Decompiled with CFR 0.152.
 */
package org.eximeebpms.bpm.engine.rest.impl.history;

import com.fasterxml.jackson.databind.ObjectMapper;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import javax.ws.rs.core.MediaType;
import javax.ws.rs.core.MultivaluedMap;
import javax.ws.rs.core.Request;
import javax.ws.rs.core.Response;
import javax.ws.rs.core.UriInfo;
import javax.ws.rs.core.Variant;
import org.eximeebpms.bpm.engine.BadUserRequestException;
import org.eximeebpms.bpm.engine.HistoryService;
import org.eximeebpms.bpm.engine.ProcessEngine;
import org.eximeebpms.bpm.engine.batch.Batch;
import org.eximeebpms.bpm.engine.exception.NotFoundException;
import org.eximeebpms.bpm.engine.history.HistoricProcessInstance;
import org.eximeebpms.bpm.engine.history.HistoricProcessInstanceQuery;
import org.eximeebpms.bpm.engine.history.ReportResult;
import org.eximeebpms.bpm.engine.history.SetRemovalTimeSelectModeForHistoricProcessInstancesBuilder;
import org.eximeebpms.bpm.engine.rest.dto.CountResultDto;
import org.eximeebpms.bpm.engine.rest.dto.batch.BatchDto;
import org.eximeebpms.bpm.engine.rest.dto.converter.ReportResultToCsvConverter;
import org.eximeebpms.bpm.engine.rest.dto.history.DeleteHistoricProcessInstancesDto;
import org.eximeebpms.bpm.engine.rest.dto.history.HistoricProcessInstanceDto;
import org.eximeebpms.bpm.engine.rest.dto.history.HistoricProcessInstanceQueryDto;
import org.eximeebpms.bpm.engine.rest.dto.history.HistoricProcessInstanceReportDto;
import org.eximeebpms.bpm.engine.rest.dto.history.ReportResultDto;
import org.eximeebpms.bpm.engine.rest.dto.history.batch.removaltime.SetRemovalTimeToHistoricProcessInstancesDto;
import org.eximeebpms.bpm.engine.rest.exception.InvalidRequestException;
import org.eximeebpms.bpm.engine.rest.history.HistoricProcessInstanceRestService;
import org.eximeebpms.bpm.engine.rest.sub.history.HistoricProcessInstanceResource;
import org.eximeebpms.bpm.engine.rest.sub.history.impl.HistoricProcessInstanceResourceImpl;
import org.eximeebpms.bpm.engine.rest.util.QueryUtil;
import org.eximeebpms.bpm.engine.rest.util.URLEncodingUtil;

public class HistoricProcessInstanceRestServiceImpl
implements HistoricProcessInstanceRestService {
    public static final MediaType APPLICATION_CSV_TYPE = new MediaType("application", "csv");
    public static final MediaType TEXT_CSV_TYPE = new MediaType("text", "csv");
    public static final List<Variant> VARIANTS = Variant.mediaTypes((MediaType[])new MediaType[]{MediaType.APPLICATION_JSON_TYPE, APPLICATION_CSV_TYPE, TEXT_CSV_TYPE}).add().build();
    protected ObjectMapper objectMapper;
    protected ProcessEngine processEngine;

    public HistoricProcessInstanceRestServiceImpl(ObjectMapper objectMapper, ProcessEngine processEngine) {
        this.objectMapper = objectMapper;
        this.processEngine = processEngine;
    }

    @Override
    public HistoricProcessInstanceResource getHistoricProcessInstance(String processInstanceId) {
        return new HistoricProcessInstanceResourceImpl(this.processEngine, processInstanceId);
    }

    @Override
    public List<HistoricProcessInstanceDto> getHistoricProcessInstances(UriInfo uriInfo, Integer firstResult, Integer maxResults) {
        HistoricProcessInstanceQueryDto queryHistoriProcessInstanceDto = new HistoricProcessInstanceQueryDto(this.objectMapper, (MultivaluedMap<String, String>)uriInfo.getQueryParameters());
        return this.queryHistoricProcessInstances(queryHistoriProcessInstanceDto, firstResult, maxResults);
    }

    @Override
    public List<HistoricProcessInstanceDto> queryHistoricProcessInstances(HistoricProcessInstanceQueryDto queryDto, Integer firstResult, Integer maxResults) {
        queryDto.setObjectMapper(this.objectMapper);
        HistoricProcessInstanceQuery query = (HistoricProcessInstanceQuery)queryDto.toQuery(this.processEngine);
        List<HistoricProcessInstance> matchingHistoricProcessInstances = QueryUtil.list(query, firstResult, maxResults);
        ArrayList<HistoricProcessInstanceDto> historicProcessInstanceDtoResults = new ArrayList<HistoricProcessInstanceDto>();
        for (HistoricProcessInstance historicProcessInstance : matchingHistoricProcessInstances) {
            HistoricProcessInstanceDto resultHistoricProcessInstanceDto = HistoricProcessInstanceDto.fromHistoricProcessInstance(historicProcessInstance);
            historicProcessInstanceDtoResults.add(resultHistoricProcessInstanceDto);
        }
        return historicProcessInstanceDtoResults;
    }

    @Override
    public CountResultDto getHistoricProcessInstancesCount(UriInfo uriInfo) {
        HistoricProcessInstanceQueryDto queryDto = new HistoricProcessInstanceQueryDto(this.objectMapper, (MultivaluedMap<String, String>)uriInfo.getQueryParameters());
        return this.queryHistoricProcessInstancesCount(queryDto);
    }

    @Override
    public CountResultDto queryHistoricProcessInstancesCount(HistoricProcessInstanceQueryDto queryDto) {
        queryDto.setObjectMapper(this.objectMapper);
        HistoricProcessInstanceQuery query = (HistoricProcessInstanceQuery)queryDto.toQuery(this.processEngine);
        long count = query.count();
        CountResultDto result = new CountResultDto();
        result.setCount(count);
        return result;
    }

    protected List<ReportResult> queryHistoricProcessInstanceReport(UriInfo uriInfo) {
        HistoricProcessInstanceReportDto reportDto = new HistoricProcessInstanceReportDto(this.objectMapper, (MultivaluedMap<String, String>)uriInfo.getQueryParameters());
        return reportDto.executeReport(this.processEngine);
    }

    @Override
    public Response getHistoricProcessInstancesReport(UriInfo uriInfo, Request request) {
        Variant variant = request.selectVariant(VARIANTS);
        if (variant != null) {
            MediaType mediaType = variant.getMediaType();
            if (MediaType.APPLICATION_JSON_TYPE.equals((Object)mediaType)) {
                List<ReportResultDto> result = this.getReportResultAsJson(uriInfo);
                return Response.ok(result, (MediaType)mediaType).build();
            }
            if (APPLICATION_CSV_TYPE.equals((Object)mediaType) || TEXT_CSV_TYPE.equals((Object)mediaType)) {
                String csv = this.getReportResultAsCsv(uriInfo);
                return Response.ok((Object)csv, (MediaType)mediaType).header("Content-Disposition", (Object)URLEncodingUtil.buildAttachmentValue("process-instance-report.csv")).build();
            }
        }
        throw new InvalidRequestException(Response.Status.NOT_ACCEPTABLE, "No acceptable content-type found");
    }

    @Override
    public BatchDto deleteAsync(DeleteHistoricProcessInstancesDto dto) {
        HistoryService historyService = this.processEngine.getHistoryService();
        HistoricProcessInstanceQuery historicProcessInstanceQuery = null;
        if (dto.getHistoricProcessInstanceQuery() != null) {
            historicProcessInstanceQuery = (HistoricProcessInstanceQuery)dto.getHistoricProcessInstanceQuery().toQuery(this.processEngine);
        }
        try {
            Batch batch = historyService.deleteHistoricProcessInstancesAsync(dto.getHistoricProcessInstanceIds(), historicProcessInstanceQuery, dto.getDeleteReason());
            return BatchDto.fromBatch(batch);
        }
        catch (BadUserRequestException e) {
            throw new InvalidRequestException(Response.Status.BAD_REQUEST, e.getMessage());
        }
    }

    @Override
    public BatchDto setRemovalTimeAsync(SetRemovalTimeToHistoricProcessInstancesDto dto) {
        Integer chunkSize;
        HistoryService historyService = this.processEngine.getHistoryService();
        HistoricProcessInstanceQuery historicProcessInstanceQuery = null;
        if (dto.getHistoricProcessInstanceQuery() != null) {
            historicProcessInstanceQuery = (HistoricProcessInstanceQuery)dto.getHistoricProcessInstanceQuery().toQuery(this.processEngine);
        }
        SetRemovalTimeSelectModeForHistoricProcessInstancesBuilder builder = historyService.setRemovalTimeToHistoricProcessInstances();
        if (dto.isCalculatedRemovalTime()) {
            builder.calculatedRemovalTime();
        }
        Date removalTime = dto.getAbsoluteRemovalTime();
        if (dto.getAbsoluteRemovalTime() != null) {
            builder.absoluteRemovalTime(removalTime);
        }
        if (dto.isClearedRemovalTime()) {
            builder.clearedRemovalTime();
        }
        builder.byIds(dto.getHistoricProcessInstanceIds());
        builder.byQuery(historicProcessInstanceQuery);
        if (dto.isHierarchical()) {
            builder.hierarchical();
        }
        if (dto.isUpdateInChunks()) {
            builder.updateInChunks();
        }
        if ((chunkSize = dto.getUpdateChunkSize()) != null) {
            builder.chunkSize(chunkSize.intValue());
        }
        Batch batch = builder.executeAsync();
        return BatchDto.fromBatch(batch);
    }

    protected List<ReportResultDto> getReportResultAsJson(UriInfo uriInfo) {
        List<ReportResult> reports = this.queryHistoricProcessInstanceReport(uriInfo);
        ArrayList<ReportResultDto> result = new ArrayList<ReportResultDto>();
        for (ReportResult report : reports) {
            result.add(ReportResultDto.fromReportResult(report));
        }
        return result;
    }

    protected String getReportResultAsCsv(UriInfo uriInfo) {
        List<ReportResult> reports = this.queryHistoricProcessInstanceReport(uriInfo);
        MultivaluedMap queryParameters = uriInfo.getQueryParameters();
        String reportType = (String)queryParameters.getFirst((Object)"reportType");
        return ReportResultToCsvConverter.convertReportResult(reports, reportType);
    }

    @Override
    public Response deleteHistoricVariableInstancesByProcessInstanceId(String processInstanceId) {
        try {
            this.processEngine.getHistoryService().deleteHistoricVariableInstancesByProcessInstanceId(processInstanceId);
        }
        catch (NotFoundException nfe) {
            throw new InvalidRequestException(Response.Status.NOT_FOUND, nfe.getMessage());
        }
        return Response.noContent().build();
    }
}

