/*
 * Decompiled with CFR 0.152.
 */
package org.eximeebpms.bpm.engine.rest.impl.history;

import com.fasterxml.jackson.databind.ObjectMapper;
import java.util.ArrayList;
import java.util.List;
import javax.ws.rs.core.Response;
import org.eximeebpms.bpm.engine.ProcessEngine;
import org.eximeebpms.bpm.engine.impl.cfg.ProcessEngineConfigurationImpl;
import org.eximeebpms.bpm.engine.impl.jobexecutor.historycleanup.BatchWindow;
import org.eximeebpms.bpm.engine.impl.util.ClockUtil;
import org.eximeebpms.bpm.engine.rest.dto.history.HistoryCleanupConfigurationDto;
import org.eximeebpms.bpm.engine.rest.dto.runtime.JobDto;
import org.eximeebpms.bpm.engine.rest.exception.RestException;
import org.eximeebpms.bpm.engine.rest.history.HistoryCleanupRestService;
import org.eximeebpms.bpm.engine.runtime.Job;

public class HistoryCleanupRestServiceImpl
implements HistoryCleanupRestService {
    protected ObjectMapper objectMapper;
    protected ProcessEngine processEngine;

    public HistoryCleanupRestServiceImpl(ObjectMapper objectMapper, ProcessEngine processEngine) {
        this.objectMapper = objectMapper;
        this.processEngine = processEngine;
    }

    @Override
    public JobDto cleanupAsync(boolean immediatelyDue) {
        Job job = this.processEngine.getHistoryService().cleanUpHistoryAsync(immediatelyDue);
        return JobDto.fromJob(job);
    }

    @Override
    public JobDto findCleanupJob() {
        Job job = this.processEngine.getHistoryService().findHistoryCleanupJob();
        if (job == null) {
            throw new RestException(Response.Status.NOT_FOUND, "History cleanup job does not exist");
        }
        return JobDto.fromJob(job);
    }

    @Override
    public List<JobDto> findCleanupJobs() {
        List jobs = this.processEngine.getHistoryService().findHistoryCleanupJobs();
        if (jobs == null || jobs.isEmpty()) {
            throw new RestException(Response.Status.NOT_FOUND, "History cleanup jobs are empty");
        }
        ArrayList<JobDto> dtos = new ArrayList<JobDto>();
        for (Job job : jobs) {
            JobDto dto = JobDto.fromJob(job);
            dtos.add(dto);
        }
        return dtos;
    }

    @Override
    public HistoryCleanupConfigurationDto getHistoryCleanupConfiguration() {
        ProcessEngineConfigurationImpl engineConfiguration = (ProcessEngineConfigurationImpl)this.processEngine.getProcessEngineConfiguration();
        HistoryCleanupConfigurationDto configurationDto = new HistoryCleanupConfigurationDto();
        configurationDto.setEnabled(engineConfiguration.isHistoryCleanupEnabled());
        BatchWindow batchWindow = engineConfiguration.getBatchWindowManager().getCurrentOrNextBatchWindow(ClockUtil.getCurrentTime(), engineConfiguration);
        if (batchWindow != null) {
            configurationDto.setBatchWindowStartTime(batchWindow.getStart());
            configurationDto.setBatchWindowEndTime(batchWindow.getEnd());
        }
        return configurationDto;
    }
}

