/*
 * Decompiled with CFR 0.152.
 */
package org.eximeebpms.bpm.engine.rest.sub;

import javax.ws.rs.DefaultValue;
import javax.ws.rs.GET;
import javax.ws.rs.Path;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import javax.ws.rs.core.Response;
import org.eximeebpms.bpm.engine.ProcessEngine;
import org.eximeebpms.bpm.engine.query.Query;
import org.eximeebpms.bpm.engine.rest.exception.InvalidRequestException;
import org.eximeebpms.bpm.engine.rest.sub.impl.VariableResponseProvider;
import org.eximeebpms.bpm.engine.variable.value.TypedValue;

public abstract class AbstractResourceProvider<T extends Query<?, U>, U, DTO> {
    protected String id;
    protected ProcessEngine engine;

    public AbstractResourceProvider(String detailId, ProcessEngine engine) {
        this.id = detailId;
        this.engine = engine;
    }

    @GET
    @Produces(value={"application/json"})
    public DTO getResource(@QueryParam(value="deserializeValue") @DefaultValue(value="true") boolean deserializeObjectValue) {
        Object variableInstance = this.baseQueryForVariable(deserializeObjectValue).singleResult();
        if (variableInstance != null) {
            return this.transformToDto(variableInstance);
        }
        throw new InvalidRequestException(Response.Status.NOT_FOUND, this.getResourceNameForErrorMessage() + " with Id '" + this.id + "' does not exist.");
    }

    @GET
    @Path(value="/data")
    public Response getResourceBinary() {
        Object queryResult = this.baseQueryForBinaryVariable().singleResult();
        if (queryResult != null) {
            TypedValue variableInstance = this.transformQueryResultIntoTypedValue(queryResult);
            return new VariableResponseProvider().getResponseForTypedVariable(variableInstance, this.id);
        }
        throw new InvalidRequestException(Response.Status.NOT_FOUND, this.getResourceNameForErrorMessage() + " with Id '" + this.id + "' does not exist.");
    }

    protected String getId() {
        return this.id;
    }

    protected ProcessEngine getEngine() {
        return this.engine;
    }

    protected abstract Query<T, U> baseQueryForBinaryVariable();

    protected abstract Query<T, U> baseQueryForVariable(boolean var1);

    protected abstract TypedValue transformQueryResultIntoTypedValue(U var1);

    protected abstract DTO transformToDto(U var1);

    protected abstract String getResourceNameForErrorMessage();
}

