/*
 * Decompiled with CFR 0.152.
 */
package org.eximeebpms.bpm.engine.rest.sub.history.impl;

import javax.ws.rs.core.Response;
import org.eximeebpms.bpm.engine.BadUserRequestException;
import org.eximeebpms.bpm.engine.ProcessEngine;
import org.eximeebpms.bpm.engine.batch.history.HistoricBatch;
import org.eximeebpms.bpm.engine.rest.dto.history.batch.HistoricBatchDto;
import org.eximeebpms.bpm.engine.rest.exception.InvalidRequestException;
import org.eximeebpms.bpm.engine.rest.sub.history.HistoricBatchResource;

public class HistoricBatchResourceImpl
implements HistoricBatchResource {
    protected ProcessEngine processEngine;
    protected String batchId;

    public HistoricBatchResourceImpl(ProcessEngine processEngine, String batchId) {
        this.processEngine = processEngine;
        this.batchId = batchId;
    }

    @Override
    public HistoricBatchDto getHistoricBatch() {
        HistoricBatch batch = (HistoricBatch)this.processEngine.getHistoryService().createHistoricBatchQuery().batchId(this.batchId).singleResult();
        if (batch == null) {
            throw new InvalidRequestException(Response.Status.NOT_FOUND, "Historic batch with id '" + this.batchId + "' does not exist");
        }
        return HistoricBatchDto.fromBatch(batch);
    }

    @Override
    public void deleteHistoricBatch() {
        try {
            this.processEngine.getHistoryService().deleteHistoricBatch(this.batchId);
        }
        catch (BadUserRequestException e) {
            throw new InvalidRequestException(Response.Status.BAD_REQUEST, (Exception)((Object)e), "Unable to delete historic batch with id '" + this.batchId + "'");
        }
    }
}

