/*
 * Decompiled with CFR 0.152.
 */
package org.eximeebpms.bpm.engine.rest.sub.runtime.impl;

import com.fasterxml.jackson.databind.ObjectMapper;
import java.util.List;
import java.util.Map;
import javax.ws.rs.core.Response;
import org.eximeebpms.bpm.engine.CaseService;
import org.eximeebpms.bpm.engine.ProcessEngine;
import org.eximeebpms.bpm.engine.ProcessEngineException;
import org.eximeebpms.bpm.engine.exception.NotAllowedException;
import org.eximeebpms.bpm.engine.exception.NotFoundException;
import org.eximeebpms.bpm.engine.exception.NotValidException;
import org.eximeebpms.bpm.engine.rest.dto.runtime.CaseExecutionTriggerDto;
import org.eximeebpms.bpm.engine.rest.dto.runtime.CaseInstanceDto;
import org.eximeebpms.bpm.engine.rest.dto.runtime.TriggerVariableValueDto;
import org.eximeebpms.bpm.engine.rest.dto.runtime.VariableNameDto;
import org.eximeebpms.bpm.engine.rest.exception.InvalidRequestException;
import org.eximeebpms.bpm.engine.rest.exception.RestException;
import org.eximeebpms.bpm.engine.rest.sub.VariableResource;
import org.eximeebpms.bpm.engine.rest.sub.runtime.CaseInstanceResource;
import org.eximeebpms.bpm.engine.rest.sub.runtime.impl.CaseExecutionVariablesResource;
import org.eximeebpms.bpm.engine.runtime.CaseExecutionCommandBuilder;
import org.eximeebpms.bpm.engine.runtime.CaseInstance;

public class CaseInstanceResourceImpl
implements CaseInstanceResource {
    protected ProcessEngine engine;
    protected String caseInstanceId;
    protected ObjectMapper objectMapper;

    public CaseInstanceResourceImpl(ProcessEngine engine, String caseInstanceId, ObjectMapper objectMapper) {
        this.engine = engine;
        this.caseInstanceId = caseInstanceId;
        this.objectMapper = objectMapper;
    }

    @Override
    public CaseInstanceDto getCaseInstance() {
        CaseService caseService = this.engine.getCaseService();
        CaseInstance instance = (CaseInstance)caseService.createCaseInstanceQuery().caseInstanceId(this.caseInstanceId).singleResult();
        if (instance == null) {
            throw new InvalidRequestException(Response.Status.NOT_FOUND, "Case instance with id " + this.caseInstanceId + " does not exist.");
        }
        CaseInstanceDto result = CaseInstanceDto.fromCaseInstance(instance);
        return result;
    }

    @Override
    public void complete(CaseExecutionTriggerDto triggerDto) {
        try {
            CaseService caseService = this.engine.getCaseService();
            CaseExecutionCommandBuilder commandBuilder = caseService.withCaseExecution(this.caseInstanceId);
            this.initializeCommand(commandBuilder, triggerDto, "complete");
            commandBuilder.complete();
        }
        catch (NotFoundException e) {
            throw this.createInvalidRequestException("complete", Response.Status.NOT_FOUND, (ProcessEngineException)((Object)e));
        }
        catch (NotValidException e) {
            throw this.createInvalidRequestException("complete", Response.Status.BAD_REQUEST, (ProcessEngineException)((Object)e));
        }
        catch (NotAllowedException e) {
            throw this.createInvalidRequestException("complete", Response.Status.FORBIDDEN, (ProcessEngineException)((Object)e));
        }
        catch (ProcessEngineException e) {
            throw this.createRestException("complete", Response.Status.INTERNAL_SERVER_ERROR, e);
        }
    }

    @Override
    public void close(CaseExecutionTriggerDto triggerDto) {
        try {
            CaseService caseService = this.engine.getCaseService();
            CaseExecutionCommandBuilder commandBuilder = caseService.withCaseExecution(this.caseInstanceId);
            this.initializeCommand(commandBuilder, triggerDto, "close");
            commandBuilder.close();
        }
        catch (NotFoundException e) {
            throw this.createInvalidRequestException("close", Response.Status.NOT_FOUND, (ProcessEngineException)((Object)e));
        }
        catch (NotValidException e) {
            throw this.createInvalidRequestException("close", Response.Status.BAD_REQUEST, (ProcessEngineException)((Object)e));
        }
        catch (NotAllowedException e) {
            throw this.createInvalidRequestException("close", Response.Status.FORBIDDEN, (ProcessEngineException)((Object)e));
        }
        catch (ProcessEngineException e) {
            throw this.createRestException("close", Response.Status.INTERNAL_SERVER_ERROR, e);
        }
    }

    @Override
    public void terminate(CaseExecutionTriggerDto triggerDto) {
        try {
            CaseService caseService = this.engine.getCaseService();
            CaseExecutionCommandBuilder commandBuilder = caseService.withCaseExecution(this.caseInstanceId);
            this.initializeCommand(commandBuilder, triggerDto, "terminate");
            commandBuilder.terminate();
        }
        catch (NotFoundException e) {
            throw this.createInvalidRequestException("terminate", Response.Status.NOT_FOUND, (ProcessEngineException)((Object)e));
        }
        catch (NotValidException e) {
            throw this.createInvalidRequestException("terminate", Response.Status.BAD_REQUEST, (ProcessEngineException)((Object)e));
        }
        catch (NotAllowedException e) {
            throw this.createInvalidRequestException("terminate", Response.Status.FORBIDDEN, (ProcessEngineException)((Object)e));
        }
        catch (ProcessEngineException e) {
            throw this.createRestException("terminate", Response.Status.INTERNAL_SERVER_ERROR, e);
        }
    }

    protected InvalidRequestException createInvalidRequestException(String transition, Response.Status status, ProcessEngineException cause) {
        String errorMessage = String.format("Cannot %s case instance %s: %s", transition, this.caseInstanceId, cause.getMessage());
        return new InvalidRequestException(status, (Exception)((Object)cause), errorMessage);
    }

    protected RestException createRestException(String transition, Response.Status status, ProcessEngineException cause) {
        String errorMessage = String.format("Cannot %s case instance %s: %s", transition, this.caseInstanceId, cause.getMessage());
        return new RestException(status, (Exception)((Object)cause), errorMessage);
    }

    protected void initializeCommand(CaseExecutionCommandBuilder commandBuilder, CaseExecutionTriggerDto triggerDto, String transition) {
        List<VariableNameDto> deletions;
        Map<String, TriggerVariableValueDto> variables = triggerDto.getVariables();
        if (variables != null && !variables.isEmpty()) {
            this.initializeCommandWithVariables(commandBuilder, variables, transition);
        }
        if ((deletions = triggerDto.getDeletions()) != null && !deletions.isEmpty()) {
            this.initializeCommandWithDeletions(commandBuilder, deletions, transition);
        }
    }

    protected void initializeCommandWithVariables(CaseExecutionCommandBuilder commandBuilder, Map<String, TriggerVariableValueDto> variables, String transition) {
        for (String variableName : variables.keySet()) {
            try {
                TriggerVariableValueDto variableValue = variables.get(variableName);
                if (variableValue.isLocal()) {
                    commandBuilder.setVariableLocal(variableName, (Object)variableValue.toTypedValue(this.engine, this.objectMapper));
                    continue;
                }
                commandBuilder.setVariable(variableName, (Object)variableValue.toTypedValue(this.engine, this.objectMapper));
            }
            catch (RestException e) {
                String errorMessage = String.format("Cannot %s case instance %s due to invalid variable %s: %s", transition, this.caseInstanceId, variableName, e.getMessage());
                throw new RestException(e.getStatus(), e, errorMessage);
            }
        }
    }

    protected void initializeCommandWithDeletions(CaseExecutionCommandBuilder commandBuilder, List<VariableNameDto> deletions, String transition) {
        for (VariableNameDto variableName : deletions) {
            if (variableName.isLocal()) {
                commandBuilder.removeVariableLocal(variableName.getName());
                continue;
            }
            commandBuilder.removeVariable(variableName.getName());
        }
    }

    @Override
    public VariableResource getVariablesResource() {
        return new CaseExecutionVariablesResource(this.engine, this.caseInstanceId, this.objectMapper);
    }
}

